/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.axiondb.AxionException;
import org.axiondb.jdbc.AbstractAxionBlob;
import org.axiondb.types.LobSource;
import org.axiondb.util.ExceptionConverter;

public class BlobSource
extends AbstractAxionBlob {
    private LobSource _lob = null;

    public BlobSource(LobSource lob) {
        this.setLobSource(lob);
    }

    public void setLobSource(LobSource lob) {
        this._lob = lob;
    }

    public long length() throws SQLException {
        try {
            return this._lob.length();
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 0L) {
            throw new SQLException("position " + pos + " is invalid.");
        }
        if (length < 0) {
            throw new SQLException("length" + length + " is invalid.");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        InputStream in = null;
        try {
            in = this.getBinaryStream();
            for (long i = 0L; i < pos; ++i) {
                in.read();
            }
            int b = in.read();
            for (int i = 0; i < length && b != -1; ++i) {
                buffer.write((byte)b);
                b = in.read();
            }
            byte[] i = buffer.toByteArray();
            return i;
        }
        catch (IOException e) {
            throw ExceptionConverter.convert(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    public void truncate(long length) throws SQLException {
        try {
            this._lob.truncate(length);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            return this._lob.getInputStream();
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        try {
            return this._lob.setOutputStream(pos);
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
    }
}

