/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class BigDecimalType
extends BaseNumberDataType
implements DataType.ExactNumeric {
    public static final int ROUNDING_RULE = 4;
    public static final int DEFAULT_PRECISION = 22;
    public static final int DEFAULT_SCALE = 0;
    public static final int MAX_PRECISION = 38;
    private int _precision = 22;
    private int _scale = 0;
    private static final String NULL_BIGDEC = " ";
    private static final int TOSTRING_RADIX = 36;
    private static final long serialVersionUID = -8555010408278020956L;

    public BigDecimalType() {
        this(22, 0);
    }

    public BigDecimalType(int scale) {
        this(22, scale);
    }

    public BigDecimalType(int precision, int scale) {
        this._precision = precision;
        this._scale = scale;
    }

    public BigDecimalType(BigDecimal result) {
        this._scale = result.scale();
        int valueLength = result.toString().length();
        valueLength -= this._scale != 0 ? 1 : 0;
        int unscaledPrecision = result.unscaledValue().abs().toString().length();
        this._precision = unscaledPrecision == this._scale ? this._scale : Math.max(valueLength -= result.signum() < 0 ? 1 : 0, unscaledPrecision);
    }

    public int getColumnDisplaySize() {
        return this._precision + (this._scale == 0 ? 0 : 1) + 1;
    }

    public int getPrecision() {
        return this._precision;
    }

    public int getJdbcType() {
        return 2;
    }

    public String getPreferredValueClassName() {
        return "java.math.BigDecimal";
    }

    public int getScale() {
        return this._scale;
    }

    public void setPrecision(int newPrecision) {
        this._precision = newPrecision;
    }

    public void setScale(int newScale) {
        this._scale = newScale;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(25);
        buf.append("numeric").append("(").append(this._precision).append(",").append(this._scale).append(")");
        return buf.toString();
    }

    public boolean accepts(Object value) {
        if (value instanceof BigDecimal) {
            return true;
        }
        return super.accepts(value);
    }

    public boolean requiresRounding(BigDecimal value) {
        return this._scale >= 0 && value.scale() != this._scale;
    }

    public Object convert(Object value) throws AxionException {
        if (value == null) {
            return value;
        }
        BigDecimal toreturn = null;
        if (value instanceof BigDecimal) {
            toreturn = (BigDecimal)value;
        } else if (value instanceof BigInteger) {
            toreturn = new BigDecimal((BigInteger)value);
        } else if (value instanceof Double || value instanceof Float) {
            try {
                toreturn = new BigDecimal(String.valueOf(value));
            }
            catch (NumberFormatException e) {
                throw new AxionException(22003);
            }
        } else if (value instanceof Number) {
            toreturn = BigDecimal.valueOf(((Number)value).longValue());
        } else if (value instanceof String) {
            try {
                toreturn = new BigDecimal(value.toString().trim());
            }
            catch (NumberFormatException e) {
                throw new AxionException(22018);
            }
        } else {
            toreturn = (BigDecimal)super.convert(value);
        }
        if (null != toreturn) {
            try {
                if (this.requiresRounding(toreturn)) {
                    toreturn = toreturn.setScale(this._scale, 4);
                }
                this.assertValueNotOutOfRange(toreturn);
            }
            catch (ArithmeticException e) {
                throw new AxionException("BigDecimal " + toreturn + " has scale " + toreturn.scale() + ", can't convert to scale " + this._scale + ": " + e.getMessage());
            }
        }
        return toreturn;
    }

    public Object read(DataInput in) throws IOException {
        String str = in.readUTF();
        if (NULL_BIGDEC.equals(str)) {
            return null;
        }
        BigInteger value = new BigInteger(str, 36);
        int scale = in.readInt();
        return new BigDecimal(value, scale);
    }

    public boolean supportsSuccessor() {
        return true;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        double v = ((BigDecimal)value).doubleValue();
        return new BigDecimal(v + 1.0);
    }

    public void write(Object value, DataOutput out) throws IOException {
        try {
            BigDecimal towrite = (BigDecimal)this.convert(value);
            if (null == towrite) {
                out.writeUTF(NULL_BIGDEC);
            } else {
                out.writeUTF(towrite.unscaledValue().toString(36));
                out.writeInt(towrite.scale());
            }
        }
        catch (AxionException e) {
            throw new IOException(e.getMessage());
        }
    }

    public DataType makeNewInstance() {
        return this.makeNewInstance(22, 0);
    }

    public int compare(Object a, Object b) {
        BigDecimal bda = null;
        try {
            bda = (BigDecimal)this.convert(a);
        }
        catch (AxionException e) {
            throw new ClassCastException("cannot convert " + a.toString() + " to BigDecimal for comparison");
        }
        BigDecimal bdb = null;
        try {
            bdb = (BigDecimal)this.convert(b);
        }
        catch (AxionException e) {
            throw new ClassCastException("cannot convert " + b.toString() + " to BigDecimal for comparison");
        }
        return bda.compareTo(bdb);
    }

    public DataType.ExactNumeric makeNewInstance(int newPrecision, int newScale) {
        return new BigDecimalType(newPrecision, newScale);
    }

    protected Comparator getComparator() {
        return this;
    }

    private int getPrecision(BigDecimal value) {
        return value.unscaledValue().abs().toString().length();
    }

    private void assertValueNotOutOfRange(BigDecimal value) throws AxionException {
        int wholeNumberPrecision = Math.max(0, this.getPrecision(value) - value.scale());
        if (wholeNumberPrecision != 0 && wholeNumberPrecision > this._precision - this._scale) {
            throw new AxionException(22003);
        }
    }
}

