/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.tools.BaseReport;

public class BatchSqlCommandRunner {
    private static Logger _log = Logger.getLogger(BatchSqlCommandRunner.class.getName());
    private StringBuffer _buf = new StringBuffer();
    private Statement _stmt = null;
    private PrintWriter _writer = null;
    private BaseReport _report = null;

    public BatchSqlCommandRunner(Connection conn) throws SQLException {
        this(conn.createStatement());
    }

    public BatchSqlCommandRunner(Connection conn, PrintWriter pw) throws SQLException {
        this(conn.createStatement(), pw);
    }

    public BatchSqlCommandRunner(Statement stmt) {
        this(stmt, null);
    }

    public BatchSqlCommandRunner(Statement stmt, PrintWriter pw) {
        this._stmt = stmt;
        this._writer = pw == null ? new PrintWriter(System.out, true) : pw;
        this._report = new BaseReport(this._writer);
    }

    public void runCommands(BufferedReader reader) throws IOException, SQLException {
        try {
            String cmd = null;
            while (!(cmd = this.readCommand(reader)).equals("")) {
                _log.log(Level.FINE, "executing command: " + cmd);
                long startTime = System.currentTimeMillis();
                boolean hasResultSet = this._stmt.execute(cmd);
                long endTime = System.currentTimeMillis();
                if (hasResultSet) {
                    ResultSet rset = this._stmt.getResultSet();
                    this._report.reportResultSet(rset);
                    rset.close();
                } else {
                    int ct = this._stmt.getUpdateCount();
                    this._report.reportUpdateCount(ct);
                }
                this._writer.println("Execution time: " + (endTime - startTime) + " ms.");
            }
        }
        catch (SQLException e) {
            this._report.reportException(e);
            throw e;
        }
        finally {
            reader.close();
        }
    }

    public void runCommands(InputStream stream) throws IOException, SQLException {
        this.runCommands(new BufferedReader(new InputStreamReader(stream, "UTF8")));
    }

    public void close() {
        try {
            this._stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String readLine(BufferedReader reader) throws IOException {
        String result = reader.readLine();
        if (result != null) {
            result.trim();
        }
        return result;
    }

    String readCommand(BufferedReader reader) throws IOException {
        this._buf.setLength(0);
        String line = null;
        boolean done = false;
        boolean inQuote = false;
        while (!done && (line = this.readLine(reader)) != null) {
            if (line.indexOf("/*") != -1) continue;
            this._buf.append(line);
            this._buf.append(' ');
            inQuote = this.isInQuotes(line, inQuote);
            done = !inQuote && line.trim().endsWith(";");
        }
        return this._buf.toString().trim();
    }

    boolean isInQuotes(String line, boolean inQuotes) {
        boolean result = inQuotes;
        int quotePos = -1;
        int startPos = 0;
        while ((quotePos = line.indexOf("'", startPos)) > -1) {
            result = !result;
            startPos = quotePos + 1;
        }
        return result;
    }
}

