/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionCommand;
import org.axiondb.AxionException;
import org.axiondb.BaseSelectable;
import org.axiondb.BindVariable;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.FromNode;
import org.axiondb.Literal;
import org.axiondb.OrderNode;
import org.axiondb.Selectable;
import org.axiondb.SelectableBasedConstraint;
import org.axiondb.TableIdentifier;
import org.axiondb.constraints.BaseSelectableBasedConstraint;
import org.axiondb.constraints.CheckConstraint;
import org.axiondb.constraints.ForeignKeyConstraint;
import org.axiondb.constraints.NotNullConstraint;
import org.axiondb.constraints.NullConstraint;
import org.axiondb.constraints.PrimaryKeyConstraint;
import org.axiondb.constraints.UniqueConstraint;
import org.axiondb.engine.commands.AddConstraintCommand;
import org.axiondb.engine.commands.AlterSequenceCommand;
import org.axiondb.engine.commands.AlterTableCommand;
import org.axiondb.engine.commands.AxionQueryContext;
import org.axiondb.engine.commands.CheckFileStateCommand;
import org.axiondb.engine.commands.CreateCommand;
import org.axiondb.engine.commands.CreateDatabaseLinkCommand;
import org.axiondb.engine.commands.CreateIndexCommand;
import org.axiondb.engine.commands.CreateSequenceCommand;
import org.axiondb.engine.commands.CreateTableCommand;
import org.axiondb.engine.commands.CreateViewCommand;
import org.axiondb.engine.commands.DMLWhenClause;
import org.axiondb.engine.commands.DefragCommand;
import org.axiondb.engine.commands.DeleteCommand;
import org.axiondb.engine.commands.DropConstraintCommand;
import org.axiondb.engine.commands.DropDatabaseLinkCommand;
import org.axiondb.engine.commands.DropIndexCommand;
import org.axiondb.engine.commands.DropSequenceCommand;
import org.axiondb.engine.commands.DropTableCommand;
import org.axiondb.engine.commands.DropViewCommand;
import org.axiondb.engine.commands.InsertCommand;
import org.axiondb.engine.commands.RemountCommand;
import org.axiondb.engine.commands.SelectCommand;
import org.axiondb.engine.commands.ShutdownCommand;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.engine.commands.TruncateCommand;
import org.axiondb.engine.commands.UpdateCommand;
import org.axiondb.engine.commands.UpsertCommand;
import org.axiondb.functions.FunctionIdentifier;
import org.axiondb.parser.AxionSqlParserConstants;
import org.axiondb.parser.AxionSqlParserTokenManager;
import org.axiondb.parser.ParseException;
import org.axiondb.parser.Parser;
import org.axiondb.parser.SimpleCharStream;
import org.axiondb.parser.Token;
import org.axiondb.parser.TokenMgrError;
import org.axiondb.types.BigDecimalType;
import org.axiondb.types.BooleanType;
import org.axiondb.types.CharacterType;

public class AxionSqlParser
implements Parser,
AxionSqlParserConstants {
    static Set systemTables = new HashSet(10);
    private static Logger _log;
    public AxionSqlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;

    public AxionSqlParser() {
        this(new StringReader(""));
        _log.log(Level.FINE, "created new parser");
    }

    public AxionCommand parse(String sql) throws AxionException {
        this.ReInit(new StringReader(sql));
        try {
            return this.SqlCommand();
        }
        catch (TokenMgrError e) {
            throw new AxionException(e);
        }
        catch (AxionSqlParseException sqlEx) {
            throw sqlEx.getNestedException();
        }
        catch (ParseException ex) {
            throw new AxionException(ex);
        }
    }

    private String getUniqueAliasName(Map aliasSuffixCounterMap, String key) {
        Object counterObj = aliasSuffixCounterMap.get(key);
        Integer counter = null;
        if (counterObj != null) {
            counter = (Integer)counterObj;
            counter = new Integer(counter + 1);
        } else {
            counter = new Integer(0);
        }
        aliasSuffixCounterMap.put(key, counter);
        if (counter == 0) {
            return key;
        }
        return key + counter;
    }

    private void protectSystemTable(String tableName) throws ParseException {
        if (systemTables.contains(tableName)) {
            throw new ParseException("Operation not allowed on SYSTEM tables");
        }
    }

    private static final String replace(String src, String old, String nu) {
        int srclen = src.length();
        int cur = 0;
        int loc = 0;
        int oldlen = old.length();
        StringBuffer buf = new StringBuffer(srclen + nu.length());
        do {
            if ((loc = src.indexOf(old, cur)) == -1) continue;
            buf.append(src.substring(cur, loc));
            buf.append(nu);
            cur = loc + oldlen;
        } while (loc != -1);
        if (cur < srclen) {
            buf.append(src.substring(cur));
        }
        return buf.toString();
    }

    private static Selectable makeLeafWhereNode(Selectable left, String op, Selectable right) {
        FunctionIdentifier fn = new FunctionIdentifier(op);
        fn.addArgument(left);
        if (null != right) {
            fn.addArgument(right);
        }
        return fn;
    }

    public final AxionCommand SqlCommand() throws ParseException {
        AxionCommand result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: 
            case 103: {
                result = this.SqlSelect();
                break;
            }
            case 67: {
                result = this.SqlInsert();
                break;
            }
            case 118: {
                result = this.SqlUpdate();
                break;
            }
            case 79: 
            case 119: {
                result = this.SqlUpsert();
                break;
            }
            case 37: {
                result = this.SqlDelete();
                break;
            }
            case 23: {
                result = this.SqlCreate();
                break;
            }
            case 40: {
                result = this.SqlDrop();
                break;
            }
            case 10: {
                result = this.SqlAlterCmd();
                break;
            }
            case 172: {
                result = this.SqlAxionCustom();
                break;
            }
            case 36: {
                result = this.SQLDefrag();
                break;
            }
            case 116: {
                result = this.SqlTruncate();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 178: {
                this.jj_consume_token(178);
                break;
            }
        }
        this.jj_consume_token(0);
        _log.log(Level.FINE, "SqlCommand: created \"" + result + "\"");
        return result;
    }

    public final AxionCommand SqlAxionCustom() throws ParseException {
        String name = this.SqlUnquotedId();
        if ("REMOUNT".equals(name)) {
            return this.SqlRemount();
        }
        if ("SHUTDOWN".equals(name)) {
            return new ShutdownCommand();
        }
        if ("CHECKFILESTATE".equals(name)) {
            return new CheckFileStateCommand();
        }
        throw new ParseException("Expected REMOUNT, SHUTDOWN or CHECKFILESTATE found \"" + name + "\".");
    }

    public final AxionCommand SqlRemount() throws ParseException {
        RemountCommand remount = new RemountCommand();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                this.jj_consume_token(110);
                String name = this.SqlUnquotedId();
                remount.setTable(new TableIdentifier(name));
                return remount;
            }
            case 171: 
            case 172: 
            case 194: {
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 172: {
                        String name = this.SqlUnquotedId();
                        remount.setTable(new TableIdentifier(name));
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 31: {
                                this.jj_consume_token(31);
                                remount.setDataFilesOnly(true);
                                break block4;
                            }
                        }
                        break;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 171: {
                        String result;
                        this.jj_consume_token(171);
                        String trimmed = this.token.image.substring(1, this.token.image.length() - 1);
                        String dir = result = AxionSqlParser.replace(trimmed, "''", "'");
                        remount.setDirectory(result);
                        break;
                    }
                    case 194: {
                        BindVariable dir = this.SqlBindVar();
                        remount.setDirectory(dir);
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return remount;
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AxionCommand SQLDefrag() throws ParseException {
        DefragCommand defrag = new DefragCommand();
        String table = null;
        this.jj_consume_token(36);
        this.jj_consume_token(110);
        table = this.SqlIdentifier();
        defrag.setObjectName(table);
        return defrag;
    }

    public final AxionCommand SqlTruncate() throws ParseException {
        TruncateCommand trunc = new TruncateCommand();
        String table = null;
        this.jj_consume_token(116);
        this.jj_consume_token(110);
        table = this.SqlIdentifier();
        this.protectSystemTable(table);
        trunc.setObjectName(table);
        return trunc;
    }

    public final AxionCommand SqlCreate() throws ParseException {
        AxionCommand result = null;
        this.jj_consume_token(23);
        if (this.jj_2_1(2)) {
            result = this.SqlCreateTable();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 124: {
                    result = this.SqlCreateView();
                    break;
                }
                case 30: {
                    result = this.SqlCreateServer();
                    break;
                }
                case 65: 
                case 117: 
                case 172: 
                case 195: {
                    result = this.SqlCreateIndex();
                    break;
                }
                case 104: {
                    result = this.SqlCreateSequence();
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return result;
    }

    public final AxionCommand SqlCreateTable() throws ParseException {
        CreateTableCommand result = new CreateTableCommand();
        Properties props = null;
        AxionCommand subselect = null;
        String type = null;
        Token t = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: 
            case 172: 
            case 195: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        t = this.jj_consume_token(48);
                        type = t.image;
                        result.setType(type);
                        break block0;
                    }
                    case 172: 
                    case 195: {
                        type = this.SqlIdentifier();
                        result.setType(type);
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(110);
        this.SqlIfNotExists(result);
        this.protectSystemTable(result.getObjectName());
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                subselect = this.SqlSubSelect();
                result.setSubQuery((SubSelectCommand)subselect);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 128: {
                        if (this.jj_2_2(2)) {
                            this.jj_consume_token(128);
                            this.jj_consume_token(85);
                            this.jj_consume_token(31);
                            result.setCreateTableWithData(false);
                            break block7;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 128: {
                                this.jj_consume_token(128);
                                this.jj_consume_token(31);
                                result.setCreateTableWithData(true);
                                break block7;
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                this.SqlColumnExpression(result);
                block23: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 176: {
                            break;
                        }
                        default: {
                            break block23;
                        }
                    }
                    this.jj_consume_token(176);
                    this.SqlColumnExpression(result);
                }
                this.jj_consume_token(189);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 92: {
                        this.jj_consume_token(92);
                        if (!"external".equalsIgnoreCase(type)) {
                            throw new ParseException("ORGANIZATION clause is only valid for external tables.");
                        }
                        this.jj_consume_token(188);
                        props = this.SqlReadProperties();
                        result.setProperties(props);
                        this.jj_consume_token(189);
                        break block7;
                    }
                }
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final AxionCommand SqlCreateView() throws ParseException {
        CreateViewCommand result = new CreateViewCommand();
        Token t = null;
        this.jj_consume_token(124);
        this.SqlIfNotExists(result);
        this.jj_consume_token(13);
        StringBuffer buf = new StringBuffer();
        t = this.getNextToken();
        while (t.kind != 0) {
            buf.append(t.image).append(" ");
            t = this.getNextToken();
        }
        result.setSubQuery(buf.toString());
        return result;
    }

    public final AxionCommand SqlCreateServer() throws ParseException {
        CreateDatabaseLinkCommand result = new CreateDatabaseLinkCommand();
        Properties props = null;
        this.jj_consume_token(30);
        this.jj_consume_token(76);
        this.SqlIfNotExists(result);
        this.jj_consume_token(188);
        props = this.SqlReadProperties();
        result.setProperties(props);
        this.jj_consume_token(189);
        return result;
    }

    public final AxionCommand SqlCreateIndex() throws ParseException {
        CreateIndexCommand result = new CreateIndexCommand();
        String str = null;
        String type = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 117: {
                this.jj_consume_token(117);
                result.setUnique(true);
                break;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 172: 
            case 195: {
                type = this.SqlIdentifier();
                result.setType(type);
                break;
            }
        }
        this.jj_consume_token(65);
        this.SqlIfNotExists(result);
        this.jj_consume_token(89);
        str = this.SqlValueTerm();
        result.setTable(str);
        str = null;
        this.jj_consume_token(188);
        str = this.SqlIdentifier();
        result.addColumn(str);
        str = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 176: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            this.jj_consume_token(176);
            str = this.SqlIdentifier();
            result.addColumn(str);
            str = null;
        }
        this.jj_consume_token(189);
        return result;
    }

    public final AxionCommand SqlCreateSequence() throws ParseException {
        CreateSequenceCommand result = new CreateSequenceCommand();
        Object[] tuple = new Object[5];
        this.jj_consume_token(104);
        this.SqlIfNotExists(result);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                this.SqlExactNumericType(tuple);
                result.setDataType((String)tuple[1]);
                break;
            }
        }
        this.SqlBasicSequenceOption(result);
        return result;
    }

    public final void SqlBasicSequenceOption(CreateSequenceCommand result) throws ParseException {
        Token t = null;
        boolean ascending = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 107: {
                this.jj_consume_token(107);
                this.jj_consume_token(128);
                t = this.jj_consume_token(168);
                result.setStartValue(t.image);
                break;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 61: {
                this.jj_consume_token(61);
                this.jj_consume_token(18);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 193: {
                        this.jj_consume_token(193);
                        ascending = false;
                        break;
                    }
                }
                t = this.jj_consume_token(168);
                String ib = t.image;
                if (!ascending) {
                    ib = "-" + t.image;
                }
                result.setIncrementBy(ib);
                break;
            }
        }
        if (this.jj_2_3(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    this.jj_consume_token(77);
                    t = this.jj_consume_token(168);
                    result.setMaxValue(t.image);
                    break;
                }
                case 85: {
                    this.jj_consume_token(85);
                    this.jj_consume_token(77);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (this.jj_2_4(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    this.jj_consume_token(81);
                    t = this.jj_consume_token(168);
                    result.setMinValue(t.image);
                    break;
                }
                case 85: {
                    this.jj_consume_token(85);
                    this.jj_consume_token(81);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block17 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 85: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.jj_consume_token(29);
                        result.setCycle(true);
                        break block17;
                    }
                    case 85: {
                        this.jj_consume_token(85);
                        this.jj_consume_token(29);
                        result.setCycle(false);
                        break block17;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final AxionCommand SqlAlterSequence() throws ParseException {
        AlterSequenceCommand result = new AlterSequenceCommand();
        Token t = null;
        String name = null;
        boolean ascending = true;
        this.jj_consume_token(104);
        name = this.SqlIdentifier();
        result.setObjectName(name);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 100: {
                this.jj_consume_token(100);
                this.jj_consume_token(128);
                t = this.jj_consume_token(168);
                result.setStartValue(t.image);
                break;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 61: {
                this.jj_consume_token(61);
                this.jj_consume_token(18);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 193: {
                        this.jj_consume_token(193);
                        ascending = false;
                        break;
                    }
                }
                t = this.jj_consume_token(168);
                String ib = t.image;
                if (!ascending) {
                    ib = "-" + t.image;
                }
                result.setIncrementBy(ib);
                break;
            }
        }
        if (this.jj_2_5(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    this.jj_consume_token(77);
                    t = this.jj_consume_token(168);
                    result.setMaxValue(t.image);
                    break;
                }
                case 85: {
                    this.jj_consume_token(85);
                    this.jj_consume_token(77);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (this.jj_2_6(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    this.jj_consume_token(81);
                    t = this.jj_consume_token(168);
                    result.setMinValue(t.image);
                    break;
                }
                case 85: {
                    this.jj_consume_token(85);
                    this.jj_consume_token(81);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block17 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 85: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.jj_consume_token(29);
                        result.setCycle(true);
                        break block17;
                    }
                    case 85: {
                        this.jj_consume_token(85);
                        this.jj_consume_token(29);
                        result.setCycle(false);
                        break block17;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final void SqlIfNotExists(AxionCommand result) throws ParseException {
        CreateCommand cmd = (CreateCommand)result;
        String name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                this.jj_consume_token(86);
                this.jj_consume_token(45);
                cmd.setIfNotExists(true);
                break;
            }
        }
        name = this.SqlIdentifier();
        cmd.setObjectName(name);
    }

    public final Properties SqlReadProperties() throws ParseException {
        Properties props = new Properties();
        String key = null;
        Literal val = null;
        key = this.SqlIdentifier();
        this.jj_consume_token(184);
        val = this.SqlLiteral();
        props.setProperty(key, val.toString());
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 172: 
                case 176: 
                case 195: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 176: {
                        break;
                    }
                    default: {
                        break block7;
                    }
                }
                this.jj_consume_token(176);
            }
            key = this.SqlIdentifier();
            this.jj_consume_token(184);
            val = this.SqlLiteral();
            props.setProperty(key, val.toString());
        }
        return props;
    }

    public final void SqlColumnExpression(CreateTableCommand result) throws ParseException {
        Object[] tuple = null;
        Constraint constraint = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: 
            case 25: 
            case 52: 
            case 86: 
            case 87: 
            case 95: 
            case 98: 
            case 117: {
                constraint = this.SqlTableConstraint();
                if (null == constraint) break;
                result.addChildCommand(new AddConstraintCommand(result.getObjectName(), constraint));
                constraint = null;
                break;
            }
            case 172: 
            case 195: {
                tuple = this.SqlColumnDef();
                result.addColumn((String)tuple[0], (String)tuple[1], (String)tuple[2], (String)tuple[3], tuple[4], (String)tuple[5]);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 22: 
                        case 25: 
                        case 52: 
                        case 86: 
                        case 87: 
                        case 95: 
                        case 98: 
                        case 117: {
                            break;
                        }
                        default: {
                            break block0;
                        }
                    }
                    constraint = this.SqlColumnConstraint(result.getObjectName(), (String)tuple[0]);
                    if (null == constraint) continue;
                    result.addChildCommand(new AddConstraintCommand(result.getObjectName(), constraint));
                    constraint = null;
                }
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final AxionCommand SqlDelete() throws ParseException {
        TableIdentifier table = null;
        Selectable where = null;
        this.jj_consume_token(37);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                this.jj_consume_token(53);
                break;
            }
        }
        table = this.SqlTableRef();
        this.protectSystemTable(table.getTableName());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 127: {
                where = this.SqlWhere();
                break;
            }
        }
        return new DeleteCommand(table, where);
    }

    public final AxionCommand SqlAlterCmd() throws ParseException {
        AxionCommand result = null;
        this.jj_consume_token(10);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 110: {
                result = this.SqlAlterTable();
                break;
            }
            case 104: {
                result = this.SqlAlterSequence();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final AxionCommand SqlAlterTable() throws ParseException {
        AxionCommand result = null;
        String tablename = null;
        this.jj_consume_token(110);
        tablename = this.SqlIdentifier();
        this.protectSystemTable(tablename);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                result = this.SqlAlterTableDrop(tablename);
                break;
            }
            case 7: {
                result = this.SqlAlterTableAdd(tablename);
                break;
            }
            case 10: {
                result = this.SqlAlterTableAlterColumn(tablename);
                break;
            }
            case 99: {
                result = this.SqlRenameTable(tablename);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final AxionCommand SqlRenameTable(String tablename) throws ParseException {
        String newName = null;
        boolean cascade = false;
        this.jj_consume_token(99);
        this.jj_consume_token(112);
        newName = this.SqlIdentifier();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: 
            case 101: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        cascade = true;
                        break block0;
                    }
                    case 101: {
                        this.jj_consume_token(101);
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AlterTableCommand cmd = new AlterTableCommand(tablename, cascade);
        cmd.setRenameTo(newName);
        return cmd;
    }

    public final AxionCommand SqlAlterTableAlterColumn(String tablename) throws ParseException {
        String oldColName = null;
        String newName = null;
        Selectable newDefault = null;
        Boolean dropdefault = null;
        boolean cascade = false;
        this.jj_consume_token(10);
        this.jj_consume_token(24);
        oldColName = this.SqlIdentifier();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 99: {
                this.jj_consume_token(99);
                this.jj_consume_token(112);
                newName = this.SqlIdentifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: 
                    case 101: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 20: {
                                this.jj_consume_token(20);
                                cascade = true;
                                break block0;
                            }
                            case 101: {
                                this.jj_consume_token(101);
                                break block0;
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                this.jj_consume_token(33);
                dropdefault = Boolean.TRUE;
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                this.jj_consume_token(33);
                newDefault = this.SqlSelectable();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AlterTableCommand cmd = new AlterTableCommand(tablename, cascade);
        cmd.alterColumn(oldColName, newName, newDefault, dropdefault);
        return cmd;
    }

    public final AxionCommand SqlDropColumn(String tablename) throws ParseException {
        String columnname = null;
        boolean cascade = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                break;
            }
        }
        columnname = this.SqlIdentifier();
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: 
            case 101: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        cascade = true;
                        break block3;
                    }
                    case 101: {
                        this.jj_consume_token(101);
                        break block3;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AlterTableCommand cmd = new AlterTableCommand(tablename, cascade);
        cmd.dropColumn(columnname);
        return cmd;
    }

    public final AxionCommand SqlAlterTableDrop(String tablename) throws ParseException {
        String constraintname = null;
        AxionCommand result = null;
        boolean cascade = false;
        this.jj_consume_token(40);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: 
            case 95: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        constraintname = this.SqlIdentifier();
                        break;
                    }
                    case 95: {
                        this.jj_consume_token(95);
                        this.jj_consume_token(71);
                        constraintname = "PRIMARYKEY";
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: 
                    case 101: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 20: {
                                this.jj_consume_token(20);
                                cascade = true;
                                break block8;
                            }
                            case 101: {
                                this.jj_consume_token(101);
                                break block8;
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                result = new DropConstraintCommand(tablename, constraintname, cascade);
                break;
            }
            case 24: 
            case 172: 
            case 195: {
                result = this.SqlDropColumn(tablename);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final AxionCommand SqlAlterTableAdd(String tablename) throws ParseException {
        Constraint constraint = null;
        AlterTableCommand altCmd = null;
        Object[] tuple = null;
        this.jj_consume_token(7);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: 
            case 25: 
            case 52: 
            case 86: 
            case 87: 
            case 95: 
            case 98: 
            case 117: {
                constraint = this.SqlTableConstraint();
                if (null == constraint) {
                    return null;
                }
                return new AddConstraintCommand(tablename, constraint);
            }
            case 24: 
            case 172: 
            case 195: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                }
                tuple = this.SqlColumnDef();
                altCmd = new AlterTableCommand(tablename, false);
                altCmd.addColumn((String)tuple[0], (String)tuple[1], (String)tuple[2], (String)tuple[3], (Selectable)tuple[4], (String)tuple[5]);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 22: 
                        case 25: 
                        case 52: 
                        case 86: 
                        case 87: 
                        case 95: 
                        case 98: 
                        case 117: {
                            break;
                        }
                        default: {
                            break block10;
                        }
                    }
                    constraint = this.SqlColumnConstraint(tablename, (String)tuple[0]);
                    if (null == constraint) continue;
                    altCmd.addChildCommand(new AddConstraintCommand(tablename, constraint));
                    constraint = null;
                }
                return altCmd;
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AxionCommand SqlDrop() throws ParseException {
        AxionCommand result = null;
        this.jj_consume_token(40);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 110: {
                result = this.SqlDropTable();
                break;
            }
            case 124: {
                result = this.SqlDropView();
                break;
            }
            case 65: {
                result = this.SqlDropIndex();
                break;
            }
            case 104: {
                result = this.SqlDropSequence();
                break;
            }
            case 30: {
                result = this.SqlDropServer();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final AxionCommand SqlDropTable() throws ParseException {
        DropTableCommand result = null;
        String tableName = null;
        boolean exists = false;
        boolean cascade = false;
        this.jj_consume_token(110);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                this.jj_consume_token(45);
                exists = true;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: 
                    case 101: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 20: {
                                this.jj_consume_token(20);
                                cascade = true;
                                break block0;
                            }
                            case 101: {
                                this.jj_consume_token(101);
                                break block0;
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            }
        }
        tableName = this.SqlIdentifier();
        this.protectSystemTable(tableName);
        result = new DropTableCommand(tableName, exists, cascade);
        return result;
    }

    public final AxionCommand SqlDropView() throws ParseException {
        DropViewCommand result = null;
        String tableName = null;
        boolean exists = false;
        boolean cascade = false;
        this.jj_consume_token(124);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                this.jj_consume_token(45);
                exists = true;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: 
                    case 101: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 20: {
                                this.jj_consume_token(20);
                                cascade = true;
                                break block0;
                            }
                            case 101: {
                                this.jj_consume_token(101);
                                break block0;
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            }
        }
        tableName = this.SqlIdentifier();
        result = new DropViewCommand(tableName, exists, cascade);
        return result;
    }

    public final AxionCommand SqlDropServer() throws ParseException {
        DropDatabaseLinkCommand result = null;
        String dblinkName = null;
        boolean exists = false;
        boolean cascade = false;
        this.jj_consume_token(30);
        this.jj_consume_token(76);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                this.jj_consume_token(45);
                exists = true;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: 
                    case 101: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 20: {
                                this.jj_consume_token(20);
                                cascade = true;
                                break block0;
                            }
                            case 101: {
                                this.jj_consume_token(101);
                                break block0;
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            }
        }
        dblinkName = this.SqlIdentifier();
        result = new DropDatabaseLinkCommand(dblinkName, exists, cascade);
        return result;
    }

    public final AxionCommand SqlDropIndex() throws ParseException {
        DropIndexCommand result = null;
        String name = null;
        boolean exists = false;
        this.jj_consume_token(65);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                this.jj_consume_token(45);
                exists = true;
                break;
            }
        }
        name = this.SqlIdentifier();
        result = new DropIndexCommand(name, exists);
        return result;
    }

    public final AxionCommand SqlDropSequence() throws ParseException {
        DropSequenceCommand result = null;
        String sequenceName = null;
        boolean exists = false;
        this.jj_consume_token(104);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                this.jj_consume_token(45);
                exists = true;
                break;
            }
        }
        sequenceName = this.SqlIdentifier();
        result = new DropSequenceCommand(sequenceName, exists);
        return result;
    }

    public final AxionCommand SqlInsert() throws ParseException {
        InsertCommand insertCommand = null;
        Token t = null;
        this.jj_consume_token(67);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 50: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        t = this.jj_consume_token(9);
                        break;
                    }
                    case 50: {
                        t = this.jj_consume_token(50);
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                insertCommand = this.SqlMultiTableInsert();
                if (t.image.equalsIgnoreCase("first")) {
                    insertCommand.setMultiTableEvaluationMode(2);
                }
                return insertCommand;
            }
            case 68: {
                this.jj_consume_token(68);
                insertCommand = this.SqlSingleTableInsert();
                return insertCommand;
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final InsertCommand SqlMultiTableInsert() throws ParseException {
        InsertCommand insertCommand = new InsertCommand();
        AxionCommand subselect = null;
        block12: while (true) {
            this.SqlInsertIntoClause(insertCommand);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 68: 
                case 126: {
                    continue block12;
                }
            }
            break;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.SqlInsertElseClause(insertCommand);
                break;
            }
        }
        this.jj_consume_token(188);
        subselect = this.SqlSubSelect();
        this.jj_consume_token(189);
        insertCommand.setSubSelect((SubSelectCommand)subselect);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 172: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        break;
                    }
                }
                String aliasName = this.SqlUnquotedId();
                ((SubSelectCommand)subselect).setAlias(aliasName);
                break;
            }
        }
        return insertCommand;
    }

    public final InsertCommand SqlSingleTableInsert() throws ParseException {
        TableIdentifier table = null;
        List columns = null;
        List values = null;
        AxionCommand subselect = null;
        InsertCommand insertCommand = null;
        table = this.SqlTableRef();
        this.protectSystemTable(table.getTableName());
        if (this.jj_2_7(2)) {
            this.jj_consume_token(188);
            columns = this.SqlSelectCols();
            this.jj_consume_token(189);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                values = this.insertValues();
                insertCommand = new InsertCommand(table, columns, values);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                this.jj_consume_token(122);
                insertCommand = new InsertCommand(table, columns, true);
                break;
            }
            default: {
                subselect = this.SqlSubSelect();
                insertCommand = new InsertCommand(table, columns, subselect);
            }
        }
        return insertCommand;
    }

    public final DMLWhenClause SqlDMLWhenClause() throws ParseException {
        Selectable condition = null;
        this.jj_consume_token(126);
        condition = this.SqlWhereOr();
        this.jj_consume_token(111);
        return new DMLWhenClause(condition);
    }

    public final void SqlInsertIntoClause(InsertCommand insertCommand) throws ParseException {
        DMLWhenClause when = null;
        TableIdentifier tid = null;
        List cols = null;
        List vals = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 126: {
                when = this.SqlDMLWhenClause();
                break;
            }
        }
        this.jj_consume_token(68);
        tid = this.SqlTableRef();
        this.protectSystemTable(tid.getTableName());
        if (this.jj_2_8(2)) {
            this.jj_consume_token(188);
            cols = this.SqlSelectCols();
            this.jj_consume_token(189);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                vals = this.insertValues();
                break;
            }
        }
        insertCommand.addInsertIntoClause(when, tid, cols, vals);
    }

    public final void SqlInsertElseClause(InsertCommand insertCommand) throws ParseException {
        TableIdentifier tid = null;
        List cols = null;
        List vals = null;
        this.jj_consume_token(41);
        if (insertCommand.isInsertIntoListEmpty()) {
            throw new ParseException("Can't use ELSE without a WHEN...");
        }
        this.jj_consume_token(68);
        tid = this.SqlTableRef();
        this.protectSystemTable(tid.getTableName());
        if (this.jj_2_9(2)) {
            this.jj_consume_token(188);
            cols = this.SqlSelectCols();
            this.jj_consume_token(189);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                vals = this.insertValues();
                break;
            }
        }
        insertCommand.setElseClause(tid, cols, vals);
    }

    public final List insertValues() throws ParseException {
        List values = null;
        this.jj_consume_token(122);
        this.jj_consume_token(188);
        values = this.SqlSelectList();
        this.jj_consume_token(189);
        return values;
    }

    public final AxionCommand SqlSelect() throws ParseException {
        AxionQueryContext context = null;
        context = this.SqlSelectContext();
        return new SelectCommand(context);
    }

    public final AxionQueryContext SqlSelectContext() throws ParseException {
        AxionQueryContext result = new AxionQueryContext();
        List colList = null;
        Selectable where = null;
        Selectable having = null;
        List order = null;
        List group = null;
        Literal limit = null;
        Literal offset = null;
        FromNode from = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                result.setExplain(true);
                break;
            }
        }
        this.jj_consume_token(103);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 39: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.jj_consume_token(9);
                        result.setDistinct(false);
                        break block3;
                    }
                    case 39: {
                        this.jj_consume_token(39);
                        result.setDistinct(true);
                        break block3;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        colList = this.SqlSelectCols();
        result.setSelect(colList);
        if (this.jj_2_10(2)) {
            this.jj_consume_token(53);
            from = this.SqlFrom();
            result.setFrom(from);
        }
        if (this.jj_2_11(2)) {
            where = this.SqlWhere();
        }
        if (this.jj_2_13(2)) {
            group = this.SqlGroupBy();
            if (this.jj_2_12(2)) {
                this.jj_consume_token(57);
                having = this.SqlWhereOr();
            }
        }
        if (this.jj_2_14(2)) {
            order = this.SqlOrderBy();
        }
        if (this.jj_2_15(2)) {
            limit = this.SqlSelectLimit();
        }
        if (this.jj_2_16(2)) {
            offset = this.SqlSelectOffset();
        }
        result.setWhere(where);
        result.setGroupBy(group);
        result.setHaving(having);
        result.setOrderBy(order);
        result.setLimit(limit);
        result.setOffset(offset);
        return result;
    }

    public final List SqlSelectCols() throws ParseException {
        List<ColumnIdentifier> list = new ArrayList<ColumnIdentifier>();
        if (this.jj_2_18(2)) {
            if (this.jj_2_17(2)) {
                this.jj_consume_token(190);
                list.add(new ColumnIdentifier("*"));
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: 
                    case 21: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 45: 
                    case 47: 
                    case 49: 
                    case 58: 
                    case 80: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 86: 
                    case 87: 
                    case 94: 
                    case 96: 
                    case 102: 
                    case 108: 
                    case 109: 
                    case 114: 
                    case 115: 
                    case 125: 
                    case 129: 
                    case 168: 
                    case 169: 
                    case 171: 
                    case 172: 
                    case 188: 
                    case 190: 
                    case 193: 
                    case 194: 
                    case 195: {
                        list = this.SqlSelectList();
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        return list;
    }

    public final ColumnIdentifier SqlNextValueFor() throws ParseException {
        String name = null;
        this.jj_consume_token(84);
        this.jj_consume_token(123);
        this.jj_consume_token(51);
        name = this.SqlIdentifier();
        return new ColumnIdentifier(name + ".NEXTVAL");
    }

    public final Literal SqlSelectLimit() throws ParseException {
        Literal limit = null;
        this.jj_consume_token(75);
        limit = this.SqlNumericLiteralOrBindVar();
        return limit;
    }

    public final Literal SqlSelectOffset() throws ParseException {
        Literal offset = null;
        this.jj_consume_token(88);
        offset = this.SqlNumericLiteralOrBindVar();
        return offset;
    }

    public final Literal SqlNumericLiteralOrBindVar() throws ParseException {
        Literal value = null;
        value = this.SqlLiteralOrBindVar();
        try {
            if (!(value instanceof BindVariable) && !(value.evaluate(null) instanceof Number)) {
                throw new ParseException("Expected numeric literal or bind variable.");
            }
        }
        catch (AxionException e) {
            throw new ParseException("AxionException " + e.toString() + " while parsing OFFSET. Shouldn't happen.");
        }
        return value;
    }

    public final Literal SqlLiteralOrBindVar() throws ParseException {
        Literal value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: 
            case 87: 
            case 115: 
            case 168: 
            case 169: 
            case 171: 
            case 190: 
            case 193: {
                value = this.SqlLiteral();
                break;
            }
            case 194: {
                value = this.SqlBindVar();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final AxionCommand SqlUpdate() throws ParseException {
        TableIdentifier table = null;
        ArrayList<Selectable[]> colvalpairs = new ArrayList<Selectable[]>();
        Selectable where = null;
        Selectable[] curpair = null;
        UpdateCommand cmd = new UpdateCommand();
        FromNode from = null;
        FromNode fromInner = null;
        this.jj_consume_token(118);
        table = this.SqlTableRef();
        this.protectSystemTable(table.getTableName());
        cmd.setTable(table);
        this.jj_consume_token(105);
        curpair = this.SqlUpdateAssignment();
        colvalpairs.add(curpair);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 176: {
                    break;
                }
                default: {
                    break block12;
                }
            }
            this.jj_consume_token(176);
            curpair = this.SqlUpdateAssignment();
            colvalpairs.add(curpair);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                this.jj_consume_token(53);
                from = this.SqlFrom();
                AxionQueryContext context = new AxionQueryContext();
                fromInner = new FromNode();
                fromInner.setLeft(table);
                fromInner.setRight(from);
                fromInner.setType(1);
                context.setFrom(fromInner);
                cmd.setQueryContext(context);
                break;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 127: {
                where = this.SqlWhere();
                break;
            }
        }
        for (Selectable[] pair : colvalpairs) {
            cmd.addColumn((ColumnIdentifier)pair[0]);
            cmd.addValue(pair[1]);
        }
        if (fromInner != null) {
            if (where != null) {
                fromInner.setCondition(where);
            }
        } else {
            cmd.setWhere(where);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.SqlUpdateExceptionWhenClause(cmd);
                break;
            }
        }
        return cmd;
    }

    public final void SqlUpdateExceptionWhenClause(UpdateCommand cmd) throws ParseException {
        DMLWhenClause when = null;
        TableIdentifier tid = null;
        List cols = null;
        List vals = null;
        this.jj_consume_token(44);
        when = this.SqlDMLWhenClause();
        this.jj_consume_token(67);
        this.jj_consume_token(68);
        tid = this.SqlTableRef();
        this.protectSystemTable(tid.getTableName());
        if (this.jj_2_19(2)) {
            this.jj_consume_token(188);
            cols = this.SqlSelectCols();
            this.jj_consume_token(189);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                vals = this.insertValues();
                break;
            }
        }
        cmd.setExceptionWhenClause(when, tid, cols, vals);
    }

    public final Selectable[] SqlUpdateAssignment() throws ParseException {
        Selectable[] pair = new Selectable[2];
        pair[0] = this.SqlColumnRef();
        this.jj_consume_token(184);
        pair[1] = this.SqlSumExprSelectable();
        return pair;
    }

    public final AxionCommand SqlUpsert() throws ParseException {
        UpsertCommand upsertCmd = new UpsertCommand();
        TableIdentifier target_table = null;
        TableIdentifier source_table = null;
        AxionQueryContext selectCmdCtx = new AxionQueryContext();
        FromNode from = new FromNode();
        Selectable condition = null;
        Selectable[] curpair = null;
        ArrayList<Selectable[]> columnValuePairsForUpdate = new ArrayList<Selectable[]>();
        List columns = null;
        List values = null;
        AxionCommand subselect = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ArrayList<ColumnIdentifier> list = new ArrayList<ColumnIdentifier>();
        list.add(new ColumnIdentifier("*"));
        selectCmdCtx.setSelect(list);
        selectCmdCtx.setFrom(from);
        upsertCmd.setSelectCommand(new SubSelectCommand(selectCmdCtx));
        this.jj_consume_token(68);
        target_table = this.SqlTableRef();
        this.protectSystemTable(target_table.getTableName());
        from.setRight(target_table);
        upsertCmd.setTargetTable(target_table);
        this.jj_consume_token(121);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 172: 
            case 195: {
                source_table = this.SqlTableRef();
                from.setLeft(source_table);
                upsertCmd.setSourceTable(source_table);
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                subselect = this.SqlSubSelect();
                this.jj_consume_token(189);
                upsertCmd.setUsingSubSelectCommand((SubSelectCommand)subselect);
                from.setLeft(subselect);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        break;
                    }
                }
                String aliasName = this.SqlUnquotedId();
                upsertCmd.setUsingSubSelectAlias(aliasName);
                ((SubSelectCommand)subselect).setAlias(aliasName);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(89);
        condition = this.SqlWhereOr();
        from.setCondition(condition);
        from.setType(2);
        upsertCmd.setCondition(condition);
        this.jj_consume_token(126);
        this.jj_consume_token(78);
        this.jj_consume_token(111);
        this.jj_consume_token(118);
        this.jj_consume_token(105);
        curpair = this.SqlUpdateAssignment();
        columnValuePairsForUpdate.add(curpair);
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 176: {
                    break;
                }
                default: {
                    break block17;
                }
            }
            this.jj_consume_token(176);
            curpair = this.SqlUpdateAssignment();
            columnValuePairsForUpdate.add(curpair);
        }
        for (Selectable[] pair : columnValuePairsForUpdate) {
            upsertCmd.addUpdateColumn((ColumnIdentifier)pair[0]);
            upsertCmd.addUpdateValue(pair[1]);
        }
        this.jj_consume_token(126);
        this.jj_consume_token(86);
        this.jj_consume_token(78);
        this.jj_consume_token(111);
        this.jj_consume_token(67);
        this.jj_consume_token(188);
        columns = this.SqlSelectCols();
        this.jj_consume_token(189);
        values = this.insertValues();
        upsertCmd.setColumnsForInsert(columns);
        upsertCmd.setValuesForInsert(values);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.SqlUpsertExceptionWhenClause(upsertCmd);
                break;
            }
        }
        return upsertCmd;
    }

    public final void SqlUpsertExceptionWhenClause(UpsertCommand cmd) throws ParseException {
        DMLWhenClause when = null;
        TableIdentifier tid = null;
        List cols = null;
        List vals = null;
        this.jj_consume_token(44);
        when = this.SqlDMLWhenClause();
        this.jj_consume_token(67);
        this.jj_consume_token(68);
        tid = this.SqlTableRef();
        this.protectSystemTable(tid.getTableName());
        if (this.jj_2_20(2)) {
            this.jj_consume_token(188);
            cols = this.SqlSelectCols();
            this.jj_consume_token(189);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                vals = this.insertValues();
                break;
            }
        }
        cmd.setExceptionWhenClause(when, tid, cols, vals);
    }

    public final Constraint SqlTableConstraint() throws ParseException {
        Constraint constraint = null;
        String name = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 172: 
                    case 195: {
                        name = this.SqlIdentifier();
                        break block0;
                    }
                }
                break;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: 
            case 87: 
            case 95: 
            case 117: {
                constraint = this.SqlSelectableBasedConstraintType(name);
                this.SqlSelectableBasedConstraintArgs((SelectableBasedConstraint)constraint);
                break;
            }
            case 22: {
                constraint = this.SqlCheckConstraintType(name);
                break;
            }
            case 52: 
            case 98: {
                constraint = this.SqlForeignKeyConstraintType(name);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.jj_2_21(2)) {
            this.SqlDeferrable(constraint);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.SqlInitiallyDeferredOrImmediate(constraint);
                break;
            }
        }
        return constraint;
    }

    public final Constraint SqlColumnConstraint(String tablename, String columnname) throws ParseException {
        Constraint constraint = null;
        String name = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 172: 
                    case 195: {
                        name = this.SqlIdentifier();
                        break block0;
                    }
                }
                break;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: 
            case 87: 
            case 95: 
            case 117: {
                constraint = this.SqlSelectableBasedConstraintType(name);
                constraint.addSelectable(new ColumnIdentifier(new TableIdentifier(tablename), columnname));
                break;
            }
            case 22: {
                constraint = this.SqlCheckConstraintType(name);
                break;
            }
            case 52: 
            case 98: {
                constraint = this.SqlForeignKeyConstraintType(name);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.jj_2_22(2)) {
            this.SqlDeferrable(constraint);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.SqlInitiallyDeferredOrImmediate(constraint);
                break;
            }
        }
        return constraint;
    }

    public final SelectableBasedConstraint SqlSelectableBasedConstraintType(String constraintname) throws ParseException {
        BaseSelectableBasedConstraint constraint = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: {
                this.jj_consume_token(95);
                this.jj_consume_token(71);
                constraint = new PrimaryKeyConstraint(constraintname);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                constraint = new NullConstraint(constraintname);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                this.jj_consume_token(87);
                constraint = new NotNullConstraint(constraintname);
                break;
            }
            case 117: {
                this.jj_consume_token(117);
                constraint = new UniqueConstraint(constraintname);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return constraint;
    }

    public final CheckConstraint SqlCheckConstraintType(String constraintname) throws ParseException {
        CheckConstraint constraint = null;
        Selectable where = null;
        this.jj_consume_token(22);
        constraint = new CheckConstraint(constraintname);
        this.jj_consume_token(188);
        where = this.SqlWhereOr();
        this.jj_consume_token(189);
        constraint.setCondition(where);
        return constraint;
    }

    public final ForeignKeyConstraint SqlForeignKeyConstraintType(String constraintname) throws ParseException {
        ForeignKeyConstraint constraint = null;
        String tablename = null;
        List colList = new ArrayList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                this.jj_consume_token(71);
                this.jj_consume_token(188);
                colList = this.SqlSelectList();
                this.jj_consume_token(189);
                break;
            }
        }
        this.jj_consume_token(98);
        tablename = this.SqlIdentifier();
        constraint = new ForeignKeyConstraint(constraintname);
        constraint.addColumns(colList);
        constraint.setParentTableName(tablename);
        if (this.jj_2_23(2)) {
            this.jj_consume_token(188);
            colList = this.SqlSelectList();
            this.jj_consume_token(189);
            constraint.addForeignColumns(colList);
        }
        if (this.jj_2_24(2)) {
            this.jj_consume_token(89);
            this.SqlForeignKeyConstraintTriger(constraint);
        }
        if (this.jj_2_25(2)) {
            this.jj_consume_token(89);
            this.SqlForeignKeyConstraintTriger(constraint);
        }
        return constraint;
    }

    public final void SqlForeignKeyConstraintTriger(ForeignKeyConstraint constraint) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        constraint.setOnDeleteActionType(10);
                        break block0;
                    }
                    case 105: {
                        this.jj_consume_token(105);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 87: {
                                this.jj_consume_token(87);
                                constraint.setOnDeleteActionType(20);
                                break block0;
                            }
                            case 33: {
                                this.jj_consume_token(33);
                                constraint.setOnDeleteActionType(30);
                                break block0;
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 85: 
                    case 101: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 101: {
                                this.jj_consume_token(101);
                                break;
                            }
                            case 85: {
                                this.jj_consume_token(85);
                                this.jj_consume_token(8);
                                break;
                            }
                            default: {
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        constraint.setOnDeleteActionType(40);
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 118: {
                this.jj_consume_token(118);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        constraint.setOnUpdateActionType(10);
                        break block0;
                    }
                    case 105: {
                        this.jj_consume_token(105);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 87: {
                                this.jj_consume_token(87);
                                constraint.setOnUpdateActionType(20);
                                break block0;
                            }
                            case 33: {
                                this.jj_consume_token(33);
                                constraint.setOnUpdateActionType(30);
                                break block0;
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 85: 
                    case 101: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 101: {
                                this.jj_consume_token(101);
                                break;
                            }
                            case 85: {
                                this.jj_consume_token(85);
                                this.jj_consume_token(8);
                                break;
                            }
                            default: {
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        constraint.setOnUpdateActionType(40);
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void SqlSelectableBasedConstraintArgs(SelectableBasedConstraint constraint) throws ParseException {
        Selectable selectable = null;
        this.jj_consume_token(188);
        selectable = this.SqlSelectableElements();
        constraint.addSelectable(selectable);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 176: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(176);
            selectable = this.SqlSelectableElements();
            constraint.addSelectable(selectable);
        }
        this.jj_consume_token(189);
    }

    public final void SqlDeferrable(Constraint constraint) throws ParseException {
        boolean deferrable = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: {
                this.jj_consume_token(86);
                deferrable = false;
                break;
            }
        }
        this.jj_consume_token(35);
        constraint.setDeferrable(deferrable);
    }

    public final void SqlInitiallyDeferredOrImmediate(Constraint constraint) throws ParseException {
        this.jj_consume_token(64);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                try {
                    constraint.setDeferred(true);
                    break;
                }
                catch (AxionException e) {
                    throw new ParseException("Constraint not deferrable (use DEFERRABLE before INITIALLY DEFERRED)");
                }
            }
            case 62: {
                this.jj_consume_token(62);
                try {
                    constraint.setDeferred(false);
                    break;
                }
                catch (AxionException e) {
                    throw new ParseException("Constraint not deferrable (use DEFERRABLE)");
                }
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String SqlIdentifier() throws ParseException {
        String id = null;
        id = this.SqlQuotedId();
        return id;
    }

    public final String SqlQuotedId() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 172: {
                t = this.jj_consume_token(172);
                return t.image.toUpperCase();
            }
            case 195: {
                this.jj_consume_token(195);
                t = this.jj_consume_token(196);
                this.jj_consume_token(197);
                return t.image.toUpperCase();
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String SqlUnquotedId() throws ParseException {
        Token t = null;
        t = this.jj_consume_token(172);
        return t.image.toUpperCase();
    }

    public final BindVariable SqlBindVar() throws ParseException {
        this.jj_consume_token(194);
        return new BindVariable();
    }

    public final Object[] SqlColumnDef() throws ParseException {
        Object[] tuple = new Object[6];
        CreateSequenceCommand seqCmd = new CreateSequenceCommand();
        tuple[0] = this.SqlValueTerm();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 132: 
            case 141: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 152: 
            case 157: 
            case 158: {
                this.SqlExactNumericType(tuple);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: 
                    case 55: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 33: {
                                this.jj_consume_token(33);
                                tuple[4] = this.SqlSelectable();
                                break block0;
                            }
                            case 55: {
                                this.jj_consume_token(55);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 11: {
                                        this.jj_consume_token(11);
                                        seqCmd.setIdentityType("always");
                                        break;
                                    }
                                    case 18: {
                                        this.jj_consume_token(18);
                                        this.jj_consume_token(33);
                                        seqCmd.setIdentityType("default");
                                        break;
                                    }
                                    default: {
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                this.jj_consume_token(13);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 59: {
                                        this.jj_consume_token(59);
                                        this.SqlBasicSequenceOption(seqCmd);
                                        seqCmd.setObjectName((String)tuple[0]);
                                        tuple[4] = seqCmd;
                                        break block0;
                                    }
                                    case 188: {
                                        this.jj_consume_token(188);
                                        tuple[4] = this.SqlSelectable();
                                        this.jj_consume_token(189);
                                        tuple[5] = "always";
                                        break block0;
                                    }
                                }
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            }
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 150: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 159: 
            case 160: 
            case 161: 
            case 164: 
            case 166: 
            case 167: 
            case 172: {
                if (this.jj_2_26(2)) {
                    this.SqlCharStringType(tuple);
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 131: 
                        case 135: 
                        case 142: 
                        case 143: 
                        case 145: 
                        case 159: 
                        case 160: 
                        case 161: {
                            this.SqlBinaryStringType(tuple);
                            break;
                        }
                        case 133: 
                        case 140: 
                        case 167: {
                            this.SqlApproximateNumericType(tuple);
                            break;
                        }
                        case 130: 
                        case 150: {
                            this.SqlBooleanType(tuple);
                            break;
                        }
                        case 138: 
                        case 139: 
                        case 164: {
                            this.SqlDataTimeType(tuple);
                            break;
                        }
                        case 166: {
                            this.SqlJavaObjectType(tuple);
                            break;
                        }
                        case 172: {
                            this.SqlUserDefinedType(tuple);
                            break;
                        }
                        default: {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: 
                    case 55: {
                        this.SqlGCAndDefaultClause(tuple);
                        break block0;
                    }
                }
                break;
            }
            case 33: 
            case 55: {
                this.SqlGCAndDefaultClause(tuple);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tuple;
    }

    public final void SqlGCAndDefaultClause(Object[] tuple) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                tuple[4] = this.SqlSelectable();
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                this.jj_consume_token(11);
                this.jj_consume_token(13);
                tuple[5] = "always";
                this.jj_consume_token(188);
                tuple[4] = this.SqlSelectable();
                this.jj_consume_token(189);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void SqlCharStringType(Object[] tuple) throws ParseException {
        if (this.jj_2_28(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 136: {
                    this.jj_consume_token(136);
                    break;
                }
                case 137: {
                    this.jj_consume_token(137);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            tuple[1] = "CHAR";
            tuple[2] = "1";
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 188: {
                    this.SqlCharLength(tuple);
                    break;
                }
            }
        } else if (this.jj_2_29(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 136: {
                    this.jj_consume_token(136);
                    this.jj_consume_token(162);
                    break;
                }
                case 137: {
                    this.jj_consume_token(137);
                    this.jj_consume_token(162);
                    break;
                }
                case 153: {
                    this.jj_consume_token(153);
                    break;
                }
                case 154: {
                    this.jj_consume_token(154);
                    break;
                }
                case 144: {
                    this.jj_consume_token(144);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            tuple[1] = "VARCHAR";
            tuple[2] = "1";
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 188: {
                    this.SqlCharLength(tuple);
                    break;
                }
            }
        } else {
            block17 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 142: 
                case 155: 
                case 156: {
                    if (this.jj_2_27(2)) {
                        this.jj_consume_token(142);
                    } else {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 142: {
                                this.jj_consume_token(142);
                                this.jj_consume_token(153);
                                break;
                            }
                            case 155: {
                                this.jj_consume_token(155);
                                break;
                            }
                            case 156: {
                                this.jj_consume_token(156);
                                break;
                            }
                            default: {
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    tuple[1] = "VARCHAR";
                    tuple[2] = "2147483647";
                    break;
                }
                case 134: 
                case 136: 
                case 137: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 136: {
                            this.jj_consume_token(136);
                            this.jj_consume_token(163);
                            this.jj_consume_token(165);
                            break;
                        }
                        case 137: {
                            this.jj_consume_token(137);
                            this.jj_consume_token(163);
                            this.jj_consume_token(165);
                            break;
                        }
                        case 134: {
                            this.jj_consume_token(134);
                            break;
                        }
                        default: {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    tuple[1] = "CLOB";
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 188: {
                            this.SqlPrecision(tuple);
                            break block17;
                        }
                    }
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void SqlBinaryStringType(Object[] tuple) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 131: {
                this.jj_consume_token(131);
                tuple[1] = "BYTE";
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 188: {
                        this.SqlPrecision(tuple);
                        break block0;
                    }
                }
                break;
            }
            default: {
                if (this.jj_2_31(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 145: {
                            this.jj_consume_token(145);
                            break;
                        }
                        case 159: {
                            this.jj_consume_token(159);
                            break;
                        }
                        case 143: {
                            this.jj_consume_token(143);
                            break;
                        }
                        default: {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    tuple[1] = "VARBINARY";
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 188: {
                            this.SqlPrecision(tuple);
                            break block0;
                        }
                    }
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 142: 
                    case 160: 
                    case 161: {
                        if (this.jj_2_30(2)) {
                            this.jj_consume_token(142);
                            this.jj_consume_token(159);
                        } else {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 160: {
                                    this.jj_consume_token(160);
                                    break;
                                }
                                case 142: {
                                    this.jj_consume_token(142);
                                    this.jj_consume_token(143);
                                    break;
                                }
                                case 161: {
                                    this.jj_consume_token(161);
                                    break;
                                }
                                default: {
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                        }
                        tuple[1] = "VARBINARY";
                        tuple[2] = "2147483647";
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 188: {
                                this.SqlCharLength(tuple);
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 135: 
                    case 145: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 145: {
                                this.jj_consume_token(145);
                                this.jj_consume_token(163);
                                this.jj_consume_token(165);
                                break;
                            }
                            case 135: {
                                this.jj_consume_token(135);
                                break;
                            }
                            default: {
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        tuple[1] = "BLOB";
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 188: {
                                this.SqlPrecision(tuple);
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void SqlExactNumericType(Object[] tuple) throws ParseException {
        Integer precision = new Integer(22);
        Integer scale = new Integer(0);
        if (this.jj_2_32(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 146: {
                    this.jj_consume_token(146);
                    break;
                }
                case 148: {
                    this.jj_consume_token(148);
                    break;
                }
                case 149: {
                    this.jj_consume_token(149);
                    break;
                }
                case 147: {
                    this.jj_consume_token(147);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            tuple[1] = "NUMERIC";
            tuple[2] = precision.toString();
            tuple[3] = scale.toString();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 188: {
                    this.SqlPrecisionAndScale(tuple);
                    break;
                }
            }
            precision = Integer.valueOf(tuple[2].toString());
            scale = Integer.valueOf(tuple[3].toString());
            if (scale.compareTo(precision) > 0) {
                throw new AxionSqlParseException("scale value exceeds precision value", 22003);
            }
            if (precision.compareTo(new Integer(38)) > 0) {
                throw new AxionSqlParseException("precision value exceeds maximum (38)", 22003);
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 132: 
                case 152: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 152: {
                            this.jj_consume_token(152);
                            break;
                        }
                        case 132: {
                            this.jj_consume_token(132);
                            break;
                        }
                        default: {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    tuple[1] = "INTEGER";
                    break;
                }
                case 157: 
                case 158: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 157: {
                            this.jj_consume_token(157);
                            break;
                        }
                        case 158: {
                            this.jj_consume_token(158);
                            break;
                        }
                        default: {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    tuple[1] = "SHORT";
                    break;
                }
                case 141: {
                    this.jj_consume_token(141);
                    tuple[1] = "BIGINT";
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void SqlApproximateNumericType(Object[] tuple) throws ParseException {
        if (this.jj_2_33(3)) {
            this.jj_consume_token(140);
            tuple[1] = "FLOAT";
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 188: {
                    this.SqlPrecision(tuple);
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 133: {
                    this.jj_consume_token(133);
                    tuple[1] = "FLOAT";
                    break;
                }
                case 167: {
                    this.jj_consume_token(167);
                    tuple[1] = "DOUBLE";
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void SqlBooleanType(Object[] tuple) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 150: {
                this.jj_consume_token(150);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        tuple[1] = "BOOLEAN";
    }

    public final void SqlDataTimeType(Object[] tuple) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                tuple[1] = "DATE";
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                tuple[1] = "TIME";
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 188: {
                        this.SqlPrecision(tuple);
                        break block0;
                    }
                }
                break;
            }
            case 164: {
                this.jj_consume_token(164);
                tuple[1] = "TIMESTAMP";
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 188: {
                        this.SqlPrecision(tuple);
                        break block0;
                    }
                }
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void SqlJavaObjectType(Object[] tuple) throws ParseException {
        this.jj_consume_token(166);
        tuple[1] = "JAVA_OBJECT";
    }

    public final void SqlUserDefinedType(Object[] tuple) throws ParseException {
        tuple[1] = this.SqlClassName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 188: {
                this.SqlPrecisionAndScale(tuple);
                break;
            }
        }
    }

    public final void SqlCharLength(Object[] tuple) throws ParseException {
        this.jj_consume_token(188);
        tuple[2] = this.SqlPositiveInteger();
        this.jj_consume_token(189);
    }

    public final void SqlPrecisionAndScale(Object[] tuple) throws ParseException {
        this.jj_consume_token(188);
        tuple[2] = this.SqlPositiveInteger();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 176: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(176);
            tuple[3] = this.SqlUnsignedInteger();
        }
        this.jj_consume_token(189);
    }

    public final void SqlPrecision(Object[] tuple) throws ParseException {
        this.jj_consume_token(188);
        tuple[2] = this.SqlUnsignedInteger();
        this.jj_consume_token(189);
    }

    public final String SqlPositiveInteger() throws ParseException {
        int val;
        String valStr = null;
        valStr = this.SqlUnsignedInteger();
        int n = val = valStr != null ? Integer.valueOf(valStr) : -1;
        if (val == 0) {
            throw new AxionSqlParseException("value must be a positive integer", 22003);
        }
        return valStr;
    }

    public final String SqlUnsignedInteger() throws ParseException {
        Token t = null;
        t = this.jj_consume_token(168);
        if (t != null) {
            return t.image;
        }
        return null;
    }

    public final ColumnIdentifier SqlColumnRef() throws ParseException {
        String column = null;
        column = this.SqlValueTerm();
        return new ColumnIdentifier(column);
    }

    public final Selectable SqlCase() throws ParseException {
        ArrayList<Selectable> caseargs = new ArrayList<Selectable>();
        ArrayList<Selectable> whenargs = null;
        ArrayList<Selectable> eqargs = null;
        Selectable condition = null;
        Selectable caseOperand = null;
        Selectable whenArg = null;
        Selectable thenArg = null;
        Selectable elseArg = null;
        FunctionIdentifier whenFn = null;
        FunctionIdentifier caseFn = null;
        FunctionIdentifier eqFn = null;
        FunctionIdentifier orFn = null;
        this.jj_consume_token(21);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 45: 
            case 47: 
            case 49: 
            case 58: 
            case 80: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 94: 
            case 96: 
            case 102: 
            case 108: 
            case 109: 
            case 114: 
            case 115: 
            case 125: 
            case 129: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 188: 
            case 190: 
            case 193: 
            case 194: 
            case 195: {
                caseOperand = this.SqlSelectable();
                block19: while (true) {
                    this.jj_consume_token(126);
                    whenArg = this.SqlSelectable();
                    eqargs = new ArrayList<Selectable>();
                    eqargs.add(caseOperand);
                    eqargs.add(whenArg);
                    eqFn = new FunctionIdentifier("=", eqargs);
                    whenargs = new ArrayList();
                    whenargs.add(eqFn);
                    block20: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 176: {
                                break;
                            }
                            default: {
                                break block20;
                            }
                        }
                        this.jj_consume_token(176);
                        whenArg = this.SqlSelectable();
                        eqargs = new ArrayList();
                        eqargs.add(caseOperand);
                        eqargs.add(whenArg);
                        eqFn = new FunctionIdentifier("=", eqargs);
                        ArrayList<FunctionIdentifier> orargs = new ArrayList<FunctionIdentifier>();
                        orargs.add(eqFn);
                        orargs.add((FunctionIdentifier)whenargs.get(0));
                        orFn = new FunctionIdentifier("OR", orargs);
                        whenargs.set(0, orFn);
                    }
                    this.jj_consume_token(111);
                    thenArg = this.SqlSelectable();
                    whenargs.add(thenArg);
                    whenFn = new FunctionIdentifier("IFTHEN", whenargs);
                    caseargs.add(whenFn);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 126: {
                            continue block19;
                        }
                    }
                    break;
                }
                break;
            }
            case 126: {
                block21: while (true) {
                    this.jj_consume_token(126);
                    condition = this.SqlWhereOr();
                    whenargs = new ArrayList<Selectable>();
                    whenargs.add(condition);
                    block22: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 176: {
                                break;
                            }
                            default: {
                                break block22;
                            }
                        }
                        this.jj_consume_token(176);
                        condition = this.SqlWhereOr();
                        ArrayList<Selectable> orargs = new ArrayList<Selectable>();
                        orargs.add(condition);
                        orargs.add((Selectable)whenargs.get(0));
                        orFn = new FunctionIdentifier("OR", orargs);
                        whenargs.set(0, orFn);
                    }
                    this.jj_consume_token(111);
                    thenArg = this.SqlSelectable();
                    whenargs.add(thenArg);
                    whenFn = new FunctionIdentifier("IFTHEN", whenargs);
                    caseargs.add(whenFn);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 126: {
                            continue block21;
                        }
                    }
                    break;
                }
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                elseArg = this.SqlSelectable();
                caseargs.add(elseArg);
                break;
            }
        }
        this.jj_consume_token(42);
        caseFn = new FunctionIdentifier("COALESCE", caseargs);
        return caseFn;
    }

    public final Selectable SqlPseudoColumn() throws ParseException {
        ArrayList<BaseSelectable> fnargs = null;
        FunctionIdentifier fn = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: 
            case 109: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 109: {
                        this.jj_consume_token(109);
                        break;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                fn = new FunctionIdentifier("NOW", Collections.EMPTY_LIST);
                fn.setAlias("CURRENT_TIMESTAMP");
                return fn;
            }
            case 27: {
                this.jj_consume_token(27);
                fnargs = new ArrayList<BaseSelectable>();
                fnargs.add(new FunctionIdentifier("NOW", Collections.EMPTY_LIST));
                fnargs.add(new Literal("DATE"));
                fn = new FunctionIdentifier("CASTAS", fnargs);
                fn.setAlias("CURRENT_DATE");
                return fn;
            }
            case 28: {
                this.jj_consume_token(28);
                fnargs = new ArrayList();
                fnargs.add(new FunctionIdentifier("NOW", Collections.EMPTY_LIST));
                fnargs.add(new Literal("TIME"));
                fn = new FunctionIdentifier("CASTAS", fnargs);
                fn.setAlias("CURRENT_TIME");
                return fn;
            }
            case 32: {
                this.jj_consume_token(32);
                return new Literal("DAY");
            }
            case 83: {
                this.jj_consume_token(83);
                return new Literal("MONTH");
            }
            case 129: {
                this.jj_consume_token(129);
                return new Literal("YEAR");
            }
            case 58: {
                this.jj_consume_token(58);
                return new Literal("HOUR");
            }
            case 80: {
                this.jj_consume_token(80);
                return new Literal("MINUTE");
            }
            case 102: {
                this.jj_consume_token(102);
                return new Literal("SECOND");
            }
            case 125: {
                this.jj_consume_token(125);
                return new Literal("WEEK");
            }
            case 96: {
                this.jj_consume_token(96);
                return new Literal("QUARTER");
            }
            case 82: {
                this.jj_consume_token(82);
                return new Literal("MILLISECOND");
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Selectable SqlCastAs() throws ParseException {
        Selectable identifer = null;
        ArrayList<Selectable> fnargs = null;
        this.jj_consume_token(19);
        this.jj_consume_token(188);
        identifer = this.SqlSumExprSelectable();
        this.jj_consume_token(13);
        Object[] tuple = this.SqlCastAsType();
        this.jj_consume_token(189);
        Literal literal = new Literal(tuple[1]);
        fnargs = new ArrayList<Selectable>();
        fnargs.add(identifer);
        fnargs.add(literal);
        if (tuple[2] != null) {
            Literal precision = new Literal(tuple[2]);
            fnargs.add(precision);
        }
        if (tuple[3] != null) {
            Literal scale = new Literal(tuple[3]);
            fnargs.add(scale);
        }
        return new FunctionIdentifier("CASTAS", fnargs);
    }

    public final Object[] SqlCastAsType() throws ParseException {
        Object[] tuple = new Object[5];
        if (this.jj_2_34(2)) {
            this.SqlCharStringType(tuple);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 131: 
                case 135: 
                case 142: 
                case 143: 
                case 145: 
                case 159: 
                case 160: 
                case 161: {
                    this.SqlBinaryStringType(tuple);
                    break;
                }
                case 132: 
                case 141: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 152: 
                case 157: 
                case 158: {
                    this.SqlExactNumericType(tuple);
                    break;
                }
                case 133: 
                case 140: 
                case 167: {
                    this.SqlApproximateNumericType(tuple);
                    break;
                }
                case 130: 
                case 150: {
                    this.SqlBooleanType(tuple);
                    break;
                }
                case 138: 
                case 139: 
                case 164: {
                    this.SqlDataTimeType(tuple);
                    break;
                }
                case 166: {
                    this.SqlJavaObjectType(tuple);
                    break;
                }
                case 172: {
                    this.SqlUserDefinedType(tuple);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return tuple;
    }

    public final Selectable SqlSubString() throws ParseException {
        Selectable charValueExpr = null;
        String startPos = null;
        String strLength = null;
        ArrayList<Selectable> fnargs = null;
        this.jj_consume_token(108);
        this.jj_consume_token(188);
        charValueExpr = this.SqlSumExprSelectable();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 176: {
                this.jj_consume_token(176);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        startPos = this.SqlUnsignedInteger();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 176: {
                this.jj_consume_token(176);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        strLength = this.SqlUnsignedInteger();
        this.jj_consume_token(189);
        fnargs = new ArrayList<Selectable>();
        fnargs.add(charValueExpr);
        fnargs.add(new Literal(startPos));
        fnargs.add(new Literal(strLength));
        return new FunctionIdentifier("SUBSTRING", fnargs);
    }

    public final Selectable SqlExtract() throws ParseException {
        Selectable datePart = null;
        Selectable dateSrc = null;
        ArrayList<Selectable> fnargs = null;
        this.jj_consume_token(47);
        this.jj_consume_token(188);
        datePart = this.SqlSumExprSelectable();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 176: {
                this.jj_consume_token(176);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        dateSrc = this.SqlSumExprSelectable();
        this.jj_consume_token(189);
        fnargs = new ArrayList<Selectable>();
        fnargs.add(datePart);
        fnargs.add(dateSrc);
        return new FunctionIdentifier("EXTRACT", fnargs);
    }

    public final Selectable SqlPosition() throws ParseException {
        Selectable charValueExpr1 = null;
        Selectable charValueExpr2 = null;
        ArrayList<Selectable> fnargs = null;
        this.jj_consume_token(94);
        this.jj_consume_token(188);
        charValueExpr1 = this.SqlSumExprSelectable();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 176: {
                this.jj_consume_token(176);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        charValueExpr2 = this.SqlSumExprSelectable();
        this.jj_consume_token(189);
        fnargs = new ArrayList<Selectable>();
        fnargs.add(charValueExpr2);
        fnargs.add(charValueExpr1);
        return new FunctionIdentifier("POSITION", fnargs);
    }

    public final Selectable SqlTrim() throws ParseException {
        Selectable trimSource = null;
        Selectable trimChar = null;
        int type = 3;
        ArrayList<Selectable> fnargs = null;
        this.jj_consume_token(114);
        this.jj_consume_token(188);
        if (this.jj_2_35(2)) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 72: 
                case 113: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 72: {
                            this.jj_consume_token(72);
                            type = 1;
                            break block0;
                        }
                        case 113: {
                            this.jj_consume_token(113);
                            type = 2;
                            break block0;
                        }
                        case 17: {
                            this.jj_consume_token(17);
                            type = 3;
                            break block0;
                        }
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 32: 
                case 45: 
                case 47: 
                case 49: 
                case 58: 
                case 80: 
                case 82: 
                case 83: 
                case 87: 
                case 94: 
                case 96: 
                case 102: 
                case 108: 
                case 109: 
                case 114: 
                case 115: 
                case 125: 
                case 129: 
                case 168: 
                case 169: 
                case 171: 
                case 172: 
                case 188: 
                case 190: 
                case 193: 
                case 194: 
                case 195: {
                    trimChar = this.SqlSumExprSelectable();
                    break;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 53: {
                    this.jj_consume_token(53);
                    break;
                }
                case 176: {
                    this.jj_consume_token(176);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        trimSource = this.SqlSumExprSelectable();
        this.jj_consume_token(189);
        fnargs = new ArrayList<Selectable>();
        fnargs.add(new Literal(new Integer(type)));
        fnargs.add(trimSource);
        if (trimChar != null) {
            fnargs.add(trimChar);
        }
        return new FunctionIdentifier("TRIM", fnargs);
    }

    public final Selectable SqlFunction() throws ParseException {
        String name = null;
        List fnargs = null;
        FunctionIdentifier sel = null;
        name = this.SqlUnquotedId();
        fnargs = this.SqlFunctionArgs(name);
        sel = new FunctionIdentifier(name, fnargs);
        return sel;
    }

    public final List SqlFunctionArgs(String name) throws ParseException {
        List<Literal> args = new ArrayList();
        String qualifier = null;
        String fn = null;
        Token t = null;
        this.jj_consume_token(188);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 39: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 39: {
                        t = this.jj_consume_token(39);
                        break;
                    }
                    case 9: {
                        t = this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                fn = name.toUpperCase();
                if (fn.equals("AVG") || fn.equals("SUM") || fn.equals("MAX") || fn.equals("MIN") || fn.equals("COUNT")) {
                    qualifier = t.image.toUpperCase();
                    break;
                }
                throw new ParseException("DISTINCT is not allowed for scalar function: " + name);
            }
        }
        args = this.SqlSelectCols();
        this.jj_consume_token(189);
        if (qualifier != null) {
            args.add(new Literal(qualifier, new CharacterType(qualifier.length())));
        }
        return args;
    }

    public final Selectable SqlSumExprSelectable() throws ParseException {
        FunctionIdentifier parent = null;
        Selectable left = null;
        Selectable right = null;
        String function = null;
        String fnalias = null;
        Selectable result = null;
        result = left = this.SqlProductExprSelectable();
        while (this.jj_2_36(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 192: {
                    this.jj_consume_token(192);
                    function = "+";
                    fnalias = "ADD";
                    break;
                }
                case 193: {
                    this.jj_consume_token(193);
                    function = "-";
                    fnalias = "SUBTRACT";
                    break;
                }
                case 177: {
                    this.jj_consume_token(177);
                    function = "||";
                    fnalias = "CONCAT";
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            right = this.SqlProductExprSelectable();
            parent = new FunctionIdentifier(function);
            parent.setAlias(fnalias);
            parent.addArgument(left);
            parent.addArgument(right);
            left = parent;
            result = parent;
        }
        return result;
    }

    public final Selectable SqlProductExprSelectable() throws ParseException {
        FunctionIdentifier parent = null;
        Selectable left = null;
        Selectable right = null;
        String function = null;
        String fnalias = null;
        Selectable result = null;
        result = left = this.SqlSelectableElements();
        while (this.jj_2_37(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 190: {
                    this.jj_consume_token(190);
                    function = "*";
                    fnalias = "MULTIPLY";
                    break;
                }
                case 191: {
                    this.jj_consume_token(191);
                    function = "/";
                    fnalias = "DIVIDE";
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            right = this.SqlSelectableElements();
            parent = new FunctionIdentifier(function);
            parent.setAlias(fnalias);
            parent.addArgument(left);
            parent.addArgument(right);
            left = parent;
            result = parent;
        }
        return result;
    }

    public final List SqlLiteralList() throws ParseException {
        ArrayList<Literal> result = new ArrayList<Literal>();
        Selectable cur = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: 
            case 87: 
            case 115: 
            case 168: 
            case 169: 
            case 171: 
            case 190: 
            case 193: {
                cur = this.SqlLiteral();
                break;
            }
            case 194: {
                cur = this.SqlBindVar();
                break;
            }
            case 188: {
                cur = this.SqlSelectAsScalarValue();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        result.add((Literal)cur);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 176: {
                    break;
                }
                default: {
                    break block13;
                }
            }
            this.jj_consume_token(176);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 49: 
                case 87: 
                case 115: 
                case 168: 
                case 169: 
                case 171: 
                case 190: 
                case 193: {
                    cur = this.SqlLiteral();
                    break;
                }
                case 194: {
                    cur = this.SqlBindVar();
                    break;
                }
                case 188: {
                    cur = this.SqlSelectAsScalarValue();
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            result.add((Literal)cur);
        }
        return result;
    }

    public final String SqlLValue() throws ParseException {
        String s = null;
        s = this.SqlValueTerm();
        return s;
    }

    public final Literal SqlLiteral() throws ParseException {
        Literal literal = null;
        Token t = null;
        boolean minus = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 171: {
                t = this.jj_consume_token(171);
                String trimmed = t.image.substring(1, t.image.length() - 1);
                String result = AxionSqlParser.replace(trimmed, "''", "'");
                literal = new Literal(result, new CharacterType(result.length()));
                break;
            }
            case 168: 
            case 169: 
            case 193: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 193: {
                        this.jj_consume_token(193);
                        minus = true;
                        break;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 168: {
                        t = this.jj_consume_token(168);
                        BigDecimal value = new BigDecimal((minus ? "-" : "") + t.image);
                        int precision = t.image.length();
                        literal = new Literal(value, new BigDecimalType(precision, 0));
                        break block0;
                    }
                    case 169: {
                        t = this.jj_consume_token(169);
                        BigDecimal value = new BigDecimal((minus ? "-" : "") + t.image);
                        int precision = value.unscaledValue().abs().toString().length();
                        int scale = value.scale();
                        literal = new Literal(value, new BigDecimalType(precision, scale));
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 87: {
                this.jj_consume_token(87);
                literal = new Literal((Object)null);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                literal = new Literal(Boolean.TRUE, new BooleanType());
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                literal = new Literal(Boolean.FALSE, new BooleanType());
                break;
            }
            case 190: {
                this.jj_consume_token(190);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return literal;
    }

    public final String SqlValueTerm() throws ParseException {
        StringBuffer buffer;
        block8: {
            buffer = new StringBuffer();
            String id = null;
            Token t = null;
            id = this.SqlQuotedId();
            buffer.append(id);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 179: {
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                t = this.jj_consume_token(179);
                buffer.append(t.image);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 172: 
                    case 195: {
                        id = this.SqlQuotedId();
                        buffer.append(id);
                        continue block7;
                    }
                    case 190: {
                        this.jj_consume_token(190);
                        buffer.append("*");
                        continue block7;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return buffer.toString();
    }

    public final String SqlClassName() throws ParseException {
        StringBuffer buffer = new StringBuffer();
        Token t = null;
        t = this.jj_consume_token(172);
        buffer.append(t.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 179: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            t = this.jj_consume_token(179);
            buffer.append(t.image);
            t = this.jj_consume_token(172);
            buffer.append(t.image);
        }
        return buffer.toString();
    }

    public final Selectable SqlSelectable() throws ParseException {
        Selectable sel = null;
        sel = this.SqlWhereOr();
        return sel;
    }

    public final Selectable SqlSelectAsScalarValue() throws ParseException {
        AxionCommand select = null;
        this.jj_consume_token(188);
        select = this.SqlSubSelect();
        this.jj_consume_token(189);
        ((SubSelectCommand)select).setEvaluteAsScalarValue();
        return (Selectable)((Object)select);
    }

    public final Selectable SqlSelectableElements() throws ParseException {
        Selectable sel = null;
        if (this.jj_2_39(2)) {
            this.jj_consume_token(188);
            sel = this.SqlWhereOr();
            this.jj_consume_token(189);
            return sel;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 45: 
            case 47: 
            case 49: 
            case 58: 
            case 80: 
            case 82: 
            case 83: 
            case 87: 
            case 94: 
            case 96: 
            case 102: 
            case 108: 
            case 109: 
            case 114: 
            case 115: 
            case 125: 
            case 129: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 188: 
            case 190: 
            case 193: 
            case 194: 
            case 195: {
                if (this.jj_2_38(2)) {
                    sel = this.SqlFunction();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 172: 
                        case 195: {
                            sel = this.SqlColumnRef();
                            break;
                        }
                        case 19: {
                            sel = this.SqlCastAs();
                            break;
                        }
                        case 108: {
                            sel = this.SqlSubString();
                            break;
                        }
                        case 94: {
                            sel = this.SqlPosition();
                            break;
                        }
                        case 47: {
                            sel = this.SqlExtract();
                            break;
                        }
                        case 114: {
                            sel = this.SqlTrim();
                            break;
                        }
                        case 49: 
                        case 87: 
                        case 115: 
                        case 168: 
                        case 169: 
                        case 171: 
                        case 190: 
                        case 193: {
                            sel = this.SqlLiteral();
                            break;
                        }
                        case 194: {
                            sel = this.SqlBindVar();
                            break;
                        }
                        case 21: {
                            sel = this.SqlCase();
                            break;
                        }
                        case 26: 
                        case 27: 
                        case 28: 
                        case 32: 
                        case 58: 
                        case 80: 
                        case 82: 
                        case 83: 
                        case 96: 
                        case 102: 
                        case 109: 
                        case 125: 
                        case 129: {
                            sel = this.SqlPseudoColumn();
                            break;
                        }
                        case 45: {
                            sel = this.SqlExistsClause();
                            break;
                        }
                        case 188: {
                            sel = this.SqlSelectAsScalarValue();
                            break;
                        }
                        default: {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                return sel;
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List SqlSelectList() throws ParseException {
        ArrayList<Selectable> list = new ArrayList<Selectable>();
        Selectable curCol = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 45: 
            case 47: 
            case 49: 
            case 58: 
            case 80: 
            case 82: 
            case 83: 
            case 86: 
            case 87: 
            case 94: 
            case 96: 
            case 102: 
            case 108: 
            case 109: 
            case 114: 
            case 115: 
            case 125: 
            case 129: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 188: 
            case 190: 
            case 193: 
            case 194: 
            case 195: {
                curCol = this.SqlSelectClauseElement();
                break;
            }
            case 84: {
                curCol = this.SqlNextValueFor();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        list.add(curCol);
        while (this.jj_2_40(2)) {
            this.jj_consume_token(176);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 32: 
                case 45: 
                case 47: 
                case 49: 
                case 58: 
                case 80: 
                case 82: 
                case 83: 
                case 86: 
                case 87: 
                case 94: 
                case 96: 
                case 102: 
                case 108: 
                case 109: 
                case 114: 
                case 115: 
                case 125: 
                case 129: 
                case 168: 
                case 169: 
                case 171: 
                case 172: 
                case 188: 
                case 190: 
                case 193: 
                case 194: 
                case 195: {
                    curCol = this.SqlSelectClauseElement();
                    break;
                }
                case 84: {
                    curCol = this.SqlNextValueFor();
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            list.add(curCol);
        }
        Iterator itr = list.iterator();
        FunctionIdentifier function = null;
        String fName = null;
        Object obj = null;
        HashMap aliasSuffixCounterMap = new HashMap();
        while (itr.hasNext()) {
            obj = itr.next();
            if (!(obj instanceof FunctionIdentifier)) continue;
            function = obj;
            fName = function.getName().toUpperCase();
            if (function.getAlias() != null) continue;
            function.setAlias(this.getUniqueAliasName(aliasSuffixCounterMap, fName));
        }
        return list;
    }

    public final Selectable SqlSelectClauseElement() throws ParseException {
        Selectable curCol = null;
        String id = null;
        curCol = this.SqlSelectable();
        if (this.jj_2_41(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    this.jj_consume_token(13);
                    break;
                }
            }
            id = this.SqlQuotedId();
        }
        if (curCol instanceof FunctionIdentifier) {
            FunctionIdentifier fn = (FunctionIdentifier)curCol;
            String fName = fn.getName().toUpperCase();
            if (fName.equals("AND") || fName.equals("OR")) {
                throw new ParseException("Branch Functions not allowed here");
            }
            if (fName.equals("<") || fName.equals(">") || fName.equals("=") || fName.equals("!=") || fName.equals(">=") || fName.equals("<=")) {
                throw new ParseException("Comparison Functions not allowed here");
            }
        }
        if (id != null) {
            if (curCol instanceof ColumnIdentifier) {
                ((ColumnIdentifier)curCol).setAlias(id);
            }
            if (curCol instanceof FunctionIdentifier) {
                ((FunctionIdentifier)curCol).setAlias(id);
            }
            if (curCol instanceof Literal) {
                ((Literal)curCol).setAlias(id);
            }
            if (curCol instanceof SubSelectCommand) {
                ((SubSelectCommand)curCol).setAlias(id);
            }
        }
        return curCol;
    }

    public final TableIdentifier SqlTableRef() throws ParseException {
        String name = null;
        String alias = null;
        name = this.SqlQuotedId();
        if (this.jj_2_42(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    this.jj_consume_token(13);
                    break;
                }
            }
            alias = this.SqlQuotedId();
        }
        return new TableIdentifier(name, alias);
    }

    public final List SqlOrderBy() throws ParseException {
        List result = null;
        this.jj_consume_token(91);
        this.jj_consume_token(18);
        result = this.SqlOrderByList();
        return result;
    }

    public final OrderNode SqlOrderByElem() throws ParseException {
        Selectable sel = null;
        boolean ascending = true;
        sel = this.SqlSelectableElements();
        if (this.jj_2_43(2)) {
            ascending = this.SqlOrderDirection();
        }
        return new OrderNode(sel, !ascending);
    }

    public final List SqlOrderByList() throws ParseException {
        ArrayList<OrderNode> result = new ArrayList<OrderNode>();
        OrderNode cur = null;
        cur = this.SqlOrderByElem();
        result.add(cur);
        while (this.jj_2_44(2)) {
            this.jj_consume_token(176);
            cur = this.SqlOrderByElem();
            result.add(cur);
        }
        return result;
    }

    public final boolean SqlOrderDirection() throws ParseException {
        boolean ascending = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                ascending = false;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ascending;
    }

    public final List SqlGroupBy() throws ParseException {
        List groupByCols = null;
        this.jj_consume_token(56);
        this.jj_consume_token(18);
        groupByCols = this.SqlGroupByList();
        return groupByCols;
    }

    public final Selectable SqlGroupByElem() throws ParseException {
        Selectable sel = null;
        sel = this.SqlSelectableElements();
        return sel;
    }

    public final List SqlGroupByList() throws ParseException {
        ArrayList<Selectable> result = new ArrayList<Selectable>();
        Selectable cur = null;
        cur = this.SqlGroupByElem();
        result.add(cur);
        while (this.jj_2_45(2)) {
            this.jj_consume_token(176);
            cur = this.SqlGroupByElem();
            result.add(cur);
        }
        return result;
    }

    public final FromNode SqlFrom() throws ParseException {
        FromNode node = new FromNode();
        Object curTable = null;
        curTable = this.SqlTableOrView();
        node.setLeft(curTable);
        if (this.jj_2_46(2)) {
            if ((node = this.SqlGetRightFromNode(node)).getRight() == null) {
                node = (FromNode)node.getLeft();
            } else if (node.getLeft() == null) {
                node = (FromNode)node.getRight();
            }
        }
        return node;
    }

    public final FromNode SqlGetTraditionalFromNode(FromNode basenode) throws ParseException {
        FromNode node = null;
        FromNode temp = null;
        Object curTable = null;
        curTable = this.SqlTableOrView();
        temp = new FromNode();
        temp.setLeft(basenode.getLeft());
        temp.setRight(curTable);
        temp.setType(1);
        temp.setCondition(null);
        basenode.setLeft(temp);
        node = basenode;
        if (this.jj_2_47(2)) {
            node = this.SqlGetRightFromNode(basenode);
            if (basenode.getType() != 0) {
                temp = new FromNode();
                temp = (FromNode)basenode.getLeft();
                basenode.setLeft(temp.getRight());
                temp.setRight(basenode);
                temp.setType(1);
                node = temp;
            }
        }
        return node;
    }

    public final Object SqlGetAnsiFromNode() throws ParseException {
        FromNode node = new FromNode();
        Object curNode = null;
        curNode = this.SqlTableOrView();
        if (this.jj_2_48(2)) {
            node = this.SqlGetRightFromNode(node);
            node.setLeft(curNode);
            curNode = node;
        }
        return curNode;
    }

    public final FromNode SqlGetRightFromNode(FromNode node) throws ParseException {
        FromNode temp = null;
        do {
            if (temp != null) {
                temp.setLeft(node);
                node = temp;
                temp = null;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 176: {
                    this.jj_consume_token(176);
                    node = this.SqlGetTraditionalFromNode(node);
                    break;
                }
                case 66: 
                case 70: 
                case 73: 
                case 97: {
                    node = this.SqlAnsiJoin(node);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            temp = new FromNode();
        } while (this.jj_2_49(2));
        return node;
    }

    public final FromNode SqlAnsiJoin(FromNode node) throws ParseException {
        Selectable condition = null;
        Object tableOrNode = null;
        int curType = -1;
        curType = this.SqlJoinType();
        node.setType(curType);
        tableOrNode = this.SqlGetAnsiFromNode();
        node.setRight(tableOrNode);
        this.jj_consume_token(89);
        condition = this.SqlWhereOr();
        node.setCondition(condition);
        return node;
    }

    public final int SqlJoinType() throws ParseException {
        int type = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 93: {
                        this.jj_consume_token(93);
                        break;
                    }
                }
                this.jj_consume_token(70);
                type = 2;
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 93: {
                        this.jj_consume_token(93);
                        break;
                    }
                }
                this.jj_consume_token(70);
                type = 3;
                break;
            }
            case 66: 
            case 70: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: {
                        this.jj_consume_token(66);
                        break;
                    }
                }
                this.jj_consume_token(70);
                type = 1;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    public final Object SqlTableOrView() throws ParseException {
        TableIdentifier curTable = null;
        AxionCommand select = null;
        String id = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 172: 
            case 195: {
                curTable = this.SqlTableRef();
                return curTable;
            }
            case 188: {
                this.jj_consume_token(188);
                select = this.SqlSubSelect();
                this.jj_consume_token(189);
                if (!this.jj_2_50(2)) break;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        break;
                    }
                }
                id = this.SqlQuotedId();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (id != null) {
            ((SubSelectCommand)select).setAlias(id);
        }
        return select;
    }

    public final Selectable SqlWhere() throws ParseException {
        Selectable result = null;
        this.jj_consume_token(127);
        result = this.SqlWhereOr();
        return result;
    }

    public final Selectable SqlWhereOr() throws ParseException {
        FunctionIdentifier parent = null;
        Selectable left = null;
        Selectable right = null;
        Selectable result = null;
        result = left = this.SqlWhereAnd();
        while (this.jj_2_51(2)) {
            this.jj_consume_token(90);
            right = this.SqlWhereAnd();
            parent = new FunctionIdentifier("OR");
            parent.addArgument(left);
            parent.addArgument(right);
            left = parent;
            result = parent;
        }
        return result;
    }

    public final Selectable SqlWhereAnd() throws ParseException {
        FunctionIdentifier parent = null;
        Selectable left = null;
        Selectable right = null;
        Selectable result = null;
        result = left = this.SqlWhereNot();
        while (this.jj_2_52(2)) {
            this.jj_consume_token(12);
            right = this.SqlWhereNot();
            parent = new FunctionIdentifier("AND");
            parent.addArgument(left);
            parent.addArgument(right);
            left = parent;
            result = parent;
        }
        return result;
    }

    public final Selectable SqlWhereNot() throws ParseException {
        Selectable child = null;
        if (this.jj_2_53(3)) {
            this.jj_consume_token(86);
            child = this.SqlWhereElt();
            FunctionIdentifier fn = new FunctionIdentifier("NOT");
            fn.addArgument(child);
            return fn;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 45: 
            case 47: 
            case 49: 
            case 58: 
            case 80: 
            case 82: 
            case 83: 
            case 87: 
            case 94: 
            case 96: 
            case 102: 
            case 108: 
            case 109: 
            case 114: 
            case 115: 
            case 125: 
            case 129: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 188: 
            case 190: 
            case 193: 
            case 194: 
            case 195: {
                child = this.SqlWhereElt();
                return child;
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Selectable SqlWhereElt() throws ParseException {
        Selectable result = null;
        result = this.SqlCompareExpr();
        return result;
    }

    public final Selectable SqlCompareExpr() throws ParseException {
        Selectable left = null;
        Selectable right = null;
        String symbol = null;
        Selectable[] endpts = null;
        Selectable result = null;
        left = this.SqlSumExprSelectable();
        if (this.jj_2_56(3)) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 69: {
                    symbol = this.SqlIsClause();
                    FunctionIdentifier fid = new FunctionIdentifier(symbol);
                    fid.addArgument(left);
                    result = fid;
                    break;
                }
                case 16: {
                    endpts = this.SqlBetweenClause();
                    FunctionIdentifier between = new FunctionIdentifier("AND");
                    between.addArgument(AxionSqlParser.makeLeafWhereNode(left, ">=", endpts[0]));
                    between.addArgument(AxionSqlParser.makeLeafWhereNode(left, "<=", endpts[1]));
                    result = between;
                    break;
                }
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: {
                    symbol = this.SqlCompareOp();
                    right = this.SqlSumExprSelectable();
                    result = AxionSqlParser.makeLeafWhereNode(left, symbol, right);
                    break;
                }
                default: {
                    if (this.jj_2_54(2)) {
                        result = this.SqlInClause(left);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 106: {
                            this.jj_consume_token(106);
                            this.jj_consume_token(74);
                            right = this.SqlSumExprSelectable();
                            result = AxionSqlParser.makeLeafWhereNode(left, "SOUNDSLIKE", right);
                            break block0;
                        }
                    }
                    if (this.jj_2_55(2)) {
                        result = this.SqlLikeClause(left);
                        break;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (result == null) {
            result = left;
        }
        return result;
    }

    public final String SqlCompareOp() throws ParseException {
        String result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 184: {
                this.jj_consume_token(184);
                result = "=";
                break;
            }
            case 185: {
                this.jj_consume_token(185);
                result = "!=";
                break;
            }
            case 186: {
                this.jj_consume_token(186);
                result = "!=";
                break;
            }
            case 182: {
                this.jj_consume_token(182);
                result = ">";
                break;
            }
            case 183: {
                this.jj_consume_token(183);
                result = ">=";
                break;
            }
            case 180: {
                this.jj_consume_token(180);
                result = "<";
                break;
            }
            case 181: {
                this.jj_consume_token(181);
                result = "<=";
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final String SqlIsClause() throws ParseException {
        boolean foundnot = false;
        this.jj_consume_token(69);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: {
                this.jj_consume_token(86);
                foundnot = true;
                break;
            }
        }
        this.jj_consume_token(87);
        return foundnot ? "ISNOTNULL" : "ISNULL";
    }

    public final Selectable[] SqlBetweenClause() throws ParseException {
        Selectable[] pair = new Selectable[2];
        this.jj_consume_token(16);
        pair[0] = this.SqlSumExprSelectable();
        this.jj_consume_token(12);
        pair[1] = this.SqlSumExprSelectable();
        return pair;
    }

    public final Selectable SqlExistsClause() throws ParseException {
        AxionCommand selectCmd = null;
        ArrayList<AxionCommand> args = new ArrayList<AxionCommand>();
        this.jj_consume_token(45);
        this.jj_consume_token(188);
        selectCmd = this.SqlSubSelect();
        this.jj_consume_token(189);
        if (selectCmd == null) {
            throw new ParseException("Expected SELECT");
        }
        args.add(selectCmd);
        return new FunctionIdentifier("EXISTS", args);
    }

    public final Selectable SqlInClause(Selectable left) throws ParseException {
        List elements = null;
        AxionCommand cmd = null;
        boolean isNot = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: {
                this.jj_consume_token(86);
                isNot = true;
                break;
            }
        }
        this.jj_consume_token(63);
        this.jj_consume_token(188);
        if (this.jj_2_57(3)) {
            elements = this.SqlLiteralList();
        } else {
            cmd = this.SqlSubSelect();
        }
        this.jj_consume_token(189);
        FunctionIdentifier fn = null;
        fn = isNot ? new FunctionIdentifier("NOTIN") : new FunctionIdentifier("IN");
        fn.addArgument(left);
        if (elements != null) {
            for (int i = 0; i < elements.size(); ++i) {
                fn.addArgument((Selectable)elements.get(i));
            }
        } else {
            if (cmd == null) {
                throw new ParseException("Expected SELECT or literal list");
            }
            fn.addArgument((SubSelectCommand)cmd);
        }
        return fn;
    }

    public final Selectable SqlLikeClause(Selectable left) throws ParseException {
        Selectable right = null;
        Token optionalEscapeChar = null;
        ArrayList<Selectable> likeArgs = new ArrayList<Selectable>();
        Selectable leafWhereNode = null;
        boolean isNot = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: {
                this.jj_consume_token(86);
                isNot = true;
                break;
            }
        }
        this.jj_consume_token(74);
        right = this.SqlSumExprSelectable();
        likeArgs.add(right);
        FunctionIdentifier like = new FunctionIdentifier("LIKE2REGEXP", likeArgs);
        ArrayList<Selectable> matchArgs = new ArrayList<Selectable>();
        matchArgs.add(left);
        matchArgs.add(like);
        FunctionIdentifier matches = new FunctionIdentifier("MATCHES", matchArgs);
        Literal troo = new Literal(Boolean.TRUE, new BooleanType());
        leafWhereNode = AxionSqlParser.makeLeafWhereNode(matches, "=", troo);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                optionalEscapeChar = this.jj_consume_token(171);
                String result = optionalEscapeChar.image.substring(1, optionalEscapeChar.image.length() - 1);
                if (result.length() > 1) {
                    throw new AxionSqlParseException("escape character must be character string of length 1", 22019);
                }
                Literal literal = new Literal(result, new CharacterType(result.length()));
                likeArgs.add(literal);
                break;
            }
        }
        if (isNot) {
            FunctionIdentifier notLike = new FunctionIdentifier("NOT");
            notLike.addArgument(leafWhereNode);
            return notLike;
        }
        return leafWhereNode;
    }

    public final AxionCommand SqlSubSelect() throws ParseException {
        AxionQueryContext context = null;
        context = this.SqlSubSelectContext();
        if (context == null) {
            throw new ParseException("Invalid Sub-Query");
        }
        return new SubSelectCommand(context);
    }

    public final AxionQueryContext SqlSubSelectContext() throws ParseException {
        AxionQueryContext context = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: 
            case 103: 
            case 188: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 46: 
                    case 103: {
                        context = this.SqlSelectContext();
                        break block0;
                    }
                    case 188: {
                        this.jj_consume_token(188);
                        context = this.SqlSubSelectContext();
                        this.jj_consume_token(189);
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return context;
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_1();
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_2();
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_3();
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_4();
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_5();
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_6();
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_7();
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_8();
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_9();
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_10();
    }

    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_11();
    }

    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_12();
    }

    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_13();
    }

    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_14();
    }

    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_15();
    }

    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_16();
    }

    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_17();
    }

    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_18();
    }

    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_19();
    }

    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_20();
    }

    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_21();
    }

    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_22();
    }

    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_23();
    }

    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_24();
    }

    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_25();
    }

    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_26();
    }

    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_27();
    }

    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_28();
    }

    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_29();
    }

    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_30();
    }

    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_31();
    }

    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_32();
    }

    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_33();
    }

    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_34();
    }

    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_35();
    }

    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_36();
    }

    private final boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_37();
    }

    private final boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_38();
    }

    private final boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_39();
    }

    private final boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_40();
    }

    private final boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_41();
    }

    private final boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_42();
    }

    private final boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_43();
    }

    private final boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_44();
    }

    private final boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_45();
    }

    private final boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_46();
    }

    private final boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_47();
    }

    private final boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_48();
    }

    private final boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_49();
    }

    private final boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_50();
    }

    private final boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_51();
    }

    private final boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_52();
    }

    private final boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_53();
    }

    private final boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_54();
    }

    private final boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_55();
    }

    private final boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_56();
    }

    private final boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        return !this.jj_3_57();
    }

    private final boolean jj_3R_89() {
        if (this.jj_scan_token(176)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_129()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_39() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_39()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_120()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_196() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_134() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_181() {
        if (this.jj_3R_204()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_134()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_119()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_182()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_90()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_185() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_204()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(189)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_3R_114()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        Token xsp;
        block3: {
            if (this.jj_3_49()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_49()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_110() {
        if (this.jj_scan_token(118)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_19() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(189)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_170() {
        if (this.jj_3R_39()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_33() {
        if (this.jj_scan_token(140)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_48() {
        if (this.jj_3R_88()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(189)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_194() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_scan_token(147)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_172() {
        if (this.jj_3R_104()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_57() {
        if (this.jj_3R_101()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        if (this.jj_scan_token(149)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_109()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_110()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_109() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_34() {
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_133() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(128)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_133()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_181()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(189)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_25() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_24() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        if (this.jj_scan_token(148)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_47() {
        if (this.jj_3R_88()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_3R_115()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_23() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_154() {
        if (this.jj_scan_token(134)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(146)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_200() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_151() {
        if (this.jj_scan_token(156)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_64()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_65()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_239() {
        if (this.jj_scan_token(179)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_scan_token(143)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_129() {
        if (this.jj_3R_104()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_143() {
        if (this.jj_3R_145()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_211() {
        Token xsp;
        block3: {
            if (this.jj_3R_83()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_239()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_193() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_136() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_119()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        if (this.jj_scan_token(154)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_173() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_150() {
        if (this.jj_scan_token(155)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_142() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_142()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_143()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        if (this.jj_scan_token(159)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_210() {
        if (this.jj_scan_token(190)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_102()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(110)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_103()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_30() {
        if (this.jj_scan_token(142)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(159)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_223() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_135() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_173()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_222() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_153() {
        if (this.jj_scan_token(137)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(163)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(153)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_3R_114()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_46() {
        if (this.jj_3R_88()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_221() {
        if (this.jj_scan_token(125)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_209() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_220() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_219() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_218() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        if (this.jj_scan_token(145)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_217() {
        if (this.jj_scan_token(129)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_180() {
        if (this.jj_scan_token(181)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_216() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_208() {
        if (this.jj_scan_token(115)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_179() {
        if (this.jj_scan_token(180)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_215() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_178() {
        if (this.jj_scan_token(183)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_191() {
        if (this.jj_3R_184()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_177() {
        if (this.jj_scan_token(182)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_176() {
        if (this.jj_scan_token(186)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_175() {
        if (this.jj_scan_token(185)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_3R_104()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_207() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_174() {
        if (this.jj_scan_token(184)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_27()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_59()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_60()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_149() {
        if (this.jj_scan_token(142)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(153)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_230() {
        if (this.jj_scan_token(169)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_137() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_174()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_175()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_176()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_177()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_178()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_179()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_180()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_214() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_232() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_155() {
        if (this.jj_3R_114()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_scan_token(137)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(162)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_55() {
        if (this.jj_3R_96()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_152() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(163)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_229() {
        if (this.jj_scan_token(168)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_45() {
        if (this.jj_scan_token(176)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_87()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_100() {
        if (this.jj_scan_token(106)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_119()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_213() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_190() {
        if (this.jj_3R_183()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_54() {
        if (this.jj_3R_95()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_228() {
        if (this.jj_scan_token(193)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_112() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_152()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_153()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_154()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_155()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_148() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_190()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_191()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_231() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_27() {
        if (this.jj_scan_token(142)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        if (this.jj_3R_113()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_99() {
        if (this.jj_3R_137()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_119()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_206() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_228()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_229()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_230()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_212() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_231()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_232()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_199() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_212()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_213()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_214()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_215()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_216()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_217()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_218()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_219()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_220()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_221()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_222()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_223()) {
                                                        return true;
                                                    }
                                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_111() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_149()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_150()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_151()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(162)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(137)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_98() {
        if (this.jj_3R_136()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_3R_113()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_3R_78()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_205() {
        if (this.jj_scan_token(171)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_53()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_54()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_55()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_56()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_57()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_144() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(136)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_105() {
        if (this.jj_3R_148()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_3R_135()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_183() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_205()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_206()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_207()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_208()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_209()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_210()) {
                                return true;
                            }
                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_144()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_145()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_50()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_29()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_111()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_112()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_97()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_98()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_99()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_54()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_100()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_55()) {
                                return true;
                            }
                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_105()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_22() {
        if (this.jj_3R_45()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_132() {
        if (this.jj_3R_119()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_56()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_128() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_188() {
        if (this.jj_3R_185()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_187() {
        if (this.jj_3R_184()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_127() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_186() {
        if (this.jj_3R_183()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_105()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_240() {
        if (this.jj_scan_token(126)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(168)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_3R_132()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_127()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_128()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_141() {
        if (this.jj_scan_token(176)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_186()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_187()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_188()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_35()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_124() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(123)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_131() {
        if (this.jj_3R_94()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_26() {
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_237() {
        Token xsp;
        block3: {
            if (this.jj_3R_240()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_240()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_140() {
        if (this.jj_3R_185()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_139() {
        if (this.jj_3R_184()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_138() {
        if (this.jj_3R_183()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(168)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_44() {
        if (this.jj_scan_token(176)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_86()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_17() {
        if (this.jj_scan_token(190)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_101() {
        Token xsp;
        block9: {
            xsp = this.jj_scanpos;
            if (this.jj_3R_138()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_139()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_140()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_141()) break block9;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_53() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_94()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_131()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_21() {
        if (this.jj_3R_45()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_18()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_scan_token(191)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(190)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_43() {
        if (this.jj_3R_85()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_3R_78()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_52() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_93()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_16() {
        if (this.jj_3R_43()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_76()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_77()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_78()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_15() {
        if (this.jj_3R_42()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_14() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_12() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_39()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_92() {
        Token xsp;
        block3: {
            if (this.jj_3R_93()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_52()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_13() {
        if (this.jj_3R_40()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        Token xsp;
        block3: {
            if (this.jj_3R_78()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_37()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_236() {
        if (this.jj_3R_170()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_11() {
        if (this.jj_3R_38()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_198() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_236()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_237()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_37()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_20() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(189)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_84()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_83()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(177)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(193)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_51() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_92()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(192)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_189() {
        if (this.jj_3R_83()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(168)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_73()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_74()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_75()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        Token xsp;
        block3: {
            if (this.jj_3R_92()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_51()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_184() {
        if (this.jj_scan_token(194)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_244() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_192() {
        if (this.jj_3R_211()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_119() {
        Token xsp;
        block3: {
            if (this.jj_3R_75()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_36()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_28() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(168)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_243() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_242() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_243()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_244()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_121() {
        if (this.jj_scan_token(172)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_29()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_scan_token(127)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_39()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_241() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_238() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_241()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_242()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_157() {
        if (this.jj_scan_token(168)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_126() {
        if (this.jj_scan_token(195)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(196)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_125() {
        if (this.jj_scan_token(172)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_91()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_83()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_125()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_126()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_82()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_83()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_156() {
        if (this.jj_3R_157()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_147() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_122() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_146() {
        if (this.jj_3R_189()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_145() {
        if (this.jj_3R_83()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_123() {
        if (this.jj_3R_170()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_41()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_114() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_157()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_104() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_146()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_147()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_226() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_115() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_156()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_3R_121()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_122()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_203() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_226()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_225() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_scan_token(176)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_113() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(189)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_3R_124()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_80() {
        if (this.jj_3R_123()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_224() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_118() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_117() {
        if (this.jj_scan_token(113)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_235() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_227()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(189)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_116() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_116()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_117()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_118()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_3R_119()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_234() {
        if (this.jj_3R_238()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_233() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_234()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_235()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_202() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_225()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_40() {
        if (this.jj_scan_token(176)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_81()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_227() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_233()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_108() {
        if (this.jj_3R_124()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_201() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_224()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_107() {
        if (this.jj_3R_123()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_68()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_70()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_71()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_106() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_171() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_201()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_202()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_203()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        Token xsp;
        block6: {
            xsp = this.jj_scanpos;
            if (this.jj_3R_107()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_108()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_40()) break block6;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_106()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_197() {
        if (this.jj_scan_token(114)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_204() {
        if (this.jj_3R_227()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_169() {
        if (this.jj_3R_185()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_168() {
        if (this.jj_3R_200()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(189)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_167() {
        if (this.jj_3R_199()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_166() {
        if (this.jj_3R_198()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_165() {
        if (this.jj_3R_184()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_164() {
        if (this.jj_3R_183()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_163() {
        if (this.jj_3R_197()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_162() {
        if (this.jj_3R_196()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_161() {
        if (this.jj_3R_195()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_160() {
        if (this.jj_3R_194()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_159() {
        if (this.jj_3R_193()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_158() {
        if (this.jj_3R_192()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_38() {
        if (this.jj_3R_79()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_195() {
        if (this.jj_scan_token(94)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(188)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_130() {
        if (this.jj_3R_171()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_172()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_120() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_158()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_159()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_160()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_161()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_162()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_163()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_164()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_165()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_166()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_167()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_168()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_169()) {
                                                            return true;
                                                        }
                                                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_182() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_3R_130()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public AxionSqlParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new AxionSqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public AxionSqlParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new AxionSqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public AxionSqlParser(AxionSqlParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(AxionSqlParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        systemTables.add("AXION_CATALOGS");
        systemTables.add("AXION_COLUMNS");
        systemTables.add("AXION_DB_LINKS");
        systemTables.add("AXION_INDEX_INFO");
        systemTables.add("AXION_SCHEMATA");
        systemTables.add("AXION_SEQUENCES");
        systemTables.add("AXION_TABLES");
        systemTables.add("AXION_TABLE_PROPERTIES");
        systemTables.add("AXION_TABLE_TYPES");
        systemTables.add("AXION_TYPES");
        _log = Logger.getLogger(AxionSqlParser.class.getName());
    }

    static class AxionSqlParseException
    extends ParseException {
        private AxionException _nested;

        public AxionSqlParseException() {
            this._nested = new AxionException(42000);
        }

        public AxionSqlParseException(String message, int sqlState) {
            super(message);
            this._nested = new AxionException(message, sqlState);
        }

        public AxionException getNestedException() {
            return this._nested;
        }
    }
}

