/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Iterator;
import org.axiondb.AxionCommand;
import org.axiondb.AxionException;
import org.axiondb.jdbc.AxionConnection;
import org.axiondb.jdbc.AxionResultSet;
import org.axiondb.jdbc.BaseAxionStatement;
import org.axiondb.jdbc.ForwardOnlyResultSet;
import org.axiondb.jdbc.UnmodifiableResultSet;
import org.axiondb.util.ExceptionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxionStatement
extends BaseAxionStatement
implements Statement {
    private int _type = 1003;
    private int _concurrency = 1007;

    protected AxionStatement(AxionConnection conn) throws SQLException {
        super(conn);
    }

    protected AxionStatement(AxionConnection conn, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn);
        this._type = resultSetType;
        this._concurrency = resultSetConcurrency;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.getBatchCount() == 0) {
            this.clearCurrentResult();
        }
        this.addToBatchContext(this.parseCommand(sql));
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("cancel is not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        this._batchContext.clear();
        this._batchContext.trimToSize();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._warning = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        SQLException exception = null;
        int[] results = new int[this.getBatchCount()];
        int i = 0;
        Iterator iter = this.getBatchContext();
        while (iter.hasNext()) {
            AxionCommand cmd = (AxionCommand)iter.next();
            try {
                results[i] = this.executeUpdate(cmd);
            }
            catch (SQLWarning w) {
                this.addWarning(w);
            }
            catch (SQLException e) {
                exception = e;
                results[i] = -3;
            }
            ++i;
        }
        this.clearBatchContext();
        if (null != exception) {
            throw new BatchUpdateException(exception.getMessage(), results);
        }
        return results;
    }

    protected synchronized void addWarning(SQLWarning newWarning) {
        if (this._warning != null) {
            this._warning.setNextWarning(newWarning);
        } else {
            this._warning = newWarning;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.clearCurrentResult();
        return this.execute(this.parseCommand(sql));
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.clearCurrentResult();
        return this.executeQuery(this.parseCommand(sql));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.clearCurrentResult();
        return this.executeUpdate(this.parseCommand(sql));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.closeCurrentResultSet();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet rs = this.getCurrentResultSet();
        if (rs != null) {
            if (this._concurrency == 1007) {
                rs = new UnmodifiableResultSet(rs);
            }
            if (this._type == 1003) {
                rs = new ForwardOnlyResultSet(rs);
            }
        }
        return rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._concurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._type;
    }

    void setResultSetConcurrency(int concurrency) throws SQLException {
        this._concurrency = concurrency;
    }

    void setResultSetType(int type) throws SQLException {
        this._type = type;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.clearCurrentUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._warning;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (!enable) {
            throw new SQLException("Unsupported");
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw new SQLException("Unrecognized fetch direction: " + direction + ".");
            }
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("FetchSize should be non-negative");
        }
    }

    @Override
    public void setMaxFieldSize(int size) throws SQLException {
        if (size < 0) {
            throw new SQLException("MaxFieldSize should be non-negative");
        }
        if (size != 0) {
            throw new SQLException("MaxFieldSize  " + size + " is not supported.");
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("QueryTimeout should be non-negative");
        }
        if (seconds != 0) {
            throw new SQLException("QueryTimeout " + seconds + " is not supported.");
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return AxionResultSet.createEmptyResultSet(this);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (2 == autoGeneratedKeys) {
            return this.execute(sql);
        }
        throw new SQLException("autoGeneratedKeys are not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("execute(String,int[]) is currently not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("execute(String,String[]) is currently not supported");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (2 == autoGeneratedKeys) {
            return this.executeUpdate(sql);
        }
        throw new SQLException("autoGeneratedKeys are not supported");
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new SQLException("executeUpdate(String,int[]) is currently not supported");
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new SQLException("executeUpdate(String,String[]) is currently not supported");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (1 == current || 3 == current) {
            return this.getMoreResults();
        }
        throw new SQLException("getMoreResults(" + current + ") is currently not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    protected final boolean execute(AxionCommand cmd) throws SQLException {
        boolean result = false;
        try {
            result = cmd.execute(this.getDatabase());
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
        catch (RuntimeException e) {
            throw ExceptionConverter.convert(e);
        }
        this.setCurrentResult(result, cmd);
        this.getAxionConnection().commitIfAuto();
        return result;
    }

    protected final ResultSet executeQuery(AxionCommand cmd) throws SQLException {
        try {
            this.setCurrentResultSet(cmd.executeQuery(this.getDatabase(), 1007 == this._concurrency));
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
        catch (RuntimeException e) {
            throw ExceptionConverter.convert(e);
        }
        if (this.getAxionConnection().getAutoCommit()) {
            this.getCurrentResultSet().setTransaction(this.getAxionConnection().getDatabase().getTransactionManager(), this.getAxionConnection().forgetCurrentTransaction());
        }
        return this.getResultSet();
    }

    protected final int executeUpdate(AxionCommand cmd) throws SQLException {
        try {
            this.setCurrentUpdateCount(cmd.executeUpdate(this.getDatabase()));
        }
        catch (AxionException e) {
            throw ExceptionConverter.convert(e);
        }
        catch (RuntimeException e) {
            throw ExceptionConverter.convert(e);
        }
        this.getAxionConnection().commitIfAuto();
        return this.getCurrentUpdateCount();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported.");
    }
}

