/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BigDecimalType;
import org.axiondb.types.IntegerType;

public class TruncateFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new BigDecimalType();
    private static final DataType ARG_TYPE = new IntegerType();

    public TruncateFunction() {
        super("TRUNCATE");
    }

    public ConcreteFunction makeNewInstance() {
        return new TruncateFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        Object rawVal = sel.evaluate(row);
        DataType type = sel.getDataType();
        Object val = type.convert(rawVal);
        Object val1 = this.getArgument(1).evaluate(row);
        BigDecimal bdVal = type.toBigDecimal(val);
        Integer scaleVal = (Integer)ARG_TYPE.convert(val1);
        if (null != bdVal && null != scaleVal) {
            return bdVal.doubleValue() < 0.0 ? bdVal.setScale((int)scaleVal, 2) : bdVal.setScale((int)scaleVal, 3);
        }
        return null;
    }

    public boolean isValid() {
        return this.getArgumentCount() == 2;
    }
}

