/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BigDecimalType;
import org.axiondb.types.IntegerType;

public class RoundFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new BigDecimalType();
    private static final DataType ARG_TYPE = new IntegerType();

    public RoundFunction() {
        super("ROUND");
    }

    public ConcreteFunction makeNewInstance() {
        return new RoundFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        Object val = sel.evaluate(row);
        DataType type = sel.getDataType();
        BigDecimal bd = type.toBigDecimal(val);
        if (bd == null) {
            return null;
        }
        int scale = 0;
        if (this.getArgumentCount() == 2) {
            Selectable sel1 = this.getArgument(1);
            Object val1 = sel1.evaluate(row);
            Integer intVal = (Integer)ARG_TYPE.convert(val1);
            scale = intVal;
        }
        return bd.setScale(scale, 4);
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 1 && this.getArgumentCount() < 3;
    }
}

