/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.DataType;
import org.axiondb.Literal;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BooleanType;

public abstract class ComparisonFunction
extends BaseFunction
implements ScalarFunction {
    private static final DataType BOOLEAN_TYPE = new BooleanType();

    public ComparisonFunction(String name) {
        super(name);
    }

    public final DataType getDataType() {
        return BOOLEAN_TYPE;
    }

    public final boolean isValid() {
        return this.getArgumentCount() == 2;
    }

    public final Object evaluate(RowDecorator row) throws AxionException {
        Selectable selLeft = this.getArgument(0);
        Object valLeft = selLeft.evaluate(row);
        DataType typeLeft = selLeft.getDataType();
        Selectable selRight = this.getArgument(1);
        Object valRight = selRight.evaluate(row);
        try {
            valRight = typeLeft.convert(valRight);
        }
        catch (AxionException ex) {
            return Boolean.FALSE;
        }
        if (null == valLeft || null == valRight) {
            return null;
        }
        if (this.compare(typeLeft.compare(valLeft, valRight))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected abstract boolean compare(int var1);

    protected abstract ComparisonFunction makeFlipFunction();

    public ComparisonFunction flip() {
        ComparisonFunction fn = this.makeFlipFunction();
        fn.setName("FLIPPED_" + this.getName());
        fn.setAlias(this.getAlias());
        fn.addArgument(this.getArgument(0));
        fn.addArgument(this.getArgument(1));
        return fn;
    }

    public boolean isColumnColumn() {
        return this.getArgumentCount() == 2 && this.getArgument(0) instanceof ColumnIdentifier && this.getArgument(1) instanceof ColumnIdentifier;
    }

    public boolean isColumnLiteral() {
        return this.getArgumentCount() == 2 && (this.getArgument(0) instanceof ColumnIdentifier && this.getArgument(1) instanceof Literal || this.getArgument(1) instanceof ColumnIdentifier && this.getArgument(0) instanceof Literal);
    }

    public abstract String getOperatorString();
}

