/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.RowDecoratorIterator;
import org.axiondb.Selectable;
import org.axiondb.functions.AggregateFunction;
import org.axiondb.functions.BaseAggregateFunction;
import org.axiondb.types.AnyType;

public abstract class ComparableAggregateFunction
extends BaseAggregateFunction
implements AggregateFunction {
    private DataType _targetType = null;
    private static final DataType ANY_TYPE = new AnyType();

    public ComparableAggregateFunction(String name) {
        super(name);
    }

    public final DataType getDataType() {
        return this._targetType == null ? ANY_TYPE : this._targetType;
    }

    public final Object evaluate(RowDecoratorIterator rows) throws AxionException {
        Comparable result = null;
        Selectable sel = this.getArgument(0);
        this._targetType = sel.getDataType();
        this.setDistinct();
        while (rows.hasNext()) {
            Object rawVal = sel.evaluate(rows.next());
            DataType currentType = sel.getDataType();
            Object val = currentType.convert(rawVal);
            if (null == val || !this.acceptable(val)) continue;
            result = this.evaluate(result, (Comparable)val);
        }
        return null != result ? result : null;
    }

    protected abstract Comparable evaluate(Comparable var1, Comparable var2);
}

