/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BigDecimalType;

public abstract class ArithmeticFunction
extends BaseFunction
implements ScalarFunction {
    private DataType _datatype = null;

    public ArithmeticFunction(String name) {
        super(name);
    }

    public final DataType getDataType() {
        return this._datatype == null ? new BigDecimalType() : this._datatype;
    }

    public final Object evaluate(RowDecorator row) throws AxionException {
        BigDecimal result = null;
        int I = this.getArgumentCount();
        for (int i = 0; i < I; ++i) {
            Selectable sel = this.getArgument(i);
            Object val = sel.evaluate(row);
            if (null == val) {
                return null;
            }
            BigDecimal bdval = sel.getDataType().toBigDecimal(val);
            result = null == result ? bdval : this.operate(result, bdval);
        }
        return result;
    }

    public final boolean isValid() {
        return this.getArgumentCount() != 0;
    }

    protected abstract BigDecimal operate(BigDecimal var1, BigDecimal var2) throws AxionException;

    protected void setDataType(DataType newType) {
        this._datatype = newType;
    }
}

