/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import org.axiondb.AxionException;
import org.axiondb.Literal;
import org.axiondb.RowIterator;
import org.axiondb.engine.rowiterators.AbstractFilteringRowIterator;

public class LimitingRowIterator
extends AbstractFilteringRowIterator {
    private Literal _limit;
    private Literal _offset;

    public LimitingRowIterator(RowIterator iter, Literal limit, Literal offset) {
        super(iter);
        this._limit = limit;
        this._offset = offset;
    }

    public String toString() {
        return "Limiting(" + this._limit + ")";
    }

    protected boolean determineNextRow() throws AxionException {
        if (this.isPreviousAvailable()) {
            this.clearPreviousRow();
            this.getDelegate().next();
            this.clearNextRow();
        }
        while (!this.overOffset(this.getDelegate().nextIndex())) {
            if (this.getDelegate().hasNext()) {
                this.getDelegate().next();
                continue;
            }
            return false;
        }
        if (this.underLimit(this.nextIndex()) && this.getDelegate().hasNext()) {
            this.setNext(this.getDelegate().next());
            return true;
        }
        return false;
    }

    protected boolean determinePreviousRow() throws AxionException {
        if (this.isNextAvailable()) {
            this.clearNextRow();
            this.determinePreviousRow();
            this.clearPreviousRow();
        }
        if (this.overOffset(this.getDelegate().previousIndex()) && this.getDelegate().hasPrevious()) {
            this.setPrevious(this.getDelegate().previous());
            return true;
        }
        return false;
    }

    private boolean overOffset(int index) throws AxionException {
        return null == this._offset || index >= ((Number)this._offset.evaluate(null)).intValue();
    }

    private boolean underLimit(int index) throws AxionException {
        return null == this._limit || index < ((Number)this._limit.evaluate(null)).intValue();
    }
}

