/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowIterator;
import org.axiondb.engine.rowiterators.AbstractFilteringRowIterator;

public abstract class AbstractAcceptingRowIterator
extends AbstractFilteringRowIterator {
    public AbstractAcceptingRowIterator(RowIterator iterator) {
        super(iterator);
    }

    public void set(Row row) throws AxionException {
        if (!this.acceptable(this.currentIndex(), row)) {
            throw new IllegalStateException("Out of range");
        }
        super.set(row);
    }

    protected abstract boolean acceptable(int var1, Row var2) throws AxionException;

    protected boolean determineNextRow() throws AxionException {
        if (this.isPreviousAvailable()) {
            this.clearPreviousRow();
            this.determineNextRow();
            this.clearNextRow();
        }
        while (this.getDelegate().hasNext()) {
            Row row = this.getDelegate().next();
            if (!this.acceptable(this.nextIndex(), row)) continue;
            this.setNext(row);
            return true;
        }
        return false;
    }

    protected boolean determinePreviousRow() throws AxionException {
        if (this.isNextAvailable()) {
            this.clearNextRow();
            this.determinePreviousRow();
            this.clearPreviousRow();
        }
        while (this.getDelegate().hasPrevious()) {
            Row row = this.getDelegate().previous();
            if (!this.acceptable(this.previousIndex(), row)) continue;
            this.setPrevious(row);
            return true;
        }
        return false;
    }
}

