/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowcollection;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.BindVariable;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Function;
import org.axiondb.Index;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.engine.rowcollection.IntHashMap;
import org.axiondb.engine.rowiterators.RebindableIndexedRowIterator;
import org.axiondb.engine.rowiterators.UnmodifiableRowIterator;
import org.axiondb.event.RowDeletedEvent;
import org.axiondb.event.RowInsertedEvent;
import org.axiondb.event.RowUpdatedEvent;
import org.axiondb.functions.ComparisonFunction;

public class IntRowMap
extends IntHashMap {
    private transient List _indices = new ArrayList(4);
    private transient RowValues _rowValues = new RowValues();

    public IntRowMap() {
        super(16);
    }

    public IntRowMap(int capacity) {
        super(capacity);
    }

    public IntRowMap(IntRowMap map) {
        super(map);
    }

    public final void addIndex(Index index) {
        this._indices.add(index);
    }

    public Row addRow(Table table, Row row) throws AxionException {
        RowInsertedEvent event = null;
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            Index index = (Index)this._indices.get(i);
            if (event == null) {
                event = new RowInsertedEvent(table, null, row);
            }
            index.rowInserted(event);
        }
        return this.putRow(row.getIdentifier(), row);
    }

    public void clear() {
        super.clear();
        try {
            this.truncateIndices();
        }
        catch (AxionException e) {
            this.clearIndexes();
        }
    }

    public final void clearIndexes() {
        this._indices.clear();
    }

    public Row deleteRow(Table table, Row deleted) throws AxionException {
        if ((deleted = this.removeRow(deleted.getIdentifier())) != null) {
            RowDeletedEvent event = null;
            int I = this._indices.size();
            for (int i = 0; i < I; ++i) {
                Index index = (Index)this._indices.get(i);
                if (event == null) {
                    event = new RowDeletedEvent(table, deleted, null);
                }
                index.rowDeleted(event);
            }
        }
        return deleted;
    }

    public RowIterator getIndexedRows(Table source, Selectable node, boolean readOnly) throws AxionException {
        if (readOnly) {
            return UnmodifiableRowIterator.wrap(this.getIndexedRows(source, node));
        }
        return this.getIndexedRows(source, node);
    }

    public Index getIndexForColumn(Column column) {
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            Index index = (Index)this._indices.get(i);
            if (!column.equals(index.getIndexedColumn())) continue;
            return index;
        }
        return null;
    }

    public final Row getRow(int key) {
        return (Row)super.get(key);
    }

    public boolean isColumnIndexed(Column column) {
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            Index index = (Index)this._indices.get(i);
            if (!column.equals(index.getIndexedColumn())) continue;
            return true;
        }
        return false;
    }

    public void populateIndex(Table table, Index index) throws AxionException {
        RowIterator i = this.rowValues().rowIterator();
        while (i.hasNext()) {
            Row row = i.next();
            if (row == null) continue;
            index.rowInserted(new RowInsertedEvent(table, null, row));
        }
    }

    public final Row putRow(int key, Row value) {
        return (Row)super.put(key, value);
    }

    public final Row removeRow(int key) {
        return (Row)super.remove(key);
    }

    public final RowIterator rowIterator() {
        return new ValueRowIterator();
    }

    public final RowCollection rowValues() {
        return this._rowValues;
    }

    public void shutdown() {
        this.clear();
        this._indices = null;
    }

    public void truncateIndices() throws AxionException {
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            Index index = (Index)this._indices.get(i);
            index.truncate();
        }
    }

    public Row updateRow(Table table, Row oldrow, Row newrow) throws AxionException {
        newrow.setIdentifier(oldrow.getIdentifier());
        oldrow = this.putRow(newrow.getIdentifier(), newrow);
        RowUpdatedEvent event = null;
        int I = this._indices.size();
        for (int i = 0; i < I; ++i) {
            Index index = (Index)this._indices.get(i);
            if (event == null) {
                event = new RowUpdatedEvent(table, oldrow, newrow);
            }
            if (oldrow != null) {
                index.rowUpdated(event);
                continue;
            }
            index.rowInserted(event);
        }
        return oldrow;
    }

    private RowIterator getIndexedRows(Table source, Selectable node) throws AxionException {
        if (node instanceof ComparisonFunction) {
            ComparisonFunction function = (ComparisonFunction)node;
            Column column = null;
            Literal literal = null;
            Selectable left = function.getArgument(0);
            Selectable right = function.getArgument(1);
            if (left instanceof ColumnIdentifier && right instanceof Literal) {
                column = source.getColumn(((ColumnIdentifier)left).getName());
                literal = (Literal)right;
            } else if (left instanceof Literal && right instanceof ColumnIdentifier) {
                column = source.getColumn(((ColumnIdentifier)right).getName());
                literal = (Literal)left;
                function = function.flip();
            } else {
                return null;
            }
            if (!this.isColumnIndexed(column)) {
                return null;
            }
            Index index = this.getIndexForColumn(column);
            if (!index.supportsFunction(function)) {
                return null;
            }
            if (literal instanceof BindVariable) {
                return new RebindableIndexedRowIterator(index, source, function, (BindVariable)literal);
            }
            return index.getRowIterator(source, function, literal.evaluate(null));
        }
        if (node instanceof ColumnIdentifier) {
            Column column = source.getColumn(((ColumnIdentifier)node).getName());
            Index index = this.getIndexForColumn(column);
            if (index != null) {
                return index.getInorderRowIterator(source);
            }
        } else if (node instanceof Function) {
            Function function = (Function)node;
            if (function.getArgumentCount() != 1) {
                return null;
            }
            Selectable colid = function.getArgument(0);
            if (colid instanceof ColumnIdentifier) {
                Column column = source.getColumn(((ColumnIdentifier)colid).getName());
                if (!this.isColumnIndexed(column)) {
                    return null;
                }
                Index index = this.getIndexForColumn(column);
                if (!index.supportsFunction(function)) {
                    return null;
                }
                return index.getRowIterator(source, function, null);
            }
        }
        return null;
    }

    private class ValueRowIterator
    extends IntHashMap.EntryIterator
    implements RowIterator {
        private ValueRowIterator() {
        }

        public void add(Row row) throws UnsupportedOperationException, AxionException {
            this.addEntry(row.getIdentifier(), row.getIdentifier(), row);
        }

        public Row current() throws NoSuchElementException {
            return (Row)this.currentEntry().getValue();
        }

        public Row first() throws NoSuchElementException, AxionException {
            return (Row)this.firstEntry().getValue();
        }

        public Row last() throws NoSuchElementException, AxionException {
            return (Row)this.lastEntry().getValue();
        }

        public Row next() throws NoSuchElementException, AxionException {
            return (Row)this.nextEntry().getValue();
        }

        public int next(int count) throws AxionException {
            for (int i = 0; i < count; ++i) {
                this.next();
            }
            return this.current().getIdentifier();
        }

        public Row peekNext() throws NoSuchElementException, AxionException {
            return (Row)this.peekNextEntry().getValue();
        }

        public Row peekPrevious() throws NoSuchElementException, AxionException {
            return (Row)this.peekPreviousEntry().getValue();
        }

        public Row previous() throws NoSuchElementException, AxionException {
            return (Row)this.previousEntry().getValue();
        }

        public int previous(int count) throws AxionException {
            for (int i = 0; i < count; ++i) {
                this.previous();
            }
            return this.current().getIdentifier();
        }

        public void set(Row row) throws UnsupportedOperationException, AxionException {
            if (!this.hasCurrent()) {
                throw new IllegalStateException();
            }
            this.currentEntry().setValue(row);
        }
    }

    private final class RowValues
    extends IntHashMap.Values
    implements RowCollection {
        private RowValues() {
        }

        public boolean add(Row row) {
            IntRowMap.this.addEntry(row.getIdentifier(), row.getIdentifier(), row);
            return true;
        }

        public boolean contains(Row row) {
            return IntRowMap.this.containsValue(row);
        }

        public boolean remove(Row row) {
            return super.remove(row);
        }

        public RowIterator rowIterator() {
            return IntRowMap.this.rowIterator();
        }
    }
}

