/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.indexes;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntList;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.Index;
import org.axiondb.IndexLoader;
import org.axiondb.Table;
import org.axiondb.engine.indexes.BaseArrayIndex;
import org.axiondb.io.AxionFileSystem;

public abstract class BaseArrayIndexLoader
implements IndexLoader {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Index loadIndex(Table table, File dataDirectory) throws AxionException {
        ObjectInputStream in = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            String name = dataDirectory.getName();
            File file = new File(dataDirectory, name + ".DATA");
            in = fs.openObjectInputSteam(file);
            int ver = in.readInt();
            if (ver != 1) {
                throw new AxionException("Can't parse data file " + file + " for index " + name + ", unrecognized data file version " + ver);
            }
            String col = in.readUTF();
            boolean unique = in.readBoolean();
            Object keys = this.readKeys(in);
            IntList values = this.readIntList(in);
            Index index = this.makeIndex(name, table.getColumn(col), unique, keys, values);
            fs.closeInputStream(in);
            return index;
        }
        catch (ClassNotFoundException e) {
            try {
                throw new AxionException(e);
                catch (IOException e2) {
                    throw new AxionException(e2);
                }
            }
            catch (Throwable throwable) {
                fs.closeInputStream(in);
                throw throwable;
            }
        }
    }

    public final void saveIndex(Index ndx, File dataDirectory) throws AxionException {
        BaseArrayIndex index = (BaseArrayIndex)ndx;
        ObjectOutputStream out = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            String name = index.getName();
            File file = new File(dataDirectory, name + ".DATA");
            out = fs.createObjectOutputSteam(file);
            out.writeInt(1);
            out.writeUTF(index.getIndexedColumn().getName());
            out.writeBoolean(index.isUnique());
            this.writeKeys(out, index);
            IntList valuelist = index.getValueList();
            out.writeInt(valuelist.size());
            int I = valuelist.size();
            for (int i = 0; i < I; ++i) {
                out.writeInt(valuelist.get(i));
            }
            out.flush();
            fs.closeOutputStream(out);
        }
        catch (IOException e) {
            try {
                throw new AxionException(e);
            }
            catch (Throwable throwable) {
                fs.closeOutputStream(out);
                throw throwable;
            }
        }
    }

    public void saveIndexAfterTruncate(Index ndx, File dataDirectory) throws AxionException {
        this.saveIndex(ndx, dataDirectory);
    }

    protected abstract Index makeIndex(String var1, Column var2, boolean var3, Object var4, IntList var5);

    protected IntList readIntList(ObjectInputStream in) throws IOException {
        int size = in.readInt();
        ArrayIntList list = new ArrayIntList(size);
        for (int i = 0; i < size; ++i) {
            list.add(in.readInt());
        }
        return list;
    }

    protected abstract Object readKeys(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    protected abstract void writeKeys(ObjectOutputStream var1, BaseArrayIndex var2) throws IOException;
}

