/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.axiondb.AxionCommand;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Selectable;
import org.axiondb.SelectableBasedConstraint;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TableFactory;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.commands.AddConstraintCommand;
import org.axiondb.engine.commands.AxionQueryContext;
import org.axiondb.engine.commands.CreateCommand;
import org.axiondb.engine.commands.CreateSequenceCommand;
import org.axiondb.engine.commands.InsertCommand;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.engine.tables.ExternalTableFactory;

public class CreateTableCommand
extends CreateCommand {
    private List _childCommands = new ArrayList();
    private List _colIdsForInsert = new ArrayList();
    private List _columnNames = new ArrayList();
    private List _columns = new ArrayList();
    private List _columnScale = new ArrayList();
    private Sequence _sequence;
    private List _alterColumnNames = new ArrayList();
    private List _newColumnNames = new ArrayList();
    private List _newDefaults = new ArrayList();
    private List _dropdefaults = new ArrayList();
    private List _columnSize = new ArrayList();
    private List _dataTypes = new ArrayList();
    private List _defaults = new ArrayList();
    private List _generated = new ArrayList();
    private Set _excludeSourceColumns = new HashSet();
    private Table _sourceTable;
    private SubSelectCommand _subQuery;
    private Properties _tableOrganization = new Properties();
    private String _type;
    private boolean _createTableWithData = true;
    private boolean _columnsAreCaseSensitive = false;

    public CreateTableCommand() {
    }

    public CreateTableCommand(String tableName) {
        this.setObjectName(tableName);
    }

    public void addChildCommand(AxionCommand cmd) {
        this._childCommands.add(cmd);
    }

    public void addColumn(String name, String datatypename) {
        this.addColumn(name, datatypename, null, null, null, null);
    }

    public void addColumn(String name, String datatypename, String precision) {
        this.addColumn(name, datatypename, precision, null, null, null);
    }

    public void addColumn(String name, String datatypename, String precision, String scale, Object defaultValue) {
        this.addColumn(name, datatypename, precision, scale, defaultValue, null);
    }

    public void addColumn(String name, String datatypename, String precision, String scale, Object defaultValue, String generated) {
        this._columnNames.add(name);
        this._dataTypes.add(datatypename);
        this._defaults.add(defaultValue);
        this._columnSize.add(precision);
        this._columnScale.add(scale);
        this._generated.add(generated);
    }

    public void alterColumn(String name, String newName, Selectable newDefault, Boolean dropDefault) {
        this._alterColumnNames.add(name);
        this._newColumnNames.add(newName);
        this._newDefaults.add(newDefault);
        this._dropdefaults.add(dropDefault);
    }

    public void excludeColumn(String colName) {
        this._excludeSourceColumns.add(this._columnsAreCaseSensitive ? colName : colName.toUpperCase());
    }

    public boolean isColumnEexcluded(String colName) {
        return this._excludeSourceColumns.contains(this._columnsAreCaseSensitive ? colName : colName.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(Database db) throws AxionException {
        Class<CreateTableCommand> clazz = CreateTableCommand.class;
        synchronized (CreateTableCommand.class) {
            this.updateColumnNames();
            this.assertNotReadOnly(db);
            if (!db.hasTable(this.getObjectName())) {
                this._columnsAreCaseSensitive = Boolean.valueOf((String)this._tableOrganization.get("COLUMNS_ARE_CASE_SENSITIVE"));
                this.buildColumnsFromSourceTable(db);
                if (this._sourceTable != null && this._subQuery == null) {
                    this.buildSubQuery();
                }
                this.buildColumns(db);
                this.applyAlterColumn();
                if (this._sourceTable != null && this._excludeSourceColumns.size() == this._sourceTable.getColumnCount()) {
                    throw new AxionException("Can't drop last column " + this._excludeSourceColumns);
                }
                TableFactory factory = db.getTableFactory(this._type);
                if (factory == null) {
                    throw new AxionException("Unknown table type (" + this._type + ")");
                }
                Table table = null;
                if (factory instanceof ExternalTableFactory) {
                    table = ((ExternalTableFactory)factory).createTable(db, this.getObjectName(), this._tableOrganization, this._columns);
                } else {
                    table = factory.createTable(db, this.getObjectName());
                    Iterator iter = this._columns.iterator();
                    while (iter.hasNext()) {
                        table.addColumn((Column)iter.next());
                    }
                }
                db.addTable(table);
                try {
                    for (AxionCommand cmd : this._childCommands) {
                        cmd.execute(db);
                    }
                    if (this._sequence != null) {
                        table.setSequence(this._sequence);
                    }
                    if (!this._createTableWithData) return false;
                    this.populateData(db, table);
                }
                catch (AxionException e) {
                    db.dropTable(this.getObjectName());
                    throw e;
                }
            } else {
                if (this.isIfNotExists()) return false;
                throw new AxionException("A table/view named \"" + this.getObjectName().toUpperCase() + "\" already exists.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public AxionCommand getChildCommand(int i) {
        return (AxionCommand)this._childCommands.get(i);
    }

    public int getChildCommandCount() {
        return this._childCommands.size();
    }

    public List getColumnNames() {
        return Collections.unmodifiableList(this._columnNames);
    }

    public String getType() {
        return this._type;
    }

    public void setProperties(Properties prop) {
        this._tableOrganization = prop;
    }

    public void setSourceTable(Table table) {
        this._sourceTable = table;
    }

    public void setSubQuery(SubSelectCommand subQuery) {
        this._subQuery = subQuery;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setCreateTableWithData(boolean createTableWithData) {
        this._createTableWithData = createTableWithData;
    }

    private void updateColumnNames() {
        this._columnsAreCaseSensitive = Boolean.valueOf((String)this._tableOrganization.get("COLUMNS_ARE_CASE_SENSITIVE"));
        if (!this._columnsAreCaseSensitive) {
            int size;
            if (this._columnNames != null && this._columnNames.size() > 0) {
                List tmpList = this._columnNames;
                this._columnNames = new ArrayList(tmpList.size());
                size = tmpList.size();
                for (int i = 0; i < size; ++i) {
                    this._columnNames.add(((String)tmpList.get(i)).toUpperCase());
                }
            }
            if (this._childCommands != null && this._childCommands.size() > 0) {
                List tempConstraints = this._childCommands;
                this._childCommands = new ArrayList(tempConstraints.size());
                size = tempConstraints.size();
                AddConstraintCommand ac = null;
                for (int i = 0; i < size; ++i) {
                    ac = (AddConstraintCommand)tempConstraints.get(i);
                    Constraint constraint = ac.getConstraint();
                    SelectableBasedConstraint sbConstraint = null;
                    Selectable sel = null;
                    if (constraint instanceof SelectableBasedConstraint && (sel = (sbConstraint = (SelectableBasedConstraint)constraint).getSelectable(0)) instanceof ColumnIdentifier) {
                        ((ColumnIdentifier)sel).setName(sel.getName().toUpperCase());
                    }
                    this._childCommands.add(ac);
                }
            }
        }
    }

    private void buildColumns(Database db) throws AxionException {
        HashSet<String> existingNames = new HashSet<String>(this._columnNames.size());
        int I = this._columnNames.size();
        for (int i = 0; i < I; ++i) {
            String normalizedColumnName;
            DataType type;
            String typeStr = (String)this._dataTypes.get(i);
            String generated = (String)this._generated.get(i);
            if (typeStr == null && generated != null && generated.equals("always")) {
                typeStr = "string";
            }
            if (null == (type = db.getDataType(typeStr))) {
                try {
                    type = (DataType)Class.forName((String)this._dataTypes.get(i)).newInstance();
                }
                catch (Exception e) {
                    type = null;
                }
            } else {
                type = type.makeNewInstance();
            }
            if (null == type) {
                throw new AxionException("Type " + this._dataTypes.get(i) + " not recognized.");
            }
            String string = normalizedColumnName = this._columnsAreCaseSensitive ? (String)this._columnNames.get(i) : ((String)this._columnNames.get(i)).toUpperCase();
            if (existingNames.contains(normalizedColumnName)) {
                throw new AxionException("Duplicate column name " + this._columnNames.get(i) + ".");
            }
            existingNames.add(normalizedColumnName);
            Selectable defaultValue = null;
            CreateSequenceCommand createSeqCmd = null;
            Object def = this._defaults.get(i);
            if (def instanceof Selectable) {
                defaultValue = (Selectable)def;
            } else if (def instanceof CreateSequenceCommand) {
                if (this._sequence == null) {
                    createSeqCmd = (CreateSequenceCommand)def;
                    this._sequence = createSeqCmd.createSequence(db);
                } else {
                    throw new AxionException("Can't have more than one Identity columns");
                }
            }
            String sizeSpec = (String)this._columnSize.get(i);
            if (null != sizeSpec && type instanceof DataType.NonFixedPrecision) {
                try {
                    Integer size = new Integer(sizeSpec);
                    ((DataType.NonFixedPrecision)type).setPrecision(size);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                String scaleSpec = (String)this._columnScale.get(i);
                if (null != scaleSpec && type instanceof DataType.ExactNumeric) {
                    try {
                        Integer scale = new Integer(scaleSpec);
                        ((DataType.ExactNumeric)type).setScale(scale);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            Column col = new Column((String)this._columnNames.get(i), type, defaultValue);
            col.setSqlType((String)this._dataTypes.get(i));
            if (createSeqCmd != null) {
                col.setIdentityType(createSeqCmd.getIdentityType());
            }
            if (generated != null && generated.equals("always")) {
                col.setGeneratedColType(generated);
            }
            this._columns.add(col);
        }
    }

    private void applyAlterColumn() throws AxionException {
        TableIdentifier trgtTid = new TableIdentifier(this.getObjectName());
        int I = this._columns.size();
        int K = this._alterColumnNames.size();
        for (int i = 0; i < I && K > 0; ++i) {
            Column col = (Column)this._columns.get(i);
            if (!col.isDerivedColumn() && !col.isIdentityColumn()) {
                int J = this._alterColumnNames.size();
                for (int j = 0; j < J; ++j) {
                    if (!col.getName().equals(this._alterColumnNames.get(j))) continue;
                    String newColName = this._newColumnNames.get(j) == null ? col.getName() : (String)this._newColumnNames.get(j);
                    Selectable newDefault = this._newDefaults.get(j) == null ? col.getDefault() : (Selectable)this._newDefaults.get(j);
                    newDefault = this._dropdefaults.get(j) == null ? newDefault : null;
                    Column newCol = new Column(newColName, col.getDataType(), newDefault);
                    newCol.setGeneratedColType(col.getGeneratedColType());
                    newCol.setIdentityType(col.getIdentityType());
                    newCol.setSqlType(col.getSqlType());
                    this._alterColumnNames.remove(j);
                    this._columns.set(i, newCol);
                    ColumnIdentifier colid = new ColumnIdentifier(trgtTid, col.getName(), null, col.getDataType());
                    ColumnIdentifier newcolid = new ColumnIdentifier(trgtTid, newCol.getName(), null, newCol.getDataType());
                    this._colIdsForInsert.set(this._colIdsForInsert.indexOf(colid), newcolid);
                }
                continue;
            }
            throw new AxionException("Can't rename Generated columns");
        }
    }

    private void buildColumnsFromSourceTable(Database db) throws AxionException {
        if (this._subQuery != null) {
            this._sourceTable = this._subQuery.getTableView(db, null);
        }
        if (this._sourceTable != null) {
            Column col;
            for (String columnName : this._excludeSourceColumns) {
                col = this._sourceTable.getColumn(columnName);
                if (col != null) continue;
                throw new AxionException("Column not found " + columnName);
            }
            for (String columnName : this._columnNames) {
                col = this._sourceTable.getColumn(columnName);
                if (col == null) continue;
                throw new AxionException("Column Already Exists " + columnName);
            }
            TableIdentifier trgtTid = new TableIdentifier(this.getObjectName());
            int count = this._sourceTable.getColumnCount();
            for (int i = 0; i < count; ++i) {
                Column col2 = this._sourceTable.getColumn(i);
                if (this._excludeSourceColumns.contains(this._columnsAreCaseSensitive ? col2.getName() : col2.getName().toUpperCase())) continue;
                this._columns.add(col2);
                if (col2.isDerivedColumn()) continue;
                ColumnIdentifier colid = new ColumnIdentifier(trgtTid, col2.getName(), null, col2.getDataType());
                this._colIdsForInsert.add(colid);
            }
        }
    }

    private void buildSubQuery() {
        AxionQueryContext ctx = new AxionQueryContext();
        TableIdentifier srctid = new TableIdentifier(this._sourceTable.getName());
        ctx.addFrom(srctid);
        for (Column col : this._columns) {
            if (col.isDerivedColumn()) continue;
            ColumnIdentifier colid = new ColumnIdentifier(srctid, col.getName(), null, col.getDataType());
            ctx.addSelect(colid);
        }
        this._subQuery = new SubSelectCommand(ctx);
    }

    private void populateData(Database db, Table table) throws AxionException {
        if (this._sourceTable != null) {
            TableIdentifier tid = new TableIdentifier(table.getName());
            InsertCommand insertSelectCmd = new InsertCommand(tid, this._colIdsForInsert, this._subQuery);
            insertSelectCmd.execute(db);
        }
    }
}

