/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Row;

public class RowDecorator {
    private Map _fieldMap;
    private Row _row;
    private int _rowndx = -1;

    public RowDecorator(Map selectableToFieldMap) {
        this._fieldMap = selectableToFieldMap;
    }

    public Object get(ColumnIdentifier colid) throws AxionException {
        Integer index = (Integer)this._fieldMap.get(this.getCanonicalForm(colid));
        if (null == index) {
            throw new AxionException("Field " + colid + " not found.", 42703);
        }
        Object obj = this._row.get(index);
        return colid.getDataType().convert(obj);
    }

    public Row getRow() {
        return this._row;
    }

    public int getRowIndex() throws AxionException {
        if (this._rowndx == -1) {
            throw new AxionException("Row index not available.");
        }
        return this._rowndx;
    }

    public Iterator getSelectableIterator() {
        return Collections.unmodifiableSet(this._fieldMap.keySet()).iterator();
    }

    public void setRow(int rowndx, Row row) {
        this._rowndx = rowndx;
        this._row = row;
    }

    public void setRow(Row row) {
        this.setRow(-1, row);
    }

    private ColumnIdentifier getCanonicalForm(ColumnIdentifier colid) {
        if (null == colid) {
            return null;
        }
        return colid.getCanonicalIdentifier();
    }
}

