/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;

public class AxionException
extends Exception {
    public static final int DEFAULT_VENDOR_CODE = 99999;
    protected static PropertyResourceBundle _bundle = null;
    private Throwable _nested = null;
    private int _vendorCode;

    public AxionException() {
        this(null, null, 99999);
    }

    public AxionException(int vendorcode) {
        this(null, null, vendorcode);
    }

    public AxionException(String message) {
        this(message, null, 99999);
    }

    public AxionException(String message, int vendorcode) {
        this(message, null, vendorcode);
    }

    public AxionException(String message, Throwable nested, int vendorcode) {
        super(null == message ? (null == nested ? null : nested.toString()) : (null == nested ? message : message + " (" + nested.toString() + ")"));
        this._nested = nested;
        this._vendorCode = vendorcode;
    }

    public AxionException(String message, Throwable nested) {
        this(message, nested, 99999);
    }

    public AxionException(Throwable nested) {
        this(null, nested, 99999);
    }

    public AxionException(Throwable nested, int vendorcode) {
        this(null, nested, vendorcode);
    }

    public int getVendorCode() {
        return this._vendorCode;
    }

    public String getMessage() {
        if (super.getMessage() != null) {
            return super.getMessage();
        }
        return AxionException.getErrorMessage(this._vendorCode);
    }

    public String getSQLState() {
        int charnum;
        if (this._vendorCode < 100000) {
            String sqlstate = String.valueOf(this._vendorCode);
            while (sqlstate.length() < 5) {
                sqlstate = '0' + sqlstate;
            }
            return sqlstate;
        }
        String CONVERSION_ERROR = "99099";
        String sqlstate = String.valueOf(this._vendorCode);
        if (sqlstate.charAt(0) > '3') {
            if (this._vendorCode == 499000) {
                return "HZ000";
            }
            return "99099";
        }
        if (sqlstate.charAt(0) == '1' || sqlstate.charAt(0) == '3') {
            charnum = Integer.parseInt(sqlstate.substring(2, 4));
            sqlstate = sqlstate.substring(0, 2) + (char)(64 + charnum) + sqlstate.substring(4, sqlstate.length());
        }
        if (sqlstate.charAt(0) == '2' || sqlstate.charAt(1) == '3') {
            charnum = Integer.parseInt(sqlstate.substring(sqlstate.length() - 2, sqlstate.length()));
            sqlstate = sqlstate.substring(0, 5) + (char)(64 + charnum);
        }
        sqlstate = sqlstate.substring(1, sqlstate.length());
        return sqlstate;
    }

    private static String getErrorMessage(int vendorcode) {
        try {
            if (_bundle == null) {
                AxionException.getResourceBundle("org/axiondb/AxionStateCodes.properties");
            }
            return _bundle.getString(String.valueOf(vendorcode));
        }
        catch (Exception e) {
            return "-- Unknown Exception (" + vendorcode + ") --";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getResourceBundle(String bundleFile) throws IOException {
        ClassLoader cl = AxionException.class.getClassLoader();
        InputStream in = null;
        try {
            in = cl.getResourceAsStream(bundleFile);
            _bundle = new PropertyResourceBundle(in);
        }
        finally {
            in.close();
        }
    }

    public Throwable getNestedThrowable() {
        return this._nested;
    }
}

