/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime.provider;

import com.sun.encoder.runtime.CoderException;
import com.sun.encoder.runtime.provider.SharedCoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class MultiByteCoder
extends SharedCoder {
    private static final int BYTES = 256;
    public static final int NOCHAR = 65535;
    public static final byte MAX_CODE = 4;
    private final int[] mFirst = new int[256];
    private int[] mRest = null;
    private short mBlock = 0;
    private byte[] mPadding = null;
    private final short[] mIndex = new short[256];
    private final short[] mRevIndex = new short[256];
    private final byte[][][] mChar2Bytes = new byte[256][][];
    private int mMaxCode = 0;
    private Object[] mTopMap = null;
    private boolean[] mSecond = null;
    private int mRestPos;

    public MultiByteCoder(File input) throws IOException {
        FileInputStream is = new FileInputStream(input);
        this.init(input.getPath(), is);
        ((InputStream)is).close();
    }

    public MultiByteCoder(String resource) throws IOException {
        ClassLoader loader = MultiByteCoder.class.getClassLoader();
        InputStream is = loader.getResourceAsStream(resource);
        if (is == null) {
            throw new IOException("can't find code table resource '" + resource + "'");
        }
        this.init(resource, is);
        is.close();
    }

    private int getHexNumber(String path, LineNumberReader in, String s, String what, byte[] buf) throws IOException {
        int len = (s = s.trim()).length();
        if (len == 0) {
            throw new IOException(path + " line " + in.getLineNumber() + ": zero-length " + what + " value");
        }
        if ((len & 1) != 0) {
            s = "0" + s;
            ++len;
        }
        if (buf.length * 2 < len) {
            throw new IOException(path + " line " + in.getLineNumber() + ": oversized " + what + " value '" + s + "', max is " + buf.length * 2 + " digits");
        }
        for (int i = 0; i < len; i += 2) {
            int hi = "0123456789ABCDEF".indexOf(s.charAt(i));
            int lo = "0123456789ABCDEF".indexOf(s.charAt(i + 1));
            if (hi < 0 || lo < 0) {
                throw new IOException(path + " line " + in.getLineNumber() + ": malformed " + what + " value '" + s + "'");
            }
            buf[i / 2] = (byte)((hi << 4) + lo);
        }
        return len / 2;
    }

    private int getHexNumber(String path, LineNumberReader in, String s, String what, long max) throws IOException {
        byte[] buf = new byte[4];
        s = s.trim();
        int bytes = this.getHexNumber(path, in, s, what, buf);
        int n = 0;
        for (int i = 0; i < bytes; ++i) {
            n = (n << 8) + (buf[i] & 0xFF);
        }
        if (n < 0 || max < (long)n) {
            throw new IOException(path + " line " + in.getLineNumber() + ": invalid " + what + " value '" + s + "'");
        }
        return n;
    }

    public void init(String path, InputStream is) throws IOException {
        String line;
        LineNumberReader in;
        if (is == null) {
            throw new NullPointerException("no input stream");
        }
        try {
            in = new LineNumberReader(new BufferedReader(new InputStreamReader(is, "UTF-8")));
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException("broken platform");
        }
        this.mMaxCode = 0;
        this.mTopMap = new Object[256];
        this.mSecond = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            this.mTopMap[i] = null;
            this.mSecond[i] = false;
        }
        byte[] buf = new byte[4];
        while ((line = in.readLine()) != null) {
            if (line.length() <= 0 || line.startsWith("#")) continue;
            int pos = line.indexOf(61);
            if (pos < 0) {
                throw new IOException(path + " line " + in.getLineNumber() + ": missing '='");
            }
            String b = line.substring(0, pos);
            String s = line.substring(pos + 1);
            int nbyte = this.getHexNumber(path, in, b, "byte", buf);
            int nchar = this.getHexNumber(path, in, s, "char", 65533L);
            try {
                this.add(buf, nbyte, nchar);
            }
            catch (IllegalArgumentException ia) {
                throw new IOException(path + " line " + in.getLineNumber() + ": " + ia.getMessage());
            }
        }
        in.close();
        this.mBlock = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.mSecond[i]) {
                this.mRevIndex[this.mBlock] = (short)i;
                this.mBlock = (short)(this.mBlock + 1);
                continue;
            }
            this.mIndex[i] = -1;
        }
        this.mSecond = null;
        int sec = this.mapCount(this.mTopMap) - 1;
        this.mRestPos = 1;
        this.mRest = new int[sec * this.mBlock + this.mRestPos];
        int i = this.mRest.length;
        while (i-- > 0) {
            this.mRest[i] = 65535;
        }
        for (i = 0; i < 256; ++i) {
            Object o = this.mTopMap[i];
            this.mFirst[i] = o == null ? 65535 : (o instanceof Integer ? ((Integer)o).intValue() : this.convertMap((Object[])o));
        }
        this.mTopMap = null;
        if (this.mChar2Bytes[0] == null || (this.mPadding = this.mChar2Bytes[0][32]) == null) {
            throw new IOException(path + ": does not map space (for padding)");
        }
    }

    private int convertMap(Object[] map) {
        int i;
        int start = this.mRestPos;
        this.mRestPos += this.mBlock;
        for (i = 0; i < this.mBlock; ++i) {
            this.mRest[start + i] = 65535;
        }
        for (i = 0; i < 256; ++i) {
            Object o = map[i];
            if (o == null) continue;
            short n = this.mIndex[i];
            if (n < 0) {
                throw new RuntimeException("index map failed for " + i);
            }
            this.mRest[start + n] = o instanceof Integer ? ((Integer)o).intValue() : this.convertMap((Object[])o);
        }
        return -start;
    }

    private int mapCount(Object[] map) {
        int count = 1;
        for (int i = 0; i < 256; ++i) {
            Object o = map[i];
            if (o == null || !(o instanceof Object[])) continue;
            count += this.mapCount((Object[])o);
        }
        return count;
    }

    private void add(byte[] b, int bsize, int c) {
        if (c < 0 || 65533 <= c) {
            throw new IllegalArgumentException("invalid code " + MultiByteCoder.uname(c));
        }
        if (this.mMaxCode < bsize) {
            this.mMaxCode = bsize;
        }
        Object[] map = this.mTopMap;
        for (int i = 0; i < bsize; ++i) {
            Object[] o;
            boolean last;
            int n = b[i] & 0xFF;
            boolean bl = last = i == bsize - 1;
            if (i > 0) {
                this.mSecond[n] = true;
            }
            if ((o = map[n]) != null && (last || !(o instanceof Object[]))) {
                throw new IllegalArgumentException("duplicate encoding prefix " + MultiByteCoder.hex(b, 0, i + 1));
            }
            if (last) {
                map[n] = new Integer(c);
                continue;
            }
            map = o != null ? o : new Object[256];
        }
        int lo = c & 0xFF;
        int hi = c >> 8 & 0xFF;
        byte[] seq = new byte[bsize];
        for (int i = 0; i < bsize; ++i) {
            seq[i] = b[i];
        }
        if (this.mChar2Bytes[hi] == null) {
            byte[][] byArrayArray = new byte[256][];
            this.mChar2Bytes[hi] = byArrayArray;
            byte[][] cb2 = byArrayArray;
            for (int j = 0; j < 256; ++j) {
                cb2[j] = null;
            }
        }
        this.mChar2Bytes[hi][lo] = seq;
    }

    public byte[] encode(String in, int min, int max) throws CoderException {
        int i;
        if (in == null) {
            return null;
        }
        if (0 <= min && 0 <= max && max < min) {
            throw new IllegalArgumentException("max (" + max + ") < min (" + min + ")");
        }
        int len = in.length();
        int room = len * this.mMaxCode;
        if (room < min) {
            room = min;
        }
        int size = 0;
        byte[] buf = new byte[room];
        for (i = 0; i < len; ++i) {
            byte[] seq;
            char c = in.charAt(i);
            byte[][] map = this.mChar2Bytes[c >> 8 & 0xFF];
            if (map == null || (seq = map[c & 0xFF]) == null) {
                throw new CoderException("char #" + i + " = " + MultiByteCoder.uname(c) + ", not encodable");
            }
            for (int j = 0; j < seq.length; ++j) {
                buf[size++] = seq[j];
            }
        }
        if (0 <= max && max < size) {
            throw new CoderException("too big: " + size + ", max=" + max);
        }
        while (size < min) {
            if (min < size + this.mPadding.length) {
                throw new CoderException("can't use " + this.mPadding.length + "-byte padding (" + MultiByteCoder.hex(this.mPadding) + ") for " + (min - size) + " gap");
            }
            for (i = 0; i < this.mPadding.length; ++i) {
                buf[size++] = this.mPadding[i];
            }
        }
        byte[] out = new byte[size];
        while (size-- > 0) {
            out[size] = buf[size];
        }
        return out;
    }

    public String decode(byte[] in, int from, int length) throws CoderException {
        if (in == null) {
            return null;
        }
        if (from < 0 || in.length < from || length < 0 || in.length < from + length) {
            throw new CoderException("invalid size/from/length: " + in.length + "/" + from + "/" + length);
        }
        char[] out = new char[length];
        int size = 0;
        int last = from + length;
        for (int i = from; i < last; ++i) {
            int c = this.mFirst[in[i] & 0xFF];
            if (c == 65535) {
                throw new CoderException(i, "code = " + MultiByteCoder.bname(in[i]) + ", not decodable");
            }
            int j = i;
            while (c < 0) {
                if (++j >= last) {
                    throw new CoderException(i, "unterminated sequence");
                }
                short n = this.mIndex[in[j] & 0xFF];
                if (n < 0) {
                    throw new CoderException(i, "part " + (j - i) + " = " + MultiByteCoder.bname(in[j]) + ", invalid continuation of" + MultiByteCoder.hex(in, i, j));
                }
                if ((c = this.mRest[n - c]) != 65535) continue;
                throw new CoderException(i, " to " + j + ": code = " + MultiByteCoder.bname(in[i]) + ", not decodable");
            }
            i = j;
            out[size++] = (char)c;
        }
        return new String(out, 0, size);
    }

    private void dump(PrintStream ps, int block, String prefix) {
        ps.println();
        ps.println("# [" + prefix + "]: " + block);
        for (int i = 0; i < this.mBlock; ++i) {
            int c = this.mRest[block + i];
            if (c == 65535) continue;
            if (c < 0) {
                this.dump(ps, -c, prefix + MultiByteCoder.hex2(this.mRevIndex[i]));
                continue;
            }
            ps.println(prefix + MultiByteCoder.hex2(this.mRevIndex[i]) + " = " + MultiByteCoder.hex4(c));
        }
    }

    public void dump(PrintStream ps) {
        ps.println("# Multi-byte encoding map dump.");
        ps.println("#-------------------------------");
        ps.println();
        for (int i = 0; i < 256; ++i) {
            if (this.mFirst[i] == 65535) continue;
            if (this.mFirst[i] < 0) {
                this.dump(ps, -this.mFirst[i], MultiByteCoder.hex2(i));
                continue;
            }
            ps.println(MultiByteCoder.hex2(i) + " = " + MultiByteCoder.hex4(this.mFirst[i]));
        }
        ps.println();
        for (int hi = 0; hi < 256; ++hi) {
            if (this.mChar2Bytes[hi] == null) continue;
            for (int lo = 0; lo < 256; ++lo) {
                byte[] b = this.mChar2Bytes[hi][lo];
                if (b == null) continue;
                ps.println("# " + MultiByteCoder.uname(hi * 256 + lo) + " = " + MultiByteCoder.hex(b, 0, b.length));
            }
        }
    }

    public static void main(String[] args) {
        try {
            boolean res = false;
            String path = "mb.code";
            int opt = 0;
            if (args.length > opt && args[opt].equals("-r")) {
                res = true;
                ++opt;
            }
            if (args.length > opt) {
                path = args[opt++];
            }
            MultiByteCoder sbc = res ? new MultiByteCoder(path) : new MultiByteCoder(new File(path));
            sbc.dump(System.out);
        }
        catch (Exception all) {
            all.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

