/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime.provider;

import com.sun.encoder.runtime.OtdInputStream;
import com.sun.encoder.runtime.OtdInputStreamMark;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FileOtdInputStreamImpl
implements OtdInputStream {
    protected InputStream mIn = null;
    protected boolean mMarkFlag = false;
    protected int mCurTokenBegin = 0;
    protected int mCurTokenEnd = -1;
    protected int pos = 0;
    protected String mFileName = "/temp/otd/external/output.txt";
    private RandomAccessFile mRAF = null;

    public FileOtdInputStreamImpl(InputStream in) {
        this.mIn = in;
    }

    public void begin() {
    }

    public void close() throws IOException {
        this.mIn.close();
    }

    public boolean end() throws IOException {
        return this.mIn.read() < 0;
    }

    public synchronized OtdInputStreamMark mark() {
        if (!this.mMarkFlag) {
            this.mMarkFlag = true;
        }
        return new FileOtdInputStreamMark(this.mCurTokenEnd - this.mCurTokenBegin);
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() throws IOException {
        int value = this.mIn.read();
        if (value < 0) {
            return -1;
        }
        ++this.pos;
        return value;
    }

    public synchronized int read(byte[] b, int off) throws IOException {
        int count = this.mIn.read(b, off, b.length - off);
        System.out.println("read(byte[],int,int)...begin pos: " + this.pos + ", ending pos: " + (this.pos + count) + ", count: " + count);
        if (count < 0) {
            return -1;
        }
        this.pos += count;
        return count;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        if (offset + length > buffer.length) {
            throw new IllegalArgumentException("offset+length > buffer size");
        }
        int count = this.mIn.read(buffer, offset, length);
        System.out.println("read(byte[],int,int)...begin pos: " + this.pos + ", ending pos: " + (this.pos + count) + ", count: " + count);
        if (count < 0) {
            return -1;
        }
        this.pos += count;
        return count;
    }

    public void reset() throws IOException {
        this.mIn.reset();
    }

    public synchronized void rewind() throws IOException {
    }

    public synchronized void seek(OtdInputStreamMark mark) throws IOException {
        long offset = ((FileOtdInputStreamMark)mark).getOffset();
    }

    public void skip(long count) throws IOException {
        if (count < 0L) {
            throw new IllegalArgumentException("negative offset");
        }
        this.mIn.skip(count);
    }

    public void writeMarkOffset(byte[] buffer, int offset, int len) throws IOException {
    }

    public synchronized void writeToken(byte[] bytes, int off, int len) throws IOException {
        if (!this.mMarkFlag) {
            return;
        }
        this.mCurTokenBegin = (int)this.mRAF.length();
        this.mRAF.seek(this.mRAF.length());
        this.mRAF.write(bytes, off, len);
        this.mCurTokenEnd = (int)this.mRAF.length();
        System.out.println("......................curTokenBegin: " + this.mCurTokenBegin + " , end: " + this.mCurTokenEnd);
    }

    private static class FileOtdInputStreamMark
    implements OtdInputStreamMark {
        private long mOffset;

        public FileOtdInputStreamMark(long offset) {
            this.mOffset = offset;
        }

        public long getOffset() {
            return this.mOffset;
        }

        public long offset() {
            return this.mOffset;
        }
    }
}

