/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** structDeclNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ stDeclNodeList
stDeclNodeList_new ()
{
  stDeclNodeList s = (stDeclNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;
  s->nspace = stDeclNodeListBASESIZE;
  s->elements = (stDeclNode *)
    dmalloc (sizeof (*s->elements) * stDeclNodeListBASESIZE);

  return (s);
}

static void
stDeclNodeList_grow (stDeclNodeList s)
{
  int i;
  stDeclNode *newelements; 

  s->nspace += stDeclNodeListBASESIZE;

  newelements = (stDeclNode *) dmalloc (sizeof (*newelements)
					* (s->nelements + s->nspace));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i]; 
    }

  sfree (s->elements); 
  s->elements = newelements;
}

stDeclNodeList  
stDeclNodeList_add (stDeclNodeList s, /*@only@*/ stDeclNode el)
{
  if (s->nspace <= 0)
    stDeclNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ stDeclNodeList 
stDeclNodeList_copy (stDeclNodeList s)
{
  stDeclNodeList r = stDeclNodeList_new ();

  stDeclNodeList_elements (s, x)
    {
      r = stDeclNodeList_add (r, stDeclNode_copy (x));
    } end_stDeclNodeList_elements;
  
  return r;
}

/*@only@*/ cstring
stDeclNodeList_unparse (stDeclNodeList s)
{
  bool first = TRUE;
  cstring st = cstring_undefined;

  stDeclNodeList_elements (s, current)
  {
    if (first)
      {
	st = message ("%q %q;", lclTypeSpecNode_unparse (current->lcltypespec),
		      declaratorNodeList_unparse (current->declarators));
	first = FALSE;
      }
    else
      {
	st = message ("%q %q %q;", st, lclTypeSpecNode_unparse (current->lcltypespec),
		      declaratorNodeList_unparse (current->declarators));
      }
  } end_stDeclNodeList_elements;

  return st;
}

void
stDeclNodeList_free (stDeclNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      stDeclNode_free (s->elements[i]); 
    }

  sfree (s->elements); 
  sfree (s);
}
