/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** paramNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ paramNodeList
paramNodeList_new ()
{
  paramNodeList s = (paramNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;
  s->nspace = paramNodeListBASESIZE;
  s->elements = (paramNode *) 
    dmalloc (sizeof (*s->elements) * paramNodeListBASESIZE);

  return (s);
}

/*@only@*/ paramNodeList
paramNodeList_single (/*@keep@*/ paramNode p)
{
  paramNodeList s = (paramNodeList) dmalloc (sizeof (*s));
  
  s->nelements = 1;
  s->nspace = paramNodeListBASESIZE - 1;
  s->elements = (paramNode *) dmalloc (sizeof (*s->elements) * paramNodeListBASESIZE);
  s->elements[0] = p;

  return (s);
}

static void
paramNodeList_grow (/*@notnull@*/ paramNodeList s)
{
  int i;
  paramNode *newelements;

  s->nspace += paramNodeListBASESIZE;

  newelements = (paramNode *) dmalloc (sizeof (*newelements)
				       * (s->nelements + s->nspace));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

paramNodeList
paramNodeList_add (paramNodeList s, paramNode el)
{
  llassert (paramNodeList_isDefined (s));

  if (s->nspace <= 0)
    paramNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  
  s->nelements++;
  return s;
}

/*@only@*/ paramNodeList 
paramNodeList_copy (paramNodeList s)
{
  paramNodeList r = paramNodeList_new ();

  paramNodeList_elements (s, x)
  {
    r = paramNodeList_add (r, paramNode_copy (x));
  } end_paramNodeList_elements;

  return r;
}

/*@only@*/ cstring
paramNodeList_unparse (paramNodeList s)
{
  bool first = TRUE;
  cstring st = cstring_undefined;

  paramNodeList_elements (s, current)
  {
    if (first)
      {
	st = paramNode_unparse (current);
	first = FALSE;
      }
    else
      {
	st = message ("%q, %q", st, paramNode_unparse (current));
      }
  } end_paramNodeList_elements;

  return st;
}

/*@only@*/ cstring
paramNodeList_unparseComments (paramNodeList s)
{
  bool first = TRUE;
  cstring st = cstring_undefined;

  paramNodeList_elements (s, current)
  {
    if (first)
      {
	st = paramNode_unparseComments (current);
	first = FALSE;
      }
    else
      {
	st = message ("%q, %q", st, paramNode_unparseComments (current));
      }
  } end_paramNodeList_elements;

  return st;
}

void
paramNodeList_free (/*@only@*/ paramNodeList s)
{
  if (paramNodeList_isDefined (s))
    {
      int i;
      for (i = 0; i < s->nelements; i++)
	{
	  paramNode_free (s->elements[i]); 
	}
      
      sfree (s->elements); 
      sfree (s);
    }
}
