/*
 * gom_file.h: loading and saving files
 */

/* 
 * This file is part of the package
 *
 * gom, Gom is nOt yet another Mixer
 *
 * (c) Stephan Suerken <suerken@fh-worms.de> 1996, 1997
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * INCLUDES
 */

/*
 * MACROS
 */

/*
 * DECLARATIONS/DEFINTIONS
 */

char gom_file_fn[FILENAME_MAX];
FILE * gom_file_f;

/*
 * FUNCTION PROTOTYPES
 */

/*
 * LOADING
 */

/* loading options from stream: */
void 
gom_file_options_read(enum gom_info_types std_verb,
		      FILE * f, int action_ignore);

/* loading options from file: */
void 
gom_file_options_load(enum gom_info_types std_verb,
		      char * fname,
		      enum gom_info_types open_err_verb, int action_ignore);

/* loading gom's configuration: */
/* - either loads user, system or no config */
/* - no errors */
void
gom_file_config_load(enum gom_info_types verb, int action_ignore);


/*
 * SAVING
 */

/* settings file to stream */
void 
gom_file_settings_write(FILE * f, int verbose);

/* settings file to file: */
void 
gom_file_settings_save(enum gom_info_types std_verb,
		       char * fname);
