/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

#define DATE_SIZE 20
#define VOLUME_SIZE 50
#define WIDTH_OFFSET 65
#define GROUP_RECORDSIZE 50
#define GS_LENGTH 250
#define GS_VERSION 1100
#define FILE_VERSION 107 /* most current file version */
#define TRENDLINE_LIMIT 25
#define SYMBOL_LIMIT 50


/*** structs ***/
struct record1
{
	unsigned long date;
	float open;
	float high;
	float low;
	float close;
	unsigned long volume;
	unsigned long openint;
};

struct record2
{
	unsigned int version;
	char name[100];
	char symbol[25];
	unsigned long first_date;
	unsigned long last_date;
	unsigned int records;
	unsigned short styleflag;
	unsigned short pixelspace;
	unsigned short volume; /* status */
	unsigned short moving[3]; /* status, type, period */
	unsigned short moving2[3];
	unsigned short moving3[3];
	unsigned short volumeroc_status;
	unsigned short closeroc_status;
	unsigned short threshold_status;
	float volumeroc;
	float closeroc;
	float threshold;
	unsigned short ma_alert;
	unsigned short ma2_alert;
	unsigned short ma3_alert;
	char filler[828];
/*	unsigned short trnedline;  # of lines 
	unsigned short trendline_data[25][4];  x, y, x, y 
	unsigned short symbols;  # of symbols 
	unsigned short symbols_data[150];  type, x, y */
};

struct record3
{
	unsigned int version;
	char last_group[250];
	char pixmap_path[250];
	unsigned int bars;
	unsigned short top_enable_flag;
	unsigned short bottom_enable_flag;
	unsigned short contract_high_flag;
	unsigned short contract_low_flag;
	unsigned short last_date_flag;
	unsigned short last_close_flag;
	unsigned short net_change_flag;
	unsigned short date_flag;
	unsigned short open_flag;
	unsigned short high_flag;
	unsigned short low_flag;
	unsigned short close_flag;
	unsigned short volume_flag;
	unsigned short openi_flag;
	unsigned short volume;
	unsigned short grid;
	unsigned short grid_red;
	unsigned short grid_green;
	unsigned short grid_blue;
	unsigned short price_red;
	unsigned short price_green;
	unsigned short price_blue;
	unsigned short volume_red;
	unsigned short volume_green;
	unsigned short volume_blue;
	unsigned short moving_red;
	unsigned short moving_green;
	unsigned short moving_blue;
	unsigned short moving2_red;
	unsigned short moving2_green;
	unsigned short moving2_blue;
	unsigned short moving3_red;
	unsigned short moving3_green;
	unsigned short moving3_blue;
	unsigned short background_red;
	unsigned short background_green;
	unsigned short background_blue;
	unsigned short border_red;
	unsigned short border_green;
	unsigned short border_blue;
	unsigned short global_indicators;
	unsigned short global_moving_status;
	unsigned short global_moving_type;
	unsigned short global_moving_length;
	unsigned short global_moving2_status;
	unsigned short global_moving2_type;
	unsigned short global_moving2_length;
	unsigned short global_moving3_status;
	unsigned short global_moving3_type;
	unsigned short global_moving3_length;
	unsigned short global_volume_status;
	unsigned short global_alerts;
	unsigned short global_alerts_moving_status;
	unsigned short global_alerts_moving2_status;
	unsigned short global_alerts_moving3_status;
	unsigned short global_alerts_closeroc_status;
	unsigned short global_alerts_threshold_status;
	unsigned short global_alerts_volumeroc_status;
	float global_threshold;
	float global_closeroc;
	float global_volumeroc;
	unsigned short style;
	unsigned short import_field;
	unsigned short import_date;
	char proxy[100];
	unsigned short port;
	char source[50];
};

extern void alert_goto_chart();
extern void create_alert_report();
extern void ok_alert_scan();
extern void alert_scan();
extern void update_stats_bar();
extern void display_message();
extern void about();
extern void show_info_bar();
extern void hide_info_bar();
extern void show_data_bar();
extern void hide_data_bar();
extern void create_config();
extern void exit_program();
extern void read_config();
extern void toggle_volume();
extern void toggle_grid();
extern void show_data_window();
extern void ok_goto_chart();
extern void goto_chart();
extern void style_button_pressed();
extern void expand_chart();
extern void shrink_chart();
extern void next_chart();
extern void previous_chart();
extern void line_style();
extern void hlc_style();
extern void new_init();
extern void init();
extern void motion_notify_event (GtkWidget *, GdkEventMotion *);
extern void configure_event (GtkWidget *, GdkEventConfigure *);
extern void scale_configure_event (GtkWidget *, GdkEventConfigure *);
extern void expose_event (GtkWidget *, GdkEventExpose *);
extern void scale_expose_event (GtkWidget *, GdkEventExpose *);
extern void button_press_event (GtkWidget *, GdkEventButton *);
extern void volume_motion_notify_event (GtkWidget *, GdkEventMotion *);
extern void volume_configure_event (GtkWidget *, GdkEventConfigure *);
extern void volume_expose_event (GtkWidget *, GdkEventExpose *);
extern void volume_button_press_event (GtkWidget *, GdkEventButton *);
extern void date_configure_event (GtkWidget *, GdkEventConfigure *);
extern void date_expose_event (GtkWidget *, GdkEventExpose *);
extern void yes_delete_chart();
extern void delete_chart();
extern void ok_open_chart();
extern void workwith_charts();
extern void draw_date();
extern void draw_volume();
extern void draw_scale();
extern void draw_price();
extern void draw_moving_average();
extern void draw();
extern void yes_delete_record();
extern void edit_data_end();
extern void edit_data_back();
extern void edit_data_next();
extern void edit_data_start();
extern void edit_data_delete();
extern void edit_data_save();
extern void edit_chart_data();
extern void save_indicators();
extern void edit_indicators();
extern void save_options();
extern void edit_options();
extern void get_export_filename();
extern void ok_export();
extern void save_export();
extern void export_options();
extern void yes_delete_group();
extern void ok_rename_group();
extern void rename_group();
extern void edit_group_insert_button();
extern void edit_group_add_button();
extern void edit_group_delete_button();
extern void edit_group_ok_button();
extern void ok_edit_group();
extern void ok_delete_group();
extern void load_group();
extern void create_group();
extern void new_group();
extern void workwith_groups();
extern void load_first_group();
extern void create_help_window();
extern void help_index();
extern void help_workwith_groups_window();
extern void help_workwith_charts_window();
extern void help_goto_chart_window();
extern void help_edit_indicator_window();
extern void help_alert_scan_window();
extern void help_alert_view_window();
extern void help_new_group_window();
extern void help_import_options_window();
extern void help_export_options_window();
extern void help_edit_options_window();
extern void help_edit_group_window();
extern void help_rename_group_window();
extern void help_edit_chart_window();
extern void get_import_filename();
extern void ok_import();
extern void open_import();
extern void import_options();
extern void save_name_dat();
extern void save_symbol_dat();
extern void save_volume_dat();
extern void save_moving_dat();
extern void save_volumeroc_dat();
extern void save_closeroc_dat();
extern void save_threshold_dat();
extern void load_alerts();
extern void load_file(char *);
extern void new_group();
extern void workwith_groups();
extern void workwith_charts();
extern void import_options();
extern void edit_options();
extern void edit_indicators();
extern void expand_chart();
extern void shrink_chart();
extern void line_style();
extern void hlc_style();
extern void show_data_window();
extern void goto_chart();
extern void alert_scan();
extern void about();
extern void load_first_group();
extern void button_press_event();
extern void export_options();
extern void new_init();
extern void exit_edit_indicator_window();
extern void exit_edit_options_window();
extern void edit_alerts();
extern void no_save_alerts();
extern void yes_save_alerts();
extern void exit_alerts_window();
extern void save_alerts();
extern void get_color(char *);
extern void get_color2(int, int, int);
extern void get_object_color();
extern void set_object_color();
extern void save_chart_header();
extern void save_config();
extern void edit_options_object_changed();
extern void edit_options_color_changed();
extern void display_record(unsigned int); 
extern void append_chart_record(char *, unsigned long, float, float, float, float, unsigned long, unsigned long);
extern int create_new_chart(char *);
extern int find_chart_record(char *, unsigned long);
extern void overwrite_chart_record (char *, unsigned int, unsigned long , float, float, float, float, unsigned long, unsigned long);
extern void insert_chart_record (char *, unsigned long, float, float, float, float, unsigned long, unsigned long);
extern void edit_goto_record();
extern void ok_goto_record();
extern void save_changes();
extern void show_chart_list(GtkWidget *);
extern void show_yesno_window(char *);
extern void show_progress_window(char *);
extern float get_simple_movavg(int , unsigned int);
extern void show_indicators();
extern void show_indicator2_window();
extern void show_indicator3_window();
extern void draw_moving_average2();
extern void draw_moving_average3();
extern void update_indicator_clist();
extern void update_alerts_clist();
extern float get_exponential_movavg(int, unsigned int);
extern float get_weighted_movavg(int, unsigned int);
extern void set_color(int);
extern void set_color2(int, int, int);
extern void scan_volumeroc(char *, unsigned int);
extern void scan_closeroc(char *, unsigned int);
extern void scan_threshold(char *, unsigned int);
extern void scan_ma(char *, unsigned int, int);
extern void toggle_global_indicators();
extern void menu_edit_indicators();
extern void menu_edit_alerts();
extern void menu_toggle_grid();
extern void menu_toggle_volume();
extern void menu_show_data_window();
extern void update_data_window();
extern int check_chart_version(unsigned int);
extern void show_update_quotes();
extern void help_update_quotes_window();
extern void ok_update_quotes();
extern void update_clist_entry(int , char *, GtkWidget *);

