/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "myheader.h"
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>



/**********************************************************************************/
void update_clist_entry(int line, char *symbol, GtkWidget *widget)
{
	char tstring[250], tstring2[25];
	int tint;
	FILE *infile;
	extern char *datapath;
	extern int header_size;
	struct record2 header;
	
	
	strcpy(tstring, datapath);
	strcat(tstring, symbol); 
   	infile = fopen(tstring, "rb");
   	if (infile)
   	{
   		fread(&header, header_size, 1, infile);
   		tint = check_chart_version(header.version);
		if (tint)
		{
			exit_program();
			exit(1);
		}
		gtk_clist_set_text(GTK_CLIST(widget), line, 0, header.symbol);
		gtk_clist_set_text(GTK_CLIST(widget), line, 1, header.name);
		sprintf(tstring2, "%ld", header.first_date);
		tstring[0] = tstring2[4];
		tstring[1] = tstring2[5];
		tstring[2] = '/';
		tstring[3] = tstring2[6];
		tstring[4] = tstring2[7];
		tstring[5] = '/';
		tstring[6] = tstring2[0];
		tstring[7] = tstring2[1];
		tstring[8] = tstring2[2];
		tstring[9] = tstring2[3];
		tstring[10] = 0;
		gtk_clist_set_text(GTK_CLIST(widget), line, 2, tstring);
		sprintf(tstring2, "%ld", header.last_date);
		tstring[0] = tstring2[4];
		tstring[1] = tstring2[5];
		tstring[2] = '/';
		tstring[3] = tstring2[6];
		tstring[4] = tstring2[7];
		tstring[5] = '/';
		tstring[6] = tstring2[0];
		tstring[7] = tstring2[1];
		tstring[8] = tstring2[2];
		tstring[9] = tstring2[3];
		tstring[10] = 0;
		gtk_clist_set_text(GTK_CLIST(widget), line, 3, tstring);
		fclose(infile);
	}
}
/*********************************************************************************/
void menu_edit_indicators()
{
	extern int chartflag;
	extern GtkWidget *indicator_button;
	
	if (chartflag)
	{
		if (! GTK_TOGGLE_BUTTON(indicator_button)->active)
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(indicator_button), 1);
		else
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(indicator_button), 0);
	}
}
/*********************************************************************************/
void menu_edit_alerts()
{
	extern int chartflag;
	extern GtkWidget *alert_button;
	
	if (chartflag)
	{
		if (! GTK_TOGGLE_BUTTON(alert_button)->active)
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(alert_button), 1);
		else
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(alert_button), 0);
	}
}
/*********************************************************************************/
void menu_toggle_grid()
{
	extern int chartflag;
	extern GtkWidget *grid_button;
	
	if (chartflag)
	{
		if (! GTK_TOGGLE_BUTTON(grid_button)->active)
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(grid_button), 1);
		else
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(grid_button), 0);
	}
}
/*********************************************************************************/
void menu_toggle_volume()
{
	extern int chartflag;
	extern GtkWidget *volume_button;
	
	if (chartflag)
	{
		if (! GTK_TOGGLE_BUTTON(volume_button)->active)
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(volume_button), 1);
		else
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(volume_button), 0);
	}
}
/*********************************************************************************/
void menu_show_data_window()
{
	extern int chartflag;
	extern GtkWidget *data_button;
	
	if (chartflag)
	{
		if (! GTK_TOGGLE_BUTTON(data_button)->active)
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(data_button), 1);
		else
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(data_button), 0);
	}
}
/**********************************************************************************
calculates a weighted moving average and returns the moving average
***********************************************************************************/
float get_weighted_movavg(int period, unsigned int start)
{
	int tint, tint2 = 0, tint3 = 0;
	float tfloat = 0.0, result;
	extern struct record1 *data;
	
	
	for (tint = (start - period), tint2 = 1; tint < start; tint++, tint2++)
	{
		tfloat = tfloat + (data[tint].close * tint2);
		tint3 = tint3 + tint2;
	}
	result = tfloat / tint3;
	return result;
}
/**********************************************************************************
calculates an exponential moving average and returns the moving average
***********************************************************************************/
float get_exponential_movavg(int period, unsigned int start)
{
	float result, expo, expo2, yesterday;
	extern struct record1 *data;
	
	
	expo = 2.0 / (period + 1);
	expo2 = 1.0 - expo;
	yesterday = get_simple_movavg(period, start);
	result = (data[start].close * expo) + (yesterday * expo2);
	return result;
}
/**********************************************************************************
calculates a simple moving average and returns the moving average
***********************************************************************************/
float get_simple_movavg(int period, unsigned int start)
{
	int tint;
	float result, tfloat = 0.0;
	extern struct record1 *data;
	
	
	for(tint = (start - period); tint < start; tint++)
		tfloat = tfloat + data[tint].close;
	result = tfloat / period;
	return result;
}
/**********************************************************************************
shows the progress bar used by various functions that use it
***********************************************************************************/
void show_progress_window(char *message)
{
	GtkWidget *vbox, *label;
	extern GtkWidget *progwindow, *progress_bar;
	
	
	progwindow = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (progwindow), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &progwindow);
	gtk_window_position(GTK_WINDOW (progwindow), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (progwindow), " ");
	gtk_container_border_width (GTK_CONTAINER (progwindow), 0);
	
	vbox = gtk_vbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (vbox), 10);
      	gtk_container_add (GTK_CONTAINER (progwindow), vbox);
      	gtk_widget_show (vbox);
      	
      	label = gtk_label_new(message);
      	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, TRUE, 0);
	gtk_widget_show(label);
	
        progress_bar = gtk_progress_bar_new ();
        gtk_box_pack_start (GTK_BOX (vbox), progress_bar, FALSE, TRUE, 0);
      	gtk_progress_bar_update (GTK_PROGRESS_BAR (progress_bar), 0.0);
      	gtk_widget_show (progress_bar);
      	
      	gtk_widget_show(progwindow);
}
/**********************************************************************************
shows the yes or no dialog window
***********************************************************************************/
void show_yesno_window(char *message)
{
	GtkWidget *vbox, *hbox2, *label, *hbox, *hsep;
	extern GtkWidget *yesno_window, *yesno_yes_button, *yesno_no_button;
	
	
	if (yesno_window)
		return;
	
	yesno_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (yesno_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &yesno_window);
	gtk_window_position(GTK_WINDOW (yesno_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (yesno_window), "Warning");
	gtk_widget_set_usize(GTK_WIDGET (yesno_window), 0, 0);
	
	vbox = gtk_vbox_new (FALSE, 5);
	gtk_container_add (GTK_CONTAINER (yesno_window), vbox);
     	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_widget_show (vbox);
      		
      	hbox2 = gtk_hbox_new (FALSE, 0);
      	gtk_container_border_width (GTK_CONTAINER (hbox2), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, TRUE, 0);
      	gtk_widget_show (hbox2);
      	
	label = gtk_label_new(message);
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, TRUE, 0);
        gtk_widget_show(label);
        
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox = gtk_hbutton_box_new();
        gtk_container_border_width (GTK_CONTAINER (hbox), 5);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
      	gtk_widget_show(hbox);
      	
      	yesno_no_button = gtk_button_new_with_label("No");
      	gtk_box_pack_start (GTK_BOX (hbox), yesno_no_button, FALSE, TRUE, 0);
      	gtk_widget_show (yesno_no_button);
        
      	yesno_yes_button = gtk_button_new_with_label("Yes");
      	gtk_box_pack_start (GTK_BOX (hbox), yesno_yes_button, FALSE, TRUE, 0);
      	gtk_widget_show (yesno_yes_button);
      	
      	GTK_WIDGET_SET_FLAGS (yesno_no_button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default (yesno_no_button);
      	gtk_widget_show(yesno_window);
}
/***********************************************************************************
scans datapath for all charts and inserts info into the specified clist box
************************************************************************************/
void show_chart_list(GtkWidget *chartlist)
{
	char tstring[250], tstring3[25], tstring4[25], tstring5[25], *line[4];
	FILE *infile;
	struct dirent **dirlist;
	int tint, tint2, tint3;
	extern char *datapath;
	extern int header_size;
	struct record2 header;
	
	
	gtk_clist_freeze(GTK_CLIST(chartlist));
	gtk_clist_clear(GTK_CLIST(chartlist));
	tint = scandir(datapath, &dirlist, NULL, alphasort);
	if (tint < 2)
    		return;
	tint2 = tint;
	for (tint = 2; tint < tint2; tint++)
	{
		strcpy(tstring, datapath);
		strcat(tstring, dirlist[tint]->d_name); 
   		infile = fopen(tstring, "rb");
   		if (infile)
   		{
   			fread(&header, header_size, 1, infile);
   			tint3 = check_chart_version(header.version);
			if (tint3)
			{
				exit_program();
				exit(1);
			}
			line[1] = header.name;
			line[0] = header.symbol;
			sprintf(tstring5, "%ld", header.first_date);
			tstring3[0] = tstring5[4];
			tstring3[1] = tstring5[5];
			tstring3[2] = '/';
			tstring3[3] = tstring5[6];
			tstring3[4] = tstring5[7];
			tstring3[5] = '/';
			tstring3[6] = tstring5[0];
			tstring3[7] = tstring5[1];
			tstring3[8] = tstring5[2];
			tstring3[9] = tstring5[3];
			tstring3[10] = 0;
			line[2] = tstring3;
			sprintf(tstring5, "%ld", header.last_date);
			tstring4[0] = tstring5[4];
			tstring4[1] = tstring5[5];
			tstring4[2] = '/';
			tstring4[3] = tstring5[6];
			tstring4[4] = tstring5[7];
			tstring4[5] = '/';
			tstring4[6] = tstring5[0];
			tstring4[7] = tstring5[1];
			tstring4[8] = tstring5[2];
			tstring4[9] = tstring5[3];
			tstring4[10] = 0;
			line[3] = tstring4;
			gtk_clist_append (GTK_CLIST (chartlist), line);
			fclose(infile);
		}
   	}
	gtk_clist_thaw (GTK_CLIST (chartlist));
}
/**********************************************************************************
saves current config file settings
**********************************************************************************/
void save_config()
{
	FILE *outfile;
	extern char *config_file;
	extern struct record3 config;
	extern int config_size;
	
	
	outfile = fopen(config_file, "wb");
	fwrite(&config, config_size, 1, outfile);
	fclose(outfile);
}
/**********************************************************************************
converts an RGB int value to string color name
***********************************************************************************/
void get_color2(int red, int green, int blue)
{
	extern char global_string[GS_LENGTH];
	
	if ((red == 0) && (green == 0) && (blue == 0))
	{
		strcpy(global_string, "black");
		return;
	}
	if ((red == 255) && (green == 255) && (blue == 255))
	{
		strcpy(global_string, "white");
		return;
	}
	if ((red == 255) && (green == 0) && (blue == 0))
	{
		strcpy(global_string, "red");
		return;
	}
	if ((red == 0) && (green == 255) && (blue == 0))
	{
		strcpy(global_string, "green");
		return;
	}
	if ((red == 0) && (green == 0) && (blue == 255))
	{
		strcpy(global_string, "blue");
		return;
	}
	if ((red == 127) && (green == 127) && (blue == 127))
	{
		strcpy(global_string, "gray");
		return;
	}
	if ((red == 160) && (green == 32) && (blue == 240))
	{
		strcpy(global_string, "purple");
		return;
	}
	if ((red == 255) && (green == 0) && (blue == 255))
	{
		strcpy(global_string, "magenta");
		return;
	}
	if ((red == 255) && (green == 192) && (blue == 203))
	{
		strcpy(global_string, "pink");
		return;
	}
	if ((red == 255) && (green == 165) && (blue == 0))
	{
		strcpy(global_string, "orange");
		return;
	}
	if ((red == 255) && (green == 255) && (blue == 0))
	{
		strcpy(global_string, "yellow");
		return;
	}
	if ((red == 0) && (green == 255) && (blue == 255))
	{
		strcpy(global_string, "cyan");
		return;
	}
	if ((red == 0) && (green == 0) && (blue == 100))
	{
		strcpy(global_string, "dark blue");
		return;
	}
	if ((red == 144) && (green == 238) && (blue == 144))
	{
		strcpy(global_string, "light green");
		return;
	}
	if ((red == 0) && (green == 139) && (blue == 139))
	{
		strcpy(global_string, "dark cyan");
		return;
	}
	if ((red == 169) && (green == 169) && (blue == 169))
	{
		strcpy(global_string, "dark gray");
		return;
	}
	if ((red == 227) && (green == 227) && (blue == 227))
	{
		strcpy(global_string, "light gray");
		return;
	}
	if ((red == 173) && (green == 216) && (blue == 230))
	{
		strcpy(global_string, "light blue");
		return;
	}
	if ((red == 0) && (green == 100) && (blue == 0))
	{
		strcpy(global_string, "dark green");
		return;
	}
	if ((red == 255) && (green == 215) && (blue == 0))
	{
		strcpy(global_string, "gold");
		return;
	}
	if ((red == 165) && (green == 42) && (blue == 42))
	{
		strcpy(global_string, "brown");
		return;
	}
	if ((red == 230) && (green == 230) && (blue == 250))
	{
		strcpy(global_string, "lavender");
		return;
	}
	if ((red == 64) && (green == 224) && (blue == 208))
	{
		strcpy(global_string, "turquoise");
		return;
	}
	if ((red == 245) && (green == 222) && (blue == 179))
	{
		strcpy(global_string, "wheat");
		return;
	}
	if ((red == 250) && (green == 128) && (blue == 114))
		strcpy(global_string, "salmon");
}
/**********************************************************************************/
void set_color(int tint)
{
	extern int global_int, global_int2, global_int3;
	
	switch(tint)
	{
		case 0: global_int = 0;
			global_int2 = 0;
			global_int3 = 255;
			break;
		case 1: global_int = 0;
			global_int2 = 0;
			global_int3 = 100;
			break;
		case 2: global_int = 173;
			global_int2 = 216;
			global_int3 = 230;
			break;
		case 3: global_int = 165;
			global_int2 = 42;
			global_int3 = 42;
			break;
		case 4: global_int = 0;
			global_int2 = 139;
			global_int3 = 139;
			break;
		case 5: global_int = 0;
			global_int2 = 255;
			global_int3 = 255;
			break;
		case 6: global_int = 255;
			global_int2 = 215;
			global_int3 = 0;
			break;
		case 7: global_int = 169;
			global_int2 = 169;
			global_int3 = 169;
			break;
		case 8: global_int = 127;
			global_int2 = 127;
			global_int3 = 127;
			break;
		case 9: global_int = 0;
			global_int2 = 100;
			global_int3 = 0;
			break;
		case 10: global_int = 144;
			global_int2 = 238;
			global_int3 = 144;
			break;
		case 11: global_int = 0;
			global_int2 = 255;
			global_int3 = 0;
			break;
		case 12: global_int = 230;
			global_int2 = 230;
			global_int3 = 250;
			break;
		case 13: global_int = 255;
			global_int2 = 0;
			global_int3 = 255;
			break;
		case 14: global_int = 255;
			global_int2 = 165;
			global_int3 = 0;
			break;
		case 15: global_int = 255;
			global_int2 = 192;
			global_int3 = 203;
			break;
		case 16: global_int = 160;
			global_int2 = 32;
			global_int3 = 240;
			break;
		case 17: global_int = 255;
			global_int2 = 0;
			global_int3 = 0;
			break;
		case 18: global_int = 250;
			global_int2 = 128;
			global_int3 = 114;
			break;
		case 19: global_int = 64;
			global_int2 = 224;
			global_int3 = 208;
			break;
		case 20: global_int = 245;
			global_int2 = 222;
			global_int3 = 179;
			break;
		case 21: global_int = 255;
			global_int2 = 255;
			global_int3 = 255;
			break;
		case 22: global_int = 255;
			global_int2 = 255;
			global_int3 = 0;
			break;
		case 23: global_int = 0;
			global_int2 = 0;
			global_int3 = 0;
			break;
		case 24: global_int = 227;
			global_int2 = 227;
			global_int3 = 227;
			break;
		default: break;
	}
}
/*********************************************************************************/
void set_color2(int red, int green, int blue)
{
	extern GtkWidget *color_clist;
	
	
	if ((red == 255) && (green == 255) && (blue == 255))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 21, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 21, 0, 0.5, 0);
		return;
	}
	if ((red == 0) && (green == 0) && (blue == 0))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 23, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 23, 0, 0.5, 0);
		return;
	}
	if ((red == 227) && (green == 227) && (blue == 227))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 24, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 24, 0, 0.5, 0);
		return;
	}
	if ((red == 255) && (green == 0) && (blue == 0))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 17, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 17, 0, 0.5, 0);
		return;
	}
	if ((red == 0) && (green == 255) && (blue == 0))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 11, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 11, 0, 0.5, 0);
		return;
	}
	if ((red == 0) && (green == 0) && (blue == 255))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 0, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 0, 0, 0.5, 0);
		return;
	}
	if ((red == 127) && (green == 127) && (blue == 127))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 8, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 8, 0, 0.5, 0);
		return;
	}
	if ((red == 160) && (green == 32) && (blue == 240))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 16, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 16, 0, 0.5, 0);
		return;
	}
	if ((red == 255) && (green == 0) && (blue == 255))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 13, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 13, 0, 0.5, 0);
		return;
	}
	if ((red == 255) && (green == 192) && (blue == 203))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 15, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 15, 0, 0.5, 0);
		return;
	}
	if ((red == 255) && (green == 165) && (blue == 0))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 14, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 14, 0, 0.5, 0);
		return;
	}
	if ((red == 255) && (green == 255) && (blue == 0))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 22, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 22, 0, 0.5, 0);
		return;
	}
	if ((red == 0) && (green == 255) && (blue == 255))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 5, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 5, 0, 0.5, 0);
		return;
	}
	if ((red == 0) && (green == 0) && (blue == 100))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 1, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 1, 0, 0.5, 0);
		return;
	}
	if ((red == 144) && (green == 238) && (blue == 144))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 10, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 10, 0, 0.5, 0);
		return;
	}
	if ((red == 0) && (green == 139) && (blue == 139))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 4, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 4, 0, 0.5, 0);
		return;
	}
	if ((red == 169) && (green == 169) && (blue == 169))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 7, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 7, 0, 0.5, 0);
		return;
	}
	if ((red == 173) && (green == 216) && (blue == 230))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 2, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 2, 0, 0.5, 0);
		return;
	}
	if ((red == 0) && (green == 100) && (blue == 0))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 9, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 9, 0, 0.5, 0);
		return;
	}
	if ((red == 255) && (green == 215) && (blue == 0))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 6, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 6, 0, 0.5, 0);
		return;
	}
	if ((red == 165) && (green == 42) && (blue == 42))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 3, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 3, 0, 0.5, 0);
		return;
	}
	if ((red == 230) && (green == 230) && (blue == 250))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 12, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 12, 0, 0.5, 0);
		return;
	}
	if ((red == 64) && (green == 224) && (blue == 208))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 19, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 19, 0, 0.5, 0);
		return;
	}
	if ((red == 245) && (green == 222) && (blue == 179))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 20, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 20, 0, 0.5, 0);
		return;
	}
	if ((red == 250) && (green == 128) && (blue == 114))
	{
		gtk_clist_select_row(GTK_CLIST(color_clist), 18, 0);
		gtk_clist_moveto(GTK_CLIST(color_clist), 18, 0, 0.5, 0);
	}
}
/**********************************************************************************
gets the color associated with an object defined in the combo box
***********************************************************************************/
void get_object_color()
{
	char tstring[25], *tstringpointer;
	extern GtkWidget *object_combo;
	extern struct record3 config;

	
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(object_combo)->entry));
	strcpy(tstring, tstringpointer);
	if (! strcmp(tstring, "Background"))
	{
		set_color2(config.background_red,config.background_green,config.background_blue);
		return;
	}
	if (! strcmp(tstring, "Borders"))
	{
		set_color2(config.border_red, config.border_green, config.border_blue);
		return;
	}
	if (! strcmp(tstring, "Grid"))
	{
		set_color2(config.grid_red, config.grid_green, config.grid_blue);
		return;
	}
	if (! strcmp(tstring, "Price"))
	{
		set_color2(config.price_red, config.price_green, config.price_blue);
		return;
	}
	if (! strcmp(tstring, "Volume"))
	{
		set_color2(config.volume_red, config.volume_green, config.volume_blue);
		return;
	}
	if (! strcmp(tstring, "MA 1"))
	{
		set_color2(config.moving_red, config.moving_green, config.moving_blue);
		return;
	}
	if (! strcmp(tstring, "MA 2"))
	{
		set_color2(config.moving2_red, config.moving2_green, config.moving2_blue);
		return;
	}
	if (! strcmp(tstring, "MA 3"))
		set_color2(config.moving3_red, config.moving3_green, config.moving3_blue);
}
/**********************************************************************************
sets the color for an object defined in the combo box
**********************************************************************************/
void set_object_color()
{
	int tint = 0;
    	GList *list;
	char *tstringpointer, tstring[25];
	extern GtkWidget *object_combo, *color_clist;
	extern struct record3 config;
	extern int global_int, global_int2, global_int3;
	
	
	list = GTK_CLIST (color_clist)->selection;
	tint = (int) list->data;
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(object_combo)->entry));
	strcpy(tstring, tstringpointer);
	if (! strcmp(tstring, "Background"))
	{
		set_color(tint);
		config.background_red = global_int;
		config.background_green = global_int2;
		config.background_blue = global_int3;
		return;
	}
	if (! strcmp(tstring, "Borders"))
	{
		set_color(tint);
		config.border_red = global_int;
		config.border_green = global_int2;
		config.border_blue = global_int3;
		return;
	}
	if (! strcmp(tstring, "Grid"))
	{
		set_color(tint);
		config.grid_red = global_int;
		config.grid_green = global_int2;
		config.grid_blue = global_int3;
		return;
	}
	if (! strcmp(tstring, "Price"))
	{
		set_color(tint);
		config.price_red = global_int;
		config.price_green = global_int2;
		config.price_blue = global_int3;
		return;
	}
	if (! strcmp(tstring, "Volume"))
	{
		set_color(tint);
		config.volume_red = global_int;
		config.volume_green = global_int2;
		config.volume_blue = global_int3;
		return;
	}
	if (! strcmp(tstring, "MA 1"))
	{
		set_color(tint);
		config.moving_red = global_int;
		config.moving_green = global_int2;
		config.moving_blue = global_int3;
		return;
	}
	if (! strcmp(tstring, "MA 2"))
	{
		set_color(tint);
		config.moving2_red = global_int;
		config.moving2_green = global_int2;
		config.moving2_blue = global_int3;
		return;
	}
	if (! strcmp(tstring, "MA 3"))
	{
		set_color(tint);
		config.moving3_red = global_int;
		config.moving3_green = global_int2;
		config.moving3_blue = global_int3;
	}
}
/*********************************************************************************
whenever a new chart is loaded this function updates the stats bar
*******************************************************************************/
void update_stats_bar()
{
	char tstring[250], tstring2[25], tstring3[25];
	float tfloat, tfloat2;
	extern GtkWidget *info_frame;
	extern float maxhigh, maxlow;
	extern struct record1 *data;
	extern struct record3 config;
	extern int chartflag;
	extern unsigned int records;
	extern struct record1 *data;
	
	
	if (! chartflag)
		return;
		
	tstring[0] = 0;
	if (config.contract_high_flag)
	{
		strcpy(tstring, "CH=");
		sprintf(tstring2, "%g", maxhigh);
		strcat(tstring, tstring2);
	}
 	if (config.contract_low_flag)
       	{
       		strcat(tstring, " CL=");
       		sprintf(tstring2, "%g", maxlow);
       		strcat(tstring, tstring2);
       	}
       	if (config.last_date_flag)
       	{
       		strcat(tstring, " LD=");
		sprintf(tstring2, "%ld", data[records - 1].date);
		tstring3[0] = tstring2[4];
        	tstring3[1] = tstring2[5];
        	tstring3[2] = '/';
        	tstring3[3] = tstring2[6];
        	tstring3[4] = tstring2[7];
        	tstring3[5] = '/';
        	tstring3[6] = tstring2[0];
        	tstring3[7] = tstring2[1];
        	tstring3[8] = tstring2[2];
        	tstring3[9] = tstring2[3];
        	tstring3[10] = 0;
        	strcat(tstring, tstring3);
        }
        if (config.last_close_flag)
        {
       		strcat(tstring, " LC=");
       		sprintf(tstring2, "%g", data[records - 1].close);
       		strcat(tstring, tstring2);
       	}
       	if (config.net_change_flag)
       	{
       		strcat(tstring, " NC= ");
       		tfloat = data[records - 1].close;
       		tfloat2 = data[records - 2].close;
       		sprintf(tstring2, "%g", tfloat - tfloat2);
       		strcat(tstring, tstring2);
       	}
       	gtk_statusbar_pop(GTK_STATUSBAR(info_frame), 1);
       	gtk_statusbar_push(GTK_STATUSBAR(info_frame), 1, tstring);
}       
/****************************************************************************************
displays message using string error_message
***************************************************************************************/
void display_message()
{
	GtkWidget *hbox, *vbox, *hbox2, *label, *button, *hsep;
	extern GtkWidget *message_window;
	extern char *error_message;
	
	
	if (message_window)
		return;
		
	message_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (message_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &message_window);
	gtk_window_position(GTK_WINDOW (message_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (message_window), " ");
	gtk_widget_set_usize(GTK_WIDGET (message_window), 0, 0);
	
	
	vbox = gtk_vbox_new (FALSE, 10);
	gtk_container_add (GTK_CONTAINER (message_window), vbox);
      	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_widget_show (vbox);
      	
      	hbox2 = gtk_hbox_new (FALSE, 0);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, TRUE, 0);
      	gtk_container_border_width (GTK_CONTAINER (hbox2), 10);
      	gtk_widget_show (hbox2);
      	
	label = gtk_label_new(error_message);
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, TRUE, 0);
        gtk_widget_show(label);
        
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox = gtk_hbutton_box_new();
        gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
      	gtk_widget_show(hbox);
        
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(message_window));
      	gtk_widget_show (button);
      	
      	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default (button);
      	gtk_widget_show(message_window);
}
/*******************************************************************************
this is the gstalker about box
*******************************************************************************/
void about()
{
	GtkWidget *window, *hbox, *vbox, *vbox2, *label, *label2, *label3, *button, *hsep;
	
	
	window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &window);
	gtk_window_position(GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (window), "About");
	gtk_widget_set_usize(GTK_WIDGET (window), 300, 0);
	
	
	vbox = gtk_vbox_new (FALSE, 10);
	gtk_container_add (GTK_CONTAINER (window), vbox);
      	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_widget_show (vbox);
      	
      	vbox2 = gtk_vbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
      	gtk_widget_show (vbox2);
      	
	label = gtk_label_new("gstalker  1.1");
	gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        gtk_widget_show(label);
        
        label2 = gtk_label_new("Copyright (c) 1998 Stefan S. Stratigakos");
	gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, TRUE, 0);
        gtk_widget_show(label2);
        
        label3 = gtk_label_new("Mail: sstratos@pathcom.com");
	gtk_box_pack_start (GTK_BOX (vbox2), label3, FALSE, TRUE, 0);
        gtk_widget_show(label3);
        
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, TRUE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox = gtk_hbutton_box_new();
        gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
      	gtk_widget_show(hbox);
        
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(window));
      	gtk_widget_show (button);
      	
      	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default (button);
      	gtk_widget_show(window);
}
/**********************************************************************************
creates and displays the stats bar
***********************************************************************************/
void show_info_bar()
{
	extern GtkWidget *info_frame, *info_bar;

	
	info_frame = gtk_statusbar_new ();
      	gtk_box_pack_start (GTK_BOX (info_bar), info_frame, TRUE, TRUE, 2);
      	gtk_widget_show (info_frame);
      	update_stats_bar();
}
/*********************************************************************************
destroys the stats bar
***********************************************************************************/
void hide_info_bar()
{
	extern GtkWidget *info_frame;
	
	if (info_frame)
		gtk_widget_destroy(info_frame);
}
/**********************************************************************************
creates and displays the data bar
***********************************************************************************/
void show_data_bar()
{
	extern GtkWidget *data_frame, *data_bar;
	
	data_frame = gtk_statusbar_new ();
      	gtk_box_pack_start (GTK_BOX (data_bar), data_frame, TRUE, TRUE, 2);
      	gtk_widget_show (data_frame);
}
/*********************************************************************************
destroys the data bar
***********************************************************************************/
void hide_data_bar()
{
	extern GtkWidget *data_frame;
	
	if (data_frame)
		gtk_widget_destroy(data_frame);
}
/*********************************************************************************
creates the config file
**********************************************************************************/
void create_config()
{
	FILE *outfile;
	extern int config_size;
	extern char *config_file;
	extern struct record3 config;
	
	
	outfile = fopen(config_file, "wb");
	if (! outfile)
	{
		printf("Can't create config_file in ~/gstalker ! Aborting program!");
		gtk_main_quit();
	}
	config.last_group[0] = 0;
	strcpy(config.pixmap_path, "/usr/share/gstalker");
	config.bars = 0;
	config.top_enable_flag = 1;
	config.bottom_enable_flag = 1;
	config.contract_high_flag = 1;
	config.contract_low_flag = 1;
	config.last_date_flag = 1;
	config.last_close_flag = 1;
	config.net_change_flag = 1;
	config.date_flag = 1;
	config.open_flag = 1;
	config.high_flag = 1;
	config.low_flag = 1;
	config.close_flag = 1;
	config.volume_flag = 1;
	config.openi_flag = 1;
	config.volume = 0;
	config.grid = 0;
	config.grid_red = 0;
	config.grid_green = 0;
	config.grid_blue = 100;
	config.price_red = 0;
	config.price_green = 255;
	config.price_blue = 0;
	config.volume_red = 255;
	config.volume_green = 255;
	config.volume_blue = 255;
	config.version = GS_VERSION;
	config.moving_red = 255;
	config.moving_green = 0;
	config.moving_blue = 0;
	config.moving2_red = 255;
	config.moving2_green = 0;
	config.moving2_blue = 0;
	config.moving3_red = 255;
	config.moving3_green = 0;
	config.moving3_blue = 0;
	config.background_red = 0;
	config.background_green = 0;
	config.background_blue = 0;
	config.border_red = 255;
	config.border_green = 255;
	config.border_blue = 255;
	config.global_indicators = 0;
	config.global_moving_status = 0;
	config.global_moving_type = 1;
	config.global_moving_length = 10;
	config.global_moving2_status = 0;
	config.global_moving2_type = 1;
	config.global_moving2_length = 10;
	config.global_moving3_status = 0;
	config.global_moving3_type = 1;
	config.global_moving3_length = 10;
	config.global_volume_status = 0;
	config.global_alerts = 0;
	config.global_alerts_moving_status = 0;
	config.global_alerts_moving2_status = 0;
	config.global_alerts_moving3_status = 0;
	config.global_alerts_closeroc_status = 0;
	config.global_alerts_threshold_status = 0;
	config.global_alerts_volumeroc_status = 0;
	config.global_threshold = 0.0;
	config.global_closeroc = 0.0;
	config.global_volumeroc = 0.0;
	config.style = 0;
	config.import_field = 0;
	config.import_date = 0;
	config.proxy[0] = 0;
	config.port = 8080;
	config.source[0] = 0;
	fwrite(&config, config_size, 1, outfile);
	fclose(outfile);
}
/***********************************************************************************
shuts down gstalker
************************************************************************************/
void exit_program()
{
	save_config();
	save_chart_header();
	gtk_main_quit();
}
/*************************************************************************************
reads config into memory
**************************************************************************************/
void read_config()
{
	FILE *infile;
	extern char *config_file;
	extern struct record3 config;
	extern int config_size;
	
	
	infile = fopen(config_file, "rb");
	if (! infile)
	{
		create_config();
		infile = fopen(config_file, "rb");
	}
	fread(&config, config_size, 1, infile);
	fclose(infile);
}
/***********************************************************************************
turns on or off volume indiactor
*************************************************************************************/
void toggle_volume()
{
	extern int chartflag;
	extern struct record3 config;
	extern GtkWidget *volume_button;

	
	if (chartflag)
	{
		if (config.volume)
		{
			config.volume--;
			show_indicators();
		}
		else
		{
			config.volume++;
			show_indicators();
		}
		draw();
	}
	else
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(volume_button), 0);
}
/************************************************************************************
turns on or off grid lines
*************************************************************************************/
void toggle_grid()
{
	extern int chartflag;
	extern struct record3 config;
	extern GtkWidget *grid_button;
	
	
	if (chartflag)
	{
		if (config.grid)
			config.grid--;
		else
			config.grid++;
		draw_price();
	}
	else
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(grid_button), 0);
}
/***************************************************************************************/
void destroy_data_window()
{
	extern GtkWidget *data_window, *data_button;
	extern int data_window_flag;
	
	gtk_widget_destroy(data_window);
	data_window_flag = 0;
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(data_button), 0);
}
/*****************************************************************************************/
void update_data_window()
{
	char tstring[250], tstring2[25], tstring3[25], tstring4[25], tstring5[25], tstring6[25];
    	char tstring7[25], tstring8[25], tstring9[25], tstring10[25], tstring11[25];
    	char *tstringpointer, *line[11], tstring12[15];
    	float tfloat = 0.0, yesterday = 0.0, yesterday2 = 0.0, yesterday3 = 0.0;
    	unsigned int tuint;
    	extern GtkWidget *data_window, *data_window_clist;
    	extern int open_file_flag;
    	extern unsigned int records;
    	extern char *groupfilename;
    	extern struct record1 *data;
    	extern struct record2 header;
    	extern struct record3 config;
	
	gtk_clist_freeze(GTK_CLIST(data_window_clist));
	gtk_clist_clear(GTK_CLIST(data_window_clist));
	if (config.global_indicators)
      	{
      		yesterday = data[config.global_moving_length - 2].close;
      		yesterday2 = data[config.global_moving2_length - 2].close;
      		yesterday3 = data[config.global_moving3_length - 2].close;
      	}
      	else
      	{
      		yesterday = data[header.moving[2] - 2].close;
      		yesterday2 = data[header.moving2[2] - 2].close;
      		yesterday3 = data[header.moving3[2] - 2].close;
      	}
       	for (tuint = 0; tuint < records; tuint++)
        {
        	sprintf(tstring12, "%d", tuint + 1);
        	line[0] = tstring12;
        	sprintf(tstring, "%ld", data[tuint].date);
         	tstring2[0] = tstring[4];
           	tstring2[1] = tstring[5];
           	tstring2[2] = '/';
           	tstring2[3] = tstring[6];
           	tstring2[4] = tstring[7];
           	tstring2[5] = '/';
           	tstring2[6] = tstring[0];
           	tstring2[7] = tstring[1];
           	tstring2[8] = tstring[2];
           	tstring2[9] = tstring[3];
           	tstring2[10] = 0;
           	line[1] = tstring2;
        	sprintf(tstring3, "%g", data[tuint].open);
        	line[2] = tstring3;
        	sprintf(tstring4, "%g", data[tuint].high);
        	line[3] = tstring4;
        	sprintf(tstring5, "%g", data[tuint].low);
        	line[4] = tstring5;
        	sprintf(tstring6, "%g", data[tuint].close);
        	line[5] = tstring6;
        	sprintf(tstring7, "%ld", data[tuint].volume);
        	line[6] = tstring7;
        	sprintf(tstring8, "%ld", data[tuint].openint);
        	line[7] = tstring8;
        	line[8] = 0;
        	line[9] = 0;
        	line[10] = 0;
        	if (config.global_indicators)
        	{
        		if (config.global_moving_status)
        		{
        			if (tuint >= config.global_moving_length)
       	  			{
       	   			   	switch(config.global_moving_type)
       	   			   	{
       	   					case 1: tfloat = get_simple_movavg(config.global_moving_length, tuint);
       	   						break;
       	   					case 2: tfloat = get_weighted_movavg(config.global_moving_length, tuint);
       	   						break;
       	   					case 3: tfloat = get_exponential_movavg(config.global_moving_length, tuint);
       	   						break;
       	   					default: break;
       	   			   	}
   				   	sprintf(tstring9, "%g", tfloat);
   				   	yesterday = tfloat;
   				   	line[8] = tstring9;
   				}
   			}
   			if (config.global_moving2_status)
        		{
        			if (tuint >= config.global_moving2_length)
       	   			{
       	   		 		switch(config.global_moving2_type)
       	   			 	{
       	   					case 1: tfloat = get_simple_movavg(config.global_moving2_length, tuint);
       	   						break;
       	   					case 2: tfloat = get_weighted_movavg(config.global_moving2_length, tuint);
       	   						break;
       	   					case 3: tfloat = get_exponential_movavg(config.global_moving2_length, tuint);
       	   						break;
       	   					default: break;
       	   			  	}
   				   	sprintf(tstring10, "%g", tfloat);
   				   	yesterday2 = tfloat;
   				   	line[9] = tstring10;
   				}
   			}
   			if (config.global_moving3_status)
        		{
        			if (tuint >= config.global_moving3_length)
       	   			{
       	   				switch(config.global_moving3_type)
       	   				{
       	   					case 1: tfloat = get_simple_movavg(config.global_moving3_length, tuint);
       	   						break;
       	   					case 2: tfloat = get_weighted_movavg(config.global_moving3_length, tuint);
       	   						break;
       	   					case 3: tfloat = get_exponential_movavg(config.global_moving3_length, tuint);
       	   						break;
       	   					default: break;
       	   			 	}
   				   	sprintf(tstring11, "%g", tfloat);
   				   	yesterday3 = tfloat;
   				   	line[10] = tstring11;
   				}
   			}
        	}
        	else
        	{
        		if (header.moving[0])
        		{
        			if (tuint >= header.moving[2])
       	  			{
       	   				switch(header.moving[1])
       	   				{
       	   					case 1: tfloat=get_simple_movavg(header.moving[2],tuint);
       	   						break;
       	   					case 2: tfloat = get_weighted_movavg(header.moving[2], tuint);
       	   						break;
       	   					case 3: tfloat = get_exponential_movavg(header.moving[2], tuint);
       	   						break;
       	   					default: break;
       	   				}
   					sprintf(tstring9, "%g", tfloat);
   					yesterday = tfloat;
   					line[8] = tstring9;
   				}
   			}
   			if (header.moving2[0])
   			{
   				if (tuint >= header.moving2[2])
       	   			{
       	   				switch(header.moving2[1])
       	   				{
       	   					case 1: tfloat=get_simple_movavg(header.moving2[2],tuint);
       	   						break;
       	   					case 2: tfloat = get_weighted_movavg(header.moving2[2], tuint);
       	   						break;
       	   					case 3: tfloat = get_exponential_movavg(header.moving2[2], tuint);
       	   						break;
       	   					default: break;
       	   				}
   					sprintf(tstring10, "%g", tfloat);
   					yesterday2 = tfloat;
   					line[9] = tstring10;
   				}
   			}
   			if (header.moving3[0])
   			{
   				if (tuint >= header.moving3[2])
       	   			{
       	   				switch(header.moving3[1])
       	   				{
       	   					case 1: tfloat=get_simple_movavg(header.moving3[2],tuint);
       	   						break;
       	   					case 2: tfloat = get_weighted_movavg(header.moving3[2], tuint);
       	   						break;
       	   					case 3: tfloat = get_exponential_movavg(header.moving3[2], tuint);
       	   						break;
       	   					default: break;
       	   				}
   					sprintf(tstring11, "%g", tfloat);
   					yesterday3 = tfloat;
   					line[10] = tstring11;
   				}
   			}
   		}
        	gtk_clist_append (GTK_CLIST (data_window_clist), line);
        }
        gtk_clist_thaw(GTK_CLIST(data_window_clist));
        if (open_file_flag == 1)
	{
		strcpy(tstring, "Data Window: ");
		strcat(tstring, header.name);
		strcat(tstring, " (");
		strcat(tstring, header.symbol);
		strcat(tstring, ")");
	}
	else
	{
		strcpy(tstring, "Data Window: [");
		tstringpointer = strrchr(groupfilename, '/');
		strcat(tstring, tstringpointer + 1);
		strcat(tstring, "] - ");
		strcat(tstring, header.name);
		strcat(tstring, " (");
		strcat(tstring, header.symbol);
		strcat(tstring, ")");
	}
	gtk_window_set_title (GTK_WINDOW (data_window), tstring);
}
/*****************************************************************************************
creates or updates the data window
******************************************************************************************/
void show_data_window()
{
    	int tint;
    	char *format[] = {"Record", "Date", "Open", "High", "Low", "Close", "Volume", "Open Int", "MA 1", "MA 2", "MA 3"};
    	GtkWidget *vbox = NULL;
    	extern GtkWidget *data_window, *data_window_clist, *data_button;
    	extern int chartflag, data_window_flag;

    
	
    	if (! chartflag)
    	{
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(data_button), 0);
    		return;
    	}
   	if (! GTK_TOGGLE_BUTTON(data_button)->active)
    	{
    		if (data_window_flag)
    		{
    			destroy_data_window();
    			return;
    		}
    		else
    			return;
    	}
    	else
    	{
    		if (data_window_flag)
    			update_data_window();
        	else
        	{
        		data_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
			gtk_signal_connect (GTK_OBJECT (data_window), "destroy",
			    	    GTK_SIGNAL_FUNC (destroy_data_window), NULL);
        		gtk_container_border_width (GTK_CONTAINER (data_window), 10);
        		gtk_window_position(GTK_WINDOW (data_window), GTK_WIN_POS_CENTER);
			gtk_widget_set_usize(GTK_WIDGET (data_window), 585, 300);

			vbox = gtk_vbox_new (FALSE, 0);
        		gtk_container_add (GTK_CONTAINER (data_window), vbox);
        		gtk_widget_show (vbox);
	
			data_window_clist = gtk_clist_new_with_titles (11, format);
			gtk_clist_set_column_width(GTK_CLIST(data_window_clist), 0, 40);
			for (tint = 1; tint < 11; tint++)
				gtk_clist_set_column_width(GTK_CLIST(data_window_clist),tint,70);
        		gtk_clist_set_selection_mode(GTK_CLIST (data_window_clist), GTK_SELECTION_BROWSE);
        		gtk_clist_set_policy (GTK_CLIST (data_window_clist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
        		gtk_box_pack_start (GTK_BOX (vbox), data_window_clist, TRUE, TRUE, 0);
        		gtk_widget_show(data_window_clist);
        		
        		update_data_window();
        		
        		gtk_widget_show(data_window);
        		data_window_flag = 1;
		}
      	}
}
/***************************************************************************************
flips the current chart style
***************************************************************************************/
void style_button_pressed()
{
	extern int chartflag;
	extern struct record3 config;
	extern struct record2 header;
	extern GtkWidget *style_button;
	
	
	if (! chartflag)
		return;
		
	if (! GTK_TOGGLE_BUTTON(style_button)->active)
		config.style = 0;
	else
	{
		if (header.pixelspace < 6)
		{
			header.pixelspace = 6;
			show_indicators();
		}
		config.style = 1;
	}
	draw();
}
/***********************************************************************************
expands the chart spacing by 1 pixel
************************************************************************************/
void expand_chart()
{
	extern int chartflag;
	extern struct record2 header;
	
	
        if (chartflag)
        {
        	header.pixelspace++;
        	show_indicators();
		draw();
	}
}
/***********************************************************************************
shrinks the chart spacing by 1 pixel
*************************************************************************************/
void shrink_chart()
{
	extern int chartflag;
	extern struct record2 header;
	extern GtkWidget *style_button;
	
	  	
  	if (! chartflag) 
  		return;
  	if (! GTK_TOGGLE_BUTTON(style_button)->active)
        {
               	if (header.pixelspace > 1)
               	{
                       	header.pixelspace--;
                       	show_indicators();
			draw();
		}
	}
	else
	{
		if (header.pixelspace > 6)
               	{
                       	header.pixelspace--;
                       	show_indicators();
			draw();
		}
	}
}
/***********************************************************************************
advances to the next chart in the current group
************************************************************************************/
void next_chart()
{
	char tstring[5];
	extern int open_file_flag, chartflag, group_pointer, group_size;
	
	
	if (open_file_flag)
		return;
        if (! chartflag)
        	return;
        group_pointer++;
	if (group_pointer > group_size)
	{
		group_pointer = 0;
  		load_file(tstring);
	}
	else
		load_file(tstring);
}
/***********************************************************************************
reverses to the previous chart in the current group
*************************************************************************************/
void previous_chart()
{
	char tstring[5];
	extern int open_file_flag, chartflag, group_pointer, group_size;
	
	
	if (open_file_flag)
		return;
       	if (! chartflag)
       		return;
       	group_pointer--;
	if (group_pointer < 0)
	{
		group_pointer = group_size;
		load_file(tstring);
	}
	else
		load_file(tstring);
}
/*************************************************************************************
called if this is the first time gstalker is run
*************************************************************************************/
void new_init()
{
	char tstring[250], tstring2[250], *gs_home, *gs_dir;
	GtkWidget *hbox, *vbox, *vbox2, *label, *label2, *button, *hsep;
	extern char *grouppath, *datapath, *errorlog, *config_file;
	extern GtkWidget *init_window;
	
	
	
	init_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (init_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &init_window);
	gtk_window_position(GTK_WINDOW (init_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (init_window), "Create Directories");
	gtk_widget_set_usize(GTK_WIDGET (init_window), 0, 0);
	
	
	vbox = gtk_vbox_new (FALSE, 10);
	gtk_container_add (GTK_CONTAINER (init_window), vbox);
      	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_widget_show (vbox);
      	
      	vbox2 = gtk_vbox_new (FALSE, 0);
      	gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
      	gtk_widget_show (vbox2);
      	
	label = gtk_label_new("Creating my data directories in your home directory.");
	gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        gtk_widget_show(label);
        
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox = gtk_hbutton_box_new();
        gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
      	gtk_widget_show(hbox);
        
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(init_window));
      	gtk_widget_show (button);
      	
      	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default (button);
      	
      	gs_home = getenv ("HOME");
        if (gs_home != NULL)
           strcpy (tstring2, gs_home);
        else
           strcpy (tstring2, "/tmp");

        gs_dir = getenv ("GSTALKER_DIR");
        if (gs_dir != NULL)
           strcat (tstring2, gs_dir);
        else
           strcat(tstring2, "/gstalker");
           
        label2 = gtk_label_new(gs_home);
	gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, TRUE, 0);
        gtk_widget_show(label2);
        
        gtk_widget_show(init_window);
      	
      	strcpy(tstring, tstring2);
	strcat(tstring, "/groups/");
	grouppath = (char *)malloc(sizeof(tstring) + 1);
	strcpy(grouppath, tstring);
	strcpy(tstring, tstring2);
	strcat(tstring, "/data/");
	datapath = (char *)malloc(sizeof(tstring) + 1);
	strcpy(datapath, tstring);
	strcpy(tstring, tstring2);
	strcat(tstring, "/error.log");
	errorlog = (char *)malloc(sizeof(tstring) + 1);
	strcpy(errorlog, tstring);
	strcpy(tstring, tstring2);
	strcat(tstring, "/.config");
	config_file = (char *)malloc(sizeof(tstring) + 1);
	strcpy(config_file, tstring);
	
	strcpy(tstring, tstring2);
	mkdir(tstring, 0777);
	strcpy(tstring, tstring2);
	strcat(tstring, "/groups");
	mkdir(tstring, 0777);
	strcpy(tstring, tstring2);
	strcat(tstring, "/data");
	mkdir(tstring, 0777);
	create_config();
}
/************************************************************************************
sets up environment for gstalker on startup
*************************************************************************************/
void init()
{
	int tint;
	FILE *infile;
	char tstring[250], tstring2[250], *gs_home, *gs_dir;
	extern char *grouppath, *datapath, *errorlog, *config_file;
	extern struct record3 config;
	
	
	gs_home = getenv ("HOME");
        if (gs_home != NULL)
           strcpy (tstring2, gs_home);
        else
           strcpy (tstring2, "/tmp");

        gs_dir = getenv ("GSTALKER_DIR");
        if (gs_dir != NULL)
           strcat (tstring2, gs_dir);
        else
           strcat(tstring2, "/gstalker");
           
      	strcpy(tstring, tstring2);
	strcat(tstring, "/groups/");
	grouppath = (char *)malloc(sizeof(tstring) + 1);
	strcpy(grouppath, tstring);
	strcpy(tstring, tstring2);
	strcat(tstring, "/data/");
	datapath = (char *)malloc(sizeof(tstring) + 1);
	strcpy(datapath, tstring);
	strcpy(tstring, tstring2);
	strcat(tstring, "/error.log");
	errorlog = (char *)malloc(sizeof(tstring) + 1);
	strcpy(errorlog, tstring);
	strcpy(tstring, tstring2);
	strcat(tstring, "/.config");
	config_file = (char *)malloc(sizeof(tstring) + 1);
	strcpy(config_file, tstring);
	
	strcpy(tstring, tstring2);
	strcat(tstring, "/groups");
	tint = chdir(tstring);
	if (tint)
	{
		strcpy(tstring, tstring2);
		strcat(tstring, "/groups");
		mkdir(tstring, 0777);
	}
	strcpy(tstring, tstring2);
	strcat(tstring, "/data");
	tint = chdir(tstring);
	if (tint)
	{
		strcpy(tstring, tstring2);
		strcat(tstring, "/data");
		mkdir(tstring, 0777);
	}
	infile = fopen(config_file, "rb");
	if (! infile)
	{
		create_config();
		read_config();
	}
	else
	{
		read_config();
		if (config.version < GS_VERSION)
		{
			unlink(config_file);
			create_config();
			read_config();
		}
	}
}
/****************************************************************************************
this catches the mouse pointer position over the chart and updates the data bar
*****************************************************************************************/
void motion_notify_event(GtkWidget *widget, GdkEventMotion *event)
{
	int x, y, tint, current_height, current_width;
	GdkModifierType state;
	char tstring[250], tstring2[25], tstring3[25];
	extern GtkWidget *data_frame, *chart;
	extern int chartflag;
	extern unsigned int records;
	extern float range, maxlow;
	extern struct record1 *data;
	extern struct record2 header;
	extern struct record3 config;
	
	
	if (! chartflag)
		return;
      	if (! config.bottom_enable_flag)
      		return;
	if (event->is_hint)
      		gdk_window_get_pointer(event->window, &x, &y, &state);
      	else
      	{
      		x = event->x;
      		y = event->y;
      		state = event->state;
      	}
      	current_height = chart->allocation.height;
      	current_width = chart->allocation.width;
      	tint = x / header.pixelspace;
        if (((tint) < records) && (x <= current_width) && (y <= current_height))
      	{
      		tstring[0] = 0;
      		if (config.date_flag)
      		{
       	 		sprintf(tstring2, "%ld", data[tint].date);
           		tstring3[0] = tstring2[4];
           		tstring3[1] = tstring2[5];
           		tstring3[2] = '/';
           		tstring3[3] = tstring2[6];
           		tstring3[4] = tstring2[7];
           		tstring3[5] = '/';
           		tstring3[6] = tstring2[0];
           		tstring3[7] = tstring2[1];
           		tstring3[8] = tstring2[2];
           		tstring3[9] = tstring2[3];
           		tstring3[10] = 0;
           		strcpy(tstring, "D=");
       	   		strcat(tstring, tstring3);
        	}
		if (config.open_flag)
       		{
       	   		strcat(tstring, " O=");
       	   		sprintf(tstring2, "%g", data[tint].open);
   			strcat(tstring, tstring2);
   		}
       		if (config.high_flag)
       		{
	   		strcat(tstring, " H=");
	   		sprintf(tstring2, "%g", data[tint].high);
       	   		strcat(tstring, tstring2);
       		}
       		if (config.low_flag)
       		{
       	   		strcat(tstring, " L=");
	   		sprintf(tstring2, "%g", data[tint].low);
       	   		strcat(tstring, tstring2);
       		}
       		if (config.close_flag)
       		{
       	   		strcat(tstring, " C=");
       	   		if (state & GDK_BUTTON1_MASK)
       	   		{
       	   			y = current_height - y;
       	   			sprintf(tstring2, "%g",((range / current_height) * y) + maxlow);
       	   		}
       	   		else
       	   			sprintf(tstring2, "%g", data[tint].close);
       	   			strcat(tstring, tstring2);
       	   		}
       	   	if (config.volume_flag)
       	   	{
  	   		strcat(tstring, " V=");
  	   		sprintf(tstring2, "%ld", data[tint].volume);
       	   		strcat(tstring, tstring2);
       	   	}
       	   	if (config.openi_flag)
       	   	{
       	   		strcat(tstring, " OI=");
   			sprintf(tstring2, "%ld", data[tint].openint);
   			strcat(tstring, tstring2);
   		}
   		gtk_statusbar_pop(GTK_STATUSBAR(data_frame), 1);
   		gtk_statusbar_push(GTK_STATUSBAR(data_frame), 1, tstring);
   	}
}
/***************************************************************************************
creates or erases the pixmap on which to draw the chart
****************************************************************************************/
void configure_event(GtkWidget *widget, GdkEventConfigure *event)
{
	GdkColor *color;
       	GdkGC *gc;
	extern GdkPixmap *pixmap;
	extern int chartflag;
	extern struct record3 config;
	
	
	gc = gdk_gc_new(widget->window);
       	color = (GdkColor *)malloc(sizeof(GdkColor));
       	color->red = config.background_red * (65535/255);
       	color->green = config.background_green * (65535/255);
       	color->blue = config.background_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(widget), color);
       	gdk_gc_set_foreground(gc, color);
	
	if (pixmap)
		gdk_pixmap_unref(pixmap);
	pixmap = gdk_pixmap_new (widget->window,
				 widget->allocation.width,
				 widget->allocation.height,
				 -1);
				 
	gdk_draw_rectangle (pixmap, gc, TRUE, 0, 0,
			    widget->allocation.width,
			    widget->allocation.height);
			    
	if (chartflag)
		draw_price();
}
/***************************************************************************************
creates or erases the scale pixmap on which to draw the price scale
****************************************************************************************/
void scale_configure_event(GtkWidget *widget, GdkEventConfigure *event)
{
	GdkColor *color;
       	GdkGC *gc;
	extern GdkPixmap *pixmap2;
	extern int chartflag;
	extern struct record3 config;
	
	
	gc = gdk_gc_new(widget->window);
       	color = (GdkColor *)malloc(sizeof(GdkColor));
       	color->red = config.background_red * (65535/255);
       	color->green = config.background_green * (65535/255);
       	color->blue = config.background_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(widget), color);
       	gdk_gc_set_foreground(gc, color);
	
	if (pixmap2)
		gdk_pixmap_unref(pixmap2);
	pixmap2 = gdk_pixmap_new(widget->window,
				 widget->allocation.width,
				 widget->allocation.height,
				 -1);
				 
	gdk_draw_rectangle (pixmap2, gc, TRUE, 0, 0,
			    widget->allocation.width,
			    widget->allocation.height);
			    
	if (chartflag)
		draw_scale();
}
/*************************************************************************************
this catches the X event to redraw the chart if it's covered by another window
**************************************************************************************/
void expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	extern GdkPixmap *pixmap;
	
	gdk_draw_pixmap (widget->window,
			 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
			 pixmap,
			 event->area.x, event->area.y,
			 event->area.x, event->area.y,
			 event->area.width, event->area.height);
}
/*************************************************************************************
this catches the X event to redraw the price scale if it's covered by another window
*************************************************************************************/
void scale_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	extern GdkPixmap *pixmap2;
	
	gdk_draw_pixmap (widget->window,
			 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
			 pixmap2,
			 event->area.x, event->area.y,
			 event->area.x, event->area.y,
			 event->area.width, event->area.height);
}
/****************************************************************************************
this catches the left mouse button press and updates the data window
*****************************************************************************************/
void button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	GtkVisibility visible;
	int x, y, tint, current_width, current_height;
	extern GdkPixmap *pixmap;
	extern GtkWidget *chart, *data_window_clist;
	extern int chartflag, data_window_flag;
	extern unsigned int records;
	extern struct record2 header;
	
	
	if (! chartflag)
		return;
	x = event->x;
	y = event->y;
	current_height = chart->allocation.height;
     	current_width = chart->allocation.width;
     	tint = x / header.pixelspace;
	if (((tint) < records) && (x <= current_width) && (y <= current_height))
      	{
		if ((event->button == 1) && (pixmap != NULL) && (data_window_flag != 0))
		{
			gtk_clist_freeze (GTK_CLIST (data_window_clist));
			gtk_clist_select_row(GTK_CLIST(data_window_clist), tint, 0);
			visible = gtk_clist_row_is_visible(GTK_CLIST(data_window_clist), tint);
			if ((visible==GTK_VISIBILITY_PARTIAL) || (visible==GTK_VISIBILITY_NONE))
				gtk_clist_moveto(GTK_CLIST(data_window_clist), tint, 0, 0.5, 0);
			gtk_clist_thaw (GTK_CLIST (data_window_clist));
		}
	}
}
/****************************************************************************************
this catches the mouse pointer position over the volume display and updates the data bar
*****************************************************************************************/
void volume_motion_notify_event(GtkWidget *widget, GdkEventMotion *event)
{
	int x, y, tint, current_height, current_width;
	GdkModifierType state;
	char tstring[100], tstring2[25], tstring3[25];
	extern GtkWidget *data_frame, *volume;
	extern int chartflag;
	extern unsigned int records;
	extern struct record1 *data;
	extern struct record2 header;
	extern struct record3 config;
	
	
	if (! chartflag)
		return;
      	if (! config.bottom_enable_flag)
      		return;
	if (event->is_hint)
      		gdk_window_get_pointer(event->window, &x, &y, &state);
      	else
      	{
      		x = event->x;
      		y = event->y;
      		state = event->state;
      	}
      	current_height = volume->allocation.height;
      	current_width = volume->allocation.width;
      	tint = x / header.pixelspace;
        if (((tint) < records) && (x <= current_width) && (y <= current_height))
      	{
       		sprintf(tstring2, "%ld", data[tint].date);
        	tstring3[0] = tstring2[4];
        	tstring3[1] = tstring2[5];
        	tstring3[2] = '/';
        	tstring3[3] = tstring2[6];
        	tstring3[4] = tstring2[7];
        	tstring3[5] = '/';
        	tstring3[6] = tstring2[0];
        	tstring3[7] = tstring2[1];
        	tstring3[8] = tstring2[2];
        	tstring3[9] = tstring2[3];
        	tstring3[10] = 0;
        	strcpy(tstring, "D=");
       		strcat(tstring, tstring3);
  		strcat(tstring, " V=");
  		sprintf(tstring2, "%ld", data[tint].volume);
      		strcat(tstring, tstring2);
      		gtk_statusbar_pop(GTK_STATUSBAR(data_frame), 1);
        	gtk_statusbar_push(GTK_STATUSBAR(data_frame), 1, tstring);
   	}
}
/***************************************************************************************
creates or erases the pixmap on which to draw the chart
****************************************************************************************/
void volume_configure_event(GtkWidget *widget, GdkEventConfigure *event)
{
	GdkColor *color;
       	GdkGC *gc;
	extern GdkPixmap *volume_pixmap;
	extern int chartflag;
	extern struct record3 config;
	
	
	gc = gdk_gc_new(widget->window);
       	color = (GdkColor *)malloc(sizeof(GdkColor));
       	color->red = config.background_red * (65535/255);
       	color->green = config.background_green * (65535/255);
       	color->blue = config.background_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(widget), color);
       	gdk_gc_set_foreground(gc, color);
	
	if (volume_pixmap)
		gdk_pixmap_unref(volume_pixmap);
	volume_pixmap = gdk_pixmap_new (widget->window,
				 widget->allocation.width,
				 widget->allocation.height,
				 -1);
				 
	gdk_draw_rectangle (volume_pixmap, gc, TRUE, 0, 0,
			    widget->allocation.width,
			    widget->allocation.height);
			    
	if (chartflag)
		draw_volume();
}
/*************************************************************************************
this catches the X event to redraw the chart if it's covered by another window
**************************************************************************************/
void volume_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	extern GdkPixmap *volume_pixmap;
	
	gdk_draw_pixmap (widget->window,
			 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
			 volume_pixmap,
			 event->area.x, event->area.y,
			 event->area.x, event->area.y,
			 event->area.width, event->area.height);
}
/****************************************************************************************
this catches the left mouse button press and updates the data window
*****************************************************************************************/
void volume_button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	GtkVisibility visible;
	int x, y, tint, current_width, current_height;
	extern GdkPixmap *volume_pixmap;
	extern GtkWidget *volume, *data_window_clist;
	extern int chartflag, data_window_flag;
	extern unsigned int records;
	extern struct record2 header;
	
	
	if (! chartflag)
		return;
	x = event->x;
	y = event->y;
	current_height = volume->allocation.height;
     	current_width = volume->allocation.width;
     	tint = x / header.pixelspace;
	if (((tint) < records) && (x <= current_width) && (y <= current_height))
      	{
		if ((event->button == 1) && (volume_pixmap != NULL) && (data_window_flag != 0))
		{
			gtk_clist_freeze (GTK_CLIST (data_window_clist));
			gtk_clist_select_row(GTK_CLIST(data_window_clist), tint, 0);
			visible = gtk_clist_row_is_visible(GTK_CLIST(data_window_clist), tint);
			if ((visible==GTK_VISIBILITY_PARTIAL) || (visible==GTK_VISIBILITY_NONE))
				gtk_clist_moveto(GTK_CLIST(data_window_clist), tint, 0, 0.5, 0);
			gtk_clist_thaw (GTK_CLIST (data_window_clist));
		}
	}
}
/***************************************************************************************
creates or erases the pixmap on which to draw the date
****************************************************************************************/
void date_configure_event(GtkWidget *widget, GdkEventConfigure *event)
{
	GdkColor *color;
       	GdkGC *gc;
	extern GdkPixmap *date_pixmap;
	extern int chartflag;
	extern struct record3 config;
	
	
	gc = gdk_gc_new(widget->window);
       	color = (GdkColor *)malloc(sizeof(GdkColor));
       	color->red = config.background_red * (65535/255);
       	color->green = config.background_green * (65535/255);
       	color->blue = config.background_blue * (65535/255);
       	gdk_color_alloc(gtk_widget_get_colormap(widget), color);
       	gdk_gc_set_foreground(gc, color);
	
	if (date_pixmap)
		gdk_pixmap_unref(date_pixmap);
	date_pixmap = gdk_pixmap_new (widget->window,
				 widget->allocation.width,
				 widget->allocation.height,
				 -1);
				 
	gdk_draw_rectangle (date_pixmap, gc, TRUE, 0, 0,
			    widget->allocation.width,
			    widget->allocation.height);
			    
	if (chartflag)
		draw_date();
}
/*************************************************************************************
this catches the X event to redraw the chart if it's covered by another window
**************************************************************************************/
void date_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	extern GdkPixmap *date_pixmap;
	
	gdk_draw_pixmap (widget->window,
			 widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
			 date_pixmap,
			 event->area.x, event->area.y,
			 event->area.x, event->area.y,
			 event->area.width, event->area.height);
}