/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998, Double Precision Inc.                                    */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"lexer.h"
#include	"recipe.h"
#include	"varlist.h"
#include	"funcs.h"
#include	"tempfile.h"
#include	"message.h"
#include	"messageinfo.h"
#include	"config.h"
#include	"exittrap.h"
#include	"maildrop.h"
#include	"autoconf.h"
#include	"setgroupid.h"
#include	<sys/types.h>
#if HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif
#include	<sysexits.h>
#include	<string.h>
#include	<stdlib.h>
#include	<pwd.h>

static const char rcsid[]="$Id: main.C 1.5 1998/08/31 03:54:50 mrsam Exp $";

static Message m1, m2;
extern char **environ;
static int errexit=EX_TEMPFAIL;
static const char *defaults_vars[]={"LOCKEXT","LOCKSLEEP","LOCKTIMEOUT",
					"LOCKREFRESH", "PATH", "SENDMAIL"};
static const char *defaults_vals[]={LOCKEXT_DEF,LOCKSLEEP_DEF,LOCKTIMEOUT_DEF,
					LOCKREFRESH_DEF, DEFAULT_PATH,
					SENDMAIL_DEF};

Maildrop maildrop;

Maildrop::Maildrop()
{
	verbose_level=0;
	isdelivery=0;
	sigfpe=0;
	includelevel=0;
	embedded_mode=0;
	msgptr= &m1;
	savemsgptr= &m2;
}

static void help()
{
	mout << "Usage: maildrop [options] [-d user] [arg] [arg] ...\n";
	mout << "       maildrop [options] [filterfile [arg] [arg] ...\n";
}

static void bad()
{
	throw "Bad command line arguments, -h for help.\n";
}

static void nouser()
{
	errexit=EX_NOUSER;
	throw "Invalid user for -d option.\n";
}

static void copyright()
{
static const char msg[]="maildrop 0.51c Copyright 1998 Double Precision, Inc."

#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
	"This program is distributed under the terms of the GNU General Public"
#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
        "License. See COPYING for additional information."
#if CRLF_TERM
	"\r\n"
#else
	"\n"
#endif
 
		;

	mout << msg;
	mout.flush();
}

static int run(int argc, char **argv)
{
int	argn;
const	char *deliverymode=0;
const	char *embedded_filter=0;
Buffer	recipe;
uid_t	orig_uid;
Buffer	extra_headers;

	umask( 0007 );
	for (argn=1; argn < argc; )
	{
		if (argv[argn][0] != '-')	break;
		if (strcmp(argv[argn], "--") == 0)	{ ++argn; break; }

	char	optc=argv[argn][1];
	const char *optarg=argv[argn]+2;

		++argn;
		switch (optc)	{
		case 'd':
			if (!*optarg && argn < argc)	optarg=argv[argn++];
			deliverymode=optarg;
			break;
		case 'V':
			if (!*optarg && argn < argc)	optarg=argv[argn++];
			maildrop.verbose_level=atoi(optarg);
			break;
		case 'v':
			copyright();
			return (0);
		case 'm':
			maildrop.embedded_mode=1;
			break;
		case 'M':
			if (!*optarg && argn < argc)	optarg=argv[argn++];
			maildrop.embedded_mode=1;
			if (!deliverymode)	deliverymode="";
			if (!*optarg)
			{
				help();
				return (EX_TEMPFAIL);
			}
			embedded_filter=optarg;
			if (*(const char*)embedded_filter == SLASH_CHAR
				|| strchr(embedded_filter, '.'))
				throw "Invalid argument for -M.\n";
			break;
		case 'A':
			if (!*optarg && argn < argc)	optarg=argv[argn++];
			if (*optarg)
			{
				extra_headers += optarg;
				extra_headers += '\n';
			}
			break;
		case 'h':
			help();
			return (EX_TEMPFAIL);
		default:
			bad();
		}
	}

	orig_uid=getuid();
	if (!deliverymode && argn < argc)
		recipe=argv[argn++];
	else
	{
	struct	passwd	*pw;

		if (!deliverymode)	deliverymode="";

		if (*deliverymode)
		{
			pw=getpwnam(deliverymode);
			if (!pw)
				nouser();
#if	RESET_GID
			setgroupid(pw->pw_gid);
#endif
			setuid(pw->pw_uid);
			if (getuid() != pw->pw_uid)
				nouser();	// Security violation.
		}
		maildrop.isdelivery=1;
#if	RESTRICT_TRUSTED
		if ( getuid() != orig_uid)
		{
		static char trusted_users[]=TRUSTED_USERS;
		static char buf[ sizeof(trusted_users) ];
		char	*p;

			strcpy(buf, trusted_users);
			for (p=buf; (p=strtok(p, " ")) != 0; p=0)
			{
			struct	passwd *q=getpwnam(p);

				if (q && q->pw_uid == orig_uid)
					break;
			}

			if (!p)	nouser();	// Security violation
		}
#endif
	}

#if	RESET_GID
	setgroupid(getgid());
#endif
	setuid(getuid());	// Drop any setuid privileges.

int	i;
Buffer	name;
Buffer	value;

	if (!maildrop.isdelivery)
	{
		for (i=0; environ[i]; i++)
		{
			name=environ[i];

		char	*p=strchr(environ[i], '=');

			value= p ? (name.Length(p - environ[i]), p+1):"";
			SetVar(name, value);
		}
	}

	i=1;
	while (argn < argc)
	{
		name="";
		name.append( (unsigned long)i);
		value=argv[argn++];
		SetVar(name, value);
		++i;
	}

	for (i=0; i<(int)(sizeof(defaults_vars)/sizeof(defaults_vars[0])); i++)
	{
		name=defaults_vars[i];
		value=defaults_vals[i];
		SetVar(name, value);
	}

struct	passwd	*p=getpwuid(getuid());

	if (!p)	nouser();
	if (deliverymode)
	{
	struct	stat	buf;

		if (VerboseLevel() > 1)
			merr << "maildrop: Changing to " << p->pw_dir << "\n";

		if (chdir(p->pw_dir) < 0)
			throw "Unable to change to home directory.\n";
		recipe=".mailfilter";

		if ( stat(".", &buf) < 0 ||
			!S_ISDIR(buf.st_mode) ||
			buf.st_mode & S_IWOTH ||
			buf.st_uid != getuid())
			throw "Invalid directory permissions.\n";

		// Quietly terminate if the sticky bit is set on the homedir

		if ( buf.st_mode & S_ISVTX)
			return (EX_TEMPFAIL);

		if (embedded_filter)
		{
			i=stat(".mailfilters", &buf);

			if ( (i < 0 && errno != ENOENT) || (i >= 0 && (
				!S_ISDIR(buf.st_mode) ||
				(buf.st_mode & (S_IRWXO|S_IRWXG)) ||
				buf.st_uid != getuid())
							)
				)
				throw "Invalid directory permissions.\n";
			recipe = embedded_filter;
		}
	}
	name="HOME";
	value=p->pw_dir;
	maildrop.tempdir=p->pw_dir;
	maildrop.tempdir += "/" TEMPDIR;
	maildrop.tempdir += '\0';
	mkdir( (const char *)maildrop.tempdir, 0700 );
	SetVar(name, value);
	name="LOGNAME";
	value=p->pw_name;
	SetVar(name, value);
	name="SHELL";
	if (p->pw_shell && *p->pw_shell)
		value=p->pw_shell;
	else
		value="/bin/sh";
	SetVar(name, value);
	name="DEFAULT";
	value=GetDefaultMailbox(p->pw_name);
	SetVar(name, value);

Buffer	msg;

	maildrop.global_timer.Set(GLOBAL_TIMEOUT);
	maildrop.msgptr->Init(0);	// Read message from standard input.
	maildrop.msginfo.info( *maildrop.msgptr );
	maildrop.msgptr->ExtraHeaders(extra_headers);
	maildrop.msgptr->setmsgsize();

// If invoking user is root, trust the From line, else set it to invoking
// user.

	if (orig_uid > 0 || maildrop.msginfo.fromname.Length() == 0)
	{
		p=getpwuid(orig_uid);
		maildrop.msginfo.fromname=p ? p->pw_name:"root";
	}

	if (VerboseLevel() > 1)
	{
		msg.reset();
		msg.append("Message start at ");
		msg.append((unsigned long)maildrop.msginfo.msgoffset);
		msg.append(" bytes, envelope sender=");
		if (maildrop.msginfo.fromname.Length() > 0)
			msg += maildrop.msginfo.fromname;
		msg.append("\n");
		msg += '\0';
		merr.write(msg);
	}

int	fd;

	//
	//

	if (!embedded_filter && deliverymode)
	{
	Recipe r;
	Lexer in;

		fd=in.Open("/etc/maildroprc");
		if (fd < 0)
		{
			if (errno != ENOENT)
				throw "Error on open of /etc/maildroprc.\n";
		}
		else
		{
			if (r.ParseRecipe(in) < 0)
				return (EX_TEMPFAIL);
			r.ExecuteRecipe();
		}
	}

Recipe	r;
Lexer	in;

#ifdef	DEFAULTEXT
int	firstdefault=1;
#endif

	name="MAILFILTER";
	value=recipe;
	SetVar(name, value);

	for (;;)
	{
		if (embedded_filter)
		{
			msg=".mailfilters/";
			msg += recipe;
			if (VerboseLevel() > 1)
				merr << "maildrop: Attempting " << msg << "\n";
			msg += '\0';
			fd=in.Open((const char *)msg);
		}
		else
		{
			msg=recipe;
			if (VerboseLevel() > 1)
				merr << "maildrop: Attempting " << msg << "\n";
			msg += '\0';
			fd=in.Open((const char *)msg);
			break;
		}
#ifndef	DEFAULTEXT
		break;
#else
		if (fd >= 0)	break;
		if (errno != ENOENT)	break;

		if (firstdefault)
		{
			recipe += DEFAULTEXT;
			firstdefault=0;
			continue;
		}

		// Pop DEFAULTEXT bytes from end of recipe name

		for (fd=sizeof(DEFAULTEXT)-1; fd; --fd)
			recipe.pop();

		while (recipe.Length())
		{
			if (recipe.pop() == '-')
			{
				recipe += DEFAULTEXT;
				break;
			}
		}
		if (recipe.Length() == 0)
		{
			msg=".mailfilters/";
			msg += DEFAULTEXT+1;
			if (VerboseLevel() > 1)
				merr << "maildrop: Attempting " << msg << "\n";
			msg += '\0';
			fd=in.Open((const char *)msg);
			break;
		}
#endif
	}

	if (fd < 0)
	{
		//
		//  If we are operating in delivery mode, it's ok if
		//  .mailfilter does not exist.
		//
		if (!deliverymode || errno != ENOENT)
			throw "Unable to open filter file.\n";
	}
	else
	{
	struct	stat	stat_buf;

		if (fstat( fd, &stat_buf) != 0)
			throw "stat() failed.\n";

		if (!S_ISREG(stat_buf.st_mode) ||
			(stat_buf.st_mode & (S_IRWXO | S_IRWXG)) ||
			stat_buf.st_uid != getuid())
			throw "Invalid permissions on filter file.\n";

		if (r.ParseRecipe(in) < 0)
			return (EX_TEMPFAIL);

//		if (maildrop.msgptr->MessageSize() > 0)
			r.ExecuteRecipe();
	}
//
// If a message is succesfully delivered, an exception is thrown.
// If we're here, we should deliver to the default mailbox.
//

	if (!maildrop.embedded_mode)
	{
		name="DEFAULT";

	const char *v=GetVarStr(name);

		if (!v)	throw "DEFAULT mailbox not defined.\n";

		value=v;
		value += '\0';
		if (delivery((const char *)value) < 0)
			return (EX_TEMPFAIL);
	}

	value="EXITCODE";
	return ( GetVar(value)->Int("0") );
}

int main(int argc, char **argv)
{
	_exit(Maildrop::trap(run, argc, argv));
}

const char *GetDefaultMailbox(const char *username)
{
static Buffer buf;
int	isfile=0;

	buf="";

const	char *p=DEFAULT_DEF;

	if (*p != SLASH_CHAR)	// Relative to home directory
	{
		buf="HOME";
		buf=GetVarStr(buf);
		buf.push(SLASH_CHAR);
		isfile=1;
	}

	while (*p)
	{
		if (*p != '=')
		{
			buf.push(*p);
			++p;
		}

	const char *q=username;

		while (*p == '=')
		{
			buf.push (*q ? *q:'.');
			if (*q)	q++;
			p++;
		}
	}

	if (!isfile)
	{
		buf.push(SLASH_CHAR);
		buf += username;
	}
	buf += '\0';
	return (buf);
}

const char *TempName()
{
Buffer	t;

	t=(const char *)maildrop.tempdir;
	t += "/tmp.";
	t += '\0';
	return (TempName((const char *)t, 0));
}
