/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998, Double Precision Inc.                                    */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"maildrop.h"
#include	"exittrap.h"
#include	<signal.h>
#include	<sysexits.h>
#include	<errno.h>

static const char rcsid[]="$Id: maildrop.C 1.1 1998/04/16 23:53:22 mrsam Exp $";

int Maildrop::sigfpe;

static RETSIGTYPE sig_fpe(int)
{
	maildrop.sigfpe=1;
	signal (SIGFPE, sig_fpe);
#if RETSIGTYPE != void
	return (0);
#endif
}

void Maildrop::cleanup()
{
	ExitTrap::onexit();
}

RETSIGTYPE Maildrop::bye(int n)
{
static const char msg[]="maildrop: signal 0x";
static const char hex[]="0123456789ABCDEF";

	cleanup();
	write(2, msg, sizeof(msg)-1);
	write(2, hex+ ((n / 16) & 0x0F), 1);
	write(2, hex+ (n & 0x0F), 1);
	write(2, "\n", 1);
	_exit(EX_TEMPFAIL);

#if RETSIGTYPE != void
	return (0);
#endif
}

int Maildrop::trap(int (*func)(int, char *[]), int argc, char *argv[])
{
int	n;

	for (n=0; n<NSIG; n++)
		signal(n, bye);
	signal(SIGPIPE, SIG_IGN);
	signal(SIGCHLD, SIG_DFL);
	signal(SIGFPE,  sig_fpe);

	try
	{
	int	r=(*func)(argc, argv);

		cleanup();
		return (r);
	}
	catch (const char *p)
	{
		merr << argv[0] << ": " << p;
		cleanup();
		return (EX_TEMPFAIL);
	}
	catch (char *p)
	{
		merr << argv[0] << ": " << p;
		cleanup();
		return (EX_TEMPFAIL);
	}
	catch (int n)
	{
		cleanup();
		return (n);
	}
	catch (...)
	{
		merr << argv[0] << ": Internal error.\n";
		cleanup();
		return (EX_TEMPFAIL);
	}
}
