//  UXInput.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UXInput.h"
#include "UCommon.h"
#include <string.h>

UXInput::UXInput (UWidgetX* uwidgetIn)
{
	uwidget = uwidgetIn;
	started = 0;
	initialized = 0;
	textType = 0;
	uString = 0;
	inputMethod = 0;
}

UXInput::~UXInput()
{
	removeEventHandler (UPROPERTY_CHANGE);
	removeEventHandler (UNO_EVENT);
	if (textType) delete textType;
	if (uString) delete uString;
	if (inputMethod) delete inputMethod;
}

//
// Text type is usually "COMPUND_TEXT" or "STRING"
//
UXInput::UStatus
UXInput::uSetup (const char *imIn, const UInputStyle inputStyleIn,
	const char* textTypeIn, const char *uStringIn, UFontX11* fontIn,
	float versionIn)
{
	inputMethod = new char [strlen (imIn) + 1 ];
	CHECKNULL (inputMethod);
	strcpy (inputMethod, imIn);

	inputStyle = inputStyleIn;

	textType = new char [strlen (textTypeIn) + 1 ];
	CHECKNULL (textType);
	strcpy (textType, textTypeIn);
	textTypeAtom = XInternAtom (uwidget->uGetDisplay(), textType, False);

	uString = new UString ();
	CHECKNULL (uString);
	if (uString->setConverter (uStringIn) != UString::OK)
	{
		cerr << "warn: can not get converter for '" << uStringIn << "'\n";
	}
	font = fontIn;
	version = versionIn;
	initialized = 1;
	return OK;
}

UXInput::UStatus
UXInput::uStart ()
{
	if (!initialized) return ERROR;
	return uStartIM ();	
}

void
UXInput::uEnd ()
{
	if (!initialized) return;
	uEndIM ();
}

//------------------------------------------------------------------------------
// This function should be called when UWidget changes its attributes.
// - background, foreground, font cursor
//------------------------------------------------------------------------------
UXInput::UStatus
UXInput::uStartIM ()
{
	return ERROR;
}

void
UXInput::uEndIM ()
{
}

void
UXInput::uChangeAttributes(const UAttribute	attrIn)
{
	uChangeIM (attrIn);
}

//------------------------------------------------------------------------------
// The following methods will be overwritten by whoever implements input method.
//------------------------------------------------------------------------------
void
UXInput::uChangeIM(UAttribute	attrIn)
{
}

void
UXInput::propertyChangeHandler (const XEvent* event)
{
}

void
UXInput::noEventHandler (const XEvent* event)
{
}

void
UXInput::addEventHandler (const UInputEvent eventType)
{
}

void
UXInput::removeEventHandler (const UInputEvent eventType)
{
}

