//  UFontMap.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
//
//

#include "UFontMap.h"
#include "UCache.h"
#include "UCommon.h"
#include <malloc.h>
#include <string.h>

#include <memory.h>

static          UCache<UFontMap*>* cache=0;

UFontMap::UFontMap (const char *nameIn)
{
	size = 0;
	name = new char[strlen (nameIn) + 1];
	CHECKNULL (name);
	strcpy (name, nameIn);
	isInited = 0;
}

UFontMap::~UFontMap()
{
	while (--size>=0)
	{
		if (fonts[size])
		{
			delete fonts[size]->foundry;
			delete fonts[size]->family;
			delete fonts[size]->registry;
			delete fonts[size]->encoding;
			delete fonts[size]->mapName;
			if (fonts[size]->encoder != 0)
			{
				delete fonts[size]->encoder;
			}
			delete fonts[size];
		}
	}
}

UFontMap::UStatus
UFontMap::deleteLast()
{
	if (size==0) return ERROR;
	size--;
	if (fonts[size] != 0)
	{
		delete fonts[size]->foundry;
		delete fonts[size]->family;
		delete fonts[size]->registry;
		delete fonts[size]->encoding;
		delete fonts[size]->mapName;
		if (fonts[size]->encoder!=0)
		{
			delete fonts[size]->encoder;
		}
		delete fonts[size];
		isInited=0;
	}
}

UFontMap::UStatus
UFontMap::addFont (const char* foundryIn, 
	const char* familyIn, const char* registryIn,
	const char* encodingIn, const char *umapIn)
{
	UFontMapStruct	*fontMap;

	if (size > UMAXFONTS -1)
	{
		return ERROR;
	}
	fontMap = new UFontMapStruct[1];
	CHECKNULL (fontMap);

	fontMap->mapName = new char[strlen (umapIn) +1];
	CHECKNULL (fontMap->mapName);
	strcpy (fontMap->mapName, umapIn);

	isInited = 0;
	fontMap->encoder = 0;
;
	fontMap->foundry = new char [1+((foundryIn==0)?1:strlen (foundryIn))];
	CHECKNULL (fontMap->foundry);
	strcpy (fontMap->foundry, (foundryIn==0)?"*":foundryIn);

	fontMap->family = new char [1+((familyIn==0)?1:strlen (familyIn))];
	CHECKNULL (fontMap->family);
	strcpy (fontMap->family, (familyIn==0)?"*":familyIn);

	fontMap->registry = new char [1+((registryIn==0)?1:strlen (registryIn))];
	CHECKNULL (fontMap->registry);
	strcpy (fontMap->registry, (registryIn==0)?"*":registryIn);

	fontMap->encoding = new char [1+((encodingIn==0)?1:strlen (encodingIn))];
	CHECKNULL (fontMap->encoding);
	strcpy (fontMap->encoding, (encodingIn==0)?"*":encodingIn);

	fonts[size] = fontMap;
	size++;
	return OK;
}

void
UFontMap::init ()
{
	int	i;
	if (isInited !=0) return;

	for (i=0; i<size; i++)
	{
		if (fonts[i]->encoder) delete fonts[i]->encoder;
		fonts[i]->encoder = new UMap();
		CHECKNULL (fonts[i]->encoder);
		if (fonts[i]->encoder->rename (
			fonts[i]->mapName)==UMap::ERROR)
		{
			cerr << "error: can not get '" << fonts[i]->mapName
				<< "'encoder.\n";
			delete fonts[i]->encoder;
			fonts[i]->encoder = 0;
		}
	}
	isInited = 1;
	
	return;
}

UFontMap::UStatus
UAddFontMap (
	const char* nameIn, const char* foundryIn, 
	const char* familyIn, const char* registryIn,
	const char* encodingIn, const char *umapIn)
{
	UFontMap		*fontMap;
	UFontMap::UStatus	status;

	if (cache == 0)
	{
		cache = new UCache<UFontMap*>;
		CHECKNULL (cache);
	}

	fontMap = cache->getItem (nameIn);
	if (fontMap == 0)
	{
		fontMap = new UFontMap (nameIn);
		CHECKNULL (fontMap);
	}
	status = fontMap->addFont (foundryIn, familyIn,
		registryIn, encodingIn, umapIn);
	if (status != UFontMap::OK)
	{
		cerr << "error: could not add item to fontmap '" << nameIn << "'.\n";
		return UFontMap::ERROR;
	}
	cache->addItem (nameIn, fontMap);
	return UFontMap::OK;
}

UFontMap *
UGetFontMap (const char *nameIn)
{
	if (cache == 0) return 0;
	return cache->getItem (nameIn);
}

UFontMap::UStatus
UDeleteFontMap (const char *nameIn)
{
	// the first was set when added 
	cache->unuseItem (nameIn);
	if (cache->dropItem(nameIn) ==  UCache<UFontMap*>::OK)
	{
		if (cache->getItemCount()==0) 
		{
			delete cache;
			cache = 0;
		}
		return UFontMap::OK;
	}
	return UFontMap::ERROR;
}
