//  AString.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __astring_h__
#define __astring_h__

#include <string.h>

#include <iostream.h>

class	AString
{
public:
				AString (void);
				AString (const AString& strIn);
				AString (const char* strIn);
				~AString();
	inline const int	isNull () const { return string==0; }
				operator const char* () const;
	AString& operator= 	(const char *str);
	AString& operator= 	(const AString& strIn);
	AString& operator+= 	(const char *str);
	int			toInt ();
	void			truncate (int i) {string[i]=0; }
private:
	char *			string;
};

class AStringList
{
public:
				AStringList ();
				AStringList (const AStringList& strIn);
				~AStringList();
	void			add (const char* element);
	void			push (const char* element);
	void			addCaseSorted (const char* element);
	const char*		at (const int position) const;
	int			getSize () const;
	int			toInt ();
	void			clear ();
	int			binaryCaseSearch(const char* str);
	AStringList& operator= 	(const AStringList& str);
private:
	void			copy (const AStringList& strIn);
	char**			elements;
	int			size;
	int			arraySize;
};

#endif /* __astring_h__ */
