//  MainWidget.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __mainwidget_h__
#define __mainwidget_h__

#include <UWidget.h>
#include <Config.h>
#include <UShell.h>
#include <UTextArea.h>
#include <UMenuBar.h>
#include <AString.h>
#include <UFileDialog.h>
#include <UChoiceDialog.h>
#include <UPromptDialog.h>
#include <UFindDialog.h>

class MainWidget : public UShell
{
public:
	enum MenuId     {UFILE, UENCODING, UINPUT, UXINPUT, UFONTNAME,
			UFONTWEIGHT, UFONTSIZE, UFONTSLANT,
			UFONTSPACING, UWINDOW, UTABSIZE, UWINDOW_BACKGROUND,
			UWINDOW_FOREGROUND, UCURSOR_COLOR, ULANGUAGE,
			USEARCH, UHELP, UMENUMAX};

			MainWidget (const Config& configIn, 
				const char* fileNameIn=0,
				const char* encodingIn=0,
				const UWidget::UEditable 
				   editableIn=UWidget::EDITABLE);
			~MainWidget();
protected:
	UPopUp*		popUp [UMENUMAX];

	MenuId		getMenuId (UPopUp* pup);
	void		menuAction (MenuId id, int meniItem);
	void		buildMenu ();
	void		translateMenuBar ();
	void		translateMenu (MenuId id);
	virtual void	eventUp (UEvent* event);
	virtual void	quit ();
	virtual int	filterKeyEvent (XEvent* event);

	void		setLanguage (const char* lang_);
	void		warn (const char* message);
	void		info (const char* message);
	int		ask (const char* message);
	void 		saveAs ();
	void 		load ();
	void 		append ();
	void 		print ();
	void 		doGoto ();
	void 		doFind ();
	int		setupPrinter (int pos);

	UTextArea*		editArea;
	UMenuBar*		menuBar;
	Config			config;
	AString			fileName;
	UWidget::UEditable	isEditable;
	
private:
	int		setXInput (const char* nameIn);
	int		checkEncoding ();
	int 		saveFile (const char* filenameIn);
	int 		loadFile (const char* filenameIn);
	int 		appendFile (const char* filenameIn);
	int		appendFileBase (const char* filenameIn);

	enum PrintComp { PRINTER, FONT_NAME, FONT_SIZE, FONT_WEIGHT,
		FONT_SLANT, TAB_SIZE, PRINT_COMP_MAX };
	void		setFileDialog (UFileDialog::UFileDialogType dialogType);
	UFileDialog*	fileDialog;
	UChoiceDialog*	printDialog;
	UPromptDialog*	promptDialog;
	UFindDialog*	findDialog;
	AString		encoding;
	AString		lastInput;
	AString		printDefault[PRINT_COMP_MAX];
	AStringList	printList[PRINT_COMP_MAX];

	const Language* language;
	UFont*		buttonFont;
	UFont*		textFont;
	UFont*		editFont;
	void 		addButtons (MenuId id, const AStringList& list,
				UMenu::UMenuArrow arrow_);
	void		checkItem (MenuId id, const char* item);
};

#endif /* __mainwidget_h__ */
