//  UFileDialog.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __ufile_dialog_h__
#define __ufile_dialog_h__

#include "UFont.h"
#include "UDialog.h"
#include <AString.h>
#include "UTextDialog.h"

class UFileDialog : public UDialog
{
public:
			// with frame
	enum USubComponent {
			OK, CD, CANCEL, 
			FILE_LABEL, FILE_TEXT,
			FILE_LIST, DIR_LIST,
			FILES_LABEL, DIRS_LABEL,
			TOGGLE, TOGGLE_TEXT, CHOICE, COMP_MAX }; 

	enum UFileDialogType { LOAD, SAVE };
			UFileDialog (UShell* transient, 
				UFileDialogType type=LOAD,
				int frameSize=2);
			UFileDialog (UTop* top_, 
				UFileDialogType type=LOAD,
				int frameSize=2);
	virtual		~UFileDialog ();
	void		setDialogType (UFileDialogType type_)
			{ type=type_; }
			// pop up, get value after popped down.
	virtual UValue	getValue();
	virtual const UBestSize&	getBestSize ();
	virtual void	resize (int w, int h);
	virtual void	passEvent (UEvent* event);
	virtual void	setTitle (const char* title=0);

	// the return value will be utf8 - this is the text encoding
	int		setEncoding (const char* encoding);
	int		setInput (const char* input);

	void		setButtonFont (UFont* font_);
	void		setTextFont (UFont* font_);
	void		setText (USubComponent w_, const char* utf8_);
	void		setExists (const char* utf8_);
	void		setExistsYes (const char* utf8_);
	void		setExistsNo (const char* utf8_);
	void		eventUp (UEvent* event);
	int		cdTo (const char* newDir);
	const char*	getSelected () { return (const char*) selected; }
	int 		setXInput (const char* name, const char* imIn,
				const char* inputStyleIn, const char* textType,
				const char* uStringIn, const char* fontMap, 
				double versionIn=0.0);
private:
	AString		workingDir;
	UTextDialog*	existsDialog;
	void		rescan ();
	void		redoList ();

	USubComponent	lastButton;
	UFileDialogType type;
	AString		selected;
	AStringList	dirList;
	AStringList	fileList;
	void		setUp();
	UComponent*	component[COMP_MAX];
	UMenuItem*	toggleMenu;
};

#endif /* __ufile_dialog_h_ */
