//  UChoice.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UChoice.h"

UChoice::UChoice (UFrame* parent_, int frameSize_) :
	UFrame (parent_, frameSize_)
{
	frameStyle = OUT;
	bestSize.width=40;
	bestSize.height=20;
	popUp = 0;
	selected = -1;
}

UChoice::~UChoice ()
{
	UComponent*	comp;
	if (popUp != 0) delete popUp;
	while (children.getSize())
	{
		comp = (UComponent*) children.at(0);
		if (comp==0) break;
		delete comp;
	}
}

void
UChoice::setFont (UFont* font_)
{
	font = font_;
	if (popUp)
	{
		popUp->setFont (font_);
		if (popUp->cascade)
		{
			popUp->cascade->setFont(font_);
		}
	}
}

const UBestSize&
UChoice::getBestSize()
{
	int		inset = 2;
	UBestSize	best;
	UBestSize	bestp;
	int		addition;

	bestSize.width=frameSize*2;
	bestSize.height=frameSize*2;
	popUp->setFont (font);
	if (bestSize.width<2) bestSize.width=2;
	if (bestSize.height<2) bestSize.height=2;
	if (popUp==0 || popUp->cascade==0) return bestSize;
	
	popUp->packItems ();
	best = popUp->cascade->getBestSize ();
	bestp = popUp->getBestSize();
	addition = 2*inset+2* frameSize;

	if (bestp.width> best.width+addition) 
		best.width = bestp.width-addition;

	popUp->cascade->place (inset+frameSize, frameSize+inset, 
		inset+frameSize, frameSize+inset);
	bestSize.width = best.width+addition+2*placement.margin;
	bestSize.height = best.height+addition+2*placement.margin;
	return bestSize;
}

int
UChoice::isA (UComponent::UType type_)
{
	if (type_ == UComponent::CHOICE) return 1;
	return UFrame::isA (type_);
}

UChoice::UStatus
UChoice::deleteMenuItem (UPopUp* popUp_)
{
	if (popUp == popUp_)
	{
		popUp = 0;
		return OK;
	}
	return OK;
}

//
// The popup cascade should be child of menubar 
//
UChoice::UStatus
UChoice::addMenuItem (UPopUp* popUp_)
{
	if (popUp != 0) delete popUp;
	popUp = popUp_;
	return OK;
}

void
UChoice::eventDown (UEvent* event)
{
	int			rootX;
	int			rootY;
	int			wX;
	int			wY;
	Window			w;
	Window			chld;
	UPopUp*			selectedPopUp;
	UComponent*		selectedItem;
	int			selectedPos;
	UMenuItem*		menuItem;
	UEvent			sendEvent;
	unsigned int		mask;

	switch (event->type)
	{
	case UEvent::TIMER:
		break;
	case UEvent::X:
	switch (event->xevent.type)
	{
	case ButtonRelease:
		if (event->xevent.xbutton.window!=window) return;
		if (event->xevent.xbutton.button != Button1) return;
		if (selected <0)
		{
			return;
		}
		// No selection is made yet.
		if (!popUp->getSelected (&selectedPopUp, 
			&selectedItem, &selectedPos))
		{
			return;
		}
		
		menuItem = (UMenuItem*) popUp->cascade->getMenu();
		if (menuItem) menuItem->unhighlight();
		XUngrabPointer (top->display, CurrentTime);
		popUp->highlightItem (
			event->xevent.xbutton.x_root,
			event->xevent.xbutton.y_root);
		popUp->hide ();
		selected = -1;
		sendEvent.type = UEvent::MENU_SELECTION;
		sendEvent.client = this;
		sendEvent.popUp = selectedPopUp;
		sendEvent.menu = selectedItem;
		sendEvent.value = selectedPos;
		// get the selected value here!!
		parent->eventUp (&sendEvent);
		break;
	case ButtonPress:
		if (event->xevent.xbutton.window!=window) return;
		if (event->xevent.xbutton.button != Button1) return;
		if (selected < 0) return;
		//menuItem = (UMenuItem*) popUp[selected]->cascade->getMenu();
		//if (menuItem) menuItem->unhighlight();
		XUngrabPointer (top->display, CurrentTime);
		popUp->highlightItem (
			event->xevent.xbutton.x_root,
			event->xevent.xbutton.y_root);
		if (popUp->getSelected (&selectedPopUp, 
			&selectedItem, &selectedPos))
		{
			popUp->hide ();
			// send menu event...
			sendEvent.type = UEvent::MENU_SELECTION;
			sendEvent.client = this;
			sendEvent.popUp = selectedPopUp;
			sendEvent.menu = selectedItem;
			sendEvent.value = selectedPos;
			// get the selected value here!!
			parent->eventUp (&sendEvent);
		}
		else
		{
			popUp->hide ();
		}

		selected = -1;
		break;
	case EnterNotify:
	case LeaveNotify:
		if (selected < 0) break;
		if (event->xevent.xcrossing.mode==NotifyUngrab)
		{
			menuItem = (UMenuItem*) popUp->cascade->getMenu();
			if (menuItem) menuItem->unhighlight();
			popUp->hide ();
			selected=-1; 
			break;
		}
		break;
	case MotionNotify:
		if (popUp==0 || selected ==-1) return;
		while (XCheckTypedWindowEvent (top->display, window,
			MotionNotify, &event->xevent));
		if (event->xevent.xmotion.is_hint)
		{
			XQueryPointer (top->display, window, &w, &chld, 
				&rootX, &rootY, &wX, &wY, &mask);
			popUp->highlightItem (rootX, rootY);
			return;
			
		}
		// Make translation
		popUp->highlightItem (
			event->xevent.xmotion.x_root,
			event->xevent.xmotion.y_root);
		break;
	default:
		break;
	}
	default:
		break;
	}
	UFrame::eventDown (event);
}

void 
UChoice::eventUp (UEvent* event)
{
	Window		w;
	int		rootX;
	int		rootY;
	int		status;
	UMenuItem*	menuItem;

	switch (event->type)
	{
	case UEvent::TIMER:
		break;
	case UEvent::PRESSED:
		break;
	case UEvent::X:
	switch (event->xevent.type)
	{
	case ButtonRelease:
		if (event->xevent.xbutton.button != Button1) return;
		XUngrabPointer (top->display, CurrentTime);
		if (popUp==0 || selected ==-1) return;
		popUp->hide ();
		// get the selected value here!!
		menuItem = (UMenuItem*) popUp->cascade->getMenu();
		if (menuItem) menuItem->unhighlight();
		popUp->unhighlightItem();
		selected = -1;
		break;
	case ButtonPress:
		if (event->xevent.xbutton.button != Button1) return;
		if (popUp==0 || popUp->cascade ==0) return;
		selected = 0;
        	status = XGrabPointer( top->display, window,
			False, ButtonPressMask | ButtonReleaseMask |
			EnterWindowMask | LeaveWindowMask | PointerMotionHintMask |
			PointerMotionMask,
			GrabModeAsync, GrabModeAsync,
			None, None, CurrentTime);
		if (status != GrabSuccess && status != AlreadyGrabbed)
		{
			cerr << "warn: pointer grab failed.\n";
			return;
		}
		menuItem = (UMenuItem*) popUp->cascade->getMenu();
		if (menuItem) menuItem->highlight();

		XTranslateCoordinates (top->display,
			popUp->cascade->window, top->root,
			-2-frameSize,
			popUp->cascade->rectangle.height+2+frameSize, 
			&rootX, &rootY, &w);

		//popUp[selected]->packItems ();
		popUp->move (rootX, rootY);
		popUp->show ();
		break;
	default:
		break;
	}
	default:
		break;
	}
}
