#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <refp.hh>
#include <common/common.h>

int
main(int argc, char* argv[])
{

  try 
    {
      CORBA::ORB* orb = CORBA::ORB_init(argc,argv,"omniORB2");
      CORBA::BOA* boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

      CORBA::Object_var obj;

      switch (argc) {
      case 2:
	{
	  try {
	    CosNaming::Name use_name = string_to_name(argv[1]);
	    obj = getObjectReference(orb,use_name);
	  }
	  catch (...) {
	    obj = CORBA::Object::_nil();
	  }
	  if (CORBA::is_nil(obj)) {
	    cerr << "Cannot resolve compound name to an object reference."
		 << endl;
	    return 1; 
	  }
	  break;
	}
      case 3:
	if (strcmp(argv[1],"-i") == 0) {
	  obj = orb->string_to_object(argv[2]);
	  if (CORBA::is_nil(obj)) {
	    cerr << "Cannot convert stringified IOR to an object reference."
		 << endl;
	    return 1;
	  }
	  break;
	}
      default:
	cerr << "usage: refpclt -i <stringified IOR>" << endl;
	cerr << "       refpclt <COSNaming compound name (e.g. x/y/echo.obj)>"
	     << endl;
	return 1;
      }

      refp_ptr rpo;

      rpo = refp::_narrow(obj);
      if (CORBA::is_nil(rpo))
	{
	  cerr << "Can't create proxy.\n" << endl;
	  return(1);
	}


      cout << "Sending reference." << endl;


      refp_ptr retobj,another_retobj;

      retobj = rpo->refpass(rpo);

      cout << "Reference returned: " << orb->object_to_string(retobj) 
	   << endl;

      cout << "\nGetting reference again..." << endl;

      another_retobj = retobj->getref();


      cout << "Reference returned: " << orb->object_to_string(another_retobj) 
	   << endl;
      if (rpo->_is_equivalent(another_retobj))
	{
	  cout << "Initial and final references are the same.\n" << endl;
	}
      else
	{
	  cout << "!!! Initial and final references are different !!!" << endl;
	  cout << "Initial: '" << orb->object_to_string(rpo) << "'" << endl;
	  cout << "Final: '" << orb->object_to_string(another_retobj) << "'\n" 
	       << endl;
	}
    }
  catch (const CORBA::COMM_FAILURE&) {
    cerr << "Caught COMM_FAILURE exception. Exit." << endl;
  }
  catch (const omniORB::fatalException &ex) 
    {
      cerr << "#### You have caught an omniORB2 bug, details are as follows:" 
	   <<  endl;
      cerr << ex.file() << " " << ex.line() << ":" << ex.errmsg() << endl; 
      cerr << "main thread exited." << endl;
    }

  return 0;
}


