#ifndef __EXPL_VFSL_H__
#define __EXPL_VFSL_H__

/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: expl_vfsl.h,v $
 *
 * $Revision: 1.2 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 *
 */
 
#include <qobject.h>

#include "file_tool.h"
#include "plugin_m.h"


class VFSL_Class : public QObject
{
      Q_OBJECT

  private:

      struct plugin_entry *pl_ltop;
      
      void do_connect (FileTreeNode *);
         
  public:

	VFSL_Class(void)
	{
         pl_ltop=NULL;
	}

	// >---------- basic functions

	virtual int vfsl_stat(const char *, struct stat *);
	virtual int vfsl_lstat(const char *, struct stat *);

/*    
 * * virtual int vfsl_readdir (unsigned int,struct dirent *,unsigned int);
 */
	virtual DIR *vfsl_opendir(char *);
	virtual int vfsl_closedir(DIR *);
	virtual int vfsl_read(int, char *, size_t);
	virtual int vfsl_write(int, char *, size_t);

/*    
 * * virtual int vfsl_chmod (); // don't know how to define this one yet
 * * virtual int vfsl_chown (); // don't know how to define this one yet 
 */
	virtual int vfsl_open(char *, int);
	virtual int vfsl_open(char *, int, int, mode_t);
	virtual int vfsl_close(int);
	virtual int vfsl_link(char *, char *);
	virtual int vfsl_unlink(char *);

// don't forget to add readlink ()    
	virtual int vfsl_rename(char *, char *);
	
  	virtual int vfsl_read_fs_dir (FileTreeNode *, char *);	

	// >---------- more complex functions

        int file_type (const char *);
        void assign_plugin_list (struct plugin_entry *);

  	virtual int vfsl_read_directory(FileTreeNode *, char *);
  	
   public slots:
   
    void create_directory (char *,unsigned long);
    void read_directory (FileTreeNode *,char *);
    void copy_a_file (char *,char *);
    void remove_a_file (char *);    
    void remove_a_dir (char *);
    
   signals:    	

    void sig_create_directory (char *,unsigned long);
    void sig_read_directory (FileTreeNode *,char *);
    void sig_copy_a_file (char *,char *);
    void sig_remove_a_file (char *);    
    void sig_remove_a_dir (char *);
};

#endif	 
