/* $Id: list.h,v 1.2 1998/08/02 20:35:01 proff Exp $ 
 * $Copyright$
 */

#ifndef LIST_H
#define LIST_H

struct list_s
{
	enum list_type type;
	char *name;
	bool auto_update;
	bool file;
};

#define MAX_NEWSGROUPS_HASH	31337 /* prime around 2x size of max number of newsgroups */

/*
 * this is stored in shared mem also
 */

struct newsgroup_index
{
	char version[16];
	struct newsgroup *newsgroup_head;
	struct newsgroup *newsgroup_tail;
	struct newsgroup *newsgroup_hash[MAX_NEWSGROUPS_HASH];
	struct newsgroup *newsgroup_freq_head;
	struct newsgroup *newsgroup_freq_tail;
};

/*
 * newsgroups are stored in a hashed indexed (autobalancing) binary linked list, double
 * threaded with a single linear list for sequential scanning.
 */

typedef enum
{
    NF_ACTIVE=1,
    NF_ACTIVE_TIMES=2,
    NF_NEWSGROUPS=4
} ng_flags;
	
struct newsgroup
{
	struct newsgroup *next; /* pointer to next entry (sequential)*/
	struct newsgroup *left; /* pointer to left hash collision */
	struct newsgroup *right;/* pointer to right hash collision */
	struct newsgroup_freq
	{
		struct newsgroup *next;
		struct newsgroup *prev;
		int weight;
	} freq;
	int msgs;		/* According to RFC977, this is an _estimate_ given by the server. Accuracy is not assured */
        int flags;		/* flags */
	int lo_xover;		/* Lowest numbered xover in cache, 0 == unknown, -1 == none cached */
	int hi_xover;		/* highest numbered xover in cache, 0 == unknown, -1 == none cached */
	int lo;			/* Lowest numbered full article in cache, 0 if unknown, -1 if none cached */
	int lo_server;		/* Lowest numbered article on server */
	int hi;			/* Highest numbered article in cache */
	int hi_server;		/* Lowest numbered article on server */
	time_t creation_time;	/* Creation time, output in active.times */
	char *group; 		/* Group's name. Really obvious */
	char *creator;		/* Group creator. Output in active.times */
	char *desc;		/* Group description. Output in newsgroups */
	struct server_cfg *server_cfg;	/* News Server for group */
	time_t last_rebuild;    /* last newsgroups/active/active.times rebuild */
	time_t group_time;      /* Last update from GROUP command update */
	time_t group_change_time; /* Last change of msgs/hi_server/lo_server */
	time_t listgroup_time;  /* Last update from LISTGROUP command update */
#ifdef READ_LOCKS
	int	read_locks;	/* number of readers */
#endif
	int	write_locks;	/* number of writers (shouldn't ever be more than 1 actually) */
	char moderation;	/* 'm' for moderated, 'y' allows unmoderated posting, 'n' disallows posts (group is read only) */
};

#include "list.ext"

#endif /* LIST_H */
