.TH GAP 1 "02/94" "LDFM"
.SH NAME
GAP \- Groups, Algorithms, and Programming
.SH SYNTAX
\fBgap\fR [ \fB\-b\fR ] [ \fB\-e\fR ] [ \fB\-q\fR ] [ \fB\-m\fR mem ] [ \fB\-g\fR ] [ \fB\-n\fR ] [ \fB\-x\fR width ] [ \fB\-y \fR height ] [ \fB\-l\fR libname ] [ \fB\-h\fR docname ] [ \fB\-z\fR freq ] [ 
.I "file"
\&...
]

.SH "DESCRIPTION"
The command above initiates a session with the group theory system GAP.
Expressions are read from standard input and the results are produced on the
standard output as each input expression is evaluated.

GAP's main purpose are group theory calculations in finitely presented
groups, permutation groups, polycyclicly presented groups,
representations and characters.  It also supports arbitrary length
integers and rationals, cyclotomic fields, finite fields, lists, sets,
records, and a programming language of Pascal type.  Some share
libraries, e.g. GRAPE for Graphs, are available.

The whole manual is accessible as on-line help.  After starting GAP,
type "?Help" to see a description of the on-line help system.  To get
more information about GAP look at the chapter "About GAP", to leave
GAP, type "quit;" or "control-D".

.SH "WARNING"
The information in this man page is an extract from the full documentation of
GAP, and is limited to the meaning of the options.

.SH "OPTIONS"
.IP "\-b"
This option tells GAP to surpress the banner.  That means that GAP
immediately prints the prompt.  This is useful when you get tired of
the banner after a while.
.\"
.IP "\-e"
This option tells GAP not to quit on "control-D".
.\"
.IP "\-q"
This options tells GAP to be quiet.  This means that GAP does not
display the banner and the prompts "gap>".  This is useful if you want
to run GAP as a filter with input and output redirection and want to
avoid the banner and the prompts clobber the output file.
.\"
.IP "\-m \fImem\fR"
This option tells GAP to allocate \fImem\fR bytes at startup
time.  If the last character of \fImem\fR is k or K, it is taken
in KBytes and if the last character is m or M, \fImem\fR is taken in
MBytes.
.\"
.IP "\-g"
This option tells GAP to print an information message every time a
garbage collection is performed. See also "Features of GAP for UNIX"
in the GAP manual.
.\"
.IP "\-r"
This option tells GAP not to read the user's .gaprc file.
.\"
.IP "\-n"
This option tells GAP to disable the line editing and history (see
also "Line Editing" in the GAP manual).  You may want to do this if
the command line editing is incompatible with another program that is
used to run GAP.
.\"
.IP "\-x \fIwidth\fR"
With this option you can tell GAP how long lines are.  GAP uses this
value to decide when to split long lines.  The default value is
80. See also "SizeScreen" in the GAP manual.
.\"
.IP "\-y \fIheight\fR"
With this option you can tell GAP how many lines your screen has.  GAP
uses this value to decide after how many lines of on-line help it
should display "-- <space> for more --". See also "SizeScreen" in the
GAP manual.
.\"
.IP "\-l \fIlibname\fR"
This option tells GAP that the library of GAP functions is in the
directory \fIlibname\fR.  Per default \fIlibname\fR is "lib/".  GAP
will read the file "\fIlibname\fR/init.g" during startup.  If GAP
cannot find this file it will print a warning. See also "Features
of GAP for UNIX" in the GAP manual.
.\"
.IP "\-h \fIdocname\fR"
This option tells GAP that the on-line documenation for GAP is in the
directory \fIdocname\fR.  Per default \fIdocname\fR is obtained by
replacing "lib" in \fIlibname\fR with "doc".  If you get a warning
when trying to use the help system check \fIdocname\fR. See also
"Features of GAP for UNIX" in the GAP manual.
.\"
.IP "\-z \fIfreq\fR"
The option is only available under MS-DOS.  GAP for MS-DOS checks in regular
intervals whether the user has entered "control-Z" or "alternate-C" to
interrupt an ongoing computation.  Under MS-DOS this requires reading the
keyboard status, which is rather expensive.  Therefore GAP only reads the
keyboard status ever \fIfreq\fR-th time.  The default is 20.  With this
option this value can be changed.  Lower values make GAP more responsive to
interrupts, higher values make GAP a little bit faster.
.\"
.IP "\fIfiles\fR"
Any additional parameters are assumed to be files, which are read in after
initialising the library.

.SH "FILES"
.IP "~/.gaprc"
if this file exists,  it is read in before the files specified on the
command line are read. If -r option was used this is file is not read.

.SH "AUTHORS"
GAP is a project of the 'Lehrstuhl D fuer Mathematik' (LDFM) of
the 'Rheinisch-Westfaelische Technische Hochschule Aachen'.

If you are a new GAP user we ask you to notify us, e.g., by sending a short
e-mail message to "gap@Math.RWTH\-Aachen.DE".  The simple reason, on top of
our curiosity, is that as anybody else in an academic environment we have
from time to time to prove that we are doing meaningful work.

We, the developers of GAP, have also established a discussion list, the GAP
forum, where interested users can discuss GAP related topics by e-mail.  In
particular this forum is for questions about GAP, general comments, bug
reports, and maybe bug fixes.  For information on how to subscribe to this
forum, see the README file.

If you have technical or installation problems, we suggest that you write to
"gap\-trouble@Math.RWTH\-Aachen.DE" instead of the GAP forum, as such
discussions are usually not very interesting for a larger audience.  Your
e-mail message will be read by several people here, and we shall try to
provide support.

.SH "COPYRIGHT"
GAP is given away under the conditions that have always been in use between
mathematicians, i.e.  in particular \fIcompletely in source\fR and \fIfree of
charge\fR. For further information see the README file.

.\" $Id: gap.man,v 1.2 1997/02/05 15:40:41 werner Exp $
.\"
.\" $Log: gap.man,v $
.\" Revision 1.2  1997/02/05 15:40:41  werner
.\" Deleted two occurrences of .TP which caused problems on SunOS
.\" and NEXTSTEP 3 and don't seem to effect the formatting.
.\"
.\" Revision 1.1.1.1  1996/12/11 12:37:06  werner
.\" Preparing 3.4.4 for release
.\"
.\" Revision 3.5  1994/09/06  10:14:36  fceller
.\" added '-r' option to avoid reading of the .gaprc file
.\"
.\" Revision 3.4  1994/02/03  13:53:52  fceller
.\" initial revision
.\"
.\"
