% Regression test.
% The Mercury compiler dated Wed Jul 9th 1997
% got an internal error for this test case.

:- module det_in_semidet_cntxt.

:- interface.

:- import_module io.

:- pred main(io__state, io__state).
:- mode main(di, uo) is det.

%------------------------------------------------------------------------------%
%------------------------------------------------------------------------------%


:- implementation.

:- import_module list, require, std_util, string.

:- type	name	== 	string.
:- type sympton	== 	string.
:- type vaccine	== 	string.

:- type disease	--->	d(name, list(sympton), list(vaccine)).

main -->
	read_diseases(_Diseases).


%------------------------------------------------------------------------------%

	%
	% read_diseases(D)
	%
	% D is the list of diseases.
	%
:- pred read_diseases(list(disease), io__state, io__state).
:- mode read_diseases(out, di, uo) is det.

read_diseases(D) -->
	read_disease(MaybeDisease),
	(
		{ MaybeDisease = yes(Disease) },
		read_diseases(Diseases),
		{ D = [Disease | Diseases] }
	;
		{ MaybeDisease = no },
		{ D = [] }
	).


:- pred read_disease(maybe(disease), io__state, io__state).
:- mode read_disease(out, di, uo) is det.

read_disease(MaybeDisease) -->
	read_name(MaybeName),
	(
		{ MaybeName = yes(Name) },
		read_symptons(Symptons),
		read_vaccines(Vaccines),
		{ MaybeDisease = yes(d(Name, Symptons, Vaccines)) }
	;
		{ MaybeName = no },
		{ MaybeDisease = no }
	).
		

:- pred read_name(maybe(string)::out, io__state::di, io__state::uo) is det.

read_name(MaybeName) --> 
	io__read_word(Result),
	(
		{ Result = ok(Name0) },
		{ string__from_char_list(Name0, Name) },
		{ MaybeName = yes(Name) }
	;
		{ Result = eof },
		{ MaybeName = no }
	;
		{ Result = error(Err) },
		{ io__error_message(Err, ErrStr) },
		{ error(ErrStr) }
	).


:- pred read_symptons(list(string)::out, io__state::di, io__state::uo) is det.
read_symptons([]) --> [].

:- pred read_vaccines(list(string)::out, io__state::di, io__state::uo) is det.
read_vaccines([]) --> [].

%------------------------------------------------------------------------------%
%------------------------------------------------------------------------------%


