/*
** Automatically generated from `std_util.m' by the Mercury compiler,
** version 0.7.3, configured for alpha-dec-osf3.2.
** Do not edit.
*/
/*
INIT mercury__std_util__init
ENDINIT
*/

#include "imp.h"
#line 934 "std_util.m"


#include "type_info.h"

int	ML_compare_type_info(Word type_info_1, Word type_info_2);


#line 21 "std_util.c"
#line 1059 "std_util.m"

/*
**	`univ' is represented as a two word structure.
**	One word contains the address of a type_info for the type.
**	The other word contains the data.
**	The offsets UNIV_OFFSET_FOR_TYPEINFO and UNIV_OFFSET_FOR_DATA 
**	are defined in runtime/type_info.h.
*/

#include "type_info.h"



#line 36 "std_util.c"
#line 1335 "std_util.m"


typedef struct ML_Construct_Info_Struct {
	int vector_type;
	int arity;
	Word *functors_vector;
	Word *argument_vector;
	Word primary_tag;
	Word secondary_tag;
	ConstString functor_name;
} ML_Construct_Info;

int	ML_get_num_functors(Word type_info); 
Word 	ML_copy_argument_typeinfos(int arity, Word type_info,
				Word *arg_vector);
bool 	ML_get_functors_check_range(int functor_number, Word type_info, 
				ML_Construct_Info *info);
void	ML_copy_arguments_from_list_to_vector(int arity, Word arg_list, 
				Word term_vector);
bool	ML_typecheck_arguments(Word type_info, int arity, 
				Word arg_list, Word* arg_vector);
Word 	ML_collapse_equivalences(Word maybe_equiv_type_info);
Word 	ML_make_type(int arity, Word *base_type_info, Word arg_type_list);


#line 63 "std_util.c"
#line 1474 "std_util.m"


Word ML_make_ctor_info(Word *type_info, Word *base_type_info);

	/*
	** Several predicates use these (the MR_BASE_TYPEINFO_IS_HO_*
	** macros need access to these addresses).
	*/
MR_DECLARE_STRUCT(mercury_data___base_type_info_pred_0);
MR_DECLARE_STRUCT(mercury_data___base_type_info_func_0);



#line 78 "std_util.c"
#line 2177 "std_util.m"


	#include <stdio.h>

	/* 
	 * Code for functor, arg and deconstruct
	 * 
	 * This relies on some C primitives that take a type_info
	 * and a data_word, and get a functor, arity, argument vector,
	 * and argument type_info vector.
	 */

	/* Type definitions */

	/* 
	 * The last two fields, need_functor, and need_args, must
	 * be set by the caller, to indicate whether ML_expand
	 * should copy the functor (if need_functor is non-zero) or
	 * the argument vector and type_info_vector (if need_args is
	 * non-zero). The arity will always be set.
	 *
	 * ML_expand will fill in the other fields (functor, arity,
	 * argument_vector, type_info_vector, and non_canonical_type)
	 * accordingly, but
	 * the values of fields not asked for should be assumed to
	 * contain random data when ML_expand returns.
	 * (that is, they should not be relied on to remain unchanged).
	 */


typedef struct ML_Expand_Info_Struct {
	ConstString functor;
	int arity;
	Word *argument_vector;
	Word *type_info_vector;
	bool non_canonical_type;
	bool need_functor;
	bool need_args;
} ML_Expand_Info;


	/* Prototypes */

void ML_expand(Word* type_info, Word *data_word_ptr, ML_Expand_Info *info);

Word * ML_create_type_info(Word *term_type_info, Word *arg_pseudo_type_info);

	/* NB. ML_arg() is also used by store__arg_ref in store.m */
bool ML_arg(Word term_type_info, Word *term, Word argument_index,
		Word *arg_type_info, Word **argument_ptr);


#line 132 "std_util.c"
#line 2 "int.opt"

	#include <limits.h>

#line 137 "std_util.c"
#line 2 "require.opt"
#include <stdio.h>
#line 140 "std_util.c"
#line 3 "string.opt"

#include <string.h>
#include <stdio.h>

#line 146 "std_util.c"

Declare_static(mercury____Index___std_util__pair_1__ua10000_2_0);
Declare_static(mercury____Index___std_util__pair_2__ua10000_2_0);
Declare_static(mercury____Index___std_util__maybe_1__ua10000_2_0);
Declare_label(mercury____Index___std_util__maybe_1__ua10000_2_0_i3);
Declare_static(mercury__std_util__list__foldl__ua10001_4_0);
Declare_label(mercury__std_util__list__foldl__ua10001_4_0_i1001);
Declare_label(mercury__std_util__list__foldl__ua10001_4_0_i4);
Declare_label(mercury__std_util__list__foldl__ua10001_4_0_i3);
Declare_static(mercury__std_util__list__foldl__ua10000_4_0);
Declare_label(mercury__std_util__list__foldl__ua10000_4_0_i1001);
Declare_label(mercury__std_util__list__foldl__ua10000_4_0_i4);
Declare_label(mercury__std_util__list__foldl__ua10000_4_0_i3);
Declare_static(mercury__std_util__cons__ua10000_3_0);
Declare_static(mercury__fn__std_util__type_of__ua10000_1_0);
Declare_static(mercury__std_util__maybe_pred__ua10000_3_0);
Declare_label(mercury__std_util__maybe_pred__ua10000_3_0_i4);
Declare_label(mercury__std_util__maybe_pred__ua10000_3_0_i2);
Declare_static(mercury__std_util__aggregate__ua10003_4_0);
Declare_label(mercury__std_util__aggregate__ua10003_4_0_i2);
Declare_label(mercury__std_util__aggregate__ua10003_4_0_i3);
Declare_label(mercury__std_util__aggregate__ua10003_4_0_i4);
Declare_static(mercury__std_util__aggregate__ua10002_4_0);
Declare_label(mercury__std_util__aggregate__ua10002_4_0_i2);
Declare_label(mercury__std_util__aggregate__ua10002_4_0_i3);
Declare_label(mercury__std_util__aggregate__ua10002_4_0_i4);
Declare_static(mercury__std_util__aggregate__ua10001_4_0);
Declare_label(mercury__std_util__aggregate__ua10001_4_0_i2);
Declare_label(mercury__std_util__aggregate__ua10001_4_0_i3);
Declare_label(mercury__std_util__aggregate__ua10001_4_0_i4);
Declare_static(mercury__std_util__aggregate__ua10000_4_0);
Declare_label(mercury__std_util__aggregate__ua10000_4_0_i2);
Declare_label(mercury__std_util__aggregate__ua10000_4_0_i3);
Declare_label(mercury__std_util__aggregate__ua10000_4_0_i4);
Define_extern_entry(mercury__std_util__type_to_univ_2_2);
Declare_label(mercury__std_util__type_to_univ_2_2_i1);
Define_extern_entry(mercury__std_util__type_to_univ_2_0);
Define_extern_entry(mercury__std_util__type_to_univ_2_1);
Define_extern_entry(mercury__std_util__univ_to_type_2_0);
Declare_label(mercury__std_util__univ_to_type_2_0_i1);
Define_extern_entry(mercury__std_util__univ_to_type_2_1);
Define_extern_entry(mercury__std_util__univ_to_type_2_2);
Define_extern_entry(mercury__fn__std_util__univ_1_2);
Declare_label(mercury__fn__std_util__univ_1_2_i1);
Define_extern_entry(mercury__fn__std_util__univ_1_0);
Define_extern_entry(mercury__fn__std_util__univ_1_1);
Define_extern_entry(mercury__fn__std_util__univ_type_1_0);
Define_extern_entry(mercury__std_util__solutions_2_0);
Declare_label(mercury__std_util__solutions_2_0_i2);
Declare_label(mercury__std_util__solutions_2_0_i3);
Define_extern_entry(mercury__std_util__solutions_2_1);
Declare_label(mercury__std_util__solutions_2_1_i2);
Declare_label(mercury__std_util__solutions_2_1_i3);
Define_extern_entry(mercury__std_util__solutions_set_2_0);
Declare_label(mercury__std_util__solutions_set_2_0_i2);
Define_extern_entry(mercury__std_util__solutions_set_2_1);
Declare_label(mercury__std_util__solutions_set_2_1_i2);
Define_extern_entry(mercury__std_util__unsorted_solutions_2_0);
Declare_label(mercury__std_util__unsorted_solutions_2_0_i2);
Define_extern_entry(mercury__std_util__unsorted_solutions_2_1);
Declare_label(mercury__std_util__unsorted_solutions_2_1_i2);
Define_extern_entry(mercury__std_util__aggregate_4_0);
Define_extern_entry(mercury__std_util__aggregate_4_1);
Define_extern_entry(mercury__std_util__aggregate_4_2);
Define_extern_entry(mercury__std_util__aggregate_4_3);
Define_extern_entry(mercury__std_util__unsorted_aggregate_4_0);
Declare_label(mercury__std_util__unsorted_aggregate_4_0_i2);
Define_extern_entry(mercury__std_util__unsorted_aggregate_4_1);
Declare_label(mercury__std_util__unsorted_aggregate_4_1_i2);
Define_extern_entry(mercury__std_util__unsorted_aggregate_4_2);
Declare_label(mercury__std_util__unsorted_aggregate_4_2_i2);
Define_extern_entry(mercury__std_util__unsorted_aggregate_4_3);
Declare_label(mercury__std_util__unsorted_aggregate_4_3_i2);
Define_extern_entry(mercury__std_util__unsorted_aggregate_4_4);
Declare_label(mercury__std_util__unsorted_aggregate_4_4_i2);
Define_extern_entry(mercury__std_util__unsorted_aggregate_4_5);
Declare_label(mercury__std_util__unsorted_aggregate_4_5_i2);
Define_extern_entry(mercury__std_util__maybe_pred_3_0);
Define_extern_entry(mercury__std_util__semidet_succeed_0_0);
Declare_label(mercury__std_util__semidet_succeed_0_0_i1);
Define_extern_entry(mercury__std_util__semidet_fail_0_0);
Declare_label(mercury__std_util__semidet_fail_0_0_i1);
Define_extern_entry(mercury__std_util__cc_multi_equal_2_0);
Define_extern_entry(mercury__std_util__cc_multi_equal_2_1);
Define_extern_entry(mercury__fn__std_util__type_of_1_0);
Declare_label(mercury__fn__std_util__type_of_1_0_i2);
Define_extern_entry(mercury__fn__std_util__type_name_1_0);
Declare_label(mercury__fn__std_util__type_name_1_0_i2);
Declare_label(mercury__fn__std_util__type_name_1_0_i5);
Declare_label(mercury__fn__std_util__type_name_1_0_i9);
Declare_label(mercury__fn__std_util__type_name_1_0_i15);
Declare_label(mercury__fn__std_util__type_name_1_0_i16);
Declare_label(mercury__fn__std_util__type_name_1_0_i10);
Declare_label(mercury__fn__std_util__type_name_1_0_i17);
Declare_label(mercury__fn__std_util__type_name_1_0_i18);
Declare_label(mercury__fn__std_util__type_name_1_0_i20);
Declare_label(mercury__fn__std_util__type_name_1_0_i25);
Define_extern_entry(mercury__std_util__type_ctor_and_args_3_0);
Define_extern_entry(mercury__fn__std_util__type_ctor_1_0);
Define_extern_entry(mercury__fn__std_util__type_args_1_0);
Define_extern_entry(mercury__fn__std_util__type_ctor_name_1_0);
Define_extern_entry(mercury__fn__std_util__type_ctor_module_name_1_0);
Define_extern_entry(mercury__fn__std_util__type_ctor_arity_1_0);
Define_extern_entry(mercury__std_util__type_ctor_name_and_arity_4_0);
Define_extern_entry(mercury__fn__std_util__make_type_2_0);
Declare_label(mercury__fn__std_util__make_type_2_0_i1);
Define_extern_entry(mercury__fn__std_util__make_type_2_1);
Define_extern_entry(mercury__fn__std_util__det_make_type_2_0);
Declare_label(mercury__fn__std_util__det_make_type_2_0_i2);
Define_extern_entry(mercury__fn__std_util__num_functors_1_0);
Define_extern_entry(mercury__std_util__get_functor_5_0);
Declare_label(mercury__std_util__get_functor_5_0_i1);
Define_extern_entry(mercury__fn__std_util__construct_3_0);
Declare_label(mercury__fn__std_util__construct_3_0_i1);
Define_extern_entry(mercury__std_util__functor_3_0);
Define_extern_entry(mercury__fn__std_util__arg_2_0);
Declare_label(mercury__fn__std_util__arg_2_0_i1);
Define_extern_entry(mercury__fn__std_util__argument_2_0);
Declare_label(mercury__fn__std_util__argument_2_0_i1);
Define_extern_entry(mercury__fn__std_util__det_arg_2_0);
Declare_label(mercury__fn__std_util__det_arg_2_0_i4);
Declare_label(mercury__fn__std_util__det_arg_2_0_i3);
Declare_label(mercury__fn__std_util__det_arg_2_0_i5);
Define_extern_entry(mercury__fn__std_util__det_argument_2_0);
Declare_label(mercury__fn__std_util__det_argument_2_0_i2);
Define_extern_entry(mercury__std_util__deconstruct_4_0);
Define_extern_entry(mercury__std_util__builtin_solutions_2_0);
Define_extern_entry(mercury__std_util__builtin_solutions_2_1);
Declare_static(mercury__std_util__cons_3_0);
Declare_static(mercury__std_util__type_arg_names_3_0);
Declare_label(mercury__std_util__type_arg_names_3_0_i3);
Declare_label(mercury__std_util__type_arg_names_3_0_i4);
Declare_label(mercury__std_util__type_arg_names_3_0_i5);
Declare_label(mercury__std_util__type_arg_names_3_0_i13);
Declare_label(mercury__std_util__type_arg_names_3_0_i8);
Declare_label(mercury__std_util__type_arg_names_3_0_i14);
Define_extern_entry(mercury____Unify___std_util__maybe_1_0);
Declare_label(mercury____Unify___std_util__maybe_1_0_i3);
Declare_label(mercury____Unify___std_util__maybe_1_0_i1);
Define_extern_entry(mercury____Index___std_util__maybe_1_0);
Define_extern_entry(mercury____Compare___std_util__maybe_1_0);
Declare_label(mercury____Compare___std_util__maybe_1_0_i3);
Declare_label(mercury____Compare___std_util__maybe_1_0_i2);
Declare_label(mercury____Compare___std_util__maybe_1_0_i5);
Declare_label(mercury____Compare___std_util__maybe_1_0_i4);
Declare_label(mercury____Compare___std_util__maybe_1_0_i6);
Declare_label(mercury____Compare___std_util__maybe_1_0_i8);
Declare_label(mercury____Compare___std_util__maybe_1_0_i13);
Declare_label(mercury____Compare___std_util__maybe_1_0_i10);
Define_extern_entry(mercury____Unify___std_util__unit_0_0);
Declare_label(mercury____Unify___std_util__unit_0_0_i1);
Define_extern_entry(mercury____Index___std_util__unit_0_0);
Define_extern_entry(mercury____Compare___std_util__unit_0_0);
Define_extern_entry(mercury____Unify___std_util__pair_2_0);
Declare_label(mercury____Unify___std_util__pair_2_0_i2);
Declare_label(mercury____Unify___std_util__pair_2_0_i1);
Define_extern_entry(mercury____Index___std_util__pair_2_0);
Define_extern_entry(mercury____Compare___std_util__pair_2_0);
Declare_label(mercury____Compare___std_util__pair_2_0_i4);
Declare_label(mercury____Compare___std_util__pair_2_0_i9);
Define_extern_entry(mercury____Unify___std_util__pair_1_0);
Declare_label(mercury____Unify___std_util__pair_1_0_i2);
Declare_label(mercury____Unify___std_util__pair_1_0_i1);
Define_extern_entry(mercury____Index___std_util__pair_1_0);
Define_extern_entry(mercury____Compare___std_util__pair_1_0);
Define_extern_entry(mercury____Unify___std_util__type_ctor_info_0_0);
Define_extern_entry(mercury____Index___std_util__type_ctor_info_0_0);
Define_extern_entry(mercury____Compare___std_util__type_ctor_info_0_0);
#line 2230 "std_util.m"


static void ML_expand_const(Word data_value, Word entry_value,
	ML_Expand_Info *info);
static void ML_expand_enum(Word data_value, Word entry_value, 
	ML_Expand_Info *info);
static void ML_expand_simple(Word data_value, Word* arg_type_infos, 
	Word * type_info, ML_Expand_Info *info);
static void ML_expand_builtin(Word data_value, Word entry_value,
	ML_Expand_Info *info);
static void ML_expand_complicated(Word data_value, Word entry_value, 
	Word * type_info, ML_Expand_Info *info);

Declare_entry(mercury__builtin_compare_pred_3_0);
Declare_entry(mercury__builtin_compare_non_canonical_type_3_0);

/*
** Expand the given data using its type_info, find its
** functor, arity, argument vector and type_info vector.
** 
** The info.type_info_vector is allocated using malloc 
** It is the responsibility of the  caller to free this
** memory, and to copy any fields of this vector to
** the Mercury heap. The type_infos that the elements of
** this vector point to are either
** 	- already allocated on the heap.
** 	- constants (eg base_type_infos)
**
** Please note: 
**	ML_expand increments the heap pointer, however, on
**	some platforms the register windows mean that transient
**	Mercury registers may be lost. Before calling ML_expand,
**	call save_transient_registers(), and afterwards, call
**	restore_transient_registers().
**
** 	If writing a C function that calls deep_copy, make sure you
** 	document that around your function, save_transient_registers()
** 	restore_transient_registers() need to be used.
*/

void 
ML_expand(Word* type_info, Word *data_word_ptr, ML_Expand_Info *info)
{
	Code *compare_pred;
	Word *base_type_info, *arg_type_info;
	Word data_value, entry_value, base_type_layout_entry;
	int entry_tag, data_tag; 
	Word data_word;

	base_type_info = MR_TYPEINFO_GET_BASE_TYPEINFO(type_info);

	compare_pred = (Code *) base_type_info[OFFSET_FOR_COMPARE_PRED];
	info->non_canonical_type = ( compare_pred ==
		ENTRY(mercury__builtin_compare_non_canonical_type_3_0) );

	data_word = *data_word_ptr;
	data_tag = tag(data_word);
	data_value = body(data_word, data_tag);
	
	base_type_layout_entry = MR_BASE_TYPEINFO_GET_TYPELAYOUT_ENTRY(
		base_type_info, data_tag);

	entry_tag = tag(base_type_layout_entry);
	entry_value = body(base_type_layout_entry, entry_tag);
	
	switch(entry_tag) {

	case TYPELAYOUT_CONST_TAG: /* case TYPELAYOUT_COMP_CONST_TAG: */

		/* 
		** This tag represents builtins, enums or complicated
		** constants.
		*/ 

		if (TYPEINFO_IS_VARIABLE(entry_value)) {

			/* 
			** It's a builtin, the rest of the layout 
			** entry value represents the type of builtin.
			*/
			entry_value = unmkbody(entry_value);
			ML_expand_builtin(data_word, entry_value,
				info);
		} else {
			/* It's a complicated constant or enum */
			if (MR_TYPELAYOUT_ENUM_VECTOR_IS_ENUM(entry_value)) {
				ML_expand_enum(data_word, entry_value, 
					info);
			} else {
				data_value = unmkbody(data_value);
				ML_expand_const(data_value, entry_value, 
					info);
			}
		}
		break;

	case TYPELAYOUT_SIMPLE_TAG:
		ML_expand_simple(data_value, (Word *) entry_value, 
			type_info, info);
		break;

	case TYPELAYOUT_COMPLICATED_TAG:
		ML_expand_complicated(data_value, entry_value, type_info,
			info);
		break;

	case TYPELAYOUT_EQUIV_TAG: /* case TYPELAYOUT_NO_TAG: */

			/* 
			** Is it a type variable? 
			*/
		if (TYPEINFO_IS_VARIABLE(entry_value)) {
			arg_type_info = ML_create_type_info(type_info, 
				(Word *) entry_value);
			ML_expand(arg_type_info, data_word_ptr, info);
		}
			/* 
			** is it a no_tag type?
			*/
		else if (MR_TYPELAYOUT_NO_TAG_VECTOR_IS_NO_TAG(entry_value)) {
			ML_expand_simple((Word) data_word_ptr,
				(Word *) entry_value, type_info, info);
		}
			/* 
			** It must be an equivalent type.
			*/
		else {
			arg_type_info = ML_create_type_info(type_info, 
				(Word *) MR_TYPELAYOUT_EQUIV_TYPE(
					entry_value));
			ML_expand(arg_type_info, data_word_ptr, info);
		}

		break;

	default:
		/* If this happens, the layout data is corrupt */

		fatal_error("ML_expand: found unused tag value");
	}
}

/*
 * Expand a constant value.
 */

void
ML_expand_const(Word data_value, Word entry_value, ML_Expand_Info *info) 
{

	/* the functors are stored after the enum_indicator and
	 * the number of functors
	 */
	info->functor = MR_TYPELAYOUT_ENUM_VECTOR_FUNCTOR_NAME(entry_value,
		data_value);
	info->arity = 0;
	info->argument_vector = NULL;
	info->type_info_vector = NULL;
}


/*
 * Expand an enum.
 */

void
ML_expand_enum(Word data_value, Word enum_vector, ML_Expand_Info *info) 
{
	info->functor = MR_TYPELAYOUT_ENUM_VECTOR_FUNCTOR_NAME(enum_vector,
		data_value);
	info->arity = 0;
	info->argument_vector = NULL;
	info->type_info_vector = NULL;
}


/*
 * Expand a functor with arguments, which has a simple tag.
 *
 * Simple tags - type_layout points to an array containing
 * the arity, then a pseudo-typeinfo for each argument, and type_info is
 * the current type_info (the type of this data item).
 *
 * Data word points to an array of argument data.
 *
 */
void 
ML_expand_simple(Word data_value, Word* simple_vector, Word * type_info,
	ML_Expand_Info *info)
{
	int i;

	info->arity = MR_TYPELAYOUT_SIMPLE_VECTOR_ARITY(simple_vector);
	
	if (info->need_functor) {
		make_aligned_string(info->functor, 
			MR_TYPELAYOUT_SIMPLE_VECTOR_FUNCTOR_NAME(
				simple_vector));
	}

	if (info->need_args) {
		info->argument_vector = (Word *) data_value;

		info->type_info_vector = 
			checked_malloc(info->arity * sizeof(Word));

		for (i = 0; i < info->arity ; i++) {
			Word *arg_pseudo_type_info;

			arg_pseudo_type_info = (Word *)
				MR_TYPELAYOUT_SIMPLE_VECTOR_ARGS(
					simple_vector)[i];
			info->type_info_vector[i] = (Word) 
				ML_create_type_info(type_info, 
					arg_pseudo_type_info);
		}
	}
}

/*
 * Complicated tags - entry_value points to a vector containing: 
 *	The number of sharers of this tag
 *	A pointer to a simple tag structure (see mercury_print_simple)
 *	for each sharer.
 *
 *	The data_value points to the actual sharer of this tag, 
 *	which should be used as an index into the vector of pointers
 *	into simple tag structures. The next n words the data_value
 *	points to are the arguments of the functor.
 */

void
ML_expand_complicated(Word data_value, Word entry_value, Word * type_info,
	ML_Expand_Info *info)
{
	Word new_data_value, simple_vector, simple_vector_tag, secondary_tag;

	secondary_tag = ((Word *) data_value)[0];
	new_data_value = (Word) ((Word *) data_value + 1);

	simple_vector = MR_TYPELAYOUT_COMPLICATED_VECTOR_GET_SIMPLE_VECTOR(
		entry_value, secondary_tag);
	simple_vector_tag = tag(simple_vector);
	simple_vector = body(simple_vector, simple_vector_tag);

	ML_expand_simple(new_data_value, (Word *) simple_vector, 
		type_info, info);
}

void
ML_expand_builtin(Word data_value, Word entry_value, ML_Expand_Info *info)
{
	switch ((int) entry_value) {
	
	case TYPELAYOUT_UNASSIGNED_VALUE:
		fatal_error("ML_expand: attempt to use an UNASSIGNED tag");
		break;

	case TYPELAYOUT_UNUSED_VALUE:
		fatal_error("ML_expand: attempt to use an UNUSED tag");
		break;

	case TYPELAYOUT_STRING_VALUE:
		/* XXX should escape characters correctly */

		if (info->need_functor) {
			char *str;

			incr_saved_hp_atomic(LVALUE_CAST(Word, str),
				(strlen((String) data_value) + 2 + 
					sizeof(Word)) / sizeof(Word));
			sprintf(str, "%c%s%c", '"', 
				(String) data_value, '"');
			info->functor = str;
		}
		info->argument_vector = NULL;
		info->type_info_vector = NULL;
		info->arity = 0;
		break;

	case TYPELAYOUT_FLOAT_VALUE:
		if (info->need_functor) {
			char buf[500];
			Float f;
			char *str;

			f = word_to_float(data_value);
			sprintf(buf, "%#.15g", f);
			incr_saved_hp_atomic(LVALUE_CAST(Word, str), 
				(strlen(buf) + sizeof(Word)) / sizeof(Word));
			strcpy(str, buf);
			info->functor = str;
		}
		info->argument_vector = NULL;
		info->type_info_vector = NULL;
		info->arity = 0;
		break;

	case TYPELAYOUT_INT_VALUE:
		if (info->need_functor) {
			char buf[500];
			char *str;

			sprintf(buf, "%ld", (long) data_value);
			incr_saved_hp_atomic(LVALUE_CAST(Word, str), 
				(strlen(buf) + sizeof(Word)) / sizeof(Word));
			strcpy(str, buf);
			info->functor = str;
		}

		info->argument_vector = NULL;
		info->type_info_vector = NULL;
		info->arity = 0;
		break;

	case TYPELAYOUT_CHARACTER_VALUE:
		/* XXX should escape characters correctly */

		if (info->need_functor) {
			char *str;

			incr_saved_hp_atomic(LVALUE_CAST(Word, str), 
				(3 + sizeof(Word)) / sizeof(Word));
			sprintf(str, "'%c'", (char) data_value);
			info->functor = str;
		}
		info->argument_vector = NULL;
		info->type_info_vector = NULL;
		info->arity = 0;
		break;

	case TYPELAYOUT_UNIV_VALUE:

		/* Univ is a two word structure, containing
		 * type_info and data.
		 */

		ML_expand((Word *) 
			((Word *) data_value)[UNIV_OFFSET_FOR_TYPEINFO], 
			&((Word *) data_value)[UNIV_OFFSET_FOR_DATA], info);
		break;

	case TYPELAYOUT_PREDICATE_VALUE:
		if (info->need_functor) {
			make_aligned_string(info->functor, "<<predicate>>");
		}
		info->argument_vector = NULL;
		info->type_info_vector = NULL;
		info->arity = 0;
		break;

	case TYPELAYOUT_VOID_VALUE:
		fatal_error("ML_expand: found void");
		break;

	case TYPELAYOUT_ARRAY_VALUE:
		fatal_error("ML_expand: found array");
		break;

	case TYPELAYOUT_TYPEINFO_VALUE:
		fatal_error("ML_expand: found type_info");
		break;

	case TYPELAYOUT_C_POINTER_VALUE:
		fatal_error("ML_expand: found c_pointer");
		break;
		
		
	default:
		fatal_error("ML_expand: invalid tag value");
		break;
	}
}


	/* 
	** Given a type_info (term_type_info) which contains a
	** base_type_info pointer and possibly other type_infos
	** giving the values of the type parameters of this type,
	** and a pseudo-type_info (arg_pseudo_type_info), which contains a
	** base_type_info pointer and possibly other type_infos
	** giving EITHER
	** 	- the values of the type parameters of this type,
	** or	- an indication of the type parameter of the
	** 	  term_type_info that should be substituted here
	**
	** This returns a fully instantiated type_info, a version of the
	** arg_pseudo_type_info with all the type variables filled in.
	**
	** We allocate memory for a new type_info on the Mercury heap,
	** copy the necessary information, and return a pointer to the
	** new type_info. 
	**
	** In the case where the argument's pseudo_type_info is a
	** base_type_info with no arguments, we don't copy the
	** base_type_info - we just return a pointer to it - no memory
	** is allocated. The caller can check this by looking at the
	** first cell of the returned pointer - if it is zero, this is a
	** base_type_info. Otherwise, it is an allocated copy of a
	** type_info.
	**
	** NOTE: If you are changing this code, you might also need
	** to change the code in make_type_info in runtime/deep_copy.c,
	** which does much the same thing, only allocating using malloc
	** instead of on the heap.
	*/

Word * 
ML_create_type_info(Word *term_type_info, Word *arg_pseudo_type_info)
{
	int i, arity, extra_args;
	Word *base_type_info;
	Word *type_info;

		/* 
		** The arg_pseudo_type_info might be a polymorphic variable,
		** if so - substitute.
		*/

	if (TYPEINFO_IS_VARIABLE(arg_pseudo_type_info)) {
		arg_pseudo_type_info = (Word *) 
			term_type_info[(Word) arg_pseudo_type_info];
	}

	if (TYPEINFO_IS_VARIABLE(arg_pseudo_type_info)) {
		fatal_error("ML_create_type_info: unbound type variable");
	}

	base_type_info = MR_TYPEINFO_GET_BASE_TYPEINFO(arg_pseudo_type_info);

		/* no arguments - optimise common case */
	if (base_type_info == arg_pseudo_type_info) {
		return arg_pseudo_type_info;
	}

	if (MR_BASE_TYPEINFO_IS_HO(base_type_info)) {
		arity = MR_TYPEINFO_GET_HIGHER_ARITY(arg_pseudo_type_info);
		extra_args = 2;
	} else {
		arity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(base_type_info);
		extra_args = 1;
	}


		/* 
		** Check for type variables -- if there are none,
		** we don't need to create a new type_info.
		*/
	for (i = arity + extra_args - 1; i >= extra_args; i--) {
		if (TYPEINFO_IS_VARIABLE(arg_pseudo_type_info[i])) {
			break;
		}
	}

		/*
		** Do we need to create a new type_info?
		*/
	if (i >= extra_args) {
		incr_saved_hp(LVALUE_CAST(Word, type_info), arity + extra_args);

			/* 
			** Copy any preliminary arguments to the type_info 
			** (this means the base_type_info and possibly
			** arity for higher order terms).
			*/ 
		for (i = 0; i < extra_args; i++) {
			type_info[i] = arg_pseudo_type_info[i];
		}

			/*
			** Copy type arguments, substituting for any 
			** type variables.
			*/
		for (i = extra_args; i < arity + extra_args; i++) {
			if (TYPEINFO_IS_VARIABLE(arg_pseudo_type_info[i])) {
				type_info[i] = term_type_info[
					arg_pseudo_type_info[i]];
				if (TYPEINFO_IS_VARIABLE(type_info[i])) {
					fatal_error("ML_create_type_info: "
						"unbound type variable");
				}

			} else {
				type_info[i] = arg_pseudo_type_info[i];
			}
		}
		return type_info;
	} else {
		return arg_pseudo_type_info;
	}
}

/*
** ML_arg() is a subroutine used to implement arg/2, argument/2,
** and also store__arg_ref/5 in store.m.
** It takes a term (& its type), and an argument index,
** and returns a
*/
bool
ML_arg(Word term_type_info, Word *term_ptr, Word argument_index,
	Word *arg_type_info, Word **argument_ptr)
{
	ML_Expand_Info info;
	Word arg_pseudo_type_info;
	bool success;

	info.need_functor = FALSE;
	info.need_args = TRUE;

	ML_expand((Word *) term_type_info, term_ptr, &info);

		/*
		** Check for attempts to deconstruct a non-canonical type:
		** such deconstructions must be cc_multi, and since
		** arg/2 is det, we must treat violations of this
		** as runtime errors.
		** (There ought to be a cc_multi version of arg/2
		** that allows this.)
		*/
	if (info.non_canonical_type) {
		fatal_error("called argument/2 for a type with a "
			"user-defined equality predicate");
	}

		/* Check range */
	success = (argument_index >= 0 && argument_index < info.arity);
	if (success) {
			/* figure out the type of the argument */
		arg_pseudo_type_info = info.type_info_vector[argument_index];
		if (TYPEINFO_IS_VARIABLE(arg_pseudo_type_info)) {
			*arg_type_info =
				((Word *) term_type_info)[arg_pseudo_type_info];
		} else {
			*arg_type_info = arg_pseudo_type_info;
		}

		*argument_ptr = &info.argument_vector[argument_index];
	}

	/*
	** Free the allocated type_info_vector, since we just copied
	** the stuff we want out of it.
	*/
	free(info.type_info_vector);

	return success;
}


#line 865 "std_util.c"
#line 1791 "std_util.m"


	/* 
	** Prototypes
	*/

static int 	ML_get_functor_info(Word type_info, int functor_number, 
				ML_Construct_Info *info);

	/*
	** ML_get_functor_info:
	**
	** Extract the information for functor number `functor_number',
	** for the type represented by type_info.
	** We succeed if the type is some sort of discriminated union.
	**
	** You need to save and restore transient registers around
	** calls to this function.
	*/

int 
ML_get_functor_info(Word type_info, int functor_number, ML_Construct_Info *info)
{
	Word *base_type_functors;

	base_type_functors = MR_BASE_TYPEINFO_GET_TYPEFUNCTORS(
		MR_TYPEINFO_GET_BASE_TYPEINFO((Word *) type_info));

	info->vector_type = MR_TYPEFUNCTORS_INDICATOR(base_type_functors);

	switch (info->vector_type) {

	case MR_TYPEFUNCTORS_ENUM:
		info->functors_vector = MR_TYPEFUNCTORS_ENUM_FUNCTORS(
				base_type_functors);
		info->arity = 0;
		info->argument_vector = NULL;
		info->primary_tag = 0;
		info->secondary_tag = functor_number;
		info->functor_name = MR_TYPELAYOUT_ENUM_VECTOR_FUNCTOR_NAME(
				info->functors_vector, functor_number);
		break; 

	case MR_TYPEFUNCTORS_DU:
		info->functors_vector = MR_TYPEFUNCTORS_DU_FUNCTOR_N(
				base_type_functors, functor_number);
		info->arity = MR_TYPELAYOUT_SIMPLE_VECTOR_ARITY(
			info->functors_vector);
		info->argument_vector = MR_TYPELAYOUT_SIMPLE_VECTOR_ARGS(
				info->functors_vector);
		info->primary_tag = tag(MR_TYPELAYOUT_SIMPLE_VECTOR_TAG(
			info->functors_vector));
		info->secondary_tag = unmkbody(
			body(MR_TYPELAYOUT_SIMPLE_VECTOR_TAG(
				info->functors_vector), info->primary_tag));
		info->functor_name = MR_TYPELAYOUT_SIMPLE_VECTOR_FUNCTOR_NAME(
				info->functors_vector);
		break; 

	case MR_TYPEFUNCTORS_NO_TAG:
		info->functors_vector = MR_TYPEFUNCTORS_NO_TAG_FUNCTOR(
				base_type_functors);
		info->arity = 1;
		info->argument_vector = MR_TYPELAYOUT_NO_TAG_VECTOR_ARGS(
				info->functors_vector);
		info->primary_tag = 0;
		info->secondary_tag = 0;
		info->functor_name = MR_TYPELAYOUT_NO_TAG_VECTOR_FUNCTOR_NAME(
				info->functors_vector);
		break; 

	case MR_TYPEFUNCTORS_EQUIV: {
		Word *equiv_type;
		equiv_type = (Word *) MR_TYPEFUNCTORS_EQUIV_TYPE(
				base_type_functors);
		return ML_get_functor_info((Word)
				ML_create_type_info((Word *) type_info, 
						equiv_type),
				functor_number, info);
	}
	case MR_TYPEFUNCTORS_SPECIAL:
		return FALSE;
	case MR_TYPEFUNCTORS_UNIV:
		return FALSE;
	default:
		fatal_error("std_util:construct - unexpected type.");
	}

	return TRUE;
}

	/*
	** ML_typecheck_arguments:
	**
	** Given a list of univs (`arg_list'), and an vector of
	** type_infos (`arg_vector'), checks that they are all of the
	** same type; if so, returns TRUE, otherwise returns FALSE;
	** `arg_vector' may contain type variables, these
	** will be filled in by the type arguments of `type_info'.
	**
	** Assumes the length of the list has already been checked.
	**
	** You need to save and restore transient registers around
	** calls to this function.
	*/

bool
ML_typecheck_arguments(Word type_info, int arity, Word arg_list,
		Word* arg_vector) 
{
	int i, comp;
	Word arg_type_info, list_arg_type_info;

		/* Type check list of arguments */

	for (i = 0; i < arity; i++) {
		if (list_is_empty(arg_list)) {
			return FALSE;
		}
		list_arg_type_info = field(0, list_head(arg_list), 
			UNIV_OFFSET_FOR_TYPEINFO);

		arg_type_info = (Word) ML_create_type_info(
			(Word *) type_info, (Word *) arg_vector[i]);

		comp = ML_compare_type_info(list_arg_type_info, arg_type_info);
		if (comp != COMPARE_EQUAL) {
			return FALSE;
		}
		arg_list = list_tail(arg_list);
	}

		/* List should now be empty */
	return list_is_empty(arg_list);
}

	/*
	** ML_copy_arguments_from_list_to_vector:
	**
	** Copy the arguments from a list of univs (`arg_list'), 
	** into the vector (`term_vector').
	**
	** Assumes the length of the list has already been checked.
	*/

void
ML_copy_arguments_from_list_to_vector(int arity, Word arg_list,
		Word term_vector) 
{
	int i;

	for (i = 0; i < arity; i++) {
		field(mktag(0), term_vector, i) = 
			field(mktag(0), list_head(arg_list), 
				UNIV_OFFSET_FOR_DATA);
		arg_list = list_tail(arg_list);
	}
}


	/*
	** ML_make_type(arity, base_type_info, arg_types_list):
	**
	** Construct and return a type_info for a type using the
	** specified type_ctor for the type constructor,
	** and using the arguments specified in arg_types_list
	** for the type arguments (if any).
	**
	** Assumes that the arity of the type constructor represented
	** by base_type_info and the length of the arg_types_list 
	** are both equal to `arity'.
	**
	** You need to save and restore transient registers around
	** calls to this function.
	*/

Word
ML_make_type(int arity, Word *type_ctor, Word arg_types_list) 
{
	int i, extra_args;
	Word base_type_info;

	/*
	** We need to treat higher-order predicates as a special case here.
	*/
	if (MR_TYPECTOR_IS_HIGHER_ORDER(type_ctor)) {
		base_type_info = MR_TYPECTOR_GET_HOT_BASE_TYPE_INFO(type_ctor);
		extra_args = 2;
	} else {
		base_type_info = (Word) type_ctor;
		extra_args = 1;
	}

	if (arity == 0) {
		return base_type_info;
	} else {
		Word *type_info;

		restore_transient_registers();
		incr_hp(LVALUE_CAST(Word, type_info), arity + extra_args);
		save_transient_registers();
		
		field(mktag(0), type_info, 0) = base_type_info;
		if (MR_TYPECTOR_IS_HIGHER_ORDER(type_ctor)) {
			field(mktag(0), type_info, 1) = (Word) arity;
		}
		for (i = 0; i < arity; i++) {
			field(mktag(0), type_info, i + extra_args) = 
				list_head(arg_types_list);
			arg_types_list = list_tail(arg_types_list);
		}

		return (Word) type_info;
	}
}


	/*
	** ML_get_functors_check_range:
	**
	** Check that functor_number is in range, and get the functor
	** info if it is. Return FALSE if it is out of range, or
	** if ML_get_functor_info returns FALSE, otherwise return TRUE.
	**
	** You need to save and restore transient registers around
	** calls to this function.
	*/

bool
ML_get_functors_check_range(int functor_number, Word type_info, 
	ML_Construct_Info *info)
{
		/* 
		** Check range of functor_number, get functors
		** vector
		*/
	return  functor_number < ML_get_num_functors(type_info) &&
		functor_number >= 0 &&
		ML_get_functor_info(type_info, functor_number, info);
}


	/* 
	** ML_copy_argument_typeinfos:
	**
	** Copy `arity' type_infos from `arg_vector' onto the heap
	** in a list. 
	** 
	** You need to save and restore transient registers around
	** calls to this function.
	*/

Word 
ML_copy_argument_typeinfos(int arity, Word type_info, Word *arg_vector)
{
	Word type_info_list, *functors;

	restore_transient_registers();
	type_info_list = list_empty(); 

	while (--arity >= 0) {
		Word argument;

			/* Get the argument type_info */
		argument = arg_vector[arity];

			/* Fill in any polymorphic type_infos */
		save_transient_registers();
		argument = (Word) ML_create_type_info(
			(Word *) type_info, (Word *) argument);
		restore_transient_registers();

			/* Look past any equivalences */
		save_transient_registers();
		argument = ML_collapse_equivalences(argument);
		restore_transient_registers();

			/* Join the argument to the front of the list */
		type_info_list = list_cons(argument, type_info_list);
	}
	save_transient_registers();

	return type_info_list;
}

	/*
	** ML_collapse_equivalences:
	**
	** Keep looking past equivalences until the there are no more.
	** This only looks past equivalences of the top level type, not
	** the argument typeinfos.
	** 
	** You need to save and restore transient registers around
	** calls to this function.
	*/

Word
ML_collapse_equivalences(Word maybe_equiv_type_info) 
{
	Word *functors, equiv_type_info;
	
	functors = MR_BASE_TYPEINFO_GET_TYPEFUNCTORS(
			MR_TYPEINFO_GET_BASE_TYPEINFO((Word *) 
					maybe_equiv_type_info));

		/* Look past equivalences */
	while (MR_TYPEFUNCTORS_INDICATOR(functors) == MR_TYPEFUNCTORS_EQUIV) {
		equiv_type_info = (Word) MR_TYPEFUNCTORS_EQUIV_TYPE(functors);
		equiv_type_info = (Word) ML_create_type_info(
				(Word *) maybe_equiv_type_info, 
				(Word *) equiv_type_info);
		functors = MR_BASE_TYPEINFO_GET_TYPEFUNCTORS(
			MR_TYPEINFO_GET_BASE_TYPEINFO((Word *) 
				equiv_type_info));
		maybe_equiv_type_info = equiv_type_info;
	}

	return maybe_equiv_type_info;
}

	/* 
	** ML_get_num_functors:
	**
	** Get the number of functors for a type. If it isn't a
	** discriminated union, return -1.
	**
	** You need to save and restore transient registers around
	** calls to this function.
	*/

int 
ML_get_num_functors(Word type_info)
{
	Word *base_type_functors;
	int Functors;

	base_type_functors = MR_BASE_TYPEINFO_GET_TYPEFUNCTORS(
		MR_TYPEINFO_GET_BASE_TYPEINFO((Word *) type_info));

	switch ((int) MR_TYPEFUNCTORS_INDICATOR(base_type_functors)) {

		case MR_TYPEFUNCTORS_DU:
			Functors = MR_TYPEFUNCTORS_DU_NUM_FUNCTORS(
					base_type_functors);
			break;

		case MR_TYPEFUNCTORS_ENUM:
			Functors = MR_TYPEFUNCTORS_ENUM_NUM_FUNCTORS(
					base_type_functors);
			break;

		case MR_TYPEFUNCTORS_EQUIV: {
			Word *equiv_type;
			equiv_type = (Word *) 
				MR_TYPEFUNCTORS_EQUIV_TYPE(
					base_type_functors);
			Functors = ML_get_num_functors((Word)
					ML_create_type_info((Word *) 
						type_info, equiv_type));
			break;
		}

		case MR_TYPEFUNCTORS_SPECIAL:
			Functors = -1;
			break;

		case MR_TYPEFUNCTORS_NO_TAG:
			Functors = 1;
			break;

		case MR_TYPEFUNCTORS_UNIV:
			Functors = -1;
			break;

		default:
			fatal_error("std_util:ML_get_num_functors :"
				" unknown indicator");
	}
	return Functors;
}


#line 1249 "std_util.c"
#line 1488 "std_util.m"



Word ML_make_ctor_info(Word *type_info, Word *base_type_info)
{
	Word ctor_info = (Word) base_type_info;

	if (MR_BASE_TYPEINFO_IS_HO_PRED(base_type_info)) {
		ctor_info = MR_TYPECTOR_MAKE_PRED(
			MR_TYPEINFO_GET_HIGHER_ARITY(type_info));
		if (!MR_TYPECTOR_IS_HIGHER_ORDER(ctor_info)) {
			fatal_error("std_util:ML_make_ctor_info"
				"- arity out of range.");
		}
	} else if (MR_BASE_TYPEINFO_IS_HO_FUNC(base_type_info)) {
		ctor_info = MR_TYPECTOR_MAKE_FUNC(
			MR_TYPEINFO_GET_HIGHER_ARITY(type_info));
		if (!MR_TYPECTOR_IS_HIGHER_ORDER(ctor_info)) {
			fatal_error("std_util:ML_make_ctor_info"
				"- arity out of range.");
		}
	}
	return ctor_info;
}


#line 1277 "std_util.c"
#line 1115 "std_util.m"


/*
 * Univ has a special value reserved for its layout, since it needs to
 * be handled as a special case. See above for information on 
 * the representation of data of type `univ'.
 */

#ifdef  USE_TYPE_LAYOUT

const struct mercury_data_std_util__base_type_layout_univ_0_struct {
	TYPE_LAYOUT_FIELDS
} mercury_data_std_util__base_type_layout_univ_0 = {
	make_typelayout_for_all_tags(TYPELAYOUT_CONST_TAG, 
		mkbody(TYPELAYOUT_UNIV_VALUE))
};

const struct mercury_data_std_util__base_type_functors_univ_0_struct {
	Integer f1;
} mercury_data_std_util__base_type_functors_univ_0 = {
	MR_TYPEFUNCTORS_UNIV
};

const struct mercury_data_std_util__base_type_layout_type_info_0_struct {
	TYPE_LAYOUT_FIELDS
} mercury_data_std_util__base_type_layout_type_info_0 = {
	make_typelayout_for_all_tags(TYPELAYOUT_CONST_TAG, 
		mkbody(TYPELAYOUT_TYPEINFO_VALUE))
};

const struct mercury_data_std_util__base_type_functors_type_info_0_struct {
	Integer f1;
} mercury_data_std_util__base_type_functors_type_info_0 = {
	MR_TYPEFUNCTORS_SPECIAL
};

#endif

Define_extern_entry(mercury____Unify___std_util__univ_0_0);
Define_extern_entry(mercury____Index___std_util__univ_0_0);
Define_extern_entry(mercury____Compare___std_util__univ_0_0);
Declare_label(mercury____Compare___std_util__univ_0_0_i1);

Define_extern_entry(mercury____Unify___std_util__type_info_0_0);
Define_extern_entry(mercury____Index___std_util__type_info_0_0);
Define_extern_entry(mercury____Compare___std_util__type_info_0_0);

BEGIN_MODULE(unify_univ_module)
	init_entry(mercury____Unify___std_util__univ_0_0);
	init_entry(mercury____Index___std_util__univ_0_0);
	init_entry(mercury____Compare___std_util__univ_0_0);
	init_label(mercury____Compare___std_util__univ_0_0_i1);

	init_entry(mercury____Unify___std_util__type_info_0_0);
	init_entry(mercury____Index___std_util__type_info_0_0);
	init_entry(mercury____Compare___std_util__type_info_0_0);
BEGIN_CODE
Define_entry(mercury____Unify___std_util__univ_0_0);
{
	/*
	** Unification for univ.
	**
	** The two inputs are in the registers named by unify_input[12].
	** The success/failure indication should go in unify_output.
	*/

	Word univ1, univ2;
	Word typeinfo1, typeinfo2;
	int comp;

	univ1 = unify_input1;
	univ2 = unify_input2;

	/* First check the type_infos compare equal */
	typeinfo1 = field(mktag(0), univ1, UNIV_OFFSET_FOR_TYPEINFO);
	typeinfo2 = field(mktag(0), univ2, UNIV_OFFSET_FOR_TYPEINFO);
	save_transient_registers();
	comp = ML_compare_type_info(typeinfo1, typeinfo2);
	restore_transient_registers();
	if (comp != COMPARE_EQUAL) {
		unify_output = FALSE;
		proceed();
	}

	/*
	** Then invoke the generic unification predicate on the
	** unwrapped args
	*/
	mercury__unify__x = field(mktag(0), univ1, UNIV_OFFSET_FOR_DATA);
	mercury__unify__y = field(mktag(0), univ2, UNIV_OFFSET_FOR_DATA);
	mercury__unify__typeinfo = typeinfo1;
	{
		Declare_entry(mercury__unify_2_0);
		tailcall(ENTRY(mercury__unify_2_0),
			LABEL(mercury____Unify___std_util__univ_0_0));
	}
}

Define_entry(mercury____Index___std_util__univ_0_0);
	index_output = -1;
	proceed();

Define_entry(mercury____Compare___std_util__univ_0_0);
{
	/*
	** Comparison for univ:
	**
	** The two inputs are in the registers named by compare_input[12].
	** The result should go in compare_output.
	*/

	Word univ1, univ2;
	Word typeinfo1, typeinfo2;
	int comp;

	univ1 = compare_input1;
	univ2 = compare_input2;

	/* First compare the type_infos */
	typeinfo1 = field(mktag(0), univ1, UNIV_OFFSET_FOR_TYPEINFO);
	typeinfo2 = field(mktag(0), univ2, UNIV_OFFSET_FOR_TYPEINFO);
	save_transient_registers();
	comp = ML_compare_type_info(typeinfo1, typeinfo2);
	restore_transient_registers();
	if (comp != COMPARE_EQUAL) {
		compare_output = comp;
		proceed();
	}

	/*
	** If the types are the same, then invoke the generic compare/3
	** predicate on the unwrapped args.
	*/
#ifdef	COMPACT_ARGS
	r1 = typeinfo1;
	r3 = field(mktag(0), univ2, UNIV_OFFSET_FOR_DATA);
	r2 = field(mktag(0), univ1, UNIV_OFFSET_FOR_DATA);
	{
		Declare_entry(mercury__compare_3_0);
		tailcall(ENTRY(mercury__compare_3_0),
			LABEL(mercury____Compare___std_util__univ_0_0));
	}
#else
	r1 = typeinfo1;
	r4 = field(mktag(0), univ2, UNIV_OFFSET_FOR_DATA);
	r3 = field(mktag(0), univ1, UNIV_OFFSET_FOR_DATA);
	{
		Declare_entry(mercury__compare_3_0);
		call(ENTRY(mercury__compare_3_0),
			LABEL(mercury____Compare___std_util__univ_0_0_i1),
			LABEL(mercury____Compare___std_util__univ_0_0));
	}
#endif
}
Define_label(mercury____Compare___std_util__univ_0_0_i1);
#ifdef	COMPACT_ARGS
	fatal_error("mercury____Compare___std_util__univ_0_0_i1 reached in COMPACT_ARGS mode");
#else
	/* shuffle the return value into the right register */
	r1 = r2;
	proceed();
#endif

Define_entry(mercury____Unify___std_util__type_info_0_0);
{
	/*
	** Unification for type_info.
	**
	** The two inputs are in the registers named by unify_input[12].
	** The success/failure indication should go in unify_output.
	*/
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(unify_input1, unify_input2);
	restore_transient_registers();
	unify_output = (comp == COMPARE_EQUAL);
	proceed();
}

Define_entry(mercury____Index___std_util__type_info_0_0);
	index_output = -1;
	proceed();

Define_entry(mercury____Compare___std_util__type_info_0_0);
{
	/*
	** Comparison for type_info:
	**
	** The two inputs are in the registers named by compare_input[12].
	** The result should go in compare_output.
	*/
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(unify_input1, unify_input2);
	restore_transient_registers();
	compare_output = comp;
	proceed();
}

END_MODULE

/* Ensure that the initialization code for the above module gets run. */
/*
INIT sys_init_unify_univ_module
*/
extern ModuleFunc unify_univ_module;
void sys_init_unify_univ_module(void); /* suppress gcc -Wmissing-decl warning */
void sys_init_unify_univ_module(void) {
	unify_univ_module();
}


#line 1491 "std_util.c"
#line 942 "std_util.m"


/*
** ML_compare_type_info(type_info_1, type_info_2):
**
** Compare two type_info structures, using an arbitrary ordering
** (based on the addresses of the base_type_infos, or in
** the case of higher order types, the arity).
**
** You need to save and restore transient registers around
** calls to this function.
*/

int
ML_compare_type_info(Word t1, Word t2)
{
	Word	*type_info_1, *type_info_2;
	Word	*base_type_info_1, *base_type_info_2;
	int	num_arg_types;
	int	i;

	/* 
	** Try to optimize a common case:
	** If type_info addresses are equal, they must represent the
	** same type.
	*/
	if (t1 == t2) {
		return COMPARE_EQUAL;
	}

	/* 
	** Otherwise, we need to expand equivalence types, if any.
	*/
	type_info_1 = (Word *) ML_collapse_equivalences(t1);
	type_info_2 = (Word *) ML_collapse_equivalences(t2);

	/* 
	** Perhaps they are equal now...
	*/
	if (type_info_1 == type_info_2) {
		return COMPARE_EQUAL;
	}

	/*
	** Otherwise find the addresses of the base_type_infos,
	** and compare those.
	**
	** Note: this is an arbitrary ordering. It doesn't matter
	** what the ordering is, just so long as it is consistent.
	** ANSI C doesn't guarantee much about pointer comparisons,
	** so it is possible that this might not do the right thing
	** on some obscure systems.
	** The casts to (Word) here are in the hope of increasing
	** the chance that this will work on a segmented architecture.
	*/
	base_type_info_1 = MR_TYPEINFO_GET_BASE_TYPEINFO(type_info_1);
	base_type_info_2 = MR_TYPEINFO_GET_BASE_TYPEINFO(type_info_2);
	if ((Word) base_type_info_1 < (Word) base_type_info_2) {
		return COMPARE_LESS;
	}
	if ((Word) base_type_info_1 > (Word) base_type_info_2) {
		return COMPARE_GREATER;
	}

	/*
	** If the base_type_info addresses are equal, we don't need to
	** compare the arity of the types - they must be the same -
	** unless they are higher-order (which are all mapped to
	** pred/0). 
	** But we need to recursively compare the argument types, if any.
	*/
		/* Check for higher order */
	if (MR_BASE_TYPEINFO_IS_HO(base_type_info_1)) 
	{
		int num_arg_types_2;

			/* Get number of arguments from type_info */
		num_arg_types = field(mktag(0), type_info_1, 
			TYPEINFO_OFFSET_FOR_PRED_ARITY);

		num_arg_types_2 = field(mktag(0), type_info_2, 
			TYPEINFO_OFFSET_FOR_PRED_ARITY);

			/* Check arity */
		if (num_arg_types < num_arg_types_2) {
			return COMPARE_LESS;
		}
		if (num_arg_types > num_arg_types_2) {
			return COMPARE_GREATER;
		}

			/*
			** Increment, so arguments are at the
			** expected offset.
			*/
		type_info_1++;
		type_info_2++;
	} else {
		num_arg_types = field(mktag(0), base_type_info_1,
				OFFSET_FOR_COUNT);
	}
		/* compare the argument types */
	for (i = 0; i < num_arg_types; i++) {
		Word arg_type_info_1 = field(mktag(0), type_info_1,
			OFFSET_FOR_ARG_TYPE_INFOS + i);
		Word arg_type_info_2 = field(mktag(0), type_info_2,
			OFFSET_FOR_ARG_TYPE_INFOS + i);
		int comp = ML_compare_type_info(
				arg_type_info_1, arg_type_info_2);
		if (comp != COMPARE_EQUAL)
			return comp;
	}
	return COMPARE_EQUAL;
}


#line 1609 "std_util.c"
#line 462 "std_util.m"

 
/*
** This module defines builtin_aggregate/4 which takes a closure of type
** pred(T) in which the remaining argument is output, and backtracks over
** solutions for this, using the second argument to aggregate them however the
** user wishes.  This is basically a generalization of solutions/2.
*/
 
#include "imp.h"
#include "deep_copy.h"

Declare_entry(do_call_nondet_closure);
Declare_entry(do_call_det_closure);

Define_extern_entry(mercury__std_util__builtin_aggregate_4_0);
Define_extern_entry(mercury__std_util__builtin_aggregate_4_1);
Define_extern_entry(mercury__std_util__builtin_aggregate_4_2);
Define_extern_entry(mercury__std_util__builtin_aggregate_4_3);
Define_extern_entry(mercury__std_util__builtin_aggregate_4_4);
Define_extern_entry(mercury__std_util__builtin_aggregate_4_5);
Declare_label(mercury__std_util__builtin_aggregate_4_0_i1);
Declare_label(mercury__std_util__builtin_aggregate_4_0_i2);
Declare_label(mercury__std_util__builtin_aggregate_4_0_i3);

BEGIN_MODULE(builtin_aggregate_module)
	init_entry(mercury__std_util__builtin_aggregate_4_0);
	init_entry(mercury__std_util__builtin_aggregate_4_1);
	init_entry(mercury__std_util__builtin_aggregate_4_2);
	init_entry(mercury__std_util__builtin_aggregate_4_3);
	init_entry(mercury__std_util__builtin_aggregate_4_4);
	init_entry(mercury__std_util__builtin_aggregate_4_5);
	init_label(mercury__std_util__builtin_aggregate_4_0_i1);
	init_label(mercury__std_util__builtin_aggregate_4_0_i2);
	init_label(mercury__std_util__builtin_aggregate_4_0_i3);
BEGIN_CODE

/*
** :- pred builtin_aggregate(pred(T), pred(T,T2,T2), T2, T2).
** :- mode builtin_aggregate(pred([out/muo]) is [multi/nondet],
**		pred([in/mdi],[in/di],[out/uo]) is det, in, out) is cc_multi.
**
** Polymorphism will add two extra input parameters, type_infos for T and T2,
** which we don't use at the moment (later they could be used to find
** the address of the respective deep copy routines).
**
** The type_info structures will be in r1 and r2, the closures will be in
** r3 and r4, and the 'initial value' will be in r5, with both caling
** conventions. The output should go either in r6 (for the normal parameter
** convention) or r1 (for the compact parameter convention).
*/
 
#ifdef	COMPACT_ARGS
  #define builtin_aggregate_output	r1
#else
  #define builtin_aggregate_output	r6
#endif

#ifdef PROFILE_CALLS
  #define fallthru(target, caller) { tailcall((target), (caller)); }
#else
  #define fallthru(target, caller)
#endif

Define_entry(mercury__std_util__builtin_aggregate_4_1);
fallthru(ENTRY(mercury__std_util__builtin_aggregate_4_0),
			LABEL(mercury__std_util__builtin_aggregate_4_1))
Define_entry(mercury__std_util__builtin_aggregate_4_2);
fallthru(ENTRY(mercury__std_util__builtin_aggregate_4_0),
			LABEL(mercury__std_util__builtin_aggregate_4_2))
Define_entry(mercury__std_util__builtin_aggregate_4_3);
fallthru(ENTRY(mercury__std_util__builtin_aggregate_4_0),
			LABEL(mercury__std_util__builtin_aggregate_4_3))
Define_entry(mercury__std_util__builtin_aggregate_4_4);
fallthru(ENTRY(mercury__std_util__builtin_aggregate_4_0),
			LABEL(mercury__std_util__builtin_aggregate_4_4))
Define_entry(mercury__std_util__builtin_aggregate_4_5);
fallthru(ENTRY(mercury__std_util__builtin_aggregate_4_0),
			LABEL(mercury__std_util__builtin_aggregate_4_5))
Define_entry(mercury__std_util__builtin_aggregate_4_0);

#ifndef CONSERVATIVE_GC

#ifndef USE_TYPE_LAYOUT
	fatal_error("builtin_aggregate/4 not supported with this grade "
		    "on this system.
"
		"Try using a `.gc' (conservative gc) grade.
");
#endif

/*
** In order to implement any sort of code that requires terms to survive
** backtracking, we need to (deeply) copy them out of the heap and into some
** other area before backtracking.  The obious thing to do then is just call
** the generator predicate, let it run to completion, and copy its result into
** another memory area (call it the solutions heap) before forcing
** backtracking.  When we get the next solution, we do the same, this time
** passing the previous collection (which is still on the solutions heap) to
** the collector predicate.  If the result of this operation contains the old
** collection as a part, then the deep copy operation is smart enough
** not to copy again.  So this could be pretty efficient.
**
** But what if the collector predicate does something that copies the previous
** collection?  Then on each solution, we'll copy the previous collection to
** the heap, and then deep copy it back to the solution heap.  This means
** copying solutions order N**2 times, where N is the number of solutions.  So
** this isn't as efficient as we hoped.
**
** So we use a slightly different approach.  When we find a solution, we deep
** copy it to the solution heap.  Then, before calling the collector code, we
** sneakily swap the runtime system's notion of which is the heap and which is
** the solutions heap.  This ensures that any terms are constructed on the
** solutions heap.  When this is complete, we swap them back, and force the
** engine to backtrack to get the next solution.  And so on.  After we've
** gotten the last solution, we do another deep copy to move the solution back
** to the 'real' heap, and reset the solutions heap pointer (which of course
** reclaims all the garbage of the collection process).
**
** Note that this will work with recursive calls to builtin_aggregate as
** well.  If the recursive invocation occurs in the generator pred, there can
** be no problem because by the time the generator succeeds, the inner
** do_ call will have completed, copied its result from the solutions heap,
** and reset the solutions heap pointer.  If the recursive invocation happens
** in the collector pred, then it will happen when the heap and solutions heap
** are 'swapped.'  This will work out fine, because the real heap isn't needed
** while the collector pred is executing, and by the time the nested do_ is
** completed, the 'real' heap pointer will have been reset.
*/

/* Define a macro to swap the heap and solutions heap */
#define swap_heap_and_solutions_heap()				    do {								Word temp;							temp = (Word) heap_zone;					heap_zone = solutions_heap_zone;				LVALUE_CAST(Word, solutions_heap_zone) = temp;			temp = (Word) hp;						hp = solutions_heap_pointer;					LVALUE_CAST(Word, solutions_heap_pointer) = temp;	    } while (0)
 
/*
** Define some framevars we will be using - we need to keep the
** value of hp and the solutions hp (solhp) before we entered 
** solutions, so we can reset the hp after each solution, and
** reset the solhp after all solutions have been found.
** To do a deep copy, we need the type_info of the type of a solution,
** so we save the type_info in type_info_fv.
** Finally, we store the collection of solutions so far in sofar_fv.
*/

#define saved_hp_fv		(framevar(0))
#define saved_solhp_fv		(framevar(1))
#define collector_pred_fv	(framevar(2))
#define sofar_fv		(framevar(3))
#define element_type_info_fv	(framevar(4))
#define collection_type_info_fv	(framevar(5))
#ifdef MR_USE_TRAIL
  #define saved_trail_ticket_fv	(framevar(6))
  #define num_framevars		7
#else
  #define num_framevars		6
#endif

	/*
	** Create a nondet frame and set the failure continuation.
	** The frame slots are used to hold heap and trail states and the
	** collector pred and the collection, and type infos for copying
	** each solution, and for copying the collection back to the heap
	** when we're done.
	*/
	mkframe("builtin_aggregate", num_framevars,
		LABEL(mercury__std_util__builtin_aggregate_4_0_i3));
 
	/* save heap states */
 	saved_solhp_fv = (Word) solutions_heap_pointer; 
 	mark_hp(saved_hp_fv);

#ifdef MR_USE_TRAIL
	/* save trail state */
	MR_store_ticket(saved_trail_ticket_fv);
#endif

	/* save arguments into framevars */
	collector_pred_fv = r4;
	sofar_fv = r5;
	element_type_info_fv = r1;
	collection_type_info_fv = r2;

	/* we do not (yet) need the type_info we are passed in r1 */
	/* call the higher-order pred closure that we were passed in r3 */
	r1 = r3;
	r2 = (Word) 0;	/* the higher-order call has 0 extra input arguments */
	r3 = (Word) 1;	/* the higher-order call has 1 extra output argument */

	call(ENTRY(do_call_nondet_closure),
		LABEL(mercury__std_util__builtin_aggregate_4_0_i1),
		LABEL(mercury__std_util__builtin_aggregate_4_1));

Define_label(mercury__std_util__builtin_aggregate_4_0_i1);
{
	Word copied_solution;

	/* we found a solution (in r1) */

#ifdef MR_USE_TRAIL
	/* check for outstanding delayed goals (``floundering'') */
	MR_reset_ticket(saved_trail_ticket_fv, MR_solve);
#endif

	/* swap heaps so we build on solution heap */
	swap_heap_and_solutions_heap();
 
	/*
	** deep copy solution to the solutions heap, up to the saved_hp.
	** Note that we need to save/restore the hp register, if it
	** is transient, before/after calling deep_copy().
	*/
	save_transient_registers();
	copied_solution = deep_copy(r1, (Word *) element_type_info_fv,
			(Word *) saved_hp_fv, solutions_heap_zone->top);
	restore_transient_registers();

	/* call the collector closure */
	r1 = collector_pred_fv;
	r2 = (Word) 2;	/* higher-order call has 2 extra input args */
	r3 = (Word) 1;	/* higher-order call has 1 extra output arg */
	r4 = copied_solution;
	r5 = sofar_fv;
	call(ENTRY(do_call_det_closure),
		LABEL(mercury__std_util__builtin_aggregate_4_0_i2),
		LABEL(mercury__std_util__builtin_aggregate_4_1));
}
Define_label(mercury__std_util__builtin_aggregate_4_0_i2);
	sofar_fv = r1;
 
	/* swap heaps back the way they were */
	swap_heap_and_solutions_heap();
 
	/* look for the next solution */
	redo();
	
Define_label(mercury__std_util__builtin_aggregate_4_0_i3);
{
	Word copied_collection;

	/* there were no more solutions */

	/* reset heap */
	restore_hp(saved_hp_fv);

#ifdef MR_USE_TRAIL
	/*
	** Reset the trail.  This is necessary to undo any updates performed
	** by the called goal before it failed, and to avoid leaking memory
	** on the trail.
	*/
	MR_reset_ticket(saved_trail_ticket_fv, MR_undo);
#endif

	/*
	** deep_copy() the result to the mercury heap, copying
	** everything between where we started on the solutions
	** heap, and the top of the solutions heap.
	** Note that we need to save/restore the hp register, if it
	** is transient, before/after calling deep_copy().
	**/
	save_transient_registers();
	copied_collection = deep_copy(sofar_fv,
		    (Word *) collection_type_info_fv,
		    (Word *) saved_solhp_fv, solutions_heap_zone->top);
	restore_transient_registers();

	builtin_aggregate_output = copied_collection;

 	/* reset solutions heap to where it was before call to solutions  */
 	solutions_heap_pointer = (Word *) saved_solhp_fv;
 	
	/* discard the frame we made */
	succeed_discard();
}

#undef saved_hp_fv
#undef saved_solhp_fv
#undef collector_pred_fv
#undef sofar_fv
#undef element_type_info_fv
#undef collection_type_info_fv
#undef num_framevars

#else

/*
** The following algorithm is very straight-forward implementation
** but only works with `--gc conservative'.
** Since with conservative gc, we don't reclaim any memory on failure,
** but instead leave it to the garbage collector, there is no need to
** make deep copies of the solutions.  This is a `copy-zero' implementation ;-)
*/

#define collector_pred_fv	(framevar(0))
#define sofar_fv		(framevar(1))
#ifdef MR_USE_TRAIL
  #define saved_trail_ticket_fv	(framevar(2))
  #define num_framevars		3
#else
  #define num_framevars		2
#endif

	/* create a nondet stack frame with two slots, to hold the collector
	   pred and the collection, and set the failure continuation */
	mkframe("builtin_aggregate", num_framevars,
		LABEL(mercury__std_util__builtin_aggregate_4_0_i3));

#ifdef MR_USE_TRAIL
	/* save trail state */
	MR_store_ticket(saved_trail_ticket_fv);
#endif

	/* save our arguments in framevars */
	collector_pred_fv = r4;
	sofar_fv = r5;
 
	/* we do not (yet) need the type_info we are passed in r1 */
	/* call the higher-order pred closure that we were passed in r3 */
	r1 = r3;
	r2 = (Word) 0;	/* the higher-order call has 0 extra input arguments */
	r3 = (Word) 1;	/* the higher-order call has 1 extra output argument */
	call(ENTRY(do_call_nondet_closure),
		LABEL(mercury__std_util__builtin_aggregate_4_0_i1),
		LABEL(mercury__std_util__builtin_aggregate_4_1));

Define_label(mercury__std_util__builtin_aggregate_4_0_i1);
	/* we found a solution (in r1) */

#ifdef MR_USE_TRAIL
	/* check for outstanding delayed goals (``floundering'') */
	MR_reset_ticket(saved_trail_ticket_fv, MR_solve);
#endif

	/* setup for calling the collector closure */
	r4 = r1;	/* put solution to be collected where we need it */
	r1 = collector_pred_fv;
	r2 = (Word) 2;	/* the higher-order call has 2 extra input arguments */
	r3 = (Word) 1;	/* the higher-order call has 1 extra output argument */
	r5 = sofar_fv;

	call(ENTRY(do_call_det_closure),
		LABEL(mercury__std_util__builtin_aggregate_4_0_i2),
		LABEL(mercury__std_util__builtin_aggregate_4_1));

Define_label(mercury__std_util__builtin_aggregate_4_0_i2);
	/*
	** we inserted the solution into the collection,
	** and we've now got a new collection (in r1)
	*/
	sofar_fv = r1;

	/* look for the next solution */
 	redo();
 
Define_label(mercury__std_util__builtin_aggregate_4_0_i3);
	/* no more solutions */

#ifdef MR_USE_TRAIL
	/*
	** Reset the trail.  This is necessary to undo any updates performed
	** by the called goal before it failed, and to avoid leaking memory
	** on the trail.
	*/
	MR_reset_ticket(saved_trail_ticket_fv, MR_undo);
#endif

	/* return the collection and discard the frame we made */
	builtin_aggregate_output = sofar_fv;
 	succeed_discard();
 
#undef collector_pred_fv
#undef sofar_fv
#undef num_framevars

#endif
 
#undef builtin_aggregate_output
#undef swap_heap_and_solutions_heap

END_MODULE
 
/* Ensure that the initialization code for the above module gets run. */
/*
INIT sys_init_builtin_aggregate_module
*/
extern ModuleFunc builtin_aggregate_module;
/* the extra declaration is to suppress a gcc -Wmissing-decl warning */
void sys_init_builtin_aggregate_module(void);
void sys_init_builtin_aggregate_module(void) {
	builtin_aggregate_module();
}


#line 2003 "std_util.c"

extern const struct mercury_data_std_util__base_type_layout_maybe_1_struct
	mercury_data_std_util__base_type_layout_maybe_1;
extern const struct mercury_data_std_util__base_type_functors_maybe_1_struct
	mercury_data_std_util__base_type_functors_maybe_1;
const struct mercury_data_std_util__base_type_info_maybe_1_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_std_util__base_type_info_maybe_1 = {
	(Integer) 1,
	ENTRY(mercury____Unify___std_util__maybe_1_0),
	ENTRY(mercury____Index___std_util__maybe_1_0),
	ENTRY(mercury____Compare___std_util__maybe_1_0),
	(const Word *) &mercury_data_std_util__base_type_layout_maybe_1,
	(const Word *) &mercury_data_std_util__base_type_functors_maybe_1,
	(const Word *) string_const("std_util", 8),
	(const Word *) string_const("maybe", 5)
};

extern const struct mercury_data_std_util__base_type_layout_pair_1_struct
	mercury_data_std_util__base_type_layout_pair_1;
extern const struct mercury_data_std_util__base_type_functors_pair_1_struct
	mercury_data_std_util__base_type_functors_pair_1;
const struct mercury_data_std_util__base_type_info_pair_1_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_std_util__base_type_info_pair_1 = {
	(Integer) 1,
	ENTRY(mercury____Unify___std_util__pair_1_0),
	ENTRY(mercury____Index___std_util__pair_1_0),
	ENTRY(mercury____Compare___std_util__pair_1_0),
	(const Word *) &mercury_data_std_util__base_type_layout_pair_1,
	(const Word *) &mercury_data_std_util__base_type_functors_pair_1,
	(const Word *) string_const("std_util", 8),
	(const Word *) string_const("pair", 4)
};

extern const struct mercury_data_std_util__base_type_layout_pair_2_struct
	mercury_data_std_util__base_type_layout_pair_2;
extern const struct mercury_data_std_util__base_type_functors_pair_2_struct
	mercury_data_std_util__base_type_functors_pair_2;
const struct mercury_data_std_util__base_type_info_pair_2_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_std_util__base_type_info_pair_2 = {
	(Integer) 2,
	ENTRY(mercury____Unify___std_util__pair_2_0),
	ENTRY(mercury____Index___std_util__pair_2_0),
	ENTRY(mercury____Compare___std_util__pair_2_0),
	(const Word *) &mercury_data_std_util__base_type_layout_pair_2,
	(const Word *) &mercury_data_std_util__base_type_functors_pair_2,
	(const Word *) string_const("std_util", 8),
	(const Word *) string_const("pair", 4)
};

extern const struct mercury_data_std_util__base_type_layout_type_ctor_info_0_struct
	mercury_data_std_util__base_type_layout_type_ctor_info_0;
extern const struct mercury_data_std_util__base_type_functors_type_ctor_info_0_struct
	mercury_data_std_util__base_type_functors_type_ctor_info_0;
const struct mercury_data_std_util__base_type_info_type_ctor_info_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_std_util__base_type_info_type_ctor_info_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___std_util__type_ctor_info_0_0),
	ENTRY(mercury____Index___std_util__type_ctor_info_0_0),
	ENTRY(mercury____Compare___std_util__type_ctor_info_0_0),
	(const Word *) &mercury_data_std_util__base_type_layout_type_ctor_info_0,
	(const Word *) &mercury_data_std_util__base_type_functors_type_ctor_info_0,
	(const Word *) string_const("std_util", 8),
	(const Word *) string_const("type_ctor_info", 14)
};

Declare_entry(mercury____Unify___std_util__type_info_0_0);
Declare_entry(mercury____Index___std_util__type_info_0_0);
Declare_entry(mercury____Compare___std_util__type_info_0_0);
extern const struct mercury_data_std_util__base_type_layout_type_info_0_struct
	mercury_data_std_util__base_type_layout_type_info_0;
extern const struct mercury_data_std_util__base_type_functors_type_info_0_struct
	mercury_data_std_util__base_type_functors_type_info_0;
const struct mercury_data_std_util__base_type_info_type_info_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_std_util__base_type_info_type_info_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___std_util__type_info_0_0),
	ENTRY(mercury____Index___std_util__type_info_0_0),
	ENTRY(mercury____Compare___std_util__type_info_0_0),
	(const Word *) &mercury_data_std_util__base_type_layout_type_info_0,
	(const Word *) &mercury_data_std_util__base_type_functors_type_info_0,
	(const Word *) string_const("std_util", 8),
	(const Word *) string_const("type_info", 9)
};

extern const struct mercury_data_std_util__base_type_layout_unit_0_struct
	mercury_data_std_util__base_type_layout_unit_0;
extern const struct mercury_data_std_util__base_type_functors_unit_0_struct
	mercury_data_std_util__base_type_functors_unit_0;
const struct mercury_data_std_util__base_type_info_unit_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_std_util__base_type_info_unit_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___std_util__unit_0_0),
	ENTRY(mercury____Index___std_util__unit_0_0),
	ENTRY(mercury____Compare___std_util__unit_0_0),
	(const Word *) &mercury_data_std_util__base_type_layout_unit_0,
	(const Word *) &mercury_data_std_util__base_type_functors_unit_0,
	(const Word *) string_const("std_util", 8),
	(const Word *) string_const("unit", 4)
};

Declare_entry(mercury____Unify___std_util__univ_0_0);
Declare_entry(mercury____Index___std_util__univ_0_0);
Declare_entry(mercury____Compare___std_util__univ_0_0);
extern const struct mercury_data_std_util__base_type_layout_univ_0_struct
	mercury_data_std_util__base_type_layout_univ_0;
extern const struct mercury_data_std_util__base_type_functors_univ_0_struct
	mercury_data_std_util__base_type_functors_univ_0;
const struct mercury_data_std_util__base_type_info_univ_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_std_util__base_type_info_univ_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___std_util__univ_0_0),
	ENTRY(mercury____Index___std_util__univ_0_0),
	ENTRY(mercury____Compare___std_util__univ_0_0),
	(const Word *) &mercury_data_std_util__base_type_layout_univ_0,
	(const Word *) &mercury_data_std_util__base_type_functors_univ_0,
	(const Word *) string_const("std_util", 8),
	(const Word *) string_const("univ", 4)
};

extern const struct mercury_data_std_util__common_1_struct
	mercury_data_std_util__common_1;
const struct mercury_data_std_util__base_type_functors_unit_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_std_util__base_type_functors_unit_0 = {
	(Integer) 1,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_1)
};

const struct mercury_data_std_util__base_type_layout_unit_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_std_util__base_type_layout_unit_0 = {
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_1),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_1),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_1),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_1)
};

extern const struct mercury_data_std_util__common_2_struct
	mercury_data_std_util__common_2;
const struct mercury_data_std_util__base_type_functors_type_ctor_info_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_std_util__base_type_functors_type_ctor_info_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_2)
};

extern const struct mercury_data_std_util__common_3_struct
	mercury_data_std_util__common_3;
const struct mercury_data_std_util__base_type_layout_type_ctor_info_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_std_util__base_type_layout_type_ctor_info_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_std_util__common_3),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_std_util__common_3),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_std_util__common_3),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_std_util__common_3)
};

extern const struct mercury_data_std_util__common_4_struct
	mercury_data_std_util__common_4;
const struct mercury_data_std_util__base_type_functors_pair_2_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
} mercury_data_std_util__base_type_functors_pair_2 = {
	(Integer) 0,
	(Integer) 1,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_4)
};

const struct mercury_data_std_util__base_type_layout_pair_2_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_std_util__base_type_layout_pair_2 = {
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_std_util__common_4),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1)),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1)),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1))
};

extern const struct mercury_data_std_util__common_5_struct
	mercury_data_std_util__common_5;
const struct mercury_data_std_util__base_type_functors_pair_1_struct {
	Integer f1;
	const Word * f2;
} mercury_data_std_util__base_type_functors_pair_1 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_5)
};

extern const struct mercury_data_std_util__common_6_struct
	mercury_data_std_util__common_6;
const struct mercury_data_std_util__base_type_layout_pair_1_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_std_util__base_type_layout_pair_1 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_std_util__common_6),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_std_util__common_6),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_std_util__common_6),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_std_util__common_6)
};

extern const struct mercury_data_std_util__common_7_struct
	mercury_data_std_util__common_7;
extern const struct mercury_data_std_util__common_8_struct
	mercury_data_std_util__common_8;
const struct mercury_data_std_util__base_type_functors_maybe_1_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
} mercury_data_std_util__base_type_functors_maybe_1 = {
	(Integer) 0,
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_7),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_8)
};

extern const struct mercury_data_std_util__common_9_struct
	mercury_data_std_util__common_9;
const struct mercury_data_std_util__base_type_layout_maybe_1_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_std_util__base_type_layout_maybe_1 = {
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_9),
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_std_util__common_8),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1)),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1))
};

static const struct mercury_data_std_util__common_0_struct {
	const Word * f1;
	const Word * f2;
} mercury_data_std_util__common_0 = {
	(const Word *) string_const(")", 1),
	(const Word *) mkword(mktag(0), mkbody((Integer) 0))
};

static const struct mercury_data_std_util__common_1_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
} mercury_data_std_util__common_1 = {
	(Integer) 1,
	(Integer) 1,
	(const Word *) string_const("unit", 4)
};

extern const struct mercury_data_mercury_builtin__base_type_info_c_pointer_0_struct
	mercury_data_mercury_builtin__base_type_info_c_pointer_0;
static const struct mercury_data_std_util__common_2_struct {
	const Word * f1;
} mercury_data_std_util__common_2 = {
	(const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0
};

static const struct mercury_data_std_util__common_3_struct {
	Integer f1;
	const Word * f2;
} mercury_data_std_util__common_3 = {
	(Integer) 0,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_2)
};

static const struct mercury_data_std_util__common_4_struct {
	Integer f1;
	Integer f2;
	Integer f3;
	const Word * f4;
	const Word * f5;
} mercury_data_std_util__common_4 = {
	(Integer) 2,
	(Integer) 1,
	(Integer) 2,
	(const Word *) string_const("-", 1),
	(const Word *) mkword(mktag(0), mkbody((Integer) 0))
};

static const struct mercury_data_std_util__common_5_struct {
	const Word * f1;
	Integer f2;
	Integer f3;
} mercury_data_std_util__common_5 = {
	(const Word *) &mercury_data_std_util__base_type_info_pair_2,
	(Integer) 1,
	(Integer) 1
};

static const struct mercury_data_std_util__common_6_struct {
	Integer f1;
	const Word * f2;
} mercury_data_std_util__common_6 = {
	(Integer) 0,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_std_util__common_5)
};

static const struct mercury_data_std_util__common_7_struct {
	Integer f1;
	const Word * f2;
	const Word * f3;
} mercury_data_std_util__common_7 = {
	(Integer) 0,
	(const Word *) string_const("no", 2),
	(const Word *) mkword(mktag(0), mkbody((Integer) 0))
};

static const struct mercury_data_std_util__common_8_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
} mercury_data_std_util__common_8 = {
	(Integer) 1,
	(Integer) 1,
	(const Word *) string_const("yes", 3),
	(const Word *) mkword(mktag(1), mkbody((Integer) 0))
};

static const struct mercury_data_std_util__common_9_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
} mercury_data_std_util__common_9 = {
	(Integer) 0,
	(Integer) 1,
	(const Word *) string_const("no", 2)
};


BEGIN_MODULE(mercury__std_util_module0)
	init_entry(mercury____Index___std_util__pair_1__ua10000_2_0);
BEGIN_CODE

/* code for predicate '__Index___std_util__pair_1__ua10000'/2 in mode 0 */
Define_static(mercury____Index___std_util__pair_1__ua10000_2_0);
	r1 = (Integer) 0;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module1)
	init_entry(mercury____Index___std_util__pair_2__ua10000_2_0);
BEGIN_CODE

/* code for predicate '__Index___std_util__pair_2__ua10000'/2 in mode 0 */
Define_static(mercury____Index___std_util__pair_2__ua10000_2_0);
	r1 = (Integer) 0;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module2)
	init_entry(mercury____Index___std_util__maybe_1__ua10000_2_0);
	init_label(mercury____Index___std_util__maybe_1__ua10000_2_0_i3);
BEGIN_CODE

/* code for predicate '__Index___std_util__maybe_1__ua10000'/2 in mode 0 */
Define_static(mercury____Index___std_util__maybe_1__ua10000_2_0);
	if (((Integer) r1 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Index___std_util__maybe_1__ua10000_2_0_i3);
	r1 = (Integer) 0;
	proceed();
Define_label(mercury____Index___std_util__maybe_1__ua10000_2_0_i3);
	r1 = (Integer) 1;
	proceed();
END_MODULE

Declare_entry(do_call_det_closure);

BEGIN_MODULE(mercury__std_util_module3)
	init_entry(mercury__std_util__list__foldl__ua10001_4_0);
	init_label(mercury__std_util__list__foldl__ua10001_4_0_i1001);
	init_label(mercury__std_util__list__foldl__ua10001_4_0_i4);
	init_label(mercury__std_util__list__foldl__ua10001_4_0_i3);
BEGIN_CODE

/* code for predicate 'foldl__ua10001'/4 in mode 0 */
Define_static(mercury__std_util__list__foldl__ua10001_4_0);
	incr_sp_push_msg(3, "list:foldl__ua10001/4");
	detstackvar(3) = (Word) succip;
Define_label(mercury__std_util__list__foldl__ua10001_4_0_i1001);
	if (((Integer) r2 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__std_util__list__foldl__ua10001_4_0_i3);
	detstackvar(1) = r1;
	detstackvar(2) = const_field(mktag(1), r2, (Integer) 1);
	r4 = const_field(mktag(1), r2, (Integer) 0);
	r5 = r3;
	r2 = (Integer) 2;
	r3 = (Integer) 1;
	call_localret(ENTRY(do_call_det_closure),
		mercury__std_util__list__foldl__ua10001_4_0_i4,
		STATIC(mercury__std_util__list__foldl__ua10001_4_0));
Define_label(mercury__std_util__list__foldl__ua10001_4_0_i4);
	update_prof_current_proc(LABEL(mercury__std_util__list__foldl__ua10001_4_0));
	r3 = r1;
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	succip = (Code *) detstackvar(3);
	GOTO_LABEL(mercury__std_util__list__foldl__ua10001_4_0_i1001);
Define_label(mercury__std_util__list__foldl__ua10001_4_0_i3);
	r1 = r3;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module4)
	init_entry(mercury__std_util__list__foldl__ua10000_4_0);
	init_label(mercury__std_util__list__foldl__ua10000_4_0_i1001);
	init_label(mercury__std_util__list__foldl__ua10000_4_0_i4);
	init_label(mercury__std_util__list__foldl__ua10000_4_0_i3);
BEGIN_CODE

/* code for predicate 'foldl__ua10000'/4 in mode 0 */
Define_static(mercury__std_util__list__foldl__ua10000_4_0);
	incr_sp_push_msg(3, "list:foldl__ua10000/4");
	detstackvar(3) = (Word) succip;
Define_label(mercury__std_util__list__foldl__ua10000_4_0_i1001);
	if (((Integer) r2 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__std_util__list__foldl__ua10000_4_0_i3);
	detstackvar(1) = r1;
	detstackvar(2) = const_field(mktag(1), r2, (Integer) 1);
	r4 = const_field(mktag(1), r2, (Integer) 0);
	r5 = r3;
	r2 = (Integer) 2;
	r3 = (Integer) 1;
	call_localret(ENTRY(do_call_det_closure),
		mercury__std_util__list__foldl__ua10000_4_0_i4,
		STATIC(mercury__std_util__list__foldl__ua10000_4_0));
Define_label(mercury__std_util__list__foldl__ua10000_4_0_i4);
	update_prof_current_proc(LABEL(mercury__std_util__list__foldl__ua10000_4_0));
	r3 = r1;
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	succip = (Code *) detstackvar(3);
	GOTO_LABEL(mercury__std_util__list__foldl__ua10000_4_0_i1001);
Define_label(mercury__std_util__list__foldl__ua10000_4_0_i3);
	r1 = r3;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module5)
	init_entry(mercury__std_util__cons__ua10000_3_0);
BEGIN_CODE

/* code for predicate 'cons__ua10000'/3 in mode 0 */
Define_static(mercury__std_util__cons__ua10000_3_0);
	r3 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 2);
	field(mktag(1), r1, (Integer) 0) = r3;
	field(mktag(1), r1, (Integer) 1) = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module6)
	init_entry(mercury__fn__std_util__type_of__ua10000_1_0);
BEGIN_CODE

/* code for predicate 'type_of__ua10000'/2 in mode 0 */
Define_static(mercury__fn__std_util__type_of__ua10000_1_0);
	{
		Word	TypeInfo_for_T;
		Word	Value;
		Word	TypeInfo;
		TypeInfo_for_T = r1;
#line 1367 "std_util.m"
{		 
{
	/* 
	** `Value' isn't used in this c_code, but the compiler
	** gives a warning if you don't mention it.
	*/ 

	TypeInfo = TypeInfo_for_T;

	/*
	** We used to collapse equivalences for efficiency here,
	** but that's not always desirable, due to the reverse
	** mode of make_type/2, and efficiency of type_infos
	** probably isn't very important anyway.
	*/
#if 0
	save_transient_registers();
	TypeInfo = ML_collapse_equivalences(TypeInfo_for_T);
	restore_transient_registers();
#endif

}
;}
#line 2567 "std_util.c"
		r2 = TypeInfo;

	}
	r1 = r2;
	proceed();
END_MODULE

Declare_entry(do_call_semidet_closure);

BEGIN_MODULE(mercury__std_util_module7)
	init_entry(mercury__std_util__maybe_pred__ua10000_3_0);
	init_label(mercury__std_util__maybe_pred__ua10000_3_0_i4);
	init_label(mercury__std_util__maybe_pred__ua10000_3_0_i2);
BEGIN_CODE

/* code for predicate 'maybe_pred__ua10000'/3 in mode 0 */
Define_static(mercury__std_util__maybe_pred__ua10000_3_0);
	incr_sp_push_msg(1, "std_util:maybe_pred__ua10000/3");
	detstackvar(1) = (Word) succip;
	r4 = r2;
	r2 = (Integer) 1;
	r3 = (Integer) 1;
	call_localret(ENTRY(do_call_semidet_closure),
		mercury__std_util__maybe_pred__ua10000_3_0_i4,
		STATIC(mercury__std_util__maybe_pred__ua10000_3_0));
Define_label(mercury__std_util__maybe_pred__ua10000_3_0_i4);
	update_prof_current_proc(LABEL(mercury__std_util__maybe_pred__ua10000_3_0));
	if (!(r1))
		GOTO_LABEL(mercury__std_util__maybe_pred__ua10000_3_0_i2);
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = r2;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury__std_util__maybe_pred__ua10000_3_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE

extern const struct mercury_data_list__base_type_info_list_1_struct
	mercury_data_list__base_type_info_list_1;
Declare_entry(mercury__std_util__builtin_aggregate_4_4);
Declare_entry(mercury__list__merge_sort_2_0);
Declare_entry(mercury__list__remove_adjacent_dups_2_0);

BEGIN_MODULE(mercury__std_util_module8)
	init_entry(mercury__std_util__aggregate__ua10003_4_0);
	init_label(mercury__std_util__aggregate__ua10003_4_0_i2);
	init_label(mercury__std_util__aggregate__ua10003_4_0_i3);
	init_label(mercury__std_util__aggregate__ua10003_4_0_i4);
BEGIN_CODE

/* code for predicate 'aggregate__ua10003'/4 in mode 0 */
Define_static(mercury__std_util__aggregate__ua10003_4_0);
	incr_sp_push_msg(4, "std_util:aggregate__ua10003/4");
	detstackvar(4) = (Word) succip;
	detstackvar(1) = r3;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	detstackvar(2) = r4;
	detstackvar(3) = r1;
	field(mktag(0), r2, (Integer) 1) = r1;
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_4),
		mercury__std_util__aggregate__ua10003_4_0_i2,
		STATIC(mercury__std_util__aggregate__ua10003_4_0));
Define_label(mercury__std_util__aggregate__ua10003_4_0_i2);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10003_4_0));
	r2 = r1;
	r1 = detstackvar(3);
	call_localret(ENTRY(mercury__list__merge_sort_2_0),
		mercury__std_util__aggregate__ua10003_4_0_i3,
		STATIC(mercury__std_util__aggregate__ua10003_4_0));
Define_label(mercury__std_util__aggregate__ua10003_4_0_i3);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10003_4_0));
	r2 = r1;
	r1 = detstackvar(3);
	call_localret(ENTRY(mercury__list__remove_adjacent_dups_2_0),
		mercury__std_util__aggregate__ua10003_4_0_i4,
		STATIC(mercury__std_util__aggregate__ua10003_4_0));
Define_label(mercury__std_util__aggregate__ua10003_4_0_i4);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10003_4_0));
	r2 = r1;
	r1 = detstackvar(1);
	r3 = detstackvar(2);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	tailcall(STATIC(mercury__std_util__list__foldl__ua10001_4_0),
		STATIC(mercury__std_util__aggregate__ua10003_4_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module9)
	init_entry(mercury__std_util__aggregate__ua10002_4_0);
	init_label(mercury__std_util__aggregate__ua10002_4_0_i2);
	init_label(mercury__std_util__aggregate__ua10002_4_0_i3);
	init_label(mercury__std_util__aggregate__ua10002_4_0_i4);
BEGIN_CODE

/* code for predicate 'aggregate__ua10002'/4 in mode 0 */
Define_static(mercury__std_util__aggregate__ua10002_4_0);
	incr_sp_push_msg(4, "std_util:aggregate__ua10002/4");
	detstackvar(4) = (Word) succip;
	detstackvar(1) = r3;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	detstackvar(2) = r4;
	detstackvar(3) = r1;
	field(mktag(0), r2, (Integer) 1) = r1;
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_4),
		mercury__std_util__aggregate__ua10002_4_0_i2,
		STATIC(mercury__std_util__aggregate__ua10002_4_0));
Define_label(mercury__std_util__aggregate__ua10002_4_0_i2);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10002_4_0));
	r2 = r1;
	r1 = detstackvar(3);
	call_localret(ENTRY(mercury__list__merge_sort_2_0),
		mercury__std_util__aggregate__ua10002_4_0_i3,
		STATIC(mercury__std_util__aggregate__ua10002_4_0));
Define_label(mercury__std_util__aggregate__ua10002_4_0_i3);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10002_4_0));
	r2 = r1;
	r1 = detstackvar(3);
	call_localret(ENTRY(mercury__list__remove_adjacent_dups_2_0),
		mercury__std_util__aggregate__ua10002_4_0_i4,
		STATIC(mercury__std_util__aggregate__ua10002_4_0));
Define_label(mercury__std_util__aggregate__ua10002_4_0_i4);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10002_4_0));
	r2 = r1;
	r1 = detstackvar(1);
	r3 = detstackvar(2);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	tailcall(STATIC(mercury__std_util__list__foldl__ua10000_4_0),
		STATIC(mercury__std_util__aggregate__ua10002_4_0));
END_MODULE

Declare_entry(mercury__std_util__builtin_aggregate_4_0);

BEGIN_MODULE(mercury__std_util_module10)
	init_entry(mercury__std_util__aggregate__ua10001_4_0);
	init_label(mercury__std_util__aggregate__ua10001_4_0_i2);
	init_label(mercury__std_util__aggregate__ua10001_4_0_i3);
	init_label(mercury__std_util__aggregate__ua10001_4_0_i4);
BEGIN_CODE

/* code for predicate 'aggregate__ua10001'/4 in mode 0 */
Define_static(mercury__std_util__aggregate__ua10001_4_0);
	incr_sp_push_msg(4, "std_util:aggregate__ua10001/4");
	detstackvar(4) = (Word) succip;
	detstackvar(1) = r3;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	detstackvar(2) = r4;
	detstackvar(3) = r1;
	field(mktag(0), r2, (Integer) 1) = r1;
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_0),
		mercury__std_util__aggregate__ua10001_4_0_i2,
		STATIC(mercury__std_util__aggregate__ua10001_4_0));
Define_label(mercury__std_util__aggregate__ua10001_4_0_i2);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10001_4_0));
	r2 = r1;
	r1 = detstackvar(3);
	call_localret(ENTRY(mercury__list__merge_sort_2_0),
		mercury__std_util__aggregate__ua10001_4_0_i3,
		STATIC(mercury__std_util__aggregate__ua10001_4_0));
Define_label(mercury__std_util__aggregate__ua10001_4_0_i3);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10001_4_0));
	r2 = r1;
	r1 = detstackvar(3);
	call_localret(ENTRY(mercury__list__remove_adjacent_dups_2_0),
		mercury__std_util__aggregate__ua10001_4_0_i4,
		STATIC(mercury__std_util__aggregate__ua10001_4_0));
Define_label(mercury__std_util__aggregate__ua10001_4_0_i4);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10001_4_0));
	r2 = r1;
	r1 = detstackvar(1);
	r3 = detstackvar(2);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	tailcall(STATIC(mercury__std_util__list__foldl__ua10000_4_0),
		STATIC(mercury__std_util__aggregate__ua10001_4_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module11)
	init_entry(mercury__std_util__aggregate__ua10000_4_0);
	init_label(mercury__std_util__aggregate__ua10000_4_0_i2);
	init_label(mercury__std_util__aggregate__ua10000_4_0_i3);
	init_label(mercury__std_util__aggregate__ua10000_4_0_i4);
BEGIN_CODE

/* code for predicate 'aggregate__ua10000'/4 in mode 0 */
Define_static(mercury__std_util__aggregate__ua10000_4_0);
	incr_sp_push_msg(4, "std_util:aggregate__ua10000/4");
	detstackvar(4) = (Word) succip;
	detstackvar(1) = r3;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	detstackvar(2) = r4;
	detstackvar(3) = r1;
	field(mktag(0), r2, (Integer) 1) = r1;
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_0),
		mercury__std_util__aggregate__ua10000_4_0_i2,
		STATIC(mercury__std_util__aggregate__ua10000_4_0));
Define_label(mercury__std_util__aggregate__ua10000_4_0_i2);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10000_4_0));
	r2 = r1;
	r1 = detstackvar(3);
	call_localret(ENTRY(mercury__list__merge_sort_2_0),
		mercury__std_util__aggregate__ua10000_4_0_i3,
		STATIC(mercury__std_util__aggregate__ua10000_4_0));
Define_label(mercury__std_util__aggregate__ua10000_4_0_i3);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10000_4_0));
	r2 = r1;
	r1 = detstackvar(3);
	call_localret(ENTRY(mercury__list__remove_adjacent_dups_2_0),
		mercury__std_util__aggregate__ua10000_4_0_i4,
		STATIC(mercury__std_util__aggregate__ua10000_4_0));
Define_label(mercury__std_util__aggregate__ua10000_4_0_i4);
	update_prof_current_proc(LABEL(mercury__std_util__aggregate__ua10000_4_0));
	r2 = r1;
	r1 = detstackvar(1);
	r3 = detstackvar(2);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	tailcall(STATIC(mercury__std_util__list__foldl__ua10001_4_0),
		STATIC(mercury__std_util__aggregate__ua10000_4_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module12)
	init_entry(mercury__std_util__type_to_univ_2_2);
	init_label(mercury__std_util__type_to_univ_2_2_i1);
BEGIN_CODE

/* code for predicate 'type_to_univ'/2 in mode 2 */
Define_entry(mercury__std_util__type_to_univ_2_2);
	r3 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Univ = r2;
#line 1097 "std_util.m"
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 2852 "std_util.c"
		r4 = Type;

	}
	if (!(r1))
		GOTO_LABEL(mercury__std_util__type_to_univ_2_2_i1);
	r2 = r4;
	r1 = TRUE;
	proceed();
Define_label(mercury__std_util__type_to_univ_2_2_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module13)
	init_entry(mercury__std_util__type_to_univ_2_0);
BEGIN_CODE

/* code for predicate 'type_to_univ'/2 in mode 0 */
Define_entry(mercury__std_util__type_to_univ_2_0);
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
#line 1082 "std_util.m"
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 2885 "std_util.c"
		r3 = Univ;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module14)
	init_entry(mercury__std_util__type_to_univ_2_1);
BEGIN_CODE

/* code for predicate 'type_to_univ'/2 in mode 1 */
Define_entry(mercury__std_util__type_to_univ_2_1);
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
#line 1087 "std_util.m"
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 2912 "std_util.c"
		r3 = Univ;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module15)
	init_entry(mercury__std_util__univ_to_type_2_0);
	init_label(mercury__std_util__univ_to_type_2_0_i1);
BEGIN_CODE

/* code for predicate 'univ_to_type'/2 in mode 0 */
Define_entry(mercury__std_util__univ_to_type_2_0);
	r3 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Univ = r2;
#line 1097 "std_util.m"
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 2949 "std_util.c"
		r4 = Type;

	}
	if (!(r1))
		GOTO_LABEL(mercury__std_util__univ_to_type_2_0_i1);
	r2 = r4;
	r1 = TRUE;
	proceed();
Define_label(mercury__std_util__univ_to_type_2_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module16)
	init_entry(mercury__std_util__univ_to_type_2_1);
BEGIN_CODE

/* code for predicate 'univ_to_type'/2 in mode 1 */
Define_entry(mercury__std_util__univ_to_type_2_1);
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
#line 1087 "std_util.m"
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 2982 "std_util.c"
		r3 = Univ;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module17)
	init_entry(mercury__std_util__univ_to_type_2_2);
BEGIN_CODE

/* code for predicate 'univ_to_type'/2 in mode 2 */
Define_entry(mercury__std_util__univ_to_type_2_2);
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
#line 1082 "std_util.m"
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 3009 "std_util.c"
		r3 = Univ;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module18)
	init_entry(mercury__fn__std_util__univ_1_2);
	init_label(mercury__fn__std_util__univ_1_2_i1);
BEGIN_CODE

/* code for predicate 'univ'/2 in mode 2 */
Define_entry(mercury__fn__std_util__univ_1_2);
	r3 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Univ = r2;
#line 1097 "std_util.m"
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 3046 "std_util.c"
		r4 = Type;

	}
	if (!(r1))
		GOTO_LABEL(mercury__fn__std_util__univ_1_2_i1);
	r2 = r4;
	r1 = TRUE;
	proceed();
Define_label(mercury__fn__std_util__univ_1_2_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module19)
	init_entry(mercury__fn__std_util__univ_1_0);
BEGIN_CODE

/* code for predicate 'univ'/2 in mode 0 */
Define_entry(mercury__fn__std_util__univ_1_0);
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
#line 1087 "std_util.m"
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 3079 "std_util.c"
		r3 = Univ;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module20)
	init_entry(mercury__fn__std_util__univ_1_1);
BEGIN_CODE

/* code for predicate 'univ'/2 in mode 1 */
Define_entry(mercury__fn__std_util__univ_1_1);
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
#line 1082 "std_util.m"
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 3106 "std_util.c"
		r3 = Univ;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module21)
	init_entry(mercury__fn__std_util__univ_type_1_0);
BEGIN_CODE

/* code for predicate 'univ_type'/2 in mode 0 */
Define_entry(mercury__fn__std_util__univ_type_1_0);
	{
		Word	Univ;
		Word	TypeInfo;
		Univ = r1;
#line 1111 "std_util.m"
{		
	TypeInfo = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
;}
#line 3129 "std_util.c"
		r2 = TypeInfo;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module22)
	init_entry(mercury__std_util__solutions_2_0);
	init_label(mercury__std_util__solutions_2_0_i2);
	init_label(mercury__std_util__solutions_2_0_i3);
BEGIN_CODE

/* code for predicate 'solutions'/2 in mode 0 */
Define_entry(mercury__std_util__solutions_2_0);
	incr_sp_push_msg(2, "std_util:solutions/2");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r1;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = r1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_0),
		mercury__std_util__solutions_2_0_i2,
		ENTRY(mercury__std_util__solutions_2_0));
Define_label(mercury__std_util__solutions_2_0_i2);
	update_prof_current_proc(LABEL(mercury__std_util__solutions_2_0));
	r2 = r1;
	r1 = detstackvar(1);
	call_localret(ENTRY(mercury__list__merge_sort_2_0),
		mercury__std_util__solutions_2_0_i3,
		ENTRY(mercury__std_util__solutions_2_0));
Define_label(mercury__std_util__solutions_2_0_i3);
	update_prof_current_proc(LABEL(mercury__std_util__solutions_2_0));
	r2 = r1;
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	tailcall(ENTRY(mercury__list__remove_adjacent_dups_2_0),
		ENTRY(mercury__std_util__solutions_2_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module23)
	init_entry(mercury__std_util__solutions_2_1);
	init_label(mercury__std_util__solutions_2_1_i2);
	init_label(mercury__std_util__solutions_2_1_i3);
BEGIN_CODE

/* code for predicate 'solutions'/2 in mode 1 */
Define_entry(mercury__std_util__solutions_2_1);
	incr_sp_push_msg(2, "std_util:solutions/2");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r1;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = r1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_4),
		mercury__std_util__solutions_2_1_i2,
		ENTRY(mercury__std_util__solutions_2_1));
Define_label(mercury__std_util__solutions_2_1_i2);
	update_prof_current_proc(LABEL(mercury__std_util__solutions_2_1));
	r2 = r1;
	r1 = detstackvar(1);
	call_localret(ENTRY(mercury__list__merge_sort_2_0),
		mercury__std_util__solutions_2_1_i3,
		ENTRY(mercury__std_util__solutions_2_1));
Define_label(mercury__std_util__solutions_2_1_i3);
	update_prof_current_proc(LABEL(mercury__std_util__solutions_2_1));
	r2 = r1;
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	tailcall(ENTRY(mercury__list__remove_adjacent_dups_2_0),
		ENTRY(mercury__std_util__solutions_2_1));
END_MODULE

Declare_entry(mercury__set_ordlist__list_to_set_2_0);

BEGIN_MODULE(mercury__std_util_module24)
	init_entry(mercury__std_util__solutions_set_2_0);
	init_label(mercury__std_util__solutions_set_2_0_i2);
BEGIN_CODE

/* code for predicate 'solutions_set'/2 in mode 0 */
Define_entry(mercury__std_util__solutions_set_2_0);
	incr_sp_push_msg(2, "std_util:solutions_set/2");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r1;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = r1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_0),
		mercury__std_util__solutions_set_2_0_i2,
		ENTRY(mercury__std_util__solutions_set_2_0));
Define_label(mercury__std_util__solutions_set_2_0_i2);
	update_prof_current_proc(LABEL(mercury__std_util__solutions_set_2_0));
	r2 = r1;
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	tailcall(ENTRY(mercury__set_ordlist__list_to_set_2_0),
		ENTRY(mercury__std_util__solutions_set_2_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module25)
	init_entry(mercury__std_util__solutions_set_2_1);
	init_label(mercury__std_util__solutions_set_2_1_i2);
BEGIN_CODE

/* code for predicate 'solutions_set'/2 in mode 1 */
Define_entry(mercury__std_util__solutions_set_2_1);
	incr_sp_push_msg(2, "std_util:solutions_set/2");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r1;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = r1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_4),
		mercury__std_util__solutions_set_2_1_i2,
		ENTRY(mercury__std_util__solutions_set_2_1));
Define_label(mercury__std_util__solutions_set_2_1_i2);
	update_prof_current_proc(LABEL(mercury__std_util__solutions_set_2_1));
	r2 = r1;
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	tailcall(ENTRY(mercury__set_ordlist__list_to_set_2_0),
		ENTRY(mercury__std_util__solutions_set_2_1));
END_MODULE


BEGIN_MODULE(mercury__std_util_module26)
	init_entry(mercury__std_util__unsorted_solutions_2_0);
	init_label(mercury__std_util__unsorted_solutions_2_0_i2);
BEGIN_CODE

/* code for predicate 'unsorted_solutions'/2 in mode 0 */
Define_entry(mercury__std_util__unsorted_solutions_2_0);
	incr_sp_push_msg(2, "std_util:unsorted_solutions/2");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r1;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = r1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_0),
		mercury__std_util__unsorted_solutions_2_0_i2,
		ENTRY(mercury__std_util__unsorted_solutions_2_0));
Define_label(mercury__std_util__unsorted_solutions_2_0_i2);
	update_prof_current_proc(LABEL(mercury__std_util__unsorted_solutions_2_0));
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = detstackvar(1);
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = r2;
		X = r1;
#line 906 "std_util.m"
{		Y = X;;}
#line 3322 "std_util.c"
		r3 = Y;

	}
	r1 = r3;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module27)
	init_entry(mercury__std_util__unsorted_solutions_2_1);
	init_label(mercury__std_util__unsorted_solutions_2_1_i2);
BEGIN_CODE

/* code for predicate 'unsorted_solutions'/2 in mode 1 */
Define_entry(mercury__std_util__unsorted_solutions_2_1);
	incr_sp_push_msg(2, "std_util:unsorted_solutions/2");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r1;
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = r1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_4),
		mercury__std_util__unsorted_solutions_2_1_i2,
		ENTRY(mercury__std_util__unsorted_solutions_2_1));
Define_label(mercury__std_util__unsorted_solutions_2_1_i2);
	update_prof_current_proc(LABEL(mercury__std_util__unsorted_solutions_2_1));
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = detstackvar(1);
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = r2;
		X = r1;
#line 906 "std_util.m"
{		Y = X;;}
#line 3368 "std_util.c"
		r3 = Y;

	}
	r1 = r3;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module28)
	init_entry(mercury__std_util__aggregate_4_0);
BEGIN_CODE

/* code for predicate 'aggregate'/4 in mode 0 */
Define_entry(mercury__std_util__aggregate_4_0);
	r2 = r3;
	r3 = r4;
	r4 = r5;
	tailcall(STATIC(mercury__std_util__aggregate__ua10000_4_0),
		ENTRY(mercury__std_util__aggregate_4_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module29)
	init_entry(mercury__std_util__aggregate_4_1);
BEGIN_CODE

/* code for predicate 'aggregate'/4 in mode 1 */
Define_entry(mercury__std_util__aggregate_4_1);
	r2 = r3;
	r3 = r4;
	r4 = r5;
	tailcall(STATIC(mercury__std_util__aggregate__ua10001_4_0),
		ENTRY(mercury__std_util__aggregate_4_1));
END_MODULE


BEGIN_MODULE(mercury__std_util_module30)
	init_entry(mercury__std_util__aggregate_4_2);
BEGIN_CODE

/* code for predicate 'aggregate'/4 in mode 2 */
Define_entry(mercury__std_util__aggregate_4_2);
	r2 = r3;
	r3 = r4;
	r4 = r5;
	tailcall(STATIC(mercury__std_util__aggregate__ua10002_4_0),
		ENTRY(mercury__std_util__aggregate_4_2));
END_MODULE


BEGIN_MODULE(mercury__std_util_module31)
	init_entry(mercury__std_util__aggregate_4_3);
BEGIN_CODE

/* code for predicate 'aggregate'/4 in mode 3 */
Define_entry(mercury__std_util__aggregate_4_3);
	r2 = r3;
	r3 = r4;
	r4 = r5;
	tailcall(STATIC(mercury__std_util__aggregate__ua10003_4_0),
		ENTRY(mercury__std_util__aggregate_4_3));
END_MODULE


BEGIN_MODULE(mercury__std_util_module32)
	init_entry(mercury__std_util__unsorted_aggregate_4_0);
	init_label(mercury__std_util__unsorted_aggregate_4_0_i2);
BEGIN_CODE

/* code for predicate 'unsorted_aggregate'/4 in mode 0 */
Define_entry(mercury__std_util__unsorted_aggregate_4_0);
	incr_sp_push_msg(2, "std_util:unsorted_aggregate/4");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r2;
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_0),
		mercury__std_util__unsorted_aggregate_4_0_i2,
		ENTRY(mercury__std_util__unsorted_aggregate_4_0));
Define_label(mercury__std_util__unsorted_aggregate_4_0_i2);
	update_prof_current_proc(LABEL(mercury__std_util__unsorted_aggregate_4_0));
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = detstackvar(1);
		X = r1;
#line 906 "std_util.m"
{		Y = X;;}
#line 3458 "std_util.c"
		r2 = Y;

	}
	r1 = r2;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE

Declare_entry(mercury__std_util__builtin_aggregate_4_1);

BEGIN_MODULE(mercury__std_util_module33)
	init_entry(mercury__std_util__unsorted_aggregate_4_1);
	init_label(mercury__std_util__unsorted_aggregate_4_1_i2);
BEGIN_CODE

/* code for predicate 'unsorted_aggregate'/4 in mode 1 */
Define_entry(mercury__std_util__unsorted_aggregate_4_1);
	incr_sp_push_msg(2, "std_util:unsorted_aggregate/4");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r2;
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_1),
		mercury__std_util__unsorted_aggregate_4_1_i2,
		ENTRY(mercury__std_util__unsorted_aggregate_4_1));
Define_label(mercury__std_util__unsorted_aggregate_4_1_i2);
	update_prof_current_proc(LABEL(mercury__std_util__unsorted_aggregate_4_1));
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = detstackvar(1);
		X = r1;
#line 908 "std_util.m"
{		Y = X;;}
#line 3493 "std_util.c"
		r2 = Y;

	}
	r1 = r2;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE

Declare_entry(mercury__std_util__builtin_aggregate_4_2);

BEGIN_MODULE(mercury__std_util_module34)
	init_entry(mercury__std_util__unsorted_aggregate_4_2);
	init_label(mercury__std_util__unsorted_aggregate_4_2_i2);
BEGIN_CODE

/* code for predicate 'unsorted_aggregate'/4 in mode 2 */
Define_entry(mercury__std_util__unsorted_aggregate_4_2);
	incr_sp_push_msg(2, "std_util:unsorted_aggregate/4");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r2;
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_2),
		mercury__std_util__unsorted_aggregate_4_2_i2,
		ENTRY(mercury__std_util__unsorted_aggregate_4_2));
Define_label(mercury__std_util__unsorted_aggregate_4_2_i2);
	update_prof_current_proc(LABEL(mercury__std_util__unsorted_aggregate_4_2));
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = detstackvar(1);
		X = r1;
#line 908 "std_util.m"
{		Y = X;;}
#line 3528 "std_util.c"
		r2 = Y;

	}
	r1 = r2;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE

Declare_entry(mercury__std_util__builtin_aggregate_4_3);

BEGIN_MODULE(mercury__std_util_module35)
	init_entry(mercury__std_util__unsorted_aggregate_4_3);
	init_label(mercury__std_util__unsorted_aggregate_4_3_i2);
BEGIN_CODE

/* code for predicate 'unsorted_aggregate'/4 in mode 3 */
Define_entry(mercury__std_util__unsorted_aggregate_4_3);
	incr_sp_push_msg(2, "std_util:unsorted_aggregate/4");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r2;
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_3),
		mercury__std_util__unsorted_aggregate_4_3_i2,
		ENTRY(mercury__std_util__unsorted_aggregate_4_3));
Define_label(mercury__std_util__unsorted_aggregate_4_3_i2);
	update_prof_current_proc(LABEL(mercury__std_util__unsorted_aggregate_4_3));
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = detstackvar(1);
		X = r1;
#line 908 "std_util.m"
{		Y = X;;}
#line 3563 "std_util.c"
		r2 = Y;

	}
	r1 = r2;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module36)
	init_entry(mercury__std_util__unsorted_aggregate_4_4);
	init_label(mercury__std_util__unsorted_aggregate_4_4_i2);
BEGIN_CODE

/* code for predicate 'unsorted_aggregate'/4 in mode 4 */
Define_entry(mercury__std_util__unsorted_aggregate_4_4);
	incr_sp_push_msg(2, "std_util:unsorted_aggregate/4");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r2;
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_4),
		mercury__std_util__unsorted_aggregate_4_4_i2,
		ENTRY(mercury__std_util__unsorted_aggregate_4_4));
Define_label(mercury__std_util__unsorted_aggregate_4_4_i2);
	update_prof_current_proc(LABEL(mercury__std_util__unsorted_aggregate_4_4));
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = detstackvar(1);
		X = r1;
#line 906 "std_util.m"
{		Y = X;;}
#line 3597 "std_util.c"
		r2 = Y;

	}
	r1 = r2;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE

Declare_entry(mercury__std_util__builtin_aggregate_4_5);

BEGIN_MODULE(mercury__std_util_module37)
	init_entry(mercury__std_util__unsorted_aggregate_4_5);
	init_label(mercury__std_util__unsorted_aggregate_4_5_i2);
BEGIN_CODE

/* code for predicate 'unsorted_aggregate'/4 in mode 5 */
Define_entry(mercury__std_util__unsorted_aggregate_4_5);
	incr_sp_push_msg(2, "std_util:unsorted_aggregate/4");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r2;
	call_localret(ENTRY(mercury__std_util__builtin_aggregate_4_5),
		mercury__std_util__unsorted_aggregate_4_5_i2,
		ENTRY(mercury__std_util__unsorted_aggregate_4_5));
Define_label(mercury__std_util__unsorted_aggregate_4_5_i2);
	update_prof_current_proc(LABEL(mercury__std_util__unsorted_aggregate_4_5));
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = detstackvar(1);
		X = r1;
#line 908 "std_util.m"
{		Y = X;;}
#line 3632 "std_util.c"
		r2 = Y;

	}
	r1 = r2;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module38)
	init_entry(mercury__std_util__maybe_pred_3_0);
BEGIN_CODE

/* code for predicate 'maybe_pred'/3 in mode 0 */
Define_entry(mercury__std_util__maybe_pred_3_0);
	r1 = r3;
	r2 = r4;
	tailcall(STATIC(mercury__std_util__maybe_pred__ua10000_3_0),
		ENTRY(mercury__std_util__maybe_pred_3_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module39)
	init_entry(mercury__std_util__semidet_succeed_0_0);
	init_label(mercury__std_util__semidet_succeed_0_0_i1);
BEGIN_CODE

/* code for predicate 'semidet_succeed'/0 in mode 0 */
Define_entry(mercury__std_util__semidet_succeed_0_0);
	{
#line 902 "std_util.m"
{		SUCCESS_INDICATOR = TRUE;;}
#line 3666 "std_util.c"

	}
	if (!(r1))
		GOTO_LABEL(mercury__std_util__semidet_succeed_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury__std_util__semidet_succeed_0_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module40)
	init_entry(mercury__std_util__semidet_fail_0_0);
	init_label(mercury__std_util__semidet_fail_0_0_i1);
BEGIN_CODE

/* code for predicate 'semidet_fail'/0 in mode 0 */
Define_entry(mercury__std_util__semidet_fail_0_0);
	{
#line 904 "std_util.m"
{		SUCCESS_INDICATOR = FALSE;;}
#line 3689 "std_util.c"

	}
	if (!(r1))
		GOTO_LABEL(mercury__std_util__semidet_fail_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury__std_util__semidet_fail_0_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module41)
	init_entry(mercury__std_util__cc_multi_equal_2_0);
BEGIN_CODE

/* code for predicate 'cc_multi_equal'/2 in mode 0 */
Define_entry(mercury__std_util__cc_multi_equal_2_0);
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = r1;
		X = r2;
#line 908 "std_util.m"
{		Y = X;;}
#line 3716 "std_util.c"
		r3 = Y;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module42)
	init_entry(mercury__std_util__cc_multi_equal_2_1);
BEGIN_CODE

/* code for predicate 'cc_multi_equal'/2 in mode 1 */
Define_entry(mercury__std_util__cc_multi_equal_2_1);
	{
		Word	TypeInfo_for_T;
		Word	X;
		Word	Y;
		TypeInfo_for_T = r1;
		X = r2;
#line 906 "std_util.m"
{		Y = X;;}
#line 3739 "std_util.c"
		r3 = Y;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module43)
	init_entry(mercury__fn__std_util__type_of_1_0);
	init_label(mercury__fn__std_util__type_of_1_0_i2);
BEGIN_CODE

/* code for predicate 'type_of'/2 in mode 0 */
Define_entry(mercury__fn__std_util__type_of_1_0);
	incr_sp_push_msg(1, "std_util:type_of/2");
	detstackvar(1) = (Word) succip;
	call_localret(STATIC(mercury__fn__std_util__type_of__ua10000_1_0),
		mercury__fn__std_util__type_of_1_0_i2,
		ENTRY(mercury__fn__std_util__type_of_1_0));
Define_label(mercury__fn__std_util__type_of_1_0_i2);
	update_prof_current_proc(LABEL(mercury__fn__std_util__type_of_1_0));
	r2 = r1;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE

Declare_entry(mercury__string__append_list_2_0);

BEGIN_MODULE(mercury__std_util_module44)
	init_entry(mercury__fn__std_util__type_name_1_0);
	init_label(mercury__fn__std_util__type_name_1_0_i2);
	init_label(mercury__fn__std_util__type_name_1_0_i5);
	init_label(mercury__fn__std_util__type_name_1_0_i9);
	init_label(mercury__fn__std_util__type_name_1_0_i15);
	init_label(mercury__fn__std_util__type_name_1_0_i16);
	init_label(mercury__fn__std_util__type_name_1_0_i10);
	init_label(mercury__fn__std_util__type_name_1_0_i17);
	init_label(mercury__fn__std_util__type_name_1_0_i18);
	init_label(mercury__fn__std_util__type_name_1_0_i20);
	init_label(mercury__fn__std_util__type_name_1_0_i25);
BEGIN_CODE

/* code for predicate 'type_name'/2 in mode 0 */
Define_entry(mercury__fn__std_util__type_name_1_0);
	incr_sp_push_msg(3, "std_util:type_name/2");
	detstackvar(3) = (Word) succip;
	{
		Word	TypeInfo;
		Word	TypeCtor;
		Word	TypeArgs;
		TypeInfo = r1;
#line 1516 "std_util.m"
{		
{
	Word *type_info, *base_type_info;
	Integer arity;

	save_transient_registers();
	type_info = (Word *) ML_collapse_equivalences(TypeInfo);
	base_type_info = MR_TYPEINFO_GET_BASE_TYPEINFO(type_info);
	TypeCtor = ML_make_ctor_info(type_info, base_type_info);

	if (MR_TYPECTOR_IS_HIGHER_ORDER(TypeCtor)) {
		arity = MR_TYPECTOR_GET_HOT_ARITY(TypeCtor);
		TypeArgs = ML_copy_argument_typeinfos(arity, 0,
			type_info + TYPEINFO_OFFSET_FOR_PRED_ARGS);
	} else {
		arity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(base_type_info);
		TypeArgs = ML_copy_argument_typeinfos(arity, 0,
			type_info + OFFSET_FOR_ARG_TYPE_INFOS);
	}
	restore_transient_registers();

}
;}
#line 3817 "std_util.c"
		r2 = TypeCtor;
		r3 = TypeArgs;

	}
	{
		Word	TypeCtor;
		String	TypeCtorModuleName;
		String	TypeCtorName;
		Integer	TypeCtorArity;
		TypeCtor = r2;
#line 1611 "std_util.m"
{		
{
	Word *type_ctor = (Word *) TypeCtor;

	if (MR_TYPECTOR_IS_HIGHER_ORDER(type_ctor)) {
		TypeCtorName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_NAME(type_ctor);
		TypeCtorModuleName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_MODULE_NAME(type_ctor);
		TypeCtorArity = MR_TYPECTOR_GET_HOT_ARITY(type_ctor);
	} else {
		TypeCtorName = MR_BASE_TYPEINFO_GET_TYPE_NAME(type_ctor);
		TypeCtorArity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(type_ctor);
		TypeCtorModuleName = 
			MR_BASE_TYPEINFO_GET_TYPE_MODULE_NAME(type_ctor);
	}
}
;}
#line 3847 "std_util.c"
		r1 = (Word) TypeCtorModuleName;
		r4 = (Word) TypeCtorName;
		r5 = TypeCtorArity;

	}
	if (((Integer) r5 != (Integer) 0))
		GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i2);
	r2 = r1;
	r1 = r4;
	GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i20);
Define_label(mercury__fn__std_util__type_name_1_0_i2);
	if ((strcmp((char *)r1, (char *)(Word) (const Word *) string_const("mercury_builtin", 15)) != 0))
		GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i5);
	if ((strcmp((char *)r4, (char *)(Word) (const Word *) string_const("func", 4)) != 0))
		GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i5);
	r2 = r1;
	r1 = r3;
	r3 = r4;
	r4 = (Integer) 1;
	GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i9);
Define_label(mercury__fn__std_util__type_name_1_0_i5);
	r2 = r1;
	r1 = r3;
	r3 = r4;
	r4 = (Integer) 0;
Define_label(mercury__fn__std_util__type_name_1_0_i9);
	if (((Integer) r4 != (Integer) 1))
		GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i10);
	if (((Integer) r1 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i10);
	r5 = const_field(mktag(1), r1, (Integer) 1);
	if (((Integer) r5 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i10);
	detstackvar(1) = r2;
	r1 = const_field(mktag(1), r1, (Integer) 0);
	localcall(mercury__fn__std_util__type_name_1_0,
		LABEL(mercury__fn__std_util__type_name_1_0_i15),
		ENTRY(mercury__fn__std_util__type_name_1_0));
Define_label(mercury__fn__std_util__type_name_1_0_i15);
	update_prof_current_proc(LABEL(mercury__fn__std_util__type_name_1_0));
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 2);
	field(mktag(1), r1, (Integer) 0) = (Word) (const Word *) string_const("((func) = ", 10);
	tag_incr_hp(r3, mktag(1), (Integer) 2);
	field(mktag(1), r3, (Integer) 0) = r2;
	field(mktag(1), r3, (Integer) 1) = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_std_util__common_0);
	field(mktag(1), r1, (Integer) 1) = r3;
	call_localret(ENTRY(mercury__string__append_list_2_0),
		mercury__fn__std_util__type_name_1_0_i16,
		ENTRY(mercury__fn__std_util__type_name_1_0));
Define_label(mercury__fn__std_util__type_name_1_0_i16);
	update_prof_current_proc(LABEL(mercury__fn__std_util__type_name_1_0));
	r2 = detstackvar(1);
	GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i20);
Define_label(mercury__fn__std_util__type_name_1_0_i10);
	detstackvar(1) = r2;
	detstackvar(2) = r3;
	r2 = r4;
	call_localret(STATIC(mercury__std_util__type_arg_names_3_0),
		mercury__fn__std_util__type_name_1_0_i17,
		ENTRY(mercury__fn__std_util__type_name_1_0));
Define_label(mercury__fn__std_util__type_name_1_0_i17);
	update_prof_current_proc(LABEL(mercury__fn__std_util__type_name_1_0));
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 2);
	field(mktag(1), r1, (Integer) 0) = detstackvar(2);
	tag_incr_hp(r3, mktag(1), (Integer) 2);
	field(mktag(1), r3, (Integer) 0) = (Word) (const Word *) string_const("(", 1);
	field(mktag(1), r3, (Integer) 1) = r2;
	field(mktag(1), r1, (Integer) 1) = r3;
	call_localret(ENTRY(mercury__string__append_list_2_0),
		mercury__fn__std_util__type_name_1_0_i18,
		ENTRY(mercury__fn__std_util__type_name_1_0));
Define_label(mercury__fn__std_util__type_name_1_0_i18);
	update_prof_current_proc(LABEL(mercury__fn__std_util__type_name_1_0));
	r2 = detstackvar(1);
Define_label(mercury__fn__std_util__type_name_1_0_i20);
	if ((strcmp((char *)r2, (char *)(Word) (const Word *) string_const("mercury_builtin", 15)) == 0))
		GOTO_LABEL(mercury__fn__std_util__type_name_1_0_i25);
	r3 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 2);
	field(mktag(1), r1, (Integer) 0) = r2;
	tag_incr_hp(r4, mktag(1), (Integer) 2);
	field(mktag(1), r4, (Integer) 0) = (Word) (const Word *) string_const(":", 1);
	tag_incr_hp(r5, mktag(1), (Integer) 2);
	field(mktag(1), r5, (Integer) 0) = r3;
	field(mktag(1), r5, (Integer) 1) = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	field(mktag(1), r4, (Integer) 1) = r5;
	field(mktag(1), r1, (Integer) 1) = r4;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	tailcall(ENTRY(mercury__string__append_list_2_0),
		ENTRY(mercury__fn__std_util__type_name_1_0));
Define_label(mercury__fn__std_util__type_name_1_0_i25);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module45)
	init_entry(mercury__std_util__type_ctor_and_args_3_0);
BEGIN_CODE

/* code for predicate 'type_ctor_and_args'/3 in mode 0 */
Define_entry(mercury__std_util__type_ctor_and_args_3_0);
	{
		Word	TypeInfo;
		Word	TypeCtor;
		Word	TypeArgs;
		TypeInfo = r1;
#line 1516 "std_util.m"
{		
{
	Word *type_info, *base_type_info;
	Integer arity;

	save_transient_registers();
	type_info = (Word *) ML_collapse_equivalences(TypeInfo);
	base_type_info = MR_TYPEINFO_GET_BASE_TYPEINFO(type_info);
	TypeCtor = ML_make_ctor_info(type_info, base_type_info);

	if (MR_TYPECTOR_IS_HIGHER_ORDER(TypeCtor)) {
		arity = MR_TYPECTOR_GET_HOT_ARITY(TypeCtor);
		TypeArgs = ML_copy_argument_typeinfos(arity, 0,
			type_info + TYPEINFO_OFFSET_FOR_PRED_ARGS);
	} else {
		arity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(base_type_info);
		TypeArgs = ML_copy_argument_typeinfos(arity, 0,
			type_info + OFFSET_FOR_ARG_TYPE_INFOS);
	}
	restore_transient_registers();

}
;}
#line 3983 "std_util.c"
		r2 = TypeCtor;
		r3 = TypeArgs;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module46)
	init_entry(mercury__fn__std_util__type_ctor_1_0);
BEGIN_CODE

/* code for predicate 'type_ctor'/2 in mode 0 */
Define_entry(mercury__fn__std_util__type_ctor_1_0);
	{
		Word	TypeInfo;
		Word	TypeCtor;
		TypeInfo = r1;
#line 1459 "std_util.m"
{		
{
	Word *type_info, *base_type_info;

	save_transient_registers();
	type_info = (Word *) ML_collapse_equivalences(TypeInfo);
	restore_transient_registers();

	base_type_info = (Word *) MR_TYPEINFO_GET_BASE_TYPEINFO(type_info);

	TypeCtor = ML_make_ctor_info(type_info, base_type_info);
}
;}
#line 4018 "std_util.c"
		r2 = TypeCtor;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module47)
	init_entry(mercury__fn__std_util__type_args_1_0);
BEGIN_CODE

/* code for predicate 'type_args'/2 in mode 0 */
Define_entry(mercury__fn__std_util__type_args_1_0);
	{
		Word	TypeInfo;
		Word	TypeCtor;
		Word	TypeArgs;
		TypeInfo = r1;
#line 1516 "std_util.m"
{		
{
	Word *type_info, *base_type_info;
	Integer arity;

	save_transient_registers();
	type_info = (Word *) ML_collapse_equivalences(TypeInfo);
	base_type_info = MR_TYPEINFO_GET_BASE_TYPEINFO(type_info);
	TypeCtor = ML_make_ctor_info(type_info, base_type_info);

	if (MR_TYPECTOR_IS_HIGHER_ORDER(TypeCtor)) {
		arity = MR_TYPECTOR_GET_HOT_ARITY(TypeCtor);
		TypeArgs = ML_copy_argument_typeinfos(arity, 0,
			type_info + TYPEINFO_OFFSET_FOR_PRED_ARGS);
	} else {
		arity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(base_type_info);
		TypeArgs = ML_copy_argument_typeinfos(arity, 0,
			type_info + OFFSET_FOR_ARG_TYPE_INFOS);
	}
	restore_transient_registers();

}
;}
#line 4062 "std_util.c"
		r2 = TypeCtor;
		r3 = TypeArgs;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module48)
	init_entry(mercury__fn__std_util__type_ctor_name_1_0);
BEGIN_CODE

/* code for predicate 'type_ctor_name'/2 in mode 0 */
Define_entry(mercury__fn__std_util__type_ctor_name_1_0);
	{
		Word	TypeCtor;
		String	TypeCtorModuleName;
		String	TypeCtorName;
		Integer	TypeCtorArity;
		TypeCtor = r1;
#line 1611 "std_util.m"
{		
{
	Word *type_ctor = (Word *) TypeCtor;

	if (MR_TYPECTOR_IS_HIGHER_ORDER(type_ctor)) {
		TypeCtorName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_NAME(type_ctor);
		TypeCtorModuleName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_MODULE_NAME(type_ctor);
		TypeCtorArity = MR_TYPECTOR_GET_HOT_ARITY(type_ctor);
	} else {
		TypeCtorName = MR_BASE_TYPEINFO_GET_TYPE_NAME(type_ctor);
		TypeCtorArity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(type_ctor);
		TypeCtorModuleName = 
			MR_BASE_TYPEINFO_GET_TYPE_MODULE_NAME(type_ctor);
	}
}
;}
#line 4103 "std_util.c"
		r2 = (Word) TypeCtorModuleName;
		r3 = (Word) TypeCtorName;
		r4 = TypeCtorArity;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module49)
	init_entry(mercury__fn__std_util__type_ctor_module_name_1_0);
BEGIN_CODE

/* code for predicate 'type_ctor_module_name'/2 in mode 0 */
Define_entry(mercury__fn__std_util__type_ctor_module_name_1_0);
	{
		Word	TypeCtor;
		String	TypeCtorModuleName;
		String	TypeCtorName;
		Integer	TypeCtorArity;
		TypeCtor = r1;
#line 1611 "std_util.m"
{		
{
	Word *type_ctor = (Word *) TypeCtor;

	if (MR_TYPECTOR_IS_HIGHER_ORDER(type_ctor)) {
		TypeCtorName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_NAME(type_ctor);
		TypeCtorModuleName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_MODULE_NAME(type_ctor);
		TypeCtorArity = MR_TYPECTOR_GET_HOT_ARITY(type_ctor);
	} else {
		TypeCtorName = MR_BASE_TYPEINFO_GET_TYPE_NAME(type_ctor);
		TypeCtorArity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(type_ctor);
		TypeCtorModuleName = 
			MR_BASE_TYPEINFO_GET_TYPE_MODULE_NAME(type_ctor);
	}
}
;}
#line 4145 "std_util.c"
		r2 = (Word) TypeCtorModuleName;
		r3 = (Word) TypeCtorName;
		r4 = TypeCtorArity;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module50)
	init_entry(mercury__fn__std_util__type_ctor_arity_1_0);
BEGIN_CODE

/* code for predicate 'type_ctor_arity'/2 in mode 0 */
Define_entry(mercury__fn__std_util__type_ctor_arity_1_0);
	{
		Word	TypeCtor;
		String	TypeCtorModuleName;
		String	TypeCtorName;
		Integer	TypeCtorArity;
		TypeCtor = r1;
#line 1611 "std_util.m"
{		
{
	Word *type_ctor = (Word *) TypeCtor;

	if (MR_TYPECTOR_IS_HIGHER_ORDER(type_ctor)) {
		TypeCtorName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_NAME(type_ctor);
		TypeCtorModuleName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_MODULE_NAME(type_ctor);
		TypeCtorArity = MR_TYPECTOR_GET_HOT_ARITY(type_ctor);
	} else {
		TypeCtorName = MR_BASE_TYPEINFO_GET_TYPE_NAME(type_ctor);
		TypeCtorArity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(type_ctor);
		TypeCtorModuleName = 
			MR_BASE_TYPEINFO_GET_TYPE_MODULE_NAME(type_ctor);
	}
}
;}
#line 4187 "std_util.c"
		r2 = (Word) TypeCtorModuleName;
		r3 = (Word) TypeCtorName;
		r4 = TypeCtorArity;

	}
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module51)
	init_entry(mercury__std_util__type_ctor_name_and_arity_4_0);
BEGIN_CODE

/* code for predicate 'type_ctor_name_and_arity'/4 in mode 0 */
Define_entry(mercury__std_util__type_ctor_name_and_arity_4_0);
	{
		Word	TypeCtor;
		String	TypeCtorModuleName;
		String	TypeCtorName;
		Integer	TypeCtorArity;
		TypeCtor = r1;
#line 1611 "std_util.m"
{		
{
	Word *type_ctor = (Word *) TypeCtor;

	if (MR_TYPECTOR_IS_HIGHER_ORDER(type_ctor)) {
		TypeCtorName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_NAME(type_ctor);
		TypeCtorModuleName = (String) (Word) 
			MR_TYPECTOR_GET_HOT_MODULE_NAME(type_ctor);
		TypeCtorArity = MR_TYPECTOR_GET_HOT_ARITY(type_ctor);
	} else {
		TypeCtorName = MR_BASE_TYPEINFO_GET_TYPE_NAME(type_ctor);
		TypeCtorArity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(type_ctor);
		TypeCtorModuleName = 
			MR_BASE_TYPEINFO_GET_TYPE_MODULE_NAME(type_ctor);
	}
}
;}
#line 4229 "std_util.c"
		r2 = (Word) TypeCtorModuleName;
		r3 = (Word) TypeCtorName;
		r4 = TypeCtorArity;

	}
	r1 = r2;
	r2 = r3;
	r3 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module52)
	init_entry(mercury__fn__std_util__make_type_2_0);
	init_label(mercury__fn__std_util__make_type_2_0_i1);
BEGIN_CODE

/* code for predicate 'make_type'/3 in mode 0 */
Define_entry(mercury__fn__std_util__make_type_2_0);
	r3 = r1;
	{
		Word	TypeCtor;
		Word	ArgTypes;
		Word	Type;
		TypeCtor = r1;
		ArgTypes = r2;
#line 1550 "std_util.m"
{		
{
	int list_length, arity;
	Word arg_type;
	Word *base_type_info;
	
	base_type_info = (Word *) TypeCtor;

	if (MR_TYPECTOR_IS_HIGHER_ORDER(base_type_info)) {
		arity = MR_TYPECTOR_GET_HOT_ARITY(base_type_info);
	} else {
		arity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(base_type_info);
	}

	arg_type = ArgTypes; 
	for (list_length = 0; !list_is_empty(arg_type); list_length++) {
		arg_type = list_tail(arg_type);
	}

	if (list_length != arity) {
		SUCCESS_INDICATOR = FALSE;
	} else {
		save_transient_registers();
		Type = ML_make_type(arity, base_type_info, ArgTypes);
		restore_transient_registers();
		SUCCESS_INDICATOR = TRUE;
	}
}
;}
#line 4286 "std_util.c"
		r4 = Type;

	}
	if (!(r1))
		GOTO_LABEL(mercury__fn__std_util__make_type_2_0_i1);
	r2 = r4;
	r1 = TRUE;
	proceed();
Define_label(mercury__fn__std_util__make_type_2_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module53)
	init_entry(mercury__fn__std_util__make_type_2_1);
BEGIN_CODE

/* code for predicate 'make_type'/3 in mode 1 */
Define_entry(mercury__fn__std_util__make_type_2_1);
	{
		Word	TypeCtor;
		Word	ArgTypes;
		Word	TypeInfo;
		TypeInfo = r1;
#line 1587 "std_util.m"
{		
{
	Word *type_info = (Word *) TypeInfo;
	Word *base_type_info = MR_TYPEINFO_GET_BASE_TYPEINFO(type_info);
	Integer arity;

	TypeCtor = ML_make_ctor_info(type_info, base_type_info);
	if (MR_TYPECTOR_IS_HIGHER_ORDER(TypeCtor)) {
		arity = MR_TYPECTOR_GET_HOT_ARITY(base_type_info);
		save_transient_registers();
		ArgTypes = ML_copy_argument_typeinfos(arity, 0,
			type_info + TYPEINFO_OFFSET_FOR_PRED_ARGS);
		restore_transient_registers();
	} else {
		arity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(base_type_info);
		save_transient_registers();
		ArgTypes = ML_copy_argument_typeinfos(arity, 0,
			type_info + OFFSET_FOR_ARG_TYPE_INFOS);
		restore_transient_registers();
	}
}
;}
#line 4335 "std_util.c"
		r2 = TypeCtor;
		r3 = ArgTypes;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module54)
	init_entry(mercury__fn__std_util__det_make_type_2_0);
	init_label(mercury__fn__std_util__det_make_type_2_0_i2);
BEGIN_CODE

/* code for predicate 'det_make_type'/3 in mode 0 */
Define_entry(mercury__fn__std_util__det_make_type_2_0);
	r3 = r1;
	{
		Word	TypeCtor;
		Word	ArgTypes;
		Word	Type;
		TypeCtor = r1;
		ArgTypes = r2;
#line 1550 "std_util.m"
{		
{
	int list_length, arity;
	Word arg_type;
	Word *base_type_info;
	
	base_type_info = (Word *) TypeCtor;

	if (MR_TYPECTOR_IS_HIGHER_ORDER(base_type_info)) {
		arity = MR_TYPECTOR_GET_HOT_ARITY(base_type_info);
	} else {
		arity = MR_BASE_TYPEINFO_GET_TYPE_ARITY(base_type_info);
	}

	arg_type = ArgTypes; 
	for (list_length = 0; !list_is_empty(arg_type); list_length++) {
		arg_type = list_tail(arg_type);
	}

	if (list_length != arity) {
		SUCCESS_INDICATOR = FALSE;
	} else {
		save_transient_registers();
		Type = ML_make_type(arity, base_type_info, ArgTypes);
		restore_transient_registers();
		SUCCESS_INDICATOR = TRUE;
	}
}
;}
#line 4390 "std_util.c"
		r4 = Type;

	}
	if (!(r1))
		GOTO_LABEL(mercury__fn__std_util__det_make_type_2_0_i2);
	r1 = r4;
	proceed();
Define_label(mercury__fn__std_util__det_make_type_2_0_i2);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("det_make_type/2: make_type/2 failed (wrong arity)", 49);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 4410 "std_util.c"

	}
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module55)
	init_entry(mercury__fn__std_util__num_functors_1_0);
BEGIN_CODE

/* code for predicate 'num_functors'/2 in mode 0 */
Define_entry(mercury__fn__std_util__num_functors_1_0);
	{
		Word	TypeInfo;
		Integer	Functors;
		TypeInfo = r1;
#line 1632 "std_util.m"
{		
{
	save_transient_registers();
	Functors = ML_get_num_functors(TypeInfo); 
	restore_transient_registers(); 
}
;}
#line 4435 "std_util.c"
		r2 = Functors;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module56)
	init_entry(mercury__std_util__get_functor_5_0);
	init_label(mercury__std_util__get_functor_5_0_i1);
BEGIN_CODE

/* code for predicate 'get_functor'/5 in mode 0 */
Define_entry(mercury__std_util__get_functor_5_0);
	r3 = r1;
	{
		Word	TypeInfo;
		Integer	FunctorNumber;
		String	FunctorName;
		Integer	Arity;
		Word	TypeInfoList;
		TypeInfo = r1;
		FunctorNumber = r2;
#line 1641 "std_util.m"
{		
{
	ML_Construct_Info info;
	bool success;

		/* 
		** Get information for this functor number and
		** store in info. If this is a discriminated union
		** type and if the functor number is in range, we
		** succeed.
		*/
	save_transient_registers();
	success = ML_get_functors_check_range(FunctorNumber,
				TypeInfo, &info);
	restore_transient_registers();

		/* 
		** Get the functor name and arity, construct the list
		** of type_infos for arguments.
		*/

	if (success) {
		make_aligned_string(FunctorName, (String) (Word) 
				info.functor_name);
		Arity = info.arity;
		save_transient_registers();
		TypeInfoList = ML_copy_argument_typeinfos((int) Arity,
				TypeInfo, info.argument_vector);
		restore_transient_registers();
	}
	SUCCESS_INDICATOR = success;
}
;}
#line 4494 "std_util.c"
		r4 = (Word) FunctorName;
		r5 = Arity;
		r6 = TypeInfoList;

	}
	if (!(r1))
		GOTO_LABEL(mercury__std_util__get_functor_5_0_i1);
	r2 = r4;
	r3 = r5;
	r4 = r6;
	r1 = TRUE;
	proceed();
Define_label(mercury__std_util__get_functor_5_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module57)
	init_entry(mercury__fn__std_util__construct_3_0);
	init_label(mercury__fn__std_util__construct_3_0_i1);
BEGIN_CODE

/* code for predicate 'construct'/4 in mode 0 */
Define_entry(mercury__fn__std_util__construct_3_0);
	r4 = r1;
	{
		Word	TypeInfo;
		Integer	FunctorNumber;
		Word	ArgList;
		Word	Term;
		TypeInfo = r1;
		FunctorNumber = r2;
		ArgList = r3;
#line 1677 "std_util.m"
{		
{
	Word 	layout_entry, new_data, term_vector;
	ML_Construct_Info info;
	bool success;

		/* 
		** Check range of FunctorNum, get info for this
		** functor.
		*/
	save_transient_registers();
	success = 
		ML_get_functors_check_range(FunctorNumber, TypeInfo, &info) &&
		ML_typecheck_arguments(TypeInfo, info.arity, ArgList, 
				info.argument_vector);
	restore_transient_registers();

		/*
		** Build the new term. 
		** 
		** It will be stored in `new_data', and `term_vector' is a
		** the argument vector.
		** 
		*/
	if (success) {

		layout_entry = MR_BASE_TYPEINFO_GET_TYPELAYOUT_ENTRY(
			MR_TYPEINFO_GET_BASE_TYPEINFO((Word *) TypeInfo), 
				info.primary_tag);

		if (info.vector_type == MR_TYPEFUNCTORS_ENUM) {
			/*
			** Enumeratiors don't have tags or arguments,
			** just the enumeration value.
			*/
			new_data = (Word) info.secondary_tag;
		} else {
			/* 
			** It must be some sort of tagged functor.
			*/

			if (info.vector_type == MR_TYPEFUNCTORS_NO_TAG) {

				/*
				** We set term_vector to point to
				** new_data so that the argument filling
				** loop will fill the argument in.
				*/

				term_vector = (Word) &new_data;

			} else if (tag(layout_entry) == 
					TYPELAYOUT_COMPLICATED_TAG) {

				/*
				** Create arity + 1 words, fill in the
				** secondary tag, and the term_vector will
				** be the rest of the words.
				*/
				incr_hp(new_data, info.arity + 1);
				field(0, new_data, 0) = info.secondary_tag;
				term_vector = (Word) (new_data + sizeof(Word));

			} else if (tag(layout_entry) == TYPELAYOUT_CONST_TAG) {

				/* 
				** If it's a du, and this tag is
				** constant, it must be a complicated
				** constant tag. 
				*/

				new_data = mkbody(info.secondary_tag);
				term_vector = (Word) NULL;

			} else {

				/*
				** A simple tagged word, just need to
				** create arguments.
				*/

				incr_hp(new_data, info.arity);
				term_vector = (Word) new_data; 
			}

				/* 
				** Copy arguments.
				*/

			ML_copy_arguments_from_list_to_vector(info.arity,
					ArgList, term_vector);

				/* 
				** Add tag to new_data.
				*/
			new_data = (Word) mkword(mktag(info.primary_tag), 
				new_data);
		}

		/* 
		** Create a univ.
		*/

		incr_hp(Term, 2);
		field(mktag(0), Term, UNIV_OFFSET_FOR_TYPEINFO) = 
			(Word) TypeInfo;
		field(mktag(0), Term, UNIV_OFFSET_FOR_DATA) = (Word) new_data;
	}

	SUCCESS_INDICATOR = success;
}
;}
#line 4642 "std_util.c"
		r5 = Term;

	}
	if (!(r1))
		GOTO_LABEL(mercury__fn__std_util__construct_3_0_i1);
	r2 = r5;
	r1 = TRUE;
	proceed();
Define_label(mercury__fn__std_util__construct_3_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module58)
	init_entry(mercury__std_util__functor_3_0);
BEGIN_CODE

/* code for predicate 'functor'/3 in mode 0 */
Define_entry(mercury__std_util__functor_3_0);
	{
		Word	TypeInfo_for_T;
		Word	Term;
		String	Functor;
		Integer	Arity;
		TypeInfo_for_T = r1;
		Term = r2;
#line 2784 "std_util.m"
{		 
{
	ML_Expand_Info info;

	info.need_functor = TRUE;
	info.need_args = FALSE;

	save_transient_registers();

	ML_expand((Word *) TypeInfo_for_T, &Term, &info);

	restore_transient_registers();

		/*
		** Check for attempts to deconstruct a non-canonical type:
		** such deconstructions must be cc_multi, and since
		** functor/2 is det, we must treat violations of this
		** as runtime errors.
		** (There ought to be a cc_multi version of functor/2
		** that allows this.)
		*/
	if (info.non_canonical_type) {
		fatal_error("called functor/2 for a type with a "
			"user-defined equality predicate");
	}

		/* Copy functor onto the heap */
	make_aligned_string(LVALUE_CAST(ConstString, Functor), info.functor);

	Arity = info.arity;
};}
#line 4702 "std_util.c"
		r3 = (Word) Functor;
		r4 = Arity;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module59)
	init_entry(mercury__fn__std_util__arg_2_0);
	init_label(mercury__fn__std_util__arg_2_0_i1);
BEGIN_CODE

/* code for predicate 'arg'/3 in mode 0 */
Define_entry(mercury__fn__std_util__arg_2_0);
	r5 = r1;
	{
		Word	TypeInfo_for_T;
		Word	TypeInfo_for_ArgT;
		Word	Term;
		Integer	ArgumentIndex;
		Word	Argument;
		TypeInfo_for_T = r1;
		TypeInfo_for_ArgT = r2;
		Term = r3;
		ArgumentIndex = r4;
#line 2822 "std_util.m"
{		 
{
	Word arg_type_info;
	Word *argument_ptr;
	bool success;
	int comparison_result;

	save_transient_registers();

	success = ML_arg(TypeInfo_for_T, &Term, ArgumentIndex, &arg_type_info,
			&argument_ptr);

	if (success) {
		/* compare the actual type with the expected type */
		comparison_result =
			ML_compare_type_info(arg_type_info, TypeInfo_for_ArgT);
		success = (comparison_result == COMPARE_EQUAL);

		if (success) {
			Argument = *argument_ptr;
		}
	}

	restore_transient_registers();

	SUCCESS_INDICATOR = success;
};}
#line 4759 "std_util.c"
		r6 = Argument;

	}
	if (!(r1))
		GOTO_LABEL(mercury__fn__std_util__arg_2_0_i1);
	r2 = r6;
	r1 = TRUE;
	proceed();
Define_label(mercury__fn__std_util__arg_2_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module60)
	init_entry(mercury__fn__std_util__argument_2_0);
	init_label(mercury__fn__std_util__argument_2_0_i1);
BEGIN_CODE

/* code for predicate 'argument'/3 in mode 0 */
Define_entry(mercury__fn__std_util__argument_2_0);
	r4 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Term;
		Integer	ArgumentIndex;
		Word	ArgumentUniv;
		TypeInfo_for_T = r1;
		Term = r2;
		ArgumentIndex = r3;
#line 2851 "std_util.m"
{		 
{
	Word arg_type_info;
	Word *argument_ptr;
	bool success;

	save_transient_registers();

	success = ML_arg(TypeInfo_for_T, &Term, ArgumentIndex, &arg_type_info,
			&argument_ptr);

	restore_transient_registers();

	if (success) {
		/* Allocate enough room for a univ */
		incr_hp(ArgumentUniv, 2);
		field(0, ArgumentUniv, UNIV_OFFSET_FOR_TYPEINFO) =
			arg_type_info;
		field(0, ArgumentUniv, UNIV_OFFSET_FOR_DATA) = *argument_ptr;
	}

	SUCCESS_INDICATOR = success;

};}
#line 4815 "std_util.c"
		r5 = ArgumentUniv;

	}
	if (!(r1))
		GOTO_LABEL(mercury__fn__std_util__argument_2_0_i1);
	r2 = r5;
	r1 = TRUE;
	proceed();
Define_label(mercury__fn__std_util__argument_2_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module61)
	init_entry(mercury__fn__std_util__det_arg_2_0);
	init_label(mercury__fn__std_util__det_arg_2_0_i4);
	init_label(mercury__fn__std_util__det_arg_2_0_i3);
	init_label(mercury__fn__std_util__det_arg_2_0_i5);
BEGIN_CODE

/* code for predicate 'det_arg'/3 in mode 0 */
Define_entry(mercury__fn__std_util__det_arg_2_0);
	incr_sp_push_msg(3, "std_util:det_arg/3");
	r5 = r1;
	{
		Word	TypeInfo_for_T;
		Word	TypeInfo_for_ArgT;
		Word	Term;
		Integer	ArgumentIndex;
		Word	Argument;
		TypeInfo_for_T = r1;
		TypeInfo_for_ArgT = r2;
		Term = r3;
		ArgumentIndex = r4;
#line 2822 "std_util.m"
{		 
{
	Word arg_type_info;
	Word *argument_ptr;
	bool success;
	int comparison_result;

	save_transient_registers();

	success = ML_arg(TypeInfo_for_T, &Term, ArgumentIndex, &arg_type_info,
			&argument_ptr);

	if (success) {
		/* compare the actual type with the expected type */
		comparison_result =
			ML_compare_type_info(arg_type_info, TypeInfo_for_ArgT);
		success = (comparison_result == COMPARE_EQUAL);

		if (success) {
			Argument = *argument_ptr;
		}
	}

	restore_transient_registers();

	SUCCESS_INDICATOR = success;
};}
#line 4879 "std_util.c"
		r6 = Argument;

	}
	if (r1)
		GOTO_LABEL(mercury__fn__std_util__det_arg_2_0_i4);
	detstackvar(1) = r3;
	detstackvar(2) = r4;
	detstackvar(3) = r5;
	GOTO_LABEL(mercury__fn__std_util__det_arg_2_0_i3);
Define_label(mercury__fn__std_util__det_arg_2_0_i4);
	r1 = r6;
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__fn__std_util__det_arg_2_0_i3);
	r3 = detstackvar(1);
	r4 = detstackvar(2);
	r1 = detstackvar(3);
	r2 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Term;
		Integer	ArgumentIndex;
		Word	ArgumentUniv;
		TypeInfo_for_T = r1;
		Term = r3;
		ArgumentIndex = r4;
#line 2851 "std_util.m"
{		 
{
	Word arg_type_info;
	Word *argument_ptr;
	bool success;

	save_transient_registers();

	success = ML_arg(TypeInfo_for_T, &Term, ArgumentIndex, &arg_type_info,
			&argument_ptr);

	restore_transient_registers();

	if (success) {
		/* Allocate enough room for a univ */
		incr_hp(ArgumentUniv, 2);
		field(0, ArgumentUniv, UNIV_OFFSET_FOR_TYPEINFO) =
			arg_type_info;
		field(0, ArgumentUniv, UNIV_OFFSET_FOR_DATA) = *argument_ptr;
	}

	SUCCESS_INDICATOR = success;

};}
#line 4931 "std_util.c"
		r5 = ArgumentUniv;

	}
	if (!(r1))
		GOTO_LABEL(mercury__fn__std_util__det_arg_2_0_i5);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("det_arg: argument number out of range", 37);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 4948 "std_util.c"

	}
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__fn__std_util__det_arg_2_0_i5);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("det_arg: argument had wrong type", 32);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 4965 "std_util.c"

	}
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module62)
	init_entry(mercury__fn__std_util__det_argument_2_0);
	init_label(mercury__fn__std_util__det_argument_2_0_i2);
BEGIN_CODE

/* code for predicate 'det_argument'/3 in mode 0 */
Define_entry(mercury__fn__std_util__det_argument_2_0);
	r4 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Term;
		Integer	ArgumentIndex;
		Word	ArgumentUniv;
		TypeInfo_for_T = r1;
		Term = r2;
		ArgumentIndex = r3;
#line 2851 "std_util.m"
{		 
{
	Word arg_type_info;
	Word *argument_ptr;
	bool success;

	save_transient_registers();

	success = ML_arg(TypeInfo_for_T, &Term, ArgumentIndex, &arg_type_info,
			&argument_ptr);

	restore_transient_registers();

	if (success) {
		/* Allocate enough room for a univ */
		incr_hp(ArgumentUniv, 2);
		field(0, ArgumentUniv, UNIV_OFFSET_FOR_TYPEINFO) =
			arg_type_info;
		field(0, ArgumentUniv, UNIV_OFFSET_FOR_DATA) = *argument_ptr;
	}

	SUCCESS_INDICATOR = success;

};}
#line 5014 "std_util.c"
		r5 = ArgumentUniv;

	}
	if (!(r1))
		GOTO_LABEL(mercury__fn__std_util__det_argument_2_0_i2);
	r1 = r5;
	proceed();
Define_label(mercury__fn__std_util__det_argument_2_0_i2);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("det_argument: argument out of range", 35);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 5034 "std_util.c"

	}
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module63)
	init_entry(mercury__std_util__deconstruct_4_0);
BEGIN_CODE

/* code for predicate 'deconstruct'/4 in mode 0 */
Define_entry(mercury__std_util__deconstruct_4_0);
	{
		Word	TypeInfo_for_T;
		Word	Term;
		String	Functor;
		Integer	Arity;
		Word	Arguments;
		TypeInfo_for_T = r1;
		Term = r2;
#line 2899 "std_util.m"
{		 
{
	ML_Expand_Info info;
	Word arg_pseudo_type_info;
	Word Argument, tmp;
	int i;

	info.need_functor = TRUE;
	info.need_args = TRUE;

	save_transient_registers();

	ML_expand((Word *) TypeInfo_for_T, &Term, &info);
	
	restore_transient_registers();

		/*
		** Check for attempts to deconstruct a non-canonical type:
		** such deconstructions must be cc_multi, and since
		** deconstruct/4 is det, we must treat violations of this
		** as runtime errors.
		** (There ought to be a cc_multi version of deconstruct/4
		** that allows this.)
		*/
	if (info.non_canonical_type) {
		fatal_error("called deconstruct/4 for a type with a "
			"user-defined equality predicate");
	}

		/* Get functor */
	make_aligned_string(LVALUE_CAST(ConstString, Functor), info.functor);

		/* Get arity */
	Arity = info.arity;

		/* Build argument list */
	Arguments = list_empty();
	i = info.arity;

	while (--i >= 0) {

			/* Create an argument on the heap */
		incr_hp(Argument, 2);

			/* Join the argument to the front of the list */
		Arguments = list_cons(Argument, Arguments);

			/* Fill in the arguments */
		arg_pseudo_type_info = info.type_info_vector[i];

		if (TYPEINFO_IS_VARIABLE(arg_pseudo_type_info)) {

				/* It's a type variable, get its value */
			field(0, Argument, UNIV_OFFSET_FOR_TYPEINFO) = 
				((Word *) TypeInfo_for_T)[arg_pseudo_type_info];
		}
		else {
				/* It's already a type_info */
			field(0, Argument, UNIV_OFFSET_FOR_TYPEINFO) = 
				arg_pseudo_type_info;
		}
			/* Fill in the data */
		field(0, Argument, UNIV_OFFSET_FOR_DATA) = 
			info.argument_vector[i];
	}

	/* Free the allocated type_info_vector, since we just copied
	 * all its arguments onto the heap. 
	 */

	free(info.type_info_vector);

};}
#line 5129 "std_util.c"
		r3 = (Word) Functor;
		r4 = Arity;
		r5 = Arguments;

	}
	r1 = r3;
	r2 = r4;
	r3 = r5;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module64)
	init_entry(mercury__std_util__builtin_solutions_2_0);
BEGIN_CODE

/* code for predicate 'builtin_solutions'/2 in mode 0 */
Define_entry(mercury__std_util__builtin_solutions_2_0);
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = r1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	tailcall(ENTRY(mercury__std_util__builtin_aggregate_4_0),
		ENTRY(mercury__std_util__builtin_solutions_2_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module65)
	init_entry(mercury__std_util__builtin_solutions_2_1);
BEGIN_CODE

/* code for predicate 'builtin_solutions'/2 in mode 1 */
Define_entry(mercury__std_util__builtin_solutions_2_1);
	r3 = r2;
	tag_incr_hp(r2, mktag(0), (Integer) 2);
	field(mktag(0), r2, (Integer) 0) = (Word) (const Word *) &mercury_data_list__base_type_info_list_1;
	field(mktag(0), r2, (Integer) 1) = r1;
	tag_incr_hp(r4, mktag(0), (Integer) 3);
	field(mktag(0), r4, (Integer) 0) = (Integer) 1;
	field(mktag(0), r4, (Integer) 1) = (Word) STATIC(mercury__std_util__cons_3_0);
	field(mktag(0), r4, (Integer) 2) = r1;
	r5 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	tailcall(ENTRY(mercury__std_util__builtin_aggregate_4_4),
		ENTRY(mercury__std_util__builtin_solutions_2_1));
END_MODULE


BEGIN_MODULE(mercury__std_util_module66)
	init_entry(mercury__std_util__cons_3_0);
BEGIN_CODE

/* code for predicate 'cons'/3 in mode 0 */
Define_static(mercury__std_util__cons_3_0);
	r1 = r2;
	r2 = r3;
	tailcall(STATIC(mercury__std_util__cons__ua10000_3_0),
		STATIC(mercury__std_util__cons_3_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module67)
	init_entry(mercury__std_util__type_arg_names_3_0);
	init_label(mercury__std_util__type_arg_names_3_0_i3);
	init_label(mercury__std_util__type_arg_names_3_0_i4);
	init_label(mercury__std_util__type_arg_names_3_0_i5);
	init_label(mercury__std_util__type_arg_names_3_0_i13);
	init_label(mercury__std_util__type_arg_names_3_0_i8);
	init_label(mercury__std_util__type_arg_names_3_0_i14);
BEGIN_CODE

/* code for predicate 'type_arg_names'/3 in mode 0 */
Define_static(mercury__std_util__type_arg_names_3_0);
	incr_sp_push_msg(3, "std_util:type_arg_names/3");
	detstackvar(3) = (Word) succip;
	if (((Integer) r1 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__std_util__type_arg_names_3_0_i3);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__std_util__type_arg_names_3_0_i3);
	detstackvar(1) = r2;
	detstackvar(2) = const_field(mktag(1), r1, (Integer) 1);
	r1 = const_field(mktag(1), r1, (Integer) 0);
	call_localret(STATIC(mercury__fn__std_util__type_name_1_0),
		mercury__std_util__type_arg_names_3_0_i4,
		STATIC(mercury__std_util__type_arg_names_3_0));
Define_label(mercury__std_util__type_arg_names_3_0_i4);
	update_prof_current_proc(LABEL(mercury__std_util__type_arg_names_3_0));
	if (((Integer) detstackvar(2) != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__std_util__type_arg_names_3_0_i5);
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 2);
	field(mktag(1), r1, (Integer) 0) = r2;
	field(mktag(1), r1, (Integer) 1) = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_std_util__common_0);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__std_util__type_arg_names_3_0_i5);
	if (((Integer) detstackvar(1) != (Integer) 1))
		GOTO_LABEL(mercury__std_util__type_arg_names_3_0_i8);
	if (((Integer) detstackvar(2) == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__std_util__type_arg_names_3_0_i8);
	r2 = const_field(mktag(1), detstackvar(2), (Integer) 1);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__std_util__type_arg_names_3_0_i8);
	detstackvar(1) = r1;
	r1 = const_field(mktag(1), detstackvar(2), (Integer) 0);
	call_localret(STATIC(mercury__fn__std_util__type_name_1_0),
		mercury__std_util__type_arg_names_3_0_i13,
		STATIC(mercury__std_util__type_arg_names_3_0));
Define_label(mercury__std_util__type_arg_names_3_0_i13);
	update_prof_current_proc(LABEL(mercury__std_util__type_arg_names_3_0));
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 2);
	field(mktag(1), r1, (Integer) 0) = detstackvar(1);
	tag_incr_hp(r3, mktag(1), (Integer) 2);
	field(mktag(1), r3, (Integer) 0) = (Word) (const Word *) string_const(") = ", 4);
	{
	Word tempr1;
	tag_incr_hp(tempr1, mktag(1), (Integer) 2);
	field(mktag(1), r3, (Integer) 1) = tempr1;
	field(mktag(1), r1, (Integer) 1) = r3;
	field(mktag(1), tempr1, (Integer) 1) = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	field(mktag(1), tempr1, (Integer) 0) = r2;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
	}
Define_label(mercury__std_util__type_arg_names_3_0_i8);
	r2 = detstackvar(1);
	detstackvar(1) = r1;
	r1 = detstackvar(2);
	localcall(mercury__std_util__type_arg_names_3_0,
		LABEL(mercury__std_util__type_arg_names_3_0_i14),
		STATIC(mercury__std_util__type_arg_names_3_0));
Define_label(mercury__std_util__type_arg_names_3_0_i14);
	update_prof_current_proc(LABEL(mercury__std_util__type_arg_names_3_0));
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 2);
	field(mktag(1), r1, (Integer) 0) = detstackvar(1);
	tag_incr_hp(r3, mktag(1), (Integer) 2);
	field(mktag(1), r3, (Integer) 0) = (Word) (const Word *) string_const(", ", 2);
	field(mktag(1), r3, (Integer) 1) = r2;
	field(mktag(1), r1, (Integer) 1) = r3;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE

Declare_entry(mercury__unify_2_0);

BEGIN_MODULE(mercury__std_util_module68)
	init_entry(mercury____Unify___std_util__maybe_1_0);
	init_label(mercury____Unify___std_util__maybe_1_0_i3);
	init_label(mercury____Unify___std_util__maybe_1_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___std_util__maybe_1_0);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Unify___std_util__maybe_1_0_i3);
	if (((Integer) r3 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Unify___std_util__maybe_1_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___std_util__maybe_1_0_i3);
	if (((Integer) r3 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Unify___std_util__maybe_1_0_i1);
	r2 = const_field(mktag(1), r2, (Integer) 0);
	r3 = const_field(mktag(1), r3, (Integer) 0);
	tailcall(ENTRY(mercury__unify_2_0),
		ENTRY(mercury____Unify___std_util__maybe_1_0));
Define_label(mercury____Unify___std_util__maybe_1_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module69)
	init_entry(mercury____Index___std_util__maybe_1_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___std_util__maybe_1_0);
	r1 = r2;
	tailcall(STATIC(mercury____Index___std_util__maybe_1__ua10000_2_0),
		ENTRY(mercury____Index___std_util__maybe_1_0));
END_MODULE

Declare_entry(mercury__compare_3_3);

BEGIN_MODULE(mercury__std_util_module70)
	init_entry(mercury____Compare___std_util__maybe_1_0);
	init_label(mercury____Compare___std_util__maybe_1_0_i3);
	init_label(mercury____Compare___std_util__maybe_1_0_i2);
	init_label(mercury____Compare___std_util__maybe_1_0_i5);
	init_label(mercury____Compare___std_util__maybe_1_0_i4);
	init_label(mercury____Compare___std_util__maybe_1_0_i6);
	init_label(mercury____Compare___std_util__maybe_1_0_i8);
	init_label(mercury____Compare___std_util__maybe_1_0_i13);
	init_label(mercury____Compare___std_util__maybe_1_0_i10);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___std_util__maybe_1_0);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___std_util__maybe_1_0_i3);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___std_util__maybe_1_0_i2);
Define_label(mercury____Compare___std_util__maybe_1_0_i3);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 1;
Define_label(mercury____Compare___std_util__maybe_1_0_i2);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___std_util__maybe_1_0_i5);
	incr_sp_push_msg(1, "std_util:__Compare__/3");
	detstackvar(1) = (Word) succip;
	r5 = r4;
	r4 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___std_util__maybe_1_0_i4);
Define_label(mercury____Compare___std_util__maybe_1_0_i5);
	r5 = r4;
	r4 = (Integer) 1;
	incr_sp_push_msg(1, "std_util:__Compare__/3");
	detstackvar(1) = (Word) succip;
Define_label(mercury____Compare___std_util__maybe_1_0_i4);
	if (((Integer) r3 >= (Integer) r4))
		GOTO_LABEL(mercury____Compare___std_util__maybe_1_0_i6);
	r1 = (Integer) 1;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___std_util__maybe_1_0_i6);
	if (((Integer) r3 <= (Integer) r4))
		GOTO_LABEL(mercury____Compare___std_util__maybe_1_0_i8);
	r1 = (Integer) 2;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___std_util__maybe_1_0_i8);
	if (((Integer) r1 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___std_util__maybe_1_0_i13);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___std_util__maybe_1_0_i10);
	r1 = (Integer) 0;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___std_util__maybe_1_0_i13);
	if (((Integer) r2 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___std_util__maybe_1_0_i10);
	r3 = r1;
	r1 = r5;
	r4 = r2;
	r2 = const_field(mktag(1), r3, (Integer) 0);
	r3 = const_field(mktag(1), r4, (Integer) 0);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(ENTRY(mercury__compare_3_3),
		ENTRY(mercury____Compare___std_util__maybe_1_0));
Define_label(mercury____Compare___std_util__maybe_1_0_i10);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("internal error in compare/3", 27);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 5413 "std_util.c"

	}
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module71)
	init_entry(mercury____Unify___std_util__unit_0_0);
	init_label(mercury____Unify___std_util__unit_0_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___std_util__unit_0_0);
	if ((r1 != r2))
		GOTO_LABEL(mercury____Unify___std_util__unit_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___std_util__unit_0_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module72)
	init_entry(mercury____Index___std_util__unit_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___std_util__unit_0_0);
	proceed();
END_MODULE

Declare_entry(mercury__builtin_compare_int_3_0);

BEGIN_MODULE(mercury__std_util_module73)
	init_entry(mercury____Compare___std_util__unit_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___std_util__unit_0_0);
	tailcall(ENTRY(mercury__builtin_compare_int_3_0),
		ENTRY(mercury____Compare___std_util__unit_0_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module74)
	init_entry(mercury____Unify___std_util__pair_2_0);
	init_label(mercury____Unify___std_util__pair_2_0_i2);
	init_label(mercury____Unify___std_util__pair_2_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___std_util__pair_2_0);
	incr_sp_push_msg(4, "std_util:__Unify__/2");
	detstackvar(4) = (Word) succip;
	detstackvar(1) = const_field(mktag(0), r3, (Integer) 1);
	detstackvar(2) = const_field(mktag(0), r4, (Integer) 1);
	detstackvar(3) = r2;
	r2 = const_field(mktag(0), r3, (Integer) 0);
	r3 = const_field(mktag(0), r4, (Integer) 0);
	call_localret(ENTRY(mercury__unify_2_0),
		mercury____Unify___std_util__pair_2_0_i2,
		ENTRY(mercury____Unify___std_util__pair_2_0));
Define_label(mercury____Unify___std_util__pair_2_0_i2);
	update_prof_current_proc(LABEL(mercury____Unify___std_util__pair_2_0));
	if (!(r1))
		GOTO_LABEL(mercury____Unify___std_util__pair_2_0_i1);
	r1 = detstackvar(3);
	r2 = detstackvar(1);
	r3 = detstackvar(2);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	tailcall(ENTRY(mercury__unify_2_0),
		ENTRY(mercury____Unify___std_util__pair_2_0));
Define_label(mercury____Unify___std_util__pair_2_0_i1);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module75)
	init_entry(mercury____Index___std_util__pair_2_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___std_util__pair_2_0);
	tailcall(STATIC(mercury____Index___std_util__pair_2__ua10000_2_0),
		ENTRY(mercury____Index___std_util__pair_2_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module76)
	init_entry(mercury____Compare___std_util__pair_2_0);
	init_label(mercury____Compare___std_util__pair_2_0_i4);
	init_label(mercury____Compare___std_util__pair_2_0_i9);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___std_util__pair_2_0);
	incr_sp_push_msg(4, "std_util:__Compare__/3");
	detstackvar(4) = (Word) succip;
	detstackvar(3) = r2;
	r2 = const_field(mktag(0), r3, (Integer) 0);
	detstackvar(1) = const_field(mktag(0), r3, (Integer) 1);
	r3 = const_field(mktag(0), r4, (Integer) 0);
	detstackvar(2) = const_field(mktag(0), r4, (Integer) 1);
	call_localret(ENTRY(mercury__compare_3_3),
		mercury____Compare___std_util__pair_2_0_i4,
		ENTRY(mercury____Compare___std_util__pair_2_0));
Define_label(mercury____Compare___std_util__pair_2_0_i4);
	update_prof_current_proc(LABEL(mercury____Compare___std_util__pair_2_0));
	if (((Integer) r1 != (Integer) 0))
		GOTO_LABEL(mercury____Compare___std_util__pair_2_0_i9);
	r1 = detstackvar(3);
	r2 = detstackvar(1);
	r3 = detstackvar(2);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	tailcall(ENTRY(mercury__compare_3_3),
		ENTRY(mercury____Compare___std_util__pair_2_0));
Define_label(mercury____Compare___std_util__pair_2_0_i9);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module77)
	init_entry(mercury____Unify___std_util__pair_1_0);
	init_label(mercury____Unify___std_util__pair_1_0_i2);
	init_label(mercury____Unify___std_util__pair_1_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___std_util__pair_1_0);
	incr_sp_push_msg(4, "std_util:__Unify__/2");
	detstackvar(4) = (Word) succip;
	detstackvar(1) = r1;
	detstackvar(2) = const_field(mktag(0), r2, (Integer) 1);
	detstackvar(3) = const_field(mktag(0), r3, (Integer) 1);
	r2 = const_field(mktag(0), r2, (Integer) 0);
	r3 = const_field(mktag(0), r3, (Integer) 0);
	call_localret(ENTRY(mercury__unify_2_0),
		mercury____Unify___std_util__pair_1_0_i2,
		ENTRY(mercury____Unify___std_util__pair_1_0));
Define_label(mercury____Unify___std_util__pair_1_0_i2);
	update_prof_current_proc(LABEL(mercury____Unify___std_util__pair_1_0));
	if (!(r1))
		GOTO_LABEL(mercury____Unify___std_util__pair_1_0_i1);
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	r3 = detstackvar(3);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	tailcall(ENTRY(mercury__unify_2_0),
		ENTRY(mercury____Unify___std_util__pair_1_0));
Define_label(mercury____Unify___std_util__pair_1_0_i1);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__std_util_module78)
	init_entry(mercury____Index___std_util__pair_1_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___std_util__pair_1_0);
	tailcall(STATIC(mercury____Index___std_util__pair_1__ua10000_2_0),
		ENTRY(mercury____Index___std_util__pair_1_0));
END_MODULE


BEGIN_MODULE(mercury__std_util_module79)
	init_entry(mercury____Compare___std_util__pair_1_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___std_util__pair_1_0);
	r4 = r3;
	r3 = r2;
	r2 = r1;
	tailcall(STATIC(mercury____Compare___std_util__pair_2_0),
		ENTRY(mercury____Compare___std_util__pair_1_0));
END_MODULE

Declare_entry(mercury____Unify___mercury_builtin__c_pointer_0_0);

BEGIN_MODULE(mercury__std_util_module80)
	init_entry(mercury____Unify___std_util__type_ctor_info_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___std_util__type_ctor_info_0_0);
	tailcall(ENTRY(mercury____Unify___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Unify___std_util__type_ctor_info_0_0));
END_MODULE

Declare_entry(mercury____Index___mercury_builtin__c_pointer_0_0);

BEGIN_MODULE(mercury__std_util_module81)
	init_entry(mercury____Index___std_util__type_ctor_info_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___std_util__type_ctor_info_0_0);
	tailcall(ENTRY(mercury____Index___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Index___std_util__type_ctor_info_0_0));
END_MODULE

Declare_entry(mercury____Compare___mercury_builtin__c_pointer_0_0);

BEGIN_MODULE(mercury__std_util_module82)
	init_entry(mercury____Compare___std_util__type_ctor_info_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___std_util__type_ctor_info_0_0);
	tailcall(ENTRY(mercury____Compare___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Compare___std_util__type_ctor_info_0_0));
END_MODULE

#if (defined(USE_GCC_NONLOCAL_GOTOS) && !defined(USE_ASM_LABELS)) \
	|| defined(PROFILE_CALLS) || defined(DEBUG_GOTOS) \
	|| defined(DEBUG_LABELS) || !defined(SPEED) \
	|| defined(NATIVE_GC) 

static void mercury__std_util_bunch_0(void)
{
	mercury__std_util_module0();
	mercury__std_util_module1();
	mercury__std_util_module2();
	mercury__std_util_module3();
	mercury__std_util_module4();
	mercury__std_util_module5();
	mercury__std_util_module6();
	mercury__std_util_module7();
	mercury__std_util_module8();
	mercury__std_util_module9();
	mercury__std_util_module10();
	mercury__std_util_module11();
	mercury__std_util_module12();
	mercury__std_util_module13();
	mercury__std_util_module14();
	mercury__std_util_module15();
	mercury__std_util_module16();
	mercury__std_util_module17();
	mercury__std_util_module18();
	mercury__std_util_module19();
	mercury__std_util_module20();
	mercury__std_util_module21();
	mercury__std_util_module22();
	mercury__std_util_module23();
	mercury__std_util_module24();
	mercury__std_util_module25();
	mercury__std_util_module26();
	mercury__std_util_module27();
	mercury__std_util_module28();
	mercury__std_util_module29();
	mercury__std_util_module30();
	mercury__std_util_module31();
	mercury__std_util_module32();
	mercury__std_util_module33();
	mercury__std_util_module34();
	mercury__std_util_module35();
	mercury__std_util_module36();
	mercury__std_util_module37();
	mercury__std_util_module38();
	mercury__std_util_module39();
	mercury__std_util_module40();
}

static void mercury__std_util_bunch_1(void)
{
	mercury__std_util_module41();
	mercury__std_util_module42();
	mercury__std_util_module43();
	mercury__std_util_module44();
	mercury__std_util_module45();
	mercury__std_util_module46();
	mercury__std_util_module47();
	mercury__std_util_module48();
	mercury__std_util_module49();
	mercury__std_util_module50();
	mercury__std_util_module51();
	mercury__std_util_module52();
	mercury__std_util_module53();
	mercury__std_util_module54();
	mercury__std_util_module55();
	mercury__std_util_module56();
	mercury__std_util_module57();
	mercury__std_util_module58();
	mercury__std_util_module59();
	mercury__std_util_module60();
	mercury__std_util_module61();
	mercury__std_util_module62();
	mercury__std_util_module63();
	mercury__std_util_module64();
	mercury__std_util_module65();
	mercury__std_util_module66();
	mercury__std_util_module67();
	mercury__std_util_module68();
	mercury__std_util_module69();
	mercury__std_util_module70();
	mercury__std_util_module71();
	mercury__std_util_module72();
	mercury__std_util_module73();
	mercury__std_util_module74();
	mercury__std_util_module75();
	mercury__std_util_module76();
	mercury__std_util_module77();
	mercury__std_util_module78();
	mercury__std_util_module79();
	mercury__std_util_module80();
	mercury__std_util_module81();
}

static void mercury__std_util_bunch_2(void)
{
	mercury__std_util_module82();
}

#endif

void mercury__std_util__init(void);/* suppress gcc -Wmissing-decls warning */
void mercury__std_util__init(void)
{
#if (defined(USE_GCC_NONLOCAL_GOTOS) && !defined(USE_ASM_LABELS)) \
	|| defined(PROFILE_CALLS) || defined(DEBUG_GOTOS) \
	|| defined(DEBUG_LABELS) || !defined(SPEED) \
	|| defined(NATIVE_GC) 

	static bool done = FALSE;
	if (!done) {
		done = TRUE;
		mercury__std_util_bunch_0();
		mercury__std_util_bunch_1();
		mercury__std_util_bunch_2();
	}
#endif
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_std_util__base_type_info_maybe_1,
		std_util__maybe_1_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_std_util__base_type_info_pair_1,
		std_util__pair_1_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_std_util__base_type_info_pair_2,
		std_util__pair_2_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_std_util__base_type_info_type_ctor_info_0,
		std_util__type_ctor_info_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_std_util__base_type_info_type_info_0,
		std_util__type_info_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_std_util__base_type_info_unit_0,
		std_util__unit_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_std_util__base_type_info_univ_0,
		std_util__univ_0_0);
}

/* ensure everything is compiled with the same grade */
static const void *const MR_grade = &MR_GRADE_VAR;
