<?php
/**
 *
 * Copyright 2001 - 2003 by Gero Kohnert
 *
 * @modulegroup watchlist
 * @package watchlist
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("watchlist","overview");
 loadmodule("watchlist");
 loadlayout();

 /**
  * show a overview of watchers
  */
 class watchlist_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $wl = new watchlist($this->dbconn);
     $r = $this->dbconn->Exec($this->q);
     $n = $r->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $r->free();
       return;
     }
     $cols = 6;
 
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     if ( $this->id != -1 ) {
       $cols -= 2;
       echo "<tr>\n";
       echo " <th colspan=\"". $cols ."\">". $lang[$this->obj->getType()] ." ". menulink($this->obj->getUrl(),$this->obj->getFullName()) ."</th>\n";
       echo "</tr>\n";
     }
     if ( $this->adr != -1 ) {
       $cols -= 1;
       echo "<tr>\n";
       echo " <th colspan=\"". $cols ."\">". $lang['Watcher'] ." ". menulink($this->obj->getUrl(),$this->obj->getFullName()) ."</th>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     if ( $this->id == -1 ) {
       echo $this->orderHeader("","Typ",$this->link2);
       echo $this->orderHeader("","ID",$this->link2);
     }
     if ( $this->adr == -1 ) {
       echo $this->orderHeader("adr_id",$lang['Watcher'],$this->link2);
     }
     echo $this->orderHeader("creation",$lang['created'],$this->link2);
     echo $this->orderHeader("lastcall",$lang['WatchLastCall'],$this->link2);
     echo $this->orderHeader("","&nbsp;",$this->link2);
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     echo "<tbody>\n";
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $oid = $r->get($a, "obj_id");
       $aid = $r->get($a, "adr_id");
       $obj = getObject($this->dbconn,$oid);
       $aobj = getObject($this->dbconn,$aid);

       $remove = false;
       echo $this->OverviewRowStart($line);
       if ( $this->id == -1 ) {
         if ( $obj == -1 ) {
           echo " <td nowrap align=\"right\">ID:". $oid ."</td>\n";
           echo " <td nowrap align=\"right\"><i>". makelink("history_show.php?id=".$oid,$lang['HistoryDeleted']) ."</i></td>\n";
           $remove = true;
         } else {
           echo " <td nowrap align=\"right\">". $lang[$obj->getType()] ."</td>\n";
           echo " <td nowrap align=\"right\">". $obj->getLink() ."</td>\n";
         }
       }
       if ( $this->adr == -1 ) {
         echo " <td nowrap align=\"right\">";
         if ( $aobj == -1 ) {
           echo "<i>". makelink("history_show.php?id=".$aid,$lang['HistoryDeleted']) ."</i>";
           $remove = true;
         } else {
           echo $aobj->getLink();
         }
         echo "</td>\n"; 
       }
       $d = $r->getDateTime($a, "creation");
       echo " <td nowrap align=\"right\">". $d->getDateTime() ."&nbsp;</td>\n";
       $d = $r->getDateTime($a, "lastcall");
       echo " <td nowrap align=\"right\">". $d->getDateTime() ."&nbsp;</td>\n";
 
       if ( !$remove && (($this->user->id == $aid) || ($obj != -1 ) || $obj->mod_ok() ) ) {
         $url = confirmlink("watchlist/watchlist_del.php?id=". $oid ."&adr=". $aid ."&gotourl=". $this->link1 ,$lang['Delete'],$lang['WatchDel']);
         echo " <td nowrap align=\"right\">". $url ."</td>\n";
       } else if ( $remove) {
         echo " <td nowrap align=\"right\"> removed </td>\n";
         $wl->remove($oid,$aid);
       } else {
         echo " <td nowrap align=\"right\">&nbsp;</td>\n";
       }
       echo $this->OverviewRowEnd($line++);

       $a++;
     }
     echo "</tbody>\n";

     echo $this->list_navigation($this->link1,$cols,$this->start,$a,$n);
     echo $this->OverviewTableEnd();
     $r->free();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['WatchOverview'];
     $this->link1 = "watchlist/watchlist_overview.php";
     $this->filter = array();
     $this->adr = -1;
     $this->id = -1;

     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."watchlist ";
     $pre = "WHERE ";

     if ( isset($_GET['adr']) && ($_GET['adr'] != "") ) {
       # overview of things a person is watching for
       $this->adr = $_GET['adr'];
       $this->q .=" " . $pre ." adr_id = ". $this->adr;
       $pre = "AND ";
       $this->link1 = addUrlParameter($this->link1,"adr=".$this->adr);
       $this->obj = getObject($this->dbconn,$this->adr);
     }
     if ( isset($_GET['id']) && ($_GET['id'] != "") ) {
       # overview of persons watching for something
       $this->id = $_GET['id'];
       $this->q .= " " . $pre ." obj_id = ". $this->id;
       $pre = "AND ";
       $this->link1 = addUrlParameter($this->link1,"id=".$this->id);
       $this->obj = getObject($this->dbconn,$this->id);
       # check permission
       if ( ! $this->obj->mod_ok()) {
         $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     }

     check_dbacl( $this->q, $this->user->id, "obj_id");

     # sorting
     $this->link2 = $this->link1;
     $xxx = "";
     order_parse($this->q,$this->link1,$xxx,$xxx,"obj_id");
   }
 }

 $l = new watchlist_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: watchlist_overview.php,v 1.19.2.1 2003/07/09 18:32:21 gokohnert Exp $
    $Author: gokohnert $
-->