<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * Editing of TUTOS users and their permissions
 *
 * @modulegroup user
 * @module user_new
 * @package user
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("user","new");
 loadlayout();

 /**
  * display a user change/create form
  */
 class user_new extends layout {
   /**
    * helpfunction to generate an option-field
    */
   Function acldefault_select($min,$max,$name) {
     global $lang,$tutos;

     $nr["r"] = 0;
     $nr["m"] = 1;
     $nr["d"] = 2;
     $js = "onchange='deselect(this.form,". $nr[$name] .");'";
     echo " <select multiple size=\"". min(count($this->obj->teamlist),$tutos[maxshow]) ."\" name=\"". $name ."[]\" ". $js .">\n";
     @reset ($this->obj->teamlist);
     while ( list ($i,$fn) = @each ($this->obj->teamlist) ) {
       if ( isset($this->obj->acldefault[$i]) ) {
         $l = $this->obj->acldefault[$i];
       } else {
         $l = 0;
       }
       if ( ($l < $max) && ($l >= $min) ) {
         echo "  <option value=\"". $i ."\" selected >&nbsp;". $this->obj->teamlist[$i]->getFullName() ."&nbsp;</option>\n";
       } else {
         echo "  <option value=\"". $i ."\">&nbsp;". $this->obj->teamlist[$i]->getFullName() ."&nbsp;</option>\n";
       }
     }
     echo " </select>\n";
   }
   /**
    * the data display part
    */
   Function info() {
     global $lang,$tutos;

     echo "<script language='JavaScript'>\n";
     echo " function deselect (obj,nr) { \n";
     echo " for(var j = 0; j <= obj.length ; j++) {\n";
     echo "   if ( obj.elements[j].name == \"r[]\" ) {\n";
     echo "    var x = obj.elements[j]; \n";
     echo "    var y = obj.elements[j+1]; \n";
     echo "    var z = obj.elements[j+2]; \n";
     echo "    break; \n";
     echo "   }\n";
     echo " }\n";  
     echo "  \n";  
     echo "  for (var i = 0; i < x.options.length; i++) {\n";
     echo "    if ( (nr == 0) && (x.options[i].selected) ) {\n";
     echo "      y.options[i].selected = false;\n";
     echo "      z.options[i].selected = false;\n";
     echo "    }\n";
     echo "    if ( (nr == 1) && (y.options[i].selected) ) {\n";
     echo "      x.options[i].selected = false;\n";
     echo "      z.options[i].selected = false;\n";
     echo "    }\n";
     echo "    if ( (nr == 2) && (z.options[i].selected) ) {\n";
     echo "      x.options[i].selected = false;\n";
     echo "      y.options[i].selected = false;\n";
     echo "    }\n";
     echo "  }\n";  
     echo " }\n";   
     echo "</script>\n";

     echo "<form name=\"useradd\" action=\"user_ins.php\" method=\"post\">\n";

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"8\">". $lang['UserInfo'] ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td align=\"right\" colspan=\"8\">". acl_link($this->obj) ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     if ( $this->user->isAdmin() ) {
       echo $this->showfieldc($lang['Username'],1,"login");
       echo " <td colspan=\"3\"><input id=\"login\" size=\"20\" maxlength=\"20\" name=\"login\" value=\"". $this->obj->login ."\"></td>\n";
       echo $this->showfieldc($lang['UserDisabled'],0,"disabled");
       echo " <td colspan=\"3\"><input id=\"disabled\" type=\"checkbox\" name=\"disabled\" value=\"1\"". ($this->obj->disabled == 1 ? " checked":"") ."></td>\n";
     } else {
       echo $this->showfieldc($lang['Username'],0,"login");
       echo $this->showdata($this->obj->login,7);
       $this->addHidden("login", $this->obj->login );
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['User']);
     echo $this->showdata($this->obj->getLink(),7);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['UserLastSeen']);
     echo $this->showdata($this->obj->last_seen->getDateTime(),3);
     echo $this->showfieldc($lang['UserLastHost']);
     echo $this->showdata($this->obj->last_host,3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['UserAdmin'],1,"admin");
     if ( $this->user->isAdmin()) {
       $achecked[0] ="";
       $achecked[1] ="";
       $achecked[$this->obj->admin] ="CHECKED";
       echo " <td colspan=\"3\">". $lang['yes'] ."&nbsp;<input id=\"admin\" type=\"radio\" name=\"admin\" value=\"1\" ". $achecked[1] ."></td>";
       echo " <td colspan=\"4\">". $lang['no'] ."&nbsp;<input id=\"admin\" type=\"radio\" name=\"admin\" value=\"0\" ". $achecked[0] ."></td>";
     } else {
       $this->addHidden("admin",$this->obj->admin);
       if ( $this->obj->isAdmin() ) {
         echo $this->showdata($lang['yes'],7);
       } else {
         echo $this->showdata($lang['no'],7);
       }
     }
     echo "</tr>\n";

     if ( ($tutos[pamauth] == 0) && ($tutos[ldapauth] == 0) ) {
       if ( $this->dbconn->Password("a") == "'a'" ) {
         echo "<tr>\n";
         echo " <td colspan=\"8\"><span class=\"warn\">Passwords will not be encrypted in the Database.<br>Do not use your standard password !!</span></td>\n";
         echo "</tr>\n";
       }
       if ( ! $this->user->isAdmin() ) {
         if ( $this->dbconn->gettype() != "MySQL" ) {
           echo "<tr>\n";
           echo $this->showfieldc($lang['Password'] ." (old)",0,"p0");
           echo " <td colspan=\"7\"><input id=\"p0\" type=\"password\" size=\"20\" maxlength=\"20\" name=\"p0\" value=\"\"></td>\n";
           echo "</tr>\n";
         }
       }
       echo "<tr>\n";
       echo $this->showfieldc($lang['Password'] ." (new)",0,"p1");
       echo " <td colspan=\"7\"><input id=\"p1\" type=\"password\" size=\"20\" maxlength=\"20\" name=\"p1\" value=\"\"></td>\n";
       echo "</tr>\n";

       echo "<tr>\n";
       echo $this->showfieldc($lang['Password'] ." (repeat)",0,"p2");
       echo " <td colspan=\"7\"><input id=\"p2\" type=\"password\" size=\"20\" maxlength=\"20\" name=\"p2\" value=\"\"></td>\n";
       echo "</tr>\n";
     }
     #
     # Feature Permissions
     permission_form($this,$this->user,$this->obj);

     #
     # Default-Groups for new objects
     #
     if ( ($tutos[defaultacl] == 2) &&
        ( ($this->user->isAdmin())  || (count($this->user->teamlist) > 0) ) 
       ) {
       # read a list of all teams;
       $q = "select * from ". $this->dbconn->prefix ."teams";
       $r = $this->dbconn->Exec($q);
       $n = $r->numrows();
       $a = 0;
       $this->obj->teamlist = array();
       while ( $a < $n ) {
         $t = new team($this->dbconn);
         $t->read_result($r,$a);
         $this->obj->teamlist[$t->id] = &$t;
         unset ($t);
         $a++;
       }
       $r->free();
       echo "<tr>\n";
       echo $this->showfieldc($lang['UserDefaultGrp'],0,"acldefault");
       echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."</th>\n";
       echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."<br>". $lang['ACLmodify'] ."</th>\n";
       echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."<br>". $lang['ACLmodify'] ."<br>". $lang['ACLdelete'] ."</th>\n";
       echo " <th>&nbsp;</th>\n";
       echo "</tr>\n";
       echo "<tr>\n"; 
       echo " <td colspan=\"1\">&nbsp;</td>\n";
       echo " <td colspan=\"2\"><center>\n";
       $this->acldefault_select(1,$tutos[modok],"r");
       echo " </center></td>\n";
       echo " <td colspan=\"2\"><center>\n";
       $this->acldefault_select($tutos[modok], $tutos[delok],"m");
       echo " </center></td>\n";
       echo " <td colspan=\"2\"><center>\n";
       $this->acldefault_select($tutos[delok], 99, "d");
       echo " </center></td>\n";
       echo " <td colspan=\"1\">&nbsp;</td>\n";
       echo "</tr>\n";
     }
     #
     # LANGUAGE
     #
     echo "<tr>\n";
     echo $this->showfieldc($lang['UserLanguage'],1,"lng");
     echo " <td colspan=\"3\">\n";
     echo "  <select id=\"lng\" name=\"lng\">\n";
     foreach($lang['lang'] as $i => $f) {
       echo "   <option value=\"". $i ."\"". ( !strcasecmp($i,$this->obj->lang) ? " selected":"") .">". myentities($f) ."</option>\n";
     }
     echo "  </select>\n";
     echo " </td>\n";

     # TIMEZONE
     echo $this->showfieldc($lang['UserTimezone'],1,"tz");
     echo " <td colspan=\"3\">";
     echo " <select id=\"tz\" name=\"tz\">\n";
     foreach($tutos[timezones] as $f) {
       echo "  <option value=\"". $f ."\"". ($this->obj->tz == $f ? " selected":"") .">". $f ."</option>\n";
     }
     echo " </select>\n";
     echo " </td>\n";
     echo "</tr>\n";

     # Workdays
     echo "<tr>\n";
     echo $this->showfield($lang['UserWorkdays'],1,"wd[]");
     echo " <td nowrap colspan=\"7\">\n";
     for ( $i = 0 ; $i < 7 ; $i++ ) {
       echo "<input id=\"wd[]\" type=\"checkbox\" name=\"wd[]\" value=\"". $i ."\" ". ($this->obj->isworkday($i) ? "checked":"") .">". $lang['Day'.$i];
     }
     echo " </td>\n";
     echo "</tr>\n";

     # Weekstart
     echo "<tr>\n";
     echo $this->showfield($lang['UserWeekstart'],1,"ws");
     echo " <td nowrap colspan=\"7\">\n";
     echo " <select id=\"ws\" name=\"ws\">\n";
     echo "  <option value=\"0\"". ($this->obj->weekstart == 0 ? " selected":"") .">". $lang['Day0'] ."</option>\n";
     echo "  <option value=\"1\"". ($this->obj->weekstart == 1 ? " selected":"") .">". $lang['Day1'] ."</option>\n";
     echo " </select>\n";
     echo " </td>\n";
     echo "</tr>\n";

     # HOLIDAYS
     $xx = 1;
     echo "<tr>\n";
     echo $this->showfield($lang['UserHoliday'],0,"h[]");
     @reset ($tutos[holiday]);
     echo " <td colspan=\"7\">\n";
     while( list ($i,$f) = @each ($tutos[holiday])) {
       if ( $tutos[holiday][$i] != 1 ) {
         continue;
       }
       echo "  <input id=\"h[]\" type=\"checkbox\" name=\"h[]\" value=\"". strtolower($i) ."\" ". ($this->obj->holiday[strtolower($i)] == 1 ? "checked":"") .">". $i;
       if ( 0 == ($xx % 6) ) {
         echo "<br>\n";
       } else {
         echo "&nbsp;&nbsp;";
       }
       $xx++;
     }
     echo " </td>\n";
     echo "</tr>\n";

     # Namedays
     echo "<tr>\n";
     echo $this->showfield($lang['UserNamedays'],0,"nd[]");
     @reset ($tutos[nameday]);
     echo " <td colspan=\"7\">\n";
     while( list ($i,$f) = @each ($tutos[nameday])) {
       if ( $tutos[nameday][$i] != 1 ) {
         continue;
       }
       echo "  <input id=\"nd[]\" type=\"checkbox\" NAME=\"nd[]\" value=\"". strtolower($i) ."\" ". ($this->obj->nameday[strtolower($i)] == 1 ? "checked":"") .">". $i;
       if ( 0 == ($xx % 4) ) {
         echo "<br>\n";
       } else {
         echo "&nbsp;&nbsp;";
       }
       $xx++;
     }
     echo " </td>\n";
     echo "</tr>\n";

     # THEME
     echo "<tr>\n";
     echo $this->showfieldc($lang['UserTheme'],1,"theme");
     echo " <td colspan=\"3\">\n";
     echo " <select id=\"theme\" name=\"theme\">\n";
     foreach($tutos[themes] as $f) {
       echo "  <option value=\"". $f ."\" ". ($f == $this->obj->theme ? " SELECTED":"") .">". $f ."</option>\n";
     }
     echo " </select>\n";
     echo " </td>\n";

     # Layout Engine
     echo $this->showfieldc($lang['UserLayout'],1,"layout");
     echo " <td colspan=\"3\">\n";
     echo " <select id=\"layout\" name=\"layout\">\n";
     foreach($tutos[layouts] as $f) {
       echo "  <option value=\"". $f ."\" ". ($f == $this->obj->ly ? " SELECTED":"") .">". $f ."</option>\n";
     }
     echo " </select>\n";
     echo " </td>\n";
     echo "</tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,8);

     echo "<tr>\n";
     if ($this->obj->uid > 0 ) {
       submit_reset(0,1,3,1,3,0);
     } else {
       submit_reset(0,-1,3,1,3,0);
     }
     echo "</tr>\n";
     if ( ($this->obj->uid != -1) && ($this->user->feature_ok(usehistory,PERM_SEE)) ) {
       echo "<tr>\n";
       echo " <td colspan=\"8\">". makelink("history_show.php?id=". $this->obj->uid,$lang['HistoryLink'],sprintf($lang['HistoryLinkI'],$this->obj->getFullname())) ."</td>\n";
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     echo $this->getHidden();
     hiddenFormElements();
     echo "</form>\n";
     echo $lang['FldsRequired'] ."\n";
     echo $this->setfocus("useradd.login");
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     if ( isset($_GET['id']) ) {
       $this->obj = new tutos_user($this->dbconn);
       $this->obj->read($_GET['id'],0);
       $this->obj->read_permissions();
     } else if ( isset($_GET['uid']) ) {
       $this->obj = new tutos_user($this->dbconn);
       $this->obj->read($_GET['uid'],1);
       $this->obj->read_permissions();
     } else {
       $this->obj = &$this->user;
     }
     if ( ! $this->user->isAdmin()) {
       $this->obj = &$this->user;
	 }
     $this->addHidden("uid",$this->obj->uid);
     $this->addHidden("id",$this->obj->id);

     if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     if ( $this->obj->uid != -1 ) {
       $this->name = $lang['UserModify'] .": ". $this->obj->login;
     } else {
       $this->name = $lang['UserCreate'];
     }

     if (isset($_GET['login'])) {
       $this->obj->login = StripSlashes($_GET['login']);
     }
     if ( isset($_GET['h']) ) {
       foreach ($_GET['h'] as $i => $f) {
         $this->obj->holiday[$i] = $f;
       }
     }
     if ( isset($_GET['wd']) ) {
       $this->obj->workday = array();
       foreach($_GET['wd'] as $i => $f) {
         $this->obj->workday[$i] = $f;
       }
     }
     if ( isset($_GET['nd']) ) {
       foreach($_GET['nd'] as $i => $f) {
         $this->obj->nameday[$i] = $f;
       }
     }
     if ( isset($_GET['ws']) ) {
       $this->obj->weekstart = $_GET['ws'];
     }

     # Create the menu items
#var_dump ($this->obj->acl);
     if ( ($this->obj->del_ok()) && ($this->obj->uid > 0) ) {
       $x = array( url => "user_del.php?id=". $this->obj->id,
                   confirm => true,
                   text => $lang['UserDel'],
                   info => sprintf($lang['UserDelInfo'], $this->obj->getFullName()),
                   category => array("user","admin","obj","del")
                 );
       $this->addMenu($x);
     }
     if ( $this->obj->uid > 0) {
       $x = array( url => "mytutos.php?adr=". $this->obj->id,
                   confirm => false,
                   text => sprintf($lang['PersonalPageFor'], $this->obj->getFullName()),
                   info => sprintf($lang['PersonalPageFor'], $this->obj->getFullName()),
                   category => array("view","obj")
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);
   }
 }


 $l = new user_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: user_new.php,v 1.68.2.2 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->
