<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup team
 * @module team_ins
 * @package team
 */
 include("webelements.p3");
 include("permission.p3");

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("team","ins");

 $msg = "";
 $gotourl = "team_new.php";
 $t = new team($dbconn);

 if ( !isset($_POST['id'] )) {
   $msg .= "Please enter a id<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"id=". $_POST['id']);
   $t->read($_POST['id']);
 }

 if ( !isset($_POST['name']) || ($_POST['name'] == $lang['PlsChangeName']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['TeamName']) ."<br>";
 } else {
   $name = trim(StripSlashes($_POST['name']));
   $gotourl= addUrlParameter($gotourl,"name=". UrlEncode($name));
 }

 if ( isset($_POST['email'])  ) {
   $t->SetEmail(StripSlashes($_POST['email']));
   $gotourl= addUrlParameter($gotourl,"email=". UrlEncode($t->email));
 }

 if ( ! isset($_POST['owner']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['TeamManager']) ."<br>";
 } else {
   $owner = $_POST['owner'];
   $gotourl= addUrlParameter($gotourl,"owner=".$owner);
 }

 if ( $msg == "" ) {
   if ( ($t->id  == -1) || ($name != $t->name) ) {
     $q = "SELECT * FROM ". $dbconn->prefix ."teams WHERE ". $dbconn->Like2 ("name",$name);
     $r = $dbconn->Exec($q);
     $n = $r->numrows();
     if ( 0 != $n) {
       $x = new team($dbconn);
       $x->read_result($r,0);
       $msg .= sprintf($lang['Err0046'],$x->getLink()) ."<br>";
     }
     $r->free();
   }
 }

 # Permissions
 $msg .= parse_permission_form($t);

 if (!isset($_POST['add']) ) {
   $add = array();
 } else {
   $add = $_POST['add'];
 }
 if (!isset($_POST['del']) ) {
   $del = array();
 } else {
   $del = $_POST['del'];
 }

 # other modules
 $msg .= module_parseforms($current_user,$t,$gotourl);

 if ( $msg == "" ) {
   $t->SetName($name);
   $o = new tutos_address($dbconn);
   $o->read($owner);
   $t->setOwner($o);
  
   $dbconn->Begin("WORK");
   $msg .= $t->save($add,$del);
   $msg .= $t->save_permissions();
   $dbconn->Commit("WORK");

   $gotourl = $t->getUrl();
 }


 /* Go back to user mask */

 $gotourl = addSessionKey($gotourl);

 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: team_ins.php,v 1.25.2.2 2003/06/18 14:34:32 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
