<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup product
 * @module select
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','select');
 loadlayout();

 /**
  * display a project selection form
  */
 class product_select extends layout {
   /**
    *
    */
   Function info() {
     global $lang;

     echo "<br><br><center>\n";

     echo " <form name=\"prodsearch1\" method=\"GET\" action=\"product_overview.php\">\n";
     hiddenFormElements();
     DoubleTableStart();

     echo "<tr>\n";
     if ( $this->ext == 0 ) {
       echo " <th colspan=\"3\">". $lang['SearchForProd'] ."</th>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['AdrName'],0,"name");
       echo " <td><center><input id=\"name\" type=\"text\" value=\"\" name=\"name\"></center></td>\n";
       echo " <td><center>\n";
       echo "  <input type=\"submit\" value=\"". $lang['Search'] ."\" title=\"". $lang['SearchForProd'] ."\"></center></td>\n";
       echo "</tr><tr>\n";
       echo " <td colspan=\"2\"><center><font size=\"-1\">". $lang['ProdSelInfo']."</font></center></td>\n";
       echo " <td><center>". makelink("product_select.php?ext=1",$lang['extended']) ."</center></td>\n";
     } else {
       echo " <th colspan=\"3\">". $lang['SearchForProdExt'] ."</th>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['AdrName'],0,"name");
       echo " <td>&nbsp;<input id=\"name\" type=\"text\" value=\"\" name=\"name\">\n";
       echo " </td>\n";
       echo " <td><center><input type=\"submit\" value=\"". $lang['Search'] ."\" title=\"". $lang['SearchForProdExt'] ."\"></center></td>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['ProdState'],0,"state");
       echo " <td colspan=\"2\">&nbsp;". ProdAskState($this->state,1) ."&nbsp;</td>\n";

       $p = new product($this->dbconn);
       for ( $cl = 1;$cl <= $p->classes; $cl++) {
         echo "</tr><tr>\n";
         echo $this->showfieldc($lang['ProdClass'.$cl],0,"class".$cl);
         echo " <td colspan=\"2\">&nbsp;". ProdAskClass($cl,$this->class[$cl],1) ."&nbsp;</td>\n";
       }

       echo "</tr><tr>\n";
       echo " <td rowspan=\"2\" class=\"desc\">". $lang['ProdBetween'] ."</td>\n";
       echo " <td colspan=\"2\">&nbsp;";
       $this->from->EnterDate("f",1);
       echo "&nbsp;</td>\n";

       echo "</tr><tr>\n";
       echo " <td colspan=\"2\">&nbsp;";
       $this->to->EnterDate("t",1);
       echo "&nbsp;</td>\n";
     }
     echo "</tr>\n";

     DoubleTableEnd();
     echo " </form>\n";
     echo "</center>\n";
     echo $this->setfocus("prodsearch1.name");
   }

   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang;

     $this->name = $lang['ProductsSearch'];

     # Defaults for search
     $this->from = new DateTime(0);
     $this->to = new DateTime(0);

     if ( isset($_SESSION['prodsearchfrom']) ) {
       $this->from->setDateTime($_SESSION['prodsearchfrom']);
     }
     if ( isset($_SESSION['prodsearchto']) ) {
       $this->to->setDateTime($_SESSION['prodsearchto']);
     }
     if ( isset($_SESSION['prodsearchstate']) ) {
       $this->state = $_SESSION['prodsearchstate'];
     } else {
       $this->state = 0;
     }
     $p = new product($this->dbconn);
     $this->class = array();
     for ( $cl = 1;$cl <= $p->classes; $cl++) {
       $y = sprintf("prodsearchcl%d",$cl);
       if ( isset($_SESSION[$y]) ) {
         $this->class[$cl] = $_SESSION[$y];
       } else {
         $this->class[$cl] = 0;
       }
     }
     if ( ! isset($_GET['ext']) ) {
       $this->ext = 0;
     } else {
       $this->ext = $_GET['ext'];
     }
     if ( ! $this->user->feature_ok(useprojects,PERM_SEL) ) {
       $this->stop = true;
	 }

     if ( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array( url => "product_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['ProdCreateInfo'],
                   category => array("product","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new product_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: product_select.php,v 1.25 2002/12/14 16:48:26 gokohnert Exp $
    $Author: gokohnert $
-->
