<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup mailbox
 * @module mailbox_new
 * @package mailbox
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('mailbox','new');
 loadmodule('mailbox');
 loadlayout();

 /**
  * change/modify a mailbox
  */
 class mailbox_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     echo "<form name=\"mailboxnew\" action=\"mailbox_ins.php\" method=\"post\">\n";
     echo $this->DataTableStart();
     $this->addHidden("parent",$this->obj->parent->id);
     echo "<tr><th colspan=\"6\">";
     if ( $this->obj->id > 0  ) {
       echo sprintf($lang['MailboxModifyI'],menulink($this->obj->parent->getURL(),$this->obj->parent->getFullName()));
     } else {
       echo sprintf($lang['MailboxCreateI'],menulink($this->obj->parent->getURL(),$this->obj->parent->getFullName()));
     }
     echo "</th></tr>\n";

     if ( $this->obj->id > 0  ) {
       echo "<tr>\n";
       echo " <td colspan=\"5\">&nbsp</td>";
       echo " <td align=\"right\" colspan=\"1\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['MailboxHost'],1,"host");
     echo " <td>\n";
     echo "  <input size=\"".min($table['mailbox']['host'][size],40)."\" maxlength=\"".$table['mailbox']['host'][size] ."\" id=\"host\" name=\"host\" value=\"". $this->obj->host ."\">\n";
     echo " </td>\n";
     echo $this->showfieldc($lang['MailboxProt'],1,"type");
     echo " <td>\n";
     echo "  <select id=\"type\" name=\"type\">\n";
     echo "   <option value=\"imap\"". ($this->obj->type == "imap" ? " selected":"") .">imap</option>\n";
     echo "   <option value=\"imap/ssl/novalidate-cert\"". ($this->obj->type == "imap/ssl/novalidate-cert" ? " selected":"") .">imap SSL</option>\n";
     echo "   <option value=\"imap/notls\"". ($this->obj->type == "imap/notls" ? " selected":"") .">imap NOTLS</option>\n";
     echo "   <option value=\"pop3\"". ($this->obj->type == "pop3" ? " selected":"") .">pop3</option>\n";
     echo "   <option value=\"pop3/notls\"". ($this->obj->type == "pop3/notls" ? " selected":"") .">pop3 NOTLS</option>\n";
     echo "  </select>\n";
     echo " </td>\n";
     echo $this->showfieldc($lang['MailboxPort'],0,"port");
     echo " <td>\n";
     echo "  <input size=\"5\" maxlength=\"5\" id=\"port\" name=\"port\" value=\"". $this->obj->port ."\">\n";
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['MailboxPath'],0,"path");
     echo " <td colspan=\"5\">\n";
     echo "  <input size=\"60\" maxlength=\"60\" id=\"path\" name=\"path\" value=\"". $this->obj->path ."\">\n";
     echo " </td>\n";

     echo "</tr>\n";
 
     echo "<tr>\n";
     echo $this->showfieldc($lang['MailboxUser'],1,"user");
     echo " <td>\n";
     echo "  <input size=\"".min($table['mailbox']['uname'][size],40)."\" maxlength=\"".$table['mailbox']['uname'][size] ."\" id=\"user\" name=\"user\" value=\"". $this->obj->user ."\">\n";
     echo " </td>\n";
     echo $this->showfieldc($lang['MailboxPass'],0,"mpw");
     echo " <td colspan=\"3\">\n";
     echo "  <input type=\"password\" id=\"mpw\" name=\"mpw\" value=\"". $this->obj->pw ."\">\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['MailboxEmail'],0,"email");
     echo " <td colspan=\"5\">\n";
     echo "  <input size=\"".min($table['mailbox']['email'][size],40)."\" maxlength=\"".$table['mailbox']['email'][size] ."\" id=\"email\" name=\"email\" value=\"". $this->obj->email ."\">\n";
     echo " </td>\n";
     echo "</tr>\n";

     if ( $this->obj->mod_ok() != 0 ) {
       echo "<tr>\n";
       if ($this->obj->id > 0 ) {
         submit_reset(0,1,2,1,2,0);
       } else {
         submit_reset(0,-1,2,1,2,0);
       }
       echo "</tr>\n";
     }

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("mailboxnew.host");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new mailbox($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     } else if ( isset($_GET['parent']) ) {
       $this->obj->parent = GetObject($this->dbconn,$_GET['parent']);
     } else {
       $msg .= " Missing parameter<br>";
       $this->stop = true;
     }

     if ( ($this->obj->id < 0) && !$this->user->feature_ok(usemailboxes,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     if ( $this->obj->id > 0 ) {
       $this->addHidden("id",$this->obj->id);
       $this->name = $lang['MailboxModify'];
     } else {
       $this->name = $lang['MailboxCreate'];
	 }

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "mailbox/mailbox_del.php?id=". $this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['MailboxDelI'],$this->obj->getFullname()),
                   confirm => true,
                   category => array("mailbox","del","obj")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new mailbox_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: mailbox_new.php,v 1.5.2.2 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->
