<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup file
 * @module file_del
 * @package file
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('file','del');
 loadmodule('file');

 /* Check Input */
 $msg = "";
 $f = new tutos_file($dbconn);

 if ( !isset($_GET['id']) ) {
   $msg .= "No ID given !<br>";
   $gotourl = "file/file_overview.php";
 } else {
   $f->read($_GET['id']);
   $gotourl = $f->getURL();
   if ( $f->locked != 0 ) {
     $msg .= $lang['Err0020'] ."<br>";
   }
   if ( ! $f->del_ok() ) {
     $msg .= sprintf($lang['Err0023'],$lang[$f->getType()]) ."<br>";
   }
 }

 if ( $msg == "" ) {
   $f->read_reference();

   $dbconn->Begin("WORK");
   $msg = $f->delete();
   $dbconn->Commit("WORK");
   if ( $f->ref != -1 ) {
     $gotourl = $f->ref->getURL();
   } else {
     $gotourl = "file/file_overview.php";
   }
 }

 $_SESSION['MSGID'.$f->id] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". $f->id);
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". dirname(getBaseUrl()) ."/". $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: file_del.php,v 1.3.2.2 2003/07/24 18:42:47 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
