<?php
/*
 * Checklist: Copyright 2002 by Markus Leist under GNU GPL
 * TUTOS:     Copyright 1999 - 2002 by Gero Kohnert
 *
 *  CVS Info:  $Id: checklist_show.php,v 1.7 2003/02/19 16:54:27 gokohnert Exp $
 *  $Author: gokohnert $
 *
 */

$tutos['base'] = "../..";
ini_set("include_path","..");
include 'webelements.p3';
include 'permission.p3';
include 'checklist/checkfield.pinc';
include("timetrack.pinc");

 /* Check if user is allowed to use it */
check_user();
loadmodules("checklist","show");
loadmodule("checklist");
loadlayout();
/**
 * display a checklist and its usage
 */
class checklist_show extends layout {
   /**
    *
    */
   Function info() {
     global $tutos,$lang;

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">". sprintf($lang['Showing'],$lang['Checklist'] ." ".$this->obj->getFullName()) ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['createdby']);
     echo $this->showdata($this->obj->creator->getLink());
     echo $this->showfield($lang['atDateTime']);
     echo $this->showdata($this->obj->creation->getDateTime());

     echo "</tr><tr>\n";
     echo $this->showfield($lang['ChecklistName']);
     echo $this->showdata(myentities($this->obj->name),3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['ChecklistDescription']);
     echo $this->showdata(myentities($this->obj->description),3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['ChecklistReference']);
     echo $this->showdata($this->obj->getRefLink(),3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['ChecklistType']);
     echo $this->showdata($this->obj->getObjType(),1);
     echo "</tr>";

     if ( $this->obj->type == CL_TYPE_TEMPL ) {  // Class
       echo "<tr>\n";
#       echo $this->showfield($lang['ChecklistInstancesFromClass']);
       checklist::instancelist($this->user,$this->obj,4,$this->format);
#       echo $this->showdata($this->obj->getCL_Class(),1);
       echo "</tr>";
     }

     if ( $this->obj->type == CL_TYPE_WORKING ) {  // Instance
       echo "<tr>\n";
       echo $this->showfield($lang['ChecklistInstance4Class']);
       echo $this->showdata($this->obj->getCL_ClassLink(),1);
       echo "</tr>";
       echo "<tr>";
       checklist::changelist($this->user,$this->obj,4,$this->format);
//        echo "<td>ddd</td>";
       echo "</tr>";
     }

     checkfield::infolist($this->user,$this->obj,4,$this->format);
     echo "<tr>\n";
     echo $this->showfield($lang['ChecklistCntFields']);
     echo $this->showdata(sprintf("%4d",count($this->obj->checkfields)),3);
     echo "</tr>";

     # References to modules
     show_module_infolists($this->user,$this->obj,4,$this->format);
     echo $this->obj->getHistoryLink(4);
     echo $this->DataTableEnd();
   }
   /**
    * naviagte
    */
   Function navigate() {
     global $tutos,$lang;

     echo "<tr><td nowrap>";
     if ( $this->user->feature_ok(usechecklists,PERM_NEW) ) {
       echo menulink("checklist/checklist_new.php",$lang['NewEntry'],$lang['ChecklistCreate']) ."<br>";
     }
     if ( $this->obj->mod_ok() ) {
       echo menulink("checklist/checklist_new.php?id=". $this->obj->id ,$lang['Modify'],sprintf($lang['ChecklistModify'],$this->obj->getFullName())) ."<br>\n";

       if ( $this->obj->type == CL_TYPE_TEMPL ) { // Class
         echo menulink("checklist/checkfield_new.php?link_id=". $this->obj->id ,$lang['CheckfieldCreate'],sprintf($lang['CheckfieldCreate'],$this->obj->getFullName())) ."<br>\n";
       }
       
       echo menulink("checklist/checkfield_overview.php?link_id=". $this->obj->id,$lang['CheckfieldOverview'],$lang['CheckfieldOverview']) ."<br>\n";

       if ( $this->obj->type == CL_TYPE_TEMPL ) { // Class
         echo menulink("checklist/checkfield_overview.php?link_id=". $this->obj->id."&format=checklist" ,$lang['ChecklistDefaultEditor'],$lang['ChecklistDefaultEditor']) ."<br>\n";
       } elseif ( $this->obj->type == CL_TYPE_WORKING ) { // working-copy
         echo menulink("checklist/checkfield_overview.php?link_id=". $this->obj->id."&format=checklist" ,$lang['ChecklistEditor'],$lang['ChecklistEditor']) ."<br>\n";
         echo menulink("checklist/checklist_update.php?id=". $this->obj->id ,$lang['ChecklistInstanceUpdate'],$lang['ChecklistInstanceUpdate']) ."&nbsp;<br>\n";
       }
       
       
       if ( $this->obj->type == CL_TYPE_TEMPL ) { // Class
         echo menulink("checklist/checklist_new.php?link_id=". $this->obj->id."&format=checklist" ,$lang['ChecklistInstance'],$lang['ChecklistInstance']) ."<br>\n";
       }
     }
     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['ChecklistDetail'];
     $this->obj = new checklist($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->obj->read_reference();
     }
     if ( $this->obj->size( $this->obj) < 1 ) {
       $msg .= $lang['CheckfieldNoFields'];
       $this->stop = true;
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $m = checklist::getSelectLink($this->user,$lang['Search']);
     $this->addmenu($m);
     add_module_addlinks($this,$this->obj);
   }
 }

 $l = new checklist_show($current_user);
 $l->display();
 $dbconn->Close();

// CVS Info:  $Id: checklist_show.php,v 1.7 2003/02/19 16:54:27 gokohnert Exp $
// $Author: gokohnert $

?>
