<?php
/**
 * Checklist: Copyright 2002 by Markus Leist under GNU GPL
 * TUTOS:     Copyright 1999 - 2002 by Gero Kohnert
 *
 *  CVS Info:  $Id: checklist_overview.php,v 1.12.2.1 2003/04/12 13:46:17 gokohnert Exp $
 *  $Author: gokohnert $
 */

 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'checklist/checkfield.pinc';

 check_user();
 loadmodule("checklist");
 loadmodules('checklist','overview');
 loadlayout();

 /**
  * display a checklist page
  */
 class checklist_overview extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$tutos;

     $result = $this->dbconn->Exec($this->q);
     $n = $result->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }
     echo $this->actionformStart("checklist_overview.php");
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("name",$lang['ChecklistName'],$this->link2);
     echo $this->orderHeader("link_id",$lang['ChecklistReference'],$this->link2);
     echo $this->orderHeader("",$lang['ChecklistCntFields'],$this->link2);
     echo $this->orderHeader("",$lang['ChecklistType'],$this->link2);
     echo $this->orderHeader("",$lang['ChecklistInstance4Class'],$this->link2);
     echo $this->orderHeader("creation",$lang['created'],$this->link2);
     echo $this->orderHeader("creator",$lang['ChecklistCreator'],$this->link2);
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     }
     echo "</tr>\n";
     echo "</thead>\n";



     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $c = new checklist($this->dbconn);
       $c->read_result($result,$a);
       $a++;
       if ( ! $c->see_ok() ) {
         continue;
       }
       $c->read_reference();
       checklist::read_checkfields($c);

       echo $this->OverviewRowStart($line);
       echo "<td valign=\"top\">". $c->getLink() ."</td>";
       echo "<td valign=\"top\">". $c->getRefLink() ."</td>";
       echo "<td align=\"right\">". count($c->checkfields) ."</td>";
       echo "<td valign=\"top\">". $c->getObjType() ."</td>";
       echo "<td valign=\"top\">". $c->getFromClass() ."</td>";
       echo " <td>". $c->creation->getDateTime() ."</TD>\n";
       echo " <td>&nbsp;". $c->creator->getLink($c->creator->getShortname()) ."</td>\n";
       if ( $tutos[massupdate] == 1 ) {
         echo " <td align=\"center\">\n";
         if ( $c->mod_ok() ) {
           echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $c->id ."\">\n";
         } else {
           echo "-\n";
         }
         echo "</td>\n";
       }
       echo $this->OverviewRowEnd($line++);
     }

     echo $this->list_navigation($this->link1,7+ $tutos[massupdate],$this->start,$a,$n);
     if ( $tutos[massupdate] == 1 ) {
        echo $this->UpdateRowStart(6);
        echo sprintf($lang['withmarked'],$lang['Checklists']);
        echo "<select name=\"action\">\n";
        echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
        echo " <option value=\"-2\">". $lang['Delete'] ."</option>\n";
//        while ( list ($i,$f) = @each ($lang['ChecklistTypes']) ) {
//          echo " <option value=\"".$i."\">". $lang['ChecklistType'] .":". $f ."</option>\n";
//        }
        echo " <option value=\"-4\">". $lang['AclModify'] ."</option>\n";
        echo "</select>\n";
        echo $this->UpdateRowEnd(2);
     }

     echo $this->OverviewTableEnd();
     echo $this->actionformEnd("checklist_overview.php");
     $result->free();
   }
   /**
    * action
    */
   Function action() {
     global $lang,$msg;

     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $b = new checklist($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }
         if ( $b->del_ok() ) {
           $msg .= sprintf($lang['ChecklistDelete'], $b->getFullName()) ."<br>";
           $msg .= $b->delete();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0023'],$lang[$b->getType()]) ."<br>\n";
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
     } else if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
     }
   }
   /**
    * naviagte
    */
   Function navigate() {
     global $tutos,$lang;

     echo "<TR><TD>";
     if ( $this->user->feature_ok(usechecklists,PERM_NEW) ) {
       echo menulink("checklist/checklist_new.php",$lang['NewEntry'],$lang['ChecklistCreate']) . "<BR>\n";
     }
     echo "</TD></TR>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['Checklist'];

     $this->link1 = "checklist/checklist_overview.php";
      $this->q = "SELECT * FROM ". $this->dbconn->prefix ."checklists";
      $pre = " WHERE ";

      if ( isset($_GET['name']) && ($_GET['name'] != "*") && ($_GET['name'] != "") ) {
        $this->q .= $pre . $this->dbconn->Like("name",$_GET['name']);
        $pre = " AND ";
        $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));
      }

      $this->q .= $pre . "(deleted=".$this->dbconn->notime() ." or deleted is null)";
      $pre = " AND ";
      
      check_dbacl( $this->q, $this->user->id);

      // sorting
      $xxx = "";
      $this->link2 = $this->link1;
      order_parse($this->q,$this->link1,$xxx,$xxx,"name");
   }
 }
 $l = new checklist_overview($current_user);
 $l->display();
 $dbconn->Close();

?>
