<?php
/*
 * Checklist: Copyright 2002 by Markus Leist under GNU GPL
 * TUTOS:     Copyright 1999 - 2002 by Gero Kohnert
 *
 *  CVS Info:  $Id: checklist_new.php,v 1.8 2003/01/01 18:54:37 gokohnert Exp $
 *  $Author: gokohnert $
 *
 */

 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include("webelements.p3");
 include("permission.p3");

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("checklist","new");
 loadmodule("checklist");
 loadlayout();
 /**
  * display a checklist create/modify form
  */
 class checklist_new extends layout {
   /**
    *
    */
   Function info() {
     global $tutos,$lang;

     echo "<form name=\"checklistnew\" action=\"checklist_ins.php\" method=\"POST\">\n";
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">".  sprintf($lang['Showing'],$lang[$this->obj->getType()])."</th>\n";
     echo "</tr>\n";
     if ($this->obj->id > 0 ) {
       $this->addHidden("id",$this->obj->id);
       echo "<tr>\n";
       echo " <td colspan=\"3\">". sprintf ($lang['BugCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
       echo " <td align=\"right\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['ChecklistName'],1,"name");
     echo " <td colspan=\"3\" valign=\"top\"><input id=\"name\" size=\"30\" maxlength=\"30\" name=\"name\" value=\"". $this->obj->name ."\"></td>";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ChecklistType'],1,"type");
     if ( $this->type_inp_protected ) {
       echo " <td colspan=\"5\">". $this->obj->getObjType() ."</td>\n";
       $this->addHidden("type",$this->obj->type);
     } else {
       echo " <td>". $this->obj->askType() ."</td>\n";
     }
     echo "</tr>\n";

     if ( $this->Classes ) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['ChecklistTypes'][2],1);
       echo " <td>". checklist::getAllClasses() ." </td>";
       $this->addHidden("checklist_ins","make_instance");
       echo "</tr>\n";
     }


     echo "<tr>\n";
     echo $this->showfieldc($lang['ChecklistReference'],1);
     echo " <td colspan=\"5\">". $lang[$this->obj->ref->getType()] ." ". $this->obj->getRefLink() ."</td>\n";
     $this->addHidden("link_id",$this->obj->link_id);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['ChecklistDescription'],0,"desc");
     echo " <td id=\"desc\" colspan=\"3\" valign=\"top\"><input size=\"60\" maxlength=\"200\" name=\"desc\" value=\"". $this->obj->description ."\"></td>";
     echo "</tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,4);

     if ( $this->obj->mod_ok() != 0 ) {
       echo "<tr>\n";
       if ($this->obj->id > 0 ) {
         submit_reset(0,1,1,1,1,0);
       } else {
         submit_reset(0,-1,1,1,1,0);
       }
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("checklistnew.name");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
     global $tutos,$lang;

     echo "<tr><td>";
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       echo confirmlink("checklist/checklist_del.php?id=". $this->obj->id ,$lang['Delete'],sprintf($lang['ChecklistDelete'],$this->obj->getFullname())) ."&nbsp;<br>";
     }
     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new checklist($this->dbconn);

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     }

     $this->Classes = 0;
     $this->type_inp_protected = false;

     if ( $this->obj->id > 0 ) {
       $this->name = $lang['ChecklistModify'] ." : ". $this->obj->getFullName();
     } else {
       $this->name = $lang['ChecklistCreate'];
     }

     if ( isset($_GET['type']) ) {
       $this->obj->type = $_GET['type'];
       $this->type_inp_protected = true;
     }

     if ( isset($_GET['link_id']) ){
       $this->obj->link_id = $_GET['link_id'];
       if ( $this->obj->type == CL_TYPE_TEMPL ) {
         $this->obj->type = CL_TYPE_TEMPL; // Template
         $this->Classes = 0;
       } else {
         $this->obj->type = CL_TYPE_WORKING; // Instance
         $this->Classes = 1;
       }
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['desc']) ) {
       $this->obj->description = StripSlashes($_GET['desc']);
     }
     if (! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->obj->read_reference();
	 }
   }
 }

$l = new checklist_new($current_user);
$l->display();
$dbconn->Close();
// CVS Info:  $Id: checklist_new.php,v 1.8 2003/01/01 18:54:37 gokohnert Exp $
// $Author: gokohnert $

?>
