<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup BASE
 * @module acl_show
 * @package acl
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('acl','new');
 loadlayout();

 /**
  * display and change permissions
  */
 class acl_new extends layout {
   /**
    *
    */
   Function acl_select($min,$max,$name) {
     global $lang,$tutos;

     $nr["r"] = 0;
     $nr["m"] = 1;
     $nr["d"] = 2;
     $js = "onchange='deselect(this.form,". $nr[$name] .");'";
     echo " <select multiple size=\"". min(count($this->user->parties),$tutos[maxshow]) ."\" name=\"". $name ."[]\" ". $js .">\n";
     foreach ($this->user->parties as $i => $fn) {

       $l = 0;
       foreach($this->obj as $val) {
         if ( isset($val->acl[$i]) ) {
           $l = max($l,$val->acl[$i]);
         }
       }
  
     if ( ($l < $max) && ($l >= $min) ) {
         echo "  <option value=\"". $i ."\" selected>&nbsp;". $fn ."&nbsp;</option>\n";
       } else {
         echo "  <option value=\"". $i ."\" >&nbsp;". $fn ."&nbsp;</option>\n";
       }
     }
     echo " </select>\n";
   }
   /**
    * show info
    */
   Function info() {
     global $lang,$tutos;

     echo "<script LANGUAGE='JavaScript'>\n";
     echo " function deselect (obj,nr) { \n";
     echo "  var x = obj.elements[0]; \n";
     echo "  var y = obj.elements[1]; \n";
     echo "  var z = obj.elements[2]; \n";
     echo "  \n";
     echo "  for (var i = 0; i < x.options.length; i++) {\n";
     echo "    if ( (nr == 0) && (x.options[i].selected) ) {\n";
     echo "      y.options[i].selected = false;\n";
     echo "      z.options[i].selected = false;\n";
     echo "    }\n";
     echo "    if ( (nr == 1) && (y.options[i].selected) ) {\n";
     echo "      x.options[i].selected = false;\n";
     echo "      z.options[i].selected = false;\n";
     echo "    }\n";
     echo "    if ( (nr == 2) && (z.options[i].selected) ) {\n";
     echo "      x.options[i].selected = false;\n";
     echo "      y.options[i].selected = false;\n";
     echo "    }\n";
     echo "  }\n";
     echo " }\n";
     echo "</script>\n";
     echo "<form name=\"acl\" action=\"acl_ins.php\" method=\"POST\">\n";

     $this->user->readKnownParties();
     $this->user->parties[0] = $lang['everybody'];
     foreach($this->obj as $val) {
       # Add Used but missing parties
       foreach ($val->acl as $i => $f) {
         if ( ! isset($this->user->parties[$i]) || ($this->user->parties[$i] == "") ) {
           $x = getObject($this->dbconn,$i);
           if ( $x == -1 ) {
             continue;
           }
           $pre = "";
           if ( method_exists($x,"gettype") && ($x->gettype() == "team") ) {
             $pre = $lang['team'] ." ";
           } 
           if ( method_exists($x,"getFullName") ) {
             $this->user->parties[$i] = $pre . $x->getFullName();
           }
           unset($x);
         }
       }
       if ( $val->gettype() == "user" ) {
         $this->addHidden("id[]",$val->uid);
       } else {
         $this->addHidden("id[]",$val->id);
       }
#   	   echo $val->getFullName() ." ". $val->id ."<br>";
     }

     echo $this->DataTableStart();

     echo " <tr><th colspan=\"6\">";
     if (count($this->obj) == 1) {
       $title = $lang[$this->obj[0]->getType()] ." ". $this->obj[0]->getFullName();
       echo sprintf($lang['AclModifyI'],menulink($this->obj[0]->getURL(),myentities($title)));
     } else {
       $title = count($this->obj) . " Objects";
       echo sprintf($lang['AclModifyI'],$title);
     }
     echo "</th></tr>\n";

     echo "<tr valign=\"top\">\n";
     echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."</th>\n";
     echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."<br>". $lang['ACLmodify'] ."</th>\n";
     echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."<br>". $lang['ACLmodify'] ."<br>". $lang['ACLdelete'] ."</th>\n";
     echo "</tr>\n";

//      if ( ($this->obj->gettype() == "user") || ($this->obj->gettype() == "team") ) {
//        echo "<tr valign=\"top\">\n";
//        echo " <td colspan=\"6\"><font size=\"-1\">(other users/teams need at least the see permission for ". $this->obj->getFullName()." to appear in selection lists)</font></td>\n";
//        echo "</tr>\n";
//      }
//      if ( $this->obj->gettype() == "file" ) {
//        echo "<tr valign=\"top\">\n";
//        echo " <td colspan=\"6\"><font size=\"-1\">(need at least the modify permission for ". $this->obj->getFullName()." to download or show documents)</font></td>\n";
//        echo "</tr>\n";
//      }
     echo "<tr>\n";
     echo " <td colspan=\"2\" align=\"center\">\n";
     $this->acl_select(1,$tutos[modok],"r");
     echo " </td>\n";
     echo " <td colspan=\"2\" align=\"center\">\n";
     $this->acl_select($tutos[modok],$tutos[delok],"m");
     echo " </td>\n";
     echo " <td colspan=\"2\" align=\"center\">\n";
     $this->acl_select($tutos[delok],99,"d");
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td colspan=\"2\">&nbsp;". sprintf($lang['ACLreadI'],myentities($title)) ."&nbsp;</td>\n";
     echo " <td colspan=\"2\">&nbsp;". sprintf($lang['ACLmodI'] ,myentities($title)) ."&nbsp;</td>\n";
     echo " <td colspan=\"2\">&nbsp;". sprintf($lang['ACLdelI'] ,myentities($title)) ."&nbsp;</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td colspan=\"6\">&nbsp;<input type=\"checkbox\" value=\"1\" name=\"keep\" ". ((count($this->obj) > 1) ? "checked":"") .">". $lang['ACLKeepOld'] ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     submit_reset(0,1,2,1,2,0);
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang,$msg,$current_user;

     $this->name = $lang['AclModify'];

     if ( ! isset($_GET['id']) ) {
       $msg .= "Missing ID";
       $this->stop = true;
       return;
     }
     $this->obj = array();

     if (! is_Array($_GET['id'])) {
       $id[0] = $_GET['id'];
     } else {
       $id = $_GET['id'];
     }
     foreach($id as $val) {
       $x = getObject($this->dbconn,$val);
       if ( $x == -1 ) {
         $msg .= sprintf($lang['Err0040'],"Object ". $val);
         $this->stop = true;
       } else if ( ! $current_user->isadmin() && ! $x->del_ok() ) {
         # we need delete permissions but talk about modify !
         $msg .= sprintf($lang['Err0024'],$lang[$x->getType()]);
         $this->stop = true;
       } else {
         $this->obj[] = &$x;
       }
       unset($x);
     }
   }
 }


 $l = new acl_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: acl_new.php,v 1.30 2003/03/14 18:16:09 gokohnert Exp $
    $Author: gokohnert $
-->
