/*
 * solve.h - header for solve.c, secure addresses family-independant resolution
 * functions.
 * $Id: solve.h,v 1.2 2004/06/05 15:15:17 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2004 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_SOLVE_H

# define __TCPREEN_SOLVE_H
# include <stddef.h> /* size_t */
# include <sys/types.h> /* might be needed for sys/socket.h */
# ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h> /* might be needed for struct sockaddr */
# endif
# include "getaddrinfo.h" /* struct addrinfo, NI_MAXHOST, NI_MAXSERV */

/* For obsolete OSes (such as Solaris) */
# ifndef PF_LOCAL
#  if defined (PF_UNIX)
#   define PF_LOCAL PF_UNIX
#   define AF_LOCAL AF_UNIX
#  elif defined (PF_FILE)
#   define PF_LOCAL PF_FILE
#   define AF_LOCAL AF_FILE
#  endif
# endif

# ifdef __cplusplus
extern "C" {
#endif

#define NI_MAXADDRESS NI_MAXHOST + NI_MAXSERV + 2

int getnamebyaddr (const struct sockaddr *addr, size_t addrlen,
			char *nodename, size_t nlen, char *service,
			size_t slen, int flags);

int getaddrbyname (const char *node, const char *service,
			const struct addrinfo *hints, struct addrinfo **res);

void freeai (struct addrinfo *res);
struct addrinfo *copyai (const struct addrinfo *src);
struct addrinfo *makeai (const struct sockaddr *addr, socklen_t addrlen);


# ifdef __cplusplus
}
# endif
#endif
