/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: rt_tool.h
 *              
 *      Abstract: General subfunction for ioctl talk to driver 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 03     Created
 *      MarkW           9th  Feb 04     Baseline of code
 ***************************************************************************/ 


#ifndef RT_TOOL_H
#define RT_TOOL_H

#define  CONFIGURATION_UI_VERSION   "1.2.1 CVS"
#define  CONFIGURATION_UI_DATE      "2004-06-20"

//////////////////////////////////////////////////////////////////////////////////// 
// Get Access Points list
#define RTLINUX_GET_OID_802_11_BSSID_LIST								8001
// Start Site Survey
#define RTLINUX_SET_OID_802_11_BSSID_LIST_SCAN							8002
#define RTLINUX_GET_MEDIA_CONNECT_STATUS 								8003
#define RTLINUX_SET_OID_802_11_BSSID         							8004 
#define RTLINUX_GET_OID_802_11_SSID             						8005
#define RTLINUX_GET_OID_802_11_BSSID									8006
#define RTLINUX_GET_OID_802_11_CONFIGURATION							8007
#define RTLINUX_GET_RT_OID_802_11_QUERY_LINK_STATUS						8008
#define RTLINUX_GET_OID_802_11_RSSI  									8009
#define RTLINUX_GET_OID_802_11_INFRASTRUCTURE_MODE						8010
#define RTLINUX_SET_OID_802_11_INFRASTRUCTURE_MODE						8011
#define RTLINUX_GET_OID_802_11_TX_ANTENNA_SELECTED						8012
#define RTLINUX_SET_OID_802_11_TX_ANTENNA_SELECTED						8013
#define RTLINUX_GET_OID_802_11_RX_ANTENNA_SELECTED						8014
#define RTLINUX_SET_OID_802_11_RX_ANTENNA_SELECTED						8015
#define RTLINUX_GET_OID_802_11_DESIRED_RATES							8016
#define RTLINUX_SET_OID_802_11_DESIRED_RATES							8017
#define RTLINUX_GET_OID_802_11_QUERY_PREAMBLE							8018
#define RTLINUX_SET_OID_802_11_SET_PREAMBLE								8019
#define RTLINUX_GET_OID_802_11_TX_POWER_LEVEL							8020
#define RTLINUX_SET_OID_802_11_TX_POWER_LEVEL							8021
#define RTLINUX_GET_OID_802_11_RTS_THRESHOLD							8022
#define RTLINUX_SET_OID_802_11_RTS_THRESHOLD							8023 
#define RTLINUX_GET_OID_802_11_FRAGMENTATION_THRESHOLD					8024
#define RTLINUX_SET_OID_802_11_FRAGMENTATION_THRESHOLD					8025
#define RTLINUX_GET_OID_802_11_AUTHENTICATION_MODE						8026
#define RTLINUX_SET_OID_802_11_AUTHENTICATION_MODE						8027
#define RTLINUX_GET_OID_802_11_WEP_STATUS								8028
#define RTLINUX_SET_OID_802_11_WEP_STATUS								8029
#define RTLINUX_SET_OID_802_11_REMOVE_WEP								8030
#define RTLINUX_SET_OID_802_11_ADD_WEP									8031
#define RTLINUX_SET_OID_802_11_CONFIGURATION							8032
#define RTLINUX_GET_OID_802_11_POWER_MODE								8033
#define RTLINUX_SET_OID_802_11_POWER_MODE								8034
#define RTLINUX_SET_OID_802_11_SSID										8035
#define RTLINUX_GET_OID_802_11_STATISTICS								8036
#define RTLINUX_GET_OID_GEN_RCV_OK										8037
#define RTLINUX_GET_OID_GEN_RCV_NO_BUFFER								8038
#define RTLINUX_SET_RT_OID_802_11_RESET_COUNTERS						8039
#define RTLINUX_GET_OID_802_3_CURRENT_ADDRESS							8040
#define RTLINUX_GET_VERSION_INFO										8041
#define RTLINUX_GET_RT_OID_802_11_QUERY_HARDWARE_REGISTER				8042
#define RTLINUX_SET_RT_OID_802_11_SET_HARDWARE_REGISTER					8043
#define RTLINUX_SET_RT_OID_802_11_SET_RADIO								8044
#define RTLINUX_GET_RT_OID_802_11_QUERY_RADIO                           8045
#define RTLINUX_RT_OID_802_11_SET_COUNTRY_REGION						8046
////////////////////////////////////////////////////////////////////////////////////
#define PROFILE_ADD  0
#define PROFILE_EDIT 1
#define RTS_MAX					2347
#define RT2460_LOCAL_PATH	   "/.Ralink/RT2400"
#define RT2460_SYSTEM_PATH   "/etc/Ralink/RT2400"
#define CONFIG_FILE       "RT2400.cfg"
#define PROFILE_FILE      "RT2400.pro"
#define INIT_FILE         "RT2400.dat"    //for driver RTMPReadParametersFromFile()
////////////////////////////////////////////////////////////////////////////////////
typedef	long			LONG;
typedef unsigned char 	UCHAR;
typedef unsigned short 	USHORT;
typedef unsigned long 	ULONG;
typedef unsigned int 	UINT;

typedef unsigned char* 	PUCHAR;
typedef unsigned short*	PUSHORT;
typedef int	 	BOOLEAN;

typedef void		VOID;

typedef struct _NDIS_802_11_CONFIGURATION_FH {
   ULONG           Length;            // Length of structure
   ULONG           HopPattern;        // As defined by 802.11, MSB set 
   ULONG           HopSet;            // to one if non-802.11
   ULONG           DwellTime;         // units are Kusec
} NDIS_802_11_CONFIGURATION_FH, *PNDIS_802_11_CONFIGURATION_FH;

typedef struct _NDIS_802_11_CONFIGURATION {
   ULONG                           Length;             // Length of structure
   ULONG                           BeaconPeriod;       // units are Kusec
   ULONG                           ATIMWindow;         // units are Kusec
   ULONG                           DSConfig;           // Frequency, units are kHz
   NDIS_802_11_CONFIGURATION_FH    FHConfig;
} NDIS_802_11_CONFIGURATION, *PNDIS_802_11_CONFIGURATION;

typedef enum _NDIS_802_11_NETWORK_INFRASTRUCTURE {
   Ndis802_11IBSS,
   Ndis802_11Infrastructure,
   Ndis802_11AutoUnknown,
   Ndis802_11InfrastructureMax     // Not a real value, defined as upper bound
} NDIS_802_11_NETWORK_INFRASTRUCTURE, *PNDIS_802_11_NETWORK_INFRASTRUCTURE;

typedef enum _NDIS_802_11_NETWORK_TYPE {
   Ndis802_11FH, 
   Ndis802_11DS, 
   Ndis802_11NetworkTypeMax
} NDIS_802_11_NETWORK_TYPE, *PNDIS_802_11_NETWORK_TYPE;

// Received Signal Strength Indication
typedef LONG    NDIS_802_11_RSSI;           // in dBm

typedef  UCHAR   NDIS_802_11_MAC_ADDRESS[6];

typedef  UCHAR   NDIS_802_11_RATES[8];  // Set of 8 data rates 

typedef struct _NDIS_802_11_SSID {
   ULONG   SsidLength;         // length of SSID field below, in bytes; this can be zero.
   UCHAR   Ssid[32];           // SSID information field
} NDIS_802_11_SSID, *PNDIS_802_11_SSID;

typedef struct _NDIS_WLAN_BSSID {
   ULONG                               Length;     // Length of this structure
   NDIS_802_11_MAC_ADDRESS             MacAddress; // BSSID
   UCHAR                               Reserved[2];
   NDIS_802_11_SSID                    Ssid;       // SSID
   ULONG                               Privacy;    // WEP encryption requirement
   NDIS_802_11_RSSI                    Rssi;       // receive signal strength in dBm
   NDIS_802_11_NETWORK_TYPE            NetworkTypeInUse;
   NDIS_802_11_CONFIGURATION           Configuration;
   NDIS_802_11_NETWORK_INFRASTRUCTURE  InfrastructureMode;
   NDIS_802_11_RATES                   SupportedRates;
} NDIS_WLAN_BSSID, *PNDIS_WLAN_BSSID;

typedef struct _NDIS_802_11_BSSID_LIST {
   ULONG           NumberOfItems;      // in list below, at least 1
   NDIS_WLAN_BSSID Bssid[1];
} NDIS_802_11_BSSID_LIST, *PNDIS_802_11_BSSID_LIST;

//
// Defines the state of the LAN media
//
typedef enum _NDIS_MEDIA_STATE
{
	NdisMediaStateConnected,
	NdisMediaStateDisconnected
} NDIS_MEDIA_STATE, *PNDIS_MEDIA_STATE;

// put all proprietery for-query objects here to reduce # of Query_OID
typedef struct _RT_802_11_LINK_STATUS {
    ULONG   CurrTxRate;         // in units of 0.5Mbps
    ULONG   ChannelQuality;     // 0..100 %
    ULONG   TxByteCount;        // both ok and fail
    ULONG   RxByteCount;        // both ok and fail
} RT_802_11_LINK_STATUS, *PRT_802_11_LINK_STATUS;

typedef enum _RT_802_11_PREAMBLE {
    Rt802_11PreambleLong,
    Rt802_11PreambleShort,
    Rt802_11PreambleAuto
} RT_802_11_PREAMBLE, *PRT_802_11_PREAMBLE;

typedef  ULONG   NDIS_802_11_ANTENNA;

typedef enum _NDIS_802_11_POWER_MODE {
   Ndis802_11PowerModeCAM,
   Ndis802_11PowerModeMAX_PSP,
   Ndis802_11PowerModeFast_PSP,
   Ndis802_11PowerModeMax
} NDIS_802_11_POWER_MODE, *PNDIS_802_11_POWER_MODE;

typedef  ULONG   NDIS_802_11_RTS_THRESHOLD;

typedef  ULONG   NDIS_802_11_FRAGMENTATION_THRESHOLD;

typedef ULONG   NDIS_802_11_TX_POWER_LEVEL; // in milliwatts

typedef enum _NDIS_802_11_WEP_STATUS {
   Ndis802_11WEPEnabled,
   Ndis802_11WEPDisabled,
   Ndis802_11WEPKeyAbsent,
   Ndis802_11WEPNotSupported,
} NDIS_802_11_WEP_STATUS, *PNDIS_802_11_WEP_STATUS;

typedef enum _NDIS_802_11_AUTHENTICATION_MODE {
   Ndis802_11AuthModeOpen,
   Ndis802_11AuthModeShared,
   Ndis802_11AuthModeAutoSwitch,
   Ndis802_11AuthModeMax           // Not a real mode, defined as upper bound
} NDIS_802_11_AUTHENTICATION_MODE, *PNDIS_802_11_AUTHENTICATION_MODE;

typedef struct _NDIS_802_11_WEP {
   ULONG     Length;        // Length of this structure
   ULONG     KeyIndex;      // 0 is the per-client key, 1-N are the global keys
   ULONG     KeyLength;     // length of key in bytes
   UCHAR     KeyMaterial[1];// variable length depending on above field
} NDIS_802_11_WEP, *PNDIS_802_11_WEP;

typedef unsigned long long u64;

typedef struct _NDIS_802_11_STATISTICS {
   ULONG          Length;             // Length of structure
   u64				TransmittedFragmentCount;
   u64			   MulticastTransmittedFrameCount;
   u64			   FailedCount;
   u64			   RetryCount;
   u64			   MultipleRetryCount;
   u64			   RTSSuccessCount;
   u64			   RTSFailureCount;
   u64			   ACKFailureCount;
   u64			   FrameDuplicateCount;
   u64			   ReceivedFragmentCount;
   u64			   MulticastReceivedFrameCount;
   u64			   FCSErrorCount;
} NDIS_802_11_STATISTICS, *PNDIS_802_11_STATISTICS;

typedef struct __VERSION_INFO{
	UCHAR		DriverMajorVersion;
	UCHAR		DriverMinorVersion;
	UCHAR		DriverSubVersion;	
	UINT		DriverBuildYear;
	UINT		DriverBuildMonth;
	UINT		DriverBuildDay;
}VERSION_INFO;

typedef struct _RT_PROFILE_SETTING {
	UCHAR		Profile[32+1];
	UCHAR		SSID[32+1];
	UINT		SsidLen;
	UINT		Channel;
	UINT		Authentication;
	UINT		Encryption;
	UINT		NetworkType;
	UINT		KeyIndex;
	UINT		KeyLength;
	UINT		KeyType;
	UCHAR		Key1[26+1];
	UCHAR		Key2[26+1];
	UCHAR		Key3[26+1];
	UCHAR		Key4[26+1];
	UINT		TransRate;
	UINT		TransPower;
	UINT		RTS; 
	UINT		RTSCheck;
	UINT		FragmentCheck;
	UINT		PSmode;
	UINT		PreamType;
	UINT		AntennaRx;
	UINT		AntennaTx;
	UINT		Fragment;
	UCHAR		CountryRegion;
	struct  _RT_PROFILE_SETTING		*Next;
} RT_PROFILE_SETTING, *PRT_PROFILE_SETTING;

#define REGISTER_TYPE_MAC		0
#define REGISTER_TYPE_BBP		1
#define REGISTER_TYPE_RF		2

// structure for query/set hardware register - MAC, BBP, RF register
typedef struct _RT_802_11_HARDWARE_REGISTER {
    ULONG   HardwareType;       // 0:MAC, 1:BBP, 2:RF register
    ULONG   Offset;             // Q/S register offset addr
    ULONG   Data;               // R/W data buffer
} RT_802_11_HARDWARE_REGISTER, *PRT_802_11_HARDWARE_REGISTER;


typedef struct _RT_DEVICE_ADAPTER {
	char	*Device_Name;
	struct _RT_DEVICE_ADAPTER *Next;
} RT_DEVICE_ADAPTER, *PRT_DEVICE_ADAPTER;


typedef struct _REGSTR_COUNTRY_ENTRY
{
	int		nCountry;	// define REGSTR_COUNTRYREGION 
    int     nChDef;		// default channel to use
    int     nChMin;		// minimum channel allowed
    int     nChMax;		// maximum channel allowed
} REGSTR_COUNTRY_ENTRY, *PREGSTR_COUNTRY_ENTRY;

#define REGSTR_COUNTRYREGION_FCC	0	// FCC, CH1-11
#define REGSTR_COUNTRYREGION_IC		1	// IC (Canada), CH1-11
#define REGSTR_COUNTRYREGION_ETSI	2	// ETSI, CH1-13
#define REGSTR_COUNTRYREGION_SPAIN	3	// SPAIN, CH10-11
#define REGSTR_COUNTRYREGION_FRANCE	4	// FRANCE, CH10-13
#define REGSTR_COUNTRYREGION_MKK	5	// MKK, CH14
#define REGSTR_COUNTRYREGION_MKK1	6	// MKK1(TELEC), CH1-14
#define REGSTR_COUNTRYREGION_ISRAEL	7	// ISRAEL, CH3-9

//
//  Debug information verbosity: lower values indicate higher urgency
//
#define RT_DEBUG_OFF        0
#define RT_DEBUG_ERROR      1
#define RT_DEBUG_WARN       2
#define RT_DEBUG_TRACE      3
#define RT_DEBUG_INFO       4
#define RT_DEBUG_LOUD       5

//
//  MACRO for debugging information
//
extern ULONG    RTDebugLevel;

#define DBGPRINT(Level, Fmt)        \
{                                   \
    if (Level <= RTDebugLevel)      \
    {                               \
        qDebug Fmt;                \
    }                                \
}

int Open_Socket(void);
int Check_DeviceName(int socket_id, char *DeviceName, char *DriverInfo);
char *Get_DeviceName(int socket_id, char *DeviceName);
NDIS_MEDIA_STATE  Get_Media_State(int socket_id, char *DeviceName);
int Get_NDIS_802_11_CONFIGURATION(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_BSSID(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_AUTHENTICATION_MODE(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_BSSID_LIST(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_DESIRED_RATES(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_FRAGMENTATION_THRESHOLD(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_INFRASTRUCTURE_MODE(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_POWER_MODE(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_QUERY_PREAMBLE(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_RSSI(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_RTS_THRESHOLD(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_RX_ANTENNA_SELECTED(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_SSID(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_STATISTICS(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_TX_ANTENNA_SELECTED(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_TX_POWER_LEVEL(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_11_WEP_STATUS(int socket_id, char *DeviceName, void *ptr);
int Get_OID_802_3_CURRENT_ADDRESS(int socket_id, char *DeviceName, void *ptr);
int Get_OID_GEN_RCV_NO_BUFFER(int socket_id, char *DeviceName, void *ptr);
int Get_OID_GEN_RCV_OK(int socket_id, char *DeviceName, void *ptr);
int Get_RT_OID_802_11_QUERY_HARDWARE_REGISTER(int socket_id, char *DeviceName, void *ptr);
int Get_RT_OID_802_11_QUERY_LINK_STATUS(int socket_id, char *DeviceName, void *ptr);
int Get_VERSION_INFO(int socket_id, char *DeviceName, void *ptr);
int GET_RT_OID_802_11_QUERY_RADIO(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_ADD_WEP(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_AUTHENTICATION_MODE(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_BSSID(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_BSSID_LIST_SCAN(int socket_id, char *DeviceName);
int Set_OID_802_11_CONFIGURATION(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_DESIRED_RATES(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_FRAGMENTATION_THRESHOLD(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_INFRASTRUCTURE_MODE(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_POWER_MODE(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_REMOVE_WEP(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_RESET_COUNTERS(int socket_id, char *DeviceName);
int Set_OID_802_11_RTS_THRESHOLD(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_RX_ANTENNA_SELECTED(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_SET_PREAMBLE(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_SSID(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_TX_ANTENNA_SELECTED(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_TX_POWER_LEVEL(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_WEP_STATUS(int socket_id, char *DeviceName, void *ptr);
int Set_RT_OID_802_11_SET_HARDWARE_REGISTER(int socket_id, char *DeviceName, void *ptr);
int Set_RT_OID_802_11_SET_RADIO(int socket_id, char *DeviceName, void *ptr);
int Set_OID_802_11_SET_COUNTRY_REGION(int socket_id, char *DeviceName, void *ptr);
UCHAR BtoH(char ch);
void AtoH(char * src, UCHAR * dest, int destlen);

#endif //RT_TOOL_H



